/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.penpower.worldcard.team.Utils.CollectionUtil;
import com.penpower.worldcard.team.config.elasticsearch.ElasticSearchProperties;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.PicklistContentDao;
import com.penpower.worldcard.team.dto.ContactInfoForEs;
import com.penpower.worldcard.team.dto.ContactVisibilityForEs;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.enums.CustomFieldCategory;
import com.penpower.worldcard.team.enums.CustomFieldContactAttribute;
import com.penpower.worldcard.team.enums.UpdateComponentForEs;
import com.penpower.worldcard.team.exception.SearchEngineIndexMissingException;
import com.penpower.worldcard.team.exception.SearchEngineNotRunningException;
import com.penpower.worldcard.team.exception.SearchEngineSpaceInsufficientException;
import com.penpower.worldcard.team.scheduler.job.RebuildElasticsearchIndexJob;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ElasticSearchService;
import com.penpower.worldcard.team.service.impl.ElasticSearchServiceImpl;
import com.penpower.worldcard.team.web.api.vo.CustomFieldCreationVo;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ElasticSearchServiceImpl
implements ElasticSearchService {
    private static final String SPACE_INSUFFICIENT_INDEX_READ_ONLY_FAILURE_REASON = "FORBIDDEN/12/index read-only";
    private static final String INDEX_NOT_FOUND_FAILURE_REASON = "no such index";
    private static final String INDEX_FAILED_TO_PARSE_FAILURE_FEASON = "failed to parse";
    private static final double CANCEL_SEARCH_ENGINE_READ_ONLY_DISK_SPACE_PERCENT = 90.0;
    private static final String GET_DISK_USED_PERCENT_ENDPOINT = "_cat/nodes?h=diskUsedPercent";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchServiceImpl.class);
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private PicklistContentDao picklistContentDao;
    @Autowired
    @Qualifier(value="searchEngineIndex")
    private String searchEngineIndex;

    @Deprecated
    public void createEsContact(String contactGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        ContactInfoForEs contactInfoForEs = new ContactInfoForEs(contact);
        IndexRequest requestForInfo = this.getContactInfoIndexRequest(contactInfoForEs);
        IndexRequest requestForVisibility = this.getContactVisibilityIndexRequest(contactInfoForEs);
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.add(requestForInfo);
        bulkRequest.add(requestForVisibility);
        try {
            this.client.bulk(bulkRequest, new Header[0]);
        }
        catch (IOException e) {
            LOG.debug(e.getMessage());
        }
    }

    public void updateEsContact(List<ContactInfoForEs> Contacts) throws SearchEngineIndexMissingException, SearchEngineSpaceInsufficientException, SearchEngineNotRunningException, IOException {
        block10: {
            boolean readOnlyExceptionOccurs;
            block9: {
                readOnlyExceptionOccurs = false;
                BulkRequest bulkRequest = new BulkRequest();
                for (ContactInfoForEs contactInfoForEs : Contacts) {
                    IndexRequest requestForInfo = this.getContactInfoIndexRequest(contactInfoForEs);
                    IndexRequest requestForVisibility = this.getContactVisibilityIndexRequest(contactInfoForEs);
                    bulkRequest.add(requestForInfo);
                    bulkRequest.add(requestForVisibility);
                }
                bulkRequest.timeout("8s");
                try {
                    BulkResponse response = this.client.bulk(bulkRequest, new Header[0]);
                    if (!response.hasFailures()) break block9;
                    String failureMessage = response.buildFailureMessage();
                    if (failureMessage.contains(INDEX_NOT_FOUND_FAILURE_REASON) || failureMessage.contains(INDEX_FAILED_TO_PARSE_FAILURE_FEASON)) {
                        throw new SearchEngineIndexMissingException();
                    }
                    if (failureMessage.contains(SPACE_INSUFFICIENT_INDEX_READ_ONLY_FAILURE_REASON)) {
                        readOnlyExceptionOccurs = true;
                        break block9;
                    }
                    throw new IOException(failureMessage);
                }
                catch (ConnectException ex) {
                    throw new SearchEngineNotRunningException();
                }
            }
            try {
                if (readOnlyExceptionOccurs) {
                    this.handleSearchEngineReadOnlyException();
                }
            }
            catch (ConnectException ex) {
                throw new SearchEngineNotRunningException();
            }
            catch (IOException ex) {
                if (!ex.getMessage().contains(INDEX_NOT_FOUND_FAILURE_REASON)) break block10;
                throw new SearchEngineIndexMissingException();
            }
        }
    }

    public void handleSearchEngineReadOnlyException() throws SearchEngineSpaceInsufficientException, IOException {
        Response response = this.client.getLowLevelClient().performRequest("GET", GET_DISK_USED_PERCENT_ENDPOINT, new Header[0]);
        Double diskUsedPercent = Double.valueOf(EntityUtils.toString((HttpEntity)response.getEntity()));
        if (diskUsedPercent <= 90.0) {
            this.cancelSearchEngineReadOnly();
            RebuildElasticsearchIndexJob.changeCurrentDiskSpaceInsufficientValue((boolean)false);
            throw new SearchEngineSpaceInsufficientException();
        }
        RebuildElasticsearchIndexJob.changeCurrentDiskSpaceInsufficientValue((boolean)true);
        throw new SearchEngineSpaceInsufficientException();
    }

    private void cancelSearchEngineReadOnly() throws IOException {
        HttpEntity readOnlyCancelSetting = ElasticSearchProperties.getReadOnlyCancelSetting();
        this.client.getLowLevelClient().performRequest("PUT", this.searchEngineIndex + "/_settings", Collections.emptyMap(), readOnlyCancelSetting, new Header[0]);
    }

    @Deprecated
    public void updateEsContact(String contactGuid, List<UpdateComponentForEs> updateComponents) {
        LOG.debug("Update ES Contact start");
        long begin = System.currentTimeMillis();
        ContactInfoForEs contactInfoForEs = null;
        ContactVisibilityForEs contactVisibilityForEs = null;
        BulkRequest bulkRequest = new BulkRequest();
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (updateComponents.contains(UpdateComponentForEs.UC_CONTENT) || updateComponents.contains(UpdateComponentForEs.UC_OWNER)) {
            contactInfoForEs = new ContactInfoForEs(contact);
            IndexRequest requestForInfo = this.getContactInfoIndexRequest(contactInfoForEs);
            bulkRequest.add(requestForInfo);
        }
        if (updateComponents.contains(UpdateComponentForEs.UC_SHARE_ACCOUNT) || updateComponents.contains(UpdateComponentForEs.UC_OWNER)) {
            contactInfoForEs = new ContactInfoForEs(contact);
            List beSharedAndOwnerAccountGuids = this.getBeSharedAndOwnerAccountGuids(contactGuid, contactInfoForEs);
            contactVisibilityForEs = new ContactVisibilityForEs(contactGuid, contact.getIsDeleted(), beSharedAndOwnerAccountGuids, null);
        }
        if (updateComponents.contains(UpdateComponentForEs.UC_CATEGORY)) {
            List belongCategoryGuids = this.contactPublicService.getByContactGuid(contactGuid);
            if (contactVisibilityForEs != null) {
                contactVisibilityForEs.setBelongCategories(belongCategoryGuids);
            } else {
                contactVisibilityForEs = new ContactVisibilityForEs(contactGuid, contact.getIsDeleted(), null, belongCategoryGuids);
            }
        }
        if (contactVisibilityForEs != null) {
            Gson gson = new Gson();
            String esContactVisibilityGuid = "!" + contactGuid;
            UpdateRequest updateRequest = new UpdateRequest(this.searchEngineIndex, "v_1.0.0", esContactVisibilityGuid);
            updateRequest.routing(contactGuid).doc(gson.toJson((Object)contactVisibilityForEs), XContentType.JSON);
            bulkRequest.add(updateRequest);
        }
        try {
            this.client.bulk(bulkRequest, new Header[0]);
        }
        catch (IOException e) {
            LOG.debug(e.getMessage());
        }
        LOG.debug("updateEsContact end, spend time:{}", (Object)(System.currentTimeMillis() - begin));
    }

    private List<String> getBeSharedAndOwnerAccountGuids(String contactGuid, ContactInfoForEs contactInfoForEs) {
        List beSharedAndOwnerAccountGuids = this.contactPublicService.getAccountGuidsSharedByContact(contactGuid);
        beSharedAndOwnerAccountGuids.add(contactInfoForEs.getOwnerGuid());
        return beSharedAndOwnerAccountGuids.stream().distinct().collect(Collectors.toList());
    }

    public IndexRequest getContactInfoIndexRequest(ContactInfoForEs contactInfoForEs) {
        IndexRequest requestForInfo = new IndexRequest(this.searchEngineIndex, "v_1.0.0");
        requestForInfo.id(contactInfoForEs.getGuid()).source(this.getContactInfoForEsJson(contactInfoForEs), XContentType.JSON);
        return requestForInfo;
    }

    private String getContactInfoForEsJson(ContactInfoForEs contactInfoForEs) {
        Gson gson = new Gson();
        JsonElement jsonElement = gson.toJsonTree((Object)contactInfoForEs);
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactInfoForEs.getGuid()));
        List customs = contact.getContactcustomdata();
        if (CollectionUtil.collectionEmpty((Collection)customs)) {
            return gson.toJson(jsonElement);
        }
        customs.stream().forEach(custom -> {
            String fieldSettingGuid = custom.getFieldsettingguid();
            CustomFieldContactAttribute attribute = custom.getFieldtype();
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$CustomFieldContactAttribute[attribute.ordinal()]) {
                case 1: 
                case 2: {
                    jsonElement.getAsJsonObject().addProperty(fieldSettingGuid, (Number)custom.getDatetimevalue().getMillis());
                    break;
                }
                case 3: {
                    jsonElement.getAsJsonObject().addProperty(fieldSettingGuid, (Number)custom.getFloatvalue());
                    break;
                }
                case 4: {
                    jsonElement.getAsJsonObject().addProperty(fieldSettingGuid, (Number)custom.getIntvalue());
                    break;
                }
                case 5: {
                    jsonElement.getAsJsonObject().addProperty(fieldSettingGuid, custom.getTextvalue());
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    jsonElement.getAsJsonObject().addProperty(fieldSettingGuid, custom.getTextvalue());
                }
            }
        });
        return gson.toJson(jsonElement);
    }

    public IndexRequest getContactVisibilityIndexRequest(ContactInfoForEs contactInfoForEs) {
        Gson gson = new Gson();
        String contactGuid = contactInfoForEs.getGuid();
        String contactVisibilityGuid = "!" + contactGuid;
        IndexRequest requestForVisibility = new IndexRequest(this.searchEngineIndex, "v_1.0.0");
        List beSharedAndOwnerAccountGuids = this.getBeSharedAndOwnerAccountGuids(contactGuid, contactInfoForEs);
        List belongCategoryGuids = this.contactPublicService.getByContactGuid(contactGuid);
        Boolean isDeleted = ((Contact)this.contactDao.findOne((Serializable)((Object)contactGuid))).getIsDeleted();
        ContactVisibilityForEs contactVisibilityForEs = new ContactVisibilityForEs(contactGuid, isDeleted, beSharedAndOwnerAccountGuids, belongCategoryGuids);
        requestForVisibility.id(contactVisibilityGuid).routing(contactGuid).source(gson.toJson((Object)contactVisibilityForEs), XContentType.JSON);
        return requestForVisibility;
    }

    public void createCustomFieldMappingSetting(CustomFieldCreationVo customFieldCreationVo, String customFieldGuid) {
        try {
            CustomFieldCategory customFieldCategory = customFieldCreationVo.getCustomFieldCategory();
            if (CustomFieldCategory.CONTACT.equals((Object)customFieldCategory)) {
                CustomFieldContactAttribute attribute = customFieldCreationVo.getCustomFieldContactAttribute();
                if (CustomFieldContactAttribute.TEXT.equals((Object)attribute) || CustomFieldContactAttribute.URL.equals((Object)attribute) || CustomFieldContactAttribute.EMAIL.equals((Object)attribute) || CustomFieldContactAttribute.PICKLIST.equals((Object)attribute)) {
                    LOG.debug(String.format("Create elasticSearch customFiellGuid[%s] mapping setting", customFieldGuid));
                    HttpEntity customFieldMappingSetting = ElasticSearchProperties.getCustomFieldMappingSetting(Arrays.asList(customFieldGuid), null);
                    this.client.getLowLevelClient().performRequest("PUT", this.searchEngineIndex + "/" + "v_1.0.0" + "/_mapping/", Collections.emptyMap(), customFieldMappingSetting, new Header[0]);
                } else if (CustomFieldContactAttribute.NUMBER.equals((Object)attribute) || CustomFieldContactAttribute.FLOAT.equals((Object)attribute)) {
                    HttpEntity customFieldMappingSetting = ElasticSearchProperties.getCustomFieldMappingSetting(null, Arrays.asList(customFieldGuid));
                    this.client.getLowLevelClient().performRequest("PUT", "contact/v_1.0.0/_mapping/", Collections.emptyMap(), customFieldMappingSetting, new Header[0]);
                }
            }
        }
        catch (IOException e) {
            LOG.debug("Error message", (Throwable)e);
            LOG.debug(e.getMessage());
        }
    }

    public void refreshIndexToBeSearchable() {
        try {
            this.client.getLowLevelClient().performRequest("POST", this.searchEngineIndex + "/_refresh", new Header[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeAllIndex() throws IOException {
        this.client.getLowLevelClient().performRequest("DELETE", this.searchEngineIndex, new Header[0]);
    }

    public boolean searchEngineExist() {
        try {
            this.client.info(new Header[0]);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

