/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.ListObjectPaginator;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.ContactSimpleInfoDao;
import com.penpower.worldcard.team.dao.ContactfulltextDao;
import com.penpower.worldcard.team.dao.NormalSearchDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contactsimpleinfo;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.ContactRangeType;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.enums.ShareRule;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.search.ChineseSearchMechanism;
import com.penpower.worldcard.team.search.DatabaseSearchMechanism;
import com.penpower.worldcard.team.search.DefaultSearchMechanism;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.SearchService;
import com.penpower.worldcard.team.web.api.vo.PageInfoVo;
import com.penpower.worldcard.team.web.api.vo.PaginationSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DatabaseNormalSearchService
implements SearchService {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseNormalSearchService.class);
    @Autowired
    private ContactfulltextDao contactfulltextDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private NormalSearchDao normalSearchDao;
    @Autowired
    private ContactSimpleInfoDao contactSimpleInfoDao;
    @Autowired
    private RestHighLevelClient client;

    public PageInfoVo<List<ContactSimpleInfoDto>> searchPublicContactWithPageable(String lowerCaseKeyword, String userGuid, PaginationSettings paginationSettings) {
        Account currentLoginAccount = this.accountDao.findOne(userGuid);
        String accountGuid = currentLoginAccount.getGuid();
        DatabaseSearchMechanism searchMechanism = this.getSQLDatabaseSearchMechanism(this.normalSearchDao, lowerCaseKeyword);
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SHARE_RULE", currentLoginUser.getCompanyGuid());
        List searchResult = new ArrayList();
        String orderByString = paginationSettings.getSortSqlPaddingString();
        long startTime = System.currentTimeMillis();
        if (ShareRule.ALL.equals((Object)ShareRule.valueOf((String)globalinfocompany.getConfigValue())) || UserRole.ADMIN.equals((Object)currentLoginAccount.getRole())) {
            LOG.debug("admin public...");
            searchResult = searchMechanism.searchGuidsByKeyword(lowerCaseKeyword, ContactRangeType.PUBLIC, accountGuid, true, orderByString);
        } else {
            searchResult = searchMechanism.searchGuidsByKeyword(lowerCaseKeyword, ContactRangeType.PUBLIC, accountGuid, false, orderByString);
        }
        long end = System.currentTimeMillis();
        LOG.debug("search  public contact , total cost time : {} ", (Object)(end - startTime));
        LOG.debug("searchResult : {} ", searchResult);
        PageInfoVo pageResult = this.convertToPageResult(paginationSettings, searchResult);
        return pageResult;
    }

    private PageInfoVo<List<ContactSimpleInfoDto>> convertToPageResult(PaginationSettings paginationSettings, List<String> searchResult) {
        LOG.debug("PaginationSettings : {} ", (Object)paginationSettings);
        long startTime = System.currentTimeMillis();
        int totalCount = searchResult.size();
        if (totalCount == 0) {
            LOG.debug("No search result found ... , return empty result array.");
            return new PageInfoVo(0L, 0, new ArrayList());
        }
        int pageNumber = paginationSettings.getPageNumber();
        int pageSize = paginationSettings.getPageSiz();
        int totalPage = this.calculateTotalPagesCeil(totalCount, pageSize);
        List searchPaginationResult = ListObjectPaginator.getPageResult(searchResult, (int)pageNumber, (int)pageSize);
        List contactSimpleinfoSearchResult = searchPaginationResult.stream().map(contactSimpleInfoGuid -> (Contactsimpleinfo)this.contactSimpleInfoDao.findOne((Serializable)((Object)contactSimpleInfoGuid))).collect(Collectors.toList());
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        List result = contactSimpleinfoSearchResult.stream().filter(Objects::nonNull).map(contactSimpleInfo -> new ContactSimpleInfoDto(contactSimpleInfo, nameDisplayOrderSettingType, contactSimpleInfo.getContact())).collect(Collectors.toList());
        PageInfoVo pageResult = new PageInfoVo((long)totalCount, totalPage, result);
        long end = System.currentTimeMillis();
        LOG.debug("Convert search result guids into pageInfoVo , total cost time : {} ", (Object)(end - startTime));
        LOG.debug("result size : {}", (Object)result.size());
        return pageResult;
    }

    private int calculateTotalPagesCeil(int totalCount, int pageSize) {
        int totalPages = (int)Math.ceil((double)totalCount / (double)pageSize);
        return totalPages;
    }

    public PageInfoVo<List<ContactSimpleInfoDto>> searchPrivateContactWithPageable(String lowerCaseKeyword, String userGuid, PaginationSettings paginationSettings) {
        Account currentLoginAccount = this.accountDao.findOne(userGuid);
        String accountGuid = currentLoginAccount.getGuid();
        DatabaseSearchMechanism searchMechanism = this.getSQLDatabaseSearchMechanism(this.normalSearchDao, lowerCaseKeyword);
        List searchResult = new ArrayList();
        String orderByString = paginationSettings.getSortSqlPaddingString();
        long startTime = System.currentTimeMillis();
        searchResult = searchMechanism.searchGuidsByKeyword(lowerCaseKeyword, ContactRangeType.PRIVATE, accountGuid, false, orderByString);
        long end = System.currentTimeMillis();
        LOG.debug("search  private contact , total cost time : {} ", (Object)(end - startTime));
        PageInfoVo pageResult = this.convertToPageResult(paginationSettings, searchResult);
        return pageResult;
    }

    private DatabaseSearchMechanism getSQLDatabaseSearchMechanism(NormalSearchDao normalSearchDao, String keyWord) {
        boolean keyWordContainsChineseWord = GlobalUtils.stringContainsChineseWord((String)keyWord);
        LOG.debug("keyWordContainsChineseWord : {} ", (Object)keyWordContainsChineseWord);
        if (keyWordContainsChineseWord) {
            return new ChineseSearchMechanism(normalSearchDao);
        }
        return new DefaultSearchMechanism(normalSearchDao);
    }
}

