/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.FieldStringFormat;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.config.ApplicationConfig;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactSimpleInfoDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dao.ContactfulltextDao;
import com.penpower.worldcard.team.dto.CategoryInfo;
import com.penpower.worldcard.team.dto.ContactIMInfo;
import com.penpower.worldcard.team.dto.ContactSimpleInfoCustomerDto;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactdateInfo;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.dto.ContactimageInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.dto.ContacturlInfo;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.CategoryType;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.ContactUrlType;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.DatabaseType;
import com.penpower.worldcard.team.enums.FieldType;
import com.penpower.worldcard.team.enums.LangCode;
import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.enums.NameOrder;
import com.penpower.worldcard.team.enums.VCardTarget;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.ExportContactToContactServerJob;
import com.penpower.worldcard.team.scheduler.job.ExportContactsToCrmJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.impl.ContactServiceImpl;
import com.penpower.worldcard.team.web.api.vo.ContactInfoExVo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.CharUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional
public class ContactServiceImpl
implements ContactService {
    private static final Logger LOG = LoggerFactory.getLogger(ContactServiceImpl.class);
    public static AtomicBoolean DEEPLY_DELETE_CONTACTS_PROCESSING = new AtomicBoolean(false);
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private ContactStatusForAccountDao contactStatusForAccountDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private ContactSimpleInfoDao contactSimpleInfoDao;
    @Autowired
    private ContactfulltextDao contactfulltextDao;
    @Autowired
    private GlobalInfoService globalInfoService;
    private static final String EXPORT_TO_CRM = "EXPORT_TO_CRM";
    private static final String EXPORT_TO_CONTACT_SERVER = "EXPORT_TO_CONTACT_SERVER";
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager scheduleManager;
    private String phone_home0;
    @Autowired
    private PathManager cardPathManager;

    public void exportContactsToContactServer(String accountGuid, List<String> contactGuids, boolean isSendNotice, String companyGuid) {
        LOG.debug("============================exportContactsToContactServer start({})======================", (Object)accountGuid);
        JobIdentify jobIdentify = new JobIdentify("EXPORT_TO_CONTACT_SERVER" + UUIDGenerator.getRandomUUID(), ExportContactToContactServerJob.class);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("EXPORT_CONTACT_GUIDS", contactGuids);
        dataMap.put("EXPORT_ACCOUNT_GUID", accountGuid);
        dataMap.put("EXPORT_COMPANY_GUID", companyGuid);
        dataMap.put("EXPORT_IS_SEND_NOTICE", isSendNotice);
        this.scheduleManager.startScheduleOnce(jobIdentify, null, dataMap);
        LOG.debug("============================exportContactsToContactServer end({})======================", (Object)accountGuid);
    }

    public void exportContactsToCRM(String accountGuid, List<String> contactGuids, boolean isSendNotice, CrmTargetType crmTargetType, String salesforceAccountId, String companyGuid) {
        LOG.debug("============================exportContactsToCRM start({})======================", (Object)accountGuid);
        CrmTargetType type = crmTargetType != null ? crmTargetType : this.accountPrivateSettingService.getCrmAutoExportTargetType(accountGuid);
        JobIdentify jobIdentify = new JobIdentify("EXPORT_TO_CRM" + UUIDGenerator.getRandomUUID(), ExportContactsToCrmJob.class);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("EXPORT_CONTACT_GUIDS", contactGuids);
        dataMap.put("EXPORT_COMPANY_GUID", companyGuid);
        dataMap.put("EXPORT_ACCOUNT_GUID", accountGuid);
        dataMap.put("EXPORT_IS_SEND_NOTICE", isSendNotice);
        dataMap.put("CRM_TARGET_TYPE", (Object)type);
        dataMap.put("SALESFORCE_TARGET_ACCOUNT_ID", salesforceAccountId);
        this.scheduleManager.startScheduleOnce(jobIdentify, null, dataMap);
        LOG.debug("============================exportContactsToCRM end({})======================", (Object)accountGuid);
    }

    private boolean AssignStringValue(String fieldString, String valueString, String noteString, String noteTitleString) {
        LOG.debug("AssignStringValue start  A={} B={} C={} D={} ", new Object[]{fieldString, valueString, noteString, noteTitleString});
        if (fieldString != null) {
            LOG.debug("AssignStringValue 1");
            if (fieldString.length() == 0) {
                LOG.debug("AssignStringValue 2");
                fieldString = valueString;
            } else {
                LOG.debug("AssignStringValue 3");
                noteString = noteString + noteTitleString + " : " + valueString + "\n";
            }
            return true;
        }
        LOG.debug("AssignStringValue end  2 A={} B={} C={} D={} ", new Object[]{fieldString, valueString, noteString, noteTitleString});
        return false;
    }

    private boolean AssignTwoStringValue(String fieldStringOne, String fieldStringTwo, String valueString, String noteString, String noteTitleString) {
        if (fieldStringOne != null && fieldStringTwo != null) {
            if (fieldStringOne.length() == 0) {
                fieldStringOne = valueString;
            } else if (fieldStringTwo.length() == 0) {
                fieldStringTwo = valueString;
            } else {
                noteString = noteString + noteTitleString + " : " + valueString + "\n";
            }
            return true;
        }
        return false;
    }

    public void exportContactsToGmail(String accountGuid, List<String> contactGuids, String filePath) {
        LOG.debug("exportContactsToGmail 1");
        File getFilePath = new File(filePath);
        LOG.debug("exportContactsToGmail 2");
        if (getFilePath != null) {
            try {
                LOG.debug("exportContactsToGmail 3");
                BufferedWriter aFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(getFilePath), "UTF-16"));
                if (aFileWriter != null) {
                    LOG.debug("exportContactsToGmail 4");
                    aFileWriter.append("Given Name,Additional Name,Family Name,Given Name Yomi,Family Name Yomi,Name Prefix,Name Suffix,Birthday,Event 1 - Type,Event 1 - Value,Event 2 - Type,Event 2 - Value,E-mail 1 - Type,E-mail 1 - Value,E-mail 2 - Type,E-mail 2 - Value,E-mail 3 - Type,E-mail 3 - Value,IM 1 - Service,IM 1 - Value,Organization 1 - Name,Organization 1 - Yomi Name,Organization 1 - Title,Organization 1 - Department,Phone 1 - Type,Phone 1 - Value,Phone 2 - Type,Phone 2 - Value,Phone 3 - Type,Phone 3 - Value,Phone 4 - Type,Phone 4 - Value,Phone 5 - Type,Phone 5 - Value,Phone 6 - Type,Phone 6 - Value,Phone 7 - Type,Phone 7 - Value,Phone 8 - Type,Phone 8 - Value,Phone 9 - Type,Phone 9 - Value,Phone 10 - Type,Phone 10 - Value,Website 1 - Type,Website 1 - Value,Website 2 - Type,Website 2 - Value,Website 3 - Type,Website 3 - Value,Website 4 - Type,Website 4 - Value,Website 5 - Type,Website 5 - Value,Website 6 - Type,Website 6 - Value,Address 1 - Type,Address 1 - Street,Address 1 - City,Address 1 - Region,Address 1 - Postal Code,Address 1 - Country,Address 2 - Type,Address 2 - Street,Address 2 - City,Address 2 - Region,Address 2 - Postal Code,Address 2 - Country,Address 3 - Type,Address 3 - Street,Address 3 - City,Address 3 - Region,Address 3 - Postal Code,Address 3 - Country,Nickname,Notes");
                    aFileWriter.append("\n");
                    for (String contactGuid : contactGuids) {
                        Iterator iterator;
                        Iterator iterator2;
                        ContactInfoExVo contactInfoVo = this.contactPrivateService.getContactInfoExByGuid(contactGuid, accountGuid);
                        if (contactInfoVo == null) continue;
                        String additional_name = "";
                        String additional_name_phonetic = "";
                        String first_name = "";
                        String first_name_phonetic = "";
                        String last_name = "";
                        String last_name_phonetic = "";
                        String prefix_name = "";
                        String suffix_name = "";
                        if (contactInfoVo.getNames() != null && (iterator2 = contactInfoVo.getNames().iterator()).hasNext()) {
                            ContactnameInfo contactNameInfo = (ContactnameInfo)iterator2.next();
                            first_name = contactNameInfo.getFirstName();
                            first_name_phonetic = contactNameInfo.getFirstNamePronunce();
                            last_name = contactNameInfo.getLastName();
                            last_name_phonetic = contactNameInfo.getLastNamePronunce();
                            prefix_name = contactNameInfo.getPrefix();
                            suffix_name = contactNameInfo.getSuffix();
                            additional_name = contactNameInfo.getMiddleName();
                        }
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)first_name);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)additional_name);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)last_name);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)first_name_phonetic);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)last_name_phonetic);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)prefix_name);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)suffix_name);
                        String birthday = "";
                        FieldStringFormat fieldStringFormat = new FieldStringFormat();
                        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
                        if (contactInfoVo.getBirthday() != null) {
                            DateTime DateTimebirthday = contactInfoVo.getBirthday();
                            birthday = timefmater.print((ReadableInstant)DateTimebirthday);
                        }
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.DATE, (String)birthday);
                        String anniversary = "";
                        String other = "";
                        if (contactInfoVo.getDates() != null) {
                            for (ContactdateInfo contactdateInfo : contactInfoVo.getDates()) {
                                if (contactdateInfo.getValue() == null) continue;
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactDateType[contactdateInfo.getType().ordinal()]) {
                                    case 1: {
                                        anniversary = fieldStringFormat.ConverGoogleFmt(anniversary, timefmater.print((ReadableInstant)contactdateInfo.getValue()));
                                        break;
                                    }
                                    case 2: {
                                        other = fieldStringFormat.ConverGoogleFmt(other, timefmater.print((ReadableInstant)contactdateInfo.getValue()));
                                    }
                                }
                            }
                        }
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Anniversary");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.DATE, (String)anniversary);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Other");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.DATE, (String)other);
                        String email_work = "";
                        String email_home = "";
                        String email_other = "";
                        if (contactInfoVo.getEmails() != null) {
                            for (ContactemailInfo contactemailInfo : contactInfoVo.getEmails()) {
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactFieldType[contactemailInfo.getType().ordinal()]) {
                                    case 1: {
                                        email_home = fieldStringFormat.ConverGoogleFmt(email_home, contactemailInfo.getValue());
                                        break;
                                    }
                                    case 2: {
                                        email_work = fieldStringFormat.ConverGoogleFmt(email_work, contactemailInfo.getValue());
                                        break;
                                    }
                                    case 3: {
                                        email_other = fieldStringFormat.ConverGoogleFmt(email_other, contactemailInfo.getValue());
                                    }
                                }
                            }
                        }
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Home");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)email_home);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Work");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)email_work);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Other");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)email_other);
                        LOG.debug("exportContactsToGmail 4");
                        String service = "";
                        String service_value = "";
                        if (contactInfoVo.getIMs() != null) {
                            for (ContactIMInfo contactIMInfo : contactInfoVo.getIMs()) {
                                if (contactIMInfo.getValue() != null && contactIMInfo.getValue().length() > 0 && service.length() > 0) {
                                    service = service + " ::: ";
                                    service_value = service_value + " ::: ";
                                }
                                boolean bExport = true;
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactIMType[contactIMInfo.getType().ordinal()]) {
                                    case 1: {
                                        service = service + "WhatsApp";
                                        break;
                                    }
                                    case 2: {
                                        service = service + "Zoom";
                                        break;
                                    }
                                    case 3: {
                                        service = service + "Line";
                                        break;
                                    }
                                    case 4: {
                                        service = service + "WeChat";
                                        break;
                                    }
                                    case 5: {
                                        service = service + "MSN";
                                        break;
                                    }
                                    case 6: {
                                        service = service + "Skype";
                                        break;
                                    }
                                    case 7: {
                                        service = service + "QQ";
                                        break;
                                    }
                                    case 8: {
                                        service = service + "Yahoo!";
                                        break;
                                    }
                                    case 9: {
                                        service = service + "ICQ";
                                        break;
                                    }
                                    case 10: {
                                        service = service + "Google Talk";
                                        break;
                                    }
                                    case 11: {
                                        service = service + "Jabber";
                                        break;
                                    }
                                    case 12: {
                                        service = service + "Aim";
                                        break;
                                    }
                                    default: {
                                        bExport = false;
                                    }
                                }
                                if (!bExport) continue;
                                service_value = service_value + contactIMInfo.getValue();
                            }
                        }
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)service);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)service_value);
                        String company = "";
                        String company_phonetic = "";
                        String department = "";
                        String job_title = "";
                        if (contactInfoVo.getJobinfos() != null && (iterator = contactInfoVo.getJobinfos().iterator()).hasNext()) {
                            ContactjobinfoInfo contactJobInfo = (ContactjobinfoInfo)iterator.next();
                            company = contactJobInfo.getCompanyName();
                            company_phonetic = contactJobInfo.getCompanyPronunce();
                            department = contactJobInfo.getDepartment();
                            job_title = contactJobInfo.getJobTitle();
                        }
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)company);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)company_phonetic);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)job_title);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)department);
                        String phone_work = "";
                        String phone_home = "";
                        String phone_work_fax = "";
                        String phone_home_fax = "";
                        String phone_mobile = "";
                        String phone_iphone = "";
                        String phone_main = "";
                        String phone_pager = "";
                        String phone_google_voice = "";
                        String phone_other = "";
                        if (contactInfoVo.getPhones() != null) {
                            for (ContactphoneInfo contactPhoneInfo : contactInfoVo.getPhones()) {
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactPhoneType[contactPhoneInfo.getType().ordinal()]) {
                                    case 1: {
                                        phone_home = fieldStringFormat.ConverGoogleFmt(phone_home, contactPhoneInfo.getValue());
                                        break;
                                    }
                                    case 2: {
                                        phone_work = fieldStringFormat.ConverGoogleFmt(phone_work, contactPhoneInfo.getValue());
                                        break;
                                    }
                                    case 3: {
                                        phone_home_fax = fieldStringFormat.ConverGoogleFmt(phone_home_fax, contactPhoneInfo.getValue());
                                        break;
                                    }
                                    case 4: {
                                        phone_work_fax = fieldStringFormat.ConverGoogleFmt(phone_work_fax, contactPhoneInfo.getValue());
                                        break;
                                    }
                                    case 5: {
                                        phone_other = fieldStringFormat.ConverGoogleFmt(phone_other, contactPhoneInfo.getValue());
                                        break;
                                    }
                                    case 6: {
                                        phone_mobile = fieldStringFormat.ConverGoogleFmt(phone_mobile, contactPhoneInfo.getValue());
                                        break;
                                    }
                                    case 7: {
                                        phone_main = fieldStringFormat.ConverGoogleFmt(phone_main, contactPhoneInfo.getValue());
                                        break;
                                    }
                                    case 8: {
                                        phone_pager = fieldStringFormat.ConverGoogleFmt(phone_pager, contactPhoneInfo.getValue());
                                        break;
                                    }
                                    case 9: {
                                        phone_google_voice = fieldStringFormat.ConverGoogleFmt(phone_google_voice, contactPhoneInfo.getValue());
                                        break;
                                    }
                                    case 10: {
                                        phone_iphone = fieldStringFormat.ConverGoogleFmt(phone_iphone, contactPhoneInfo.getValue());
                                    }
                                }
                            }
                        }
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Work");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_work);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Home");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_home);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Work Fax");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_work_fax);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Home Fax");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_home_fax);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Mobile");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_mobile);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"iPhone");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_iphone);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Main");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_main);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Pager");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_pager);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Google Voice");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_google_voice);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Other");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_other);
                        LOG.debug("exportContactsToGmail 5");
                        String web_work = "";
                        String web_home = "";
                        String web_homepage = "";
                        String web_blog = "";
                        String web_profile = "";
                        String web_other = "";
                        if (contactInfoVo.getUrls() != null) {
                            for (ContacturlInfo contacturlInfo : contactInfoVo.getUrls()) {
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactUrlType[contacturlInfo.getType().ordinal()]) {
                                    case 1: {
                                        web_homepage = fieldStringFormat.ConverGoogleFmt(web_homepage, contacturlInfo.getValue());
                                        break;
                                    }
                                    case 2: {
                                        web_home = fieldStringFormat.ConverGoogleFmt(web_home, contacturlInfo.getValue());
                                        break;
                                    }
                                    case 3: {
                                        web_work = fieldStringFormat.ConverGoogleFmt(web_work, contacturlInfo.getValue());
                                        break;
                                    }
                                    case 4: {
                                        web_profile = fieldStringFormat.ConverGoogleFmt(web_profile, contacturlInfo.getValue());
                                        break;
                                    }
                                    case 5: {
                                        web_blog = fieldStringFormat.ConverGoogleFmt(web_blog, contacturlInfo.getValue());
                                        break;
                                    }
                                    case 6: {
                                        web_other = fieldStringFormat.ConverGoogleFmt(web_other, contacturlInfo.getValue());
                                    }
                                }
                            }
                        }
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Work");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)web_work);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Home");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)web_home);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Homepage");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)web_homepage);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Blog");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)web_blog);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Profile");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)web_profile);
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Other");
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)web_other);
                        String address_work = "";
                        String address_work_street = "";
                        String address_work_city = "";
                        String address_work_region = "";
                        String address_work_postal_code = "";
                        String address_work_country = "";
                        String address_home = "";
                        String address_home_street = "";
                        String address_home_city = "";
                        String address_home_region = "";
                        String address_home_postal_code = "";
                        String address_home_country = "";
                        String address_other = "";
                        String address_other_street = "";
                        String address_other_city = "";
                        String address_other_region = "";
                        String address_other_postal_code = "";
                        String address_other_country = "";
                        int outputAddressCount = 0;
                        if (contactInfoVo.getAddresses() != null) {
                            for (ContactaddressInfo contactaddressInfo : contactInfoVo.getAddresses()) {
                                boolean bAdd = true;
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactFieldType[contactaddressInfo.getType().ordinal()]) {
                                    case 1: {
                                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Home");
                                        break;
                                    }
                                    case 2: {
                                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Work");
                                        break;
                                    }
                                    case 3: {
                                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"Other");
                                        break;
                                    }
                                    default: {
                                        bAdd = false;
                                    }
                                }
                                if (bAdd) {
                                    ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getStreet());
                                    ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getCity());
                                    ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getState());
                                    ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getZip());
                                    ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getCountryName());
                                    ++outputAddressCount;
                                }
                                if (outputAddressCount < 3) continue;
                                break;
                            }
                        }
                        for (int iIdx = outputAddressCount; iIdx < 3; ++iIdx) {
                            for (int jIdx = 0; jIdx < 6; ++jIdx) {
                                ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"");
                            }
                        }
                        String nickname = contactInfoVo.getNickname();
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)nickname);
                        String note = contactInfoVo.getNote();
                        ContactServiceImpl.appendValue((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)note);
                        aFileWriter.append("\n");
                        LOG.debug("exportContactsToGmail 6");
                    }
                    LOG.debug("exportContactsToGmail 7");
                    ((Writer)aFileWriter).flush();
                    LOG.debug("exportContactsToGmail 8");
                    ((Writer)aFileWriter).close();
                    LOG.debug("exportContactsToGmail 9");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void appendValueBySeparator(Writer aFileWriter, String aValue, LangCode langCode) {
        try {
            String getConvertString;
            if (aValue.length() > 0 && (getConvertString = ContactServiceImpl.UTF8ToASCIIString((String)aValue, (LangCode)langCode)) != null) {
                aFileWriter.append(aValue);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String appendValue(Writer aFileWriter, FieldType aValeType, String aValue) {
        String value = aValue;
        if (aValeType == FieldType.STRING) {
            if (aValue != null && aValue.length() > 0) {
                aValue = aValue.replace("\"", "\"\"");
                value = "\"" + aValue + "\"";
            } else {
                value = "";
            }
        } else if (aValeType == FieldType.DATE) {
            value = !StringUtil.IsStringNullorEmpty((String)aValue) ? "\"" + aValue + "\"" : "";
        }
        try {
            if (value.length() > 0) {
                aFileWriter.append(value);
            }
            aFileWriter.append(",");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return aValue;
    }

    private String AppendNoteValue(String fieldString, String titleString) {
        String value = fieldString;
        if (value != null && value.length() > 0) {
            return titleString + " : " + value + "\r";
        }
        return "";
    }

    private static String GetOutlookCSVTitle(LangCode langCode) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$LangCode[langCode.ordinal()]) {
            case 1: {
                return "\u540d\u5b57,\u4e2d\u9593\u540d,\u59d3\u6c0f,\u7a31\u8b02,\u516c\u53f8,\u90e8\u9580,\u8077\u7a31,\u5546\u52d9 - \u8857,\u5546\u52d9 - \u5e02/\u93ae,\u5546\u52d9 - \u7e23/\u5e02,\u5546\u52d9 - \u90f5\u905e\u5340\u865f,\u5546\u52d9 - \u570b\u5bb6/\u5730\u5340,\u4f4f\u5bb6 - \u8857,\u4f4f\u5bb6 - \u5e02/\u93ae,\u4f4f\u5bb6 - \u7e23/\u5e02,\u4f4f\u5bb6 - \u90f5\u905e\u5340\u865f,\u4f4f\u5bb6 - \u570b\u5bb6/\u5730\u5340,\u5176\u4ed6 - \u8857,\u5176\u4ed6 - \u5e02/\u93ae,\u5176\u4ed6 - \u7e23/\u5e02,\u5176\u4ed6 - \u90f5\u905e\u5340\u865f,\u5176\u4ed6 - \u570b\u5bb6/\u5730\u5340,\u5546\u52d9\u50b3\u771f,\u5546\u52d9\u96fb\u8a71,\u5546\u52d9\u96fb\u8a71 2,\u4f4f\u5bb6\u50b3\u771f,\u4f4f\u5bb6\u96fb\u8a71,\u4f4f\u5bb6\u96fb\u8a71 2,\u547c\u53eb\u5668,\u516c\u53f8\u4ee3\u8868\u7dda,\u884c\u52d5\u96fb\u8a71,\u5176\u4ed6\u96fb\u8a71,\u96fb\u5b50\u90f5\u4ef6\u5730\u5740,\u96fb\u5b50\u90f5\u4ef6 2 \u5730\u5740,\u96fb\u5b50\u90f5\u4ef6 3 \u5730\u5740,\u7db2\u9801,\u751f\u65e5,\u7d00\u5ff5\u65e5,\u985e\u5225,\u8a18\u4e8b";
            }
            case 2: {
                return "\u540d,\u4e2d\u95f4\u540d,\u59d3,\u79f0\u8c13,\u5355\u4f4d,\u90e8\u95e8,\u804c\u52a1,\u5546\u52a1\u5730\u5740 \u8857\u9053,\u5546\u52a1\u5730\u5740 \u5e02/\u53bf,\u5546\u52a1\u5730\u5740 \u7701/\u5e02/\u81ea\u6cbb\u533a,\u5546\u52a1\u5730\u5740 \u90ae\u653f\u7f16\u7801,\u5546\u52a1\u5730\u5740 \u56fd\u5bb6/\u5730\u533a,\u4f4f\u5b85\u5730\u5740 \u8857\u9053,\u4f4f\u5b85\u5730\u5740 \u5e02/\u53bf,\u4f4f\u5b85\u5730\u5740 \u7701/\u5e02/\u81ea\u6cbb\u533a,\u4f4f\u5b85\u5730\u5740 \u90ae\u653f\u7f16\u7801,\u4f4f\u5b85\u5730\u5740 \u56fd\u5bb6/\u5730\u533a,\u5176\u4ed6\u5730\u5740 \u8857\u9053,\u5176\u4ed6\u5730\u5740 \u5e02/\u53bf,\u5176\u4ed6\u5730\u5740 \u7701/\u5e02/\u81ea\u6cbb\u533a,\u5176\u4ed6\u5730\u5740 \u90ae\u653f\u7f16\u7801,\u5176\u4ed6\u5730\u5740 \u56fd\u5bb6/\u5730\u533a,\u5546\u52a1\u4f20\u771f,\u5546\u52a1\u7535\u8bdd,\u5546\u52a1\u7535\u8bdd 2,\u4f4f\u5b85\u4f20\u771f,\u4f4f\u5b85\u7535\u8bdd,\u4f4f\u5b85\u7535\u8bdd 2,\u5bfb\u547c\u673a,\u5355\u4f4d\u4e3b\u8981\u7535\u8bdd,\u79fb\u52a8\u7535\u8bdd,\u5176\u5b83\u7535\u8bdd,\u7535\u5b50\u90ae\u4ef6\u5730\u5740,\u7535\u5b50\u90ae\u4ef6 2 \u5730\u5740,\u7535\u5b50\u90ae\u4ef6 3 \u5730\u5740,\u7f51\u9875,\u751f\u65e5,\u7eaa\u5ff5\u65e5,\u7c7b\u522b,\u9644\u6ce8";
            }
            default: {
                return "First Name,Middle Name,Last Name,Suffix,Company,Department,Job Title,Business Street,Business City,Business State,Business Postal Code,Business Country/Region,Home Street,Home City,Home State,Home Postal Code,Home Country/Region,Other Street,Other City,Other State,Other Postal Code,Other Country/Region,Business Fax,Business Phone,Business Phone 2,Home Fax,Home Phone,Home Phone 2,Pager,Company Main Phone,Mobile Phone,Other Phone,E-mail Address,E-mail 2 Address,E-mail 3 Address,Web Page,Birthday,Anniversary,Categories,Notes";
            }
            case 4: {
                return "Vorname,Weitere Vornamen,Nachname,Suffix,Firma,Abteilung,Position,Stra\u00dfe gesch\u00e4ftlich,Ort gesch\u00e4ftlich,Region gesch\u00e4ftlich,Postleitzahl gesch\u00e4ftlich,Land/Region gesch\u00e4ftlich,Stra\u00dfe privat,Ort privat,Bundesland/Kanton privat,Postleitzahl privat,Land/Region privat,Weitere Stra\u00dfe,Weiterer Ort,Weiteres/r Bundesland/Kanton,Weitere Postleitzahl,Weiteres/e Land/Region,Fax gesch\u00e4ftlich,Telefon gesch\u00e4ftlich,Telefon gesch\u00e4ftlich 2,Fax privat,Telefon (privat),Telefon (privat 2),Pager,Telefon Firma,Mobiltelefon,Weiteres Telefon,E-Mail-Adresse,E-Mail-Adresse,E-Mail-Adresse,Webseite,Geburtstag,Jahrestag,Kategorien,Notizen";
            }
            case 5: {
                return "Pr\u00e9nom,Deuxi\u00e8me pr\u00e9nom,Nom,Suffixe,Soci\u00e9t\u00e9,Service,Titre,Rue (bureau),Ville (bureau),D\u00e9p/R\u00e9gion (bureau),Code postal (bureau),Pays/R\u00e9gion (bureau),Rue (domicile),Ville (domicile),D\u00e9p/R\u00e9gion (domicile),Code postal (domicile),Pays/R\u00e9gion (domicile),Rue (autre),Ville (autre),D\u00e9p/R\u00e9gion (autre),Code postal (autre),Pays/R\u00e9gion (autre),T\u00e9l\u00e9copie (bureau),T\u00e9l\u00e9phone (bureau),T\u00e9l\u00e9phone 2 (bureau),T\u00e9l\u00e9copie (domicile),T\u00e9l\u00e9phone (domicile),T\u00e9l\u00e9phone 2 (domicile),R\u00e9cepteur de radiomessagerie,T\u00e9l\u00e9phone soci\u00e9t\u00e9,T\u00e9l. mobile,Autre t\u00e9l\u00e9phone,Adresse de messagerie,Adresse de messagerie,Adresse de messagerie,Page web,Anniversaire,Anniversaire de mariage ou f\u00eate,Cat\u00e9gories,Notes";
            }
            case 6: {
                return "Nome,Secondo nome,Cognome,Titolo straniero,Societ\u00e0,Reparto,Posizione,Via (uff.),Citt\u00e0 (uff.),Provincia (uff.),CAP (uff.),Paese/area geografica (uff.),Via (ab.),Citt\u00e0 (ab.),Provincia (ab.),CAP (ab.),Paese/area geografica (ab.),Altra via,Altra citt\u00e0,Altra provincia,Altro CAP,Altro paese/area geografica,Fax (uff.),Ufficio,Ufficio 2,Fax (ab.),Abitazione,Abitazione 2,Cercapersone,Telefono principale societ\u00e0,Cellulare,Altro tel,Indirizzo posta elettronica,Indirizzo posta elettronica,Indirizzo posta elettronica,Pagina Web,Compleanno,Anniversario,Categorie,Notes";
            }
            case 7: {
                return "Nombre,Segundo nombre,Apellidos,Suffix,Organizaci\u00f3n,Department,Puesto,Calle del trabajo,Ciudad de trabajo,Provincia o estado de trabajo,C\u00f3digo postal del trabajo,Pa\u00eds o regi\u00f3n del trabajo,Home Street,Home City,Home State,Home Postal Code,Pa\u00eds o regi\u00f3n del domicilio,Otra calle,Otra ciudad,Otra provincia o estado,Otro c\u00f3digo postal,Otro pa\u00eds o regi\u00f3n,Business Fax,Tel\u00e9fono del trabajo,Business Phone 2,Home Fax,Particular,Home Phone 2,Pager,N\u00famero de centralita de la organizaci\u00f3n,Mobile Phone,Otro tel\u00e9fono,E-mail Address,E-mail Address,E-mail Address,P\u00e1gina web,Birthday,Anniversary,Categor\u00edas,Notes";
            }
            case 8: {
                return "Primeiro nome,Outros nomes/apelidos,Apelido,Sufixo,Empresa,Departamento,Cargo,Rua da empresa,Localidade da empresa,Distrito da empresa,C\u00f3digo postal da empresa,Pa\u00eds/Regi\u00e3o da Empresa,Rua da resid\u00eancia,Localidade da resid\u00eancia,Distrito da resid\u00eancia,C\u00f3digo postal da resid\u00eancia,Pa\u00eds da Resid\u00eancia/Regi\u00e3o,Rua do outro endere\u00e7o,Localidade do outro endere\u00e7o,Distrito do outro endere\u00e7o,C\u00f3digo postal do outro endere\u00e7o,Outro Pa\u00eds/Regi\u00e3o,Fax da empresa,Telefone da empresa,2\u00ba telefone da empresa,Fax da resid\u00eancia,Telefone da resid\u00eancia,2\u00ba telefone da resid\u00eancia,Pager,Telefone principal da empresa,Telem\u00f3vel,Other Phone,Endere\u00e7o de correio eletr\u00f3nico,Endere\u00e7o de correio eletr\u00f3nico,Endere\u00e7o de correio eletr\u00f3nico,P\u00e1gina na Web,Data de nascimento,Anivers\u00e1rio,Categorias,Notas";
            }
            case 9: {
                return "Voornaam,Middelste naam,Achternaam,Achtervoegsel,Bedrijf,Afdeling,Functie,\"Werkadres, straat\",\"Werkadres, plaats\",\"Werkadres, provincie\",\"Werkadres, postcode\",Land/regio (werk),\"Huisadres, straat\",\"Huisadres, plaats\",\"Huisadres, provincie\",\"Huisadres, postcode\",Land/regio (thuis),\"Ander adres, straat\",\"Ander adres, plaats\",\"Ander adres, provincie\",\"Ander adres, postcode\",Land/regio (anders),Fax op werk,Telefoon op werk,Telefoon op werk 2,Fax thuis,Telefoon thuis,Telefoon thuis 2,Pager,Hoofdtelefoon bedrijf,Mobiele telefoon,Other Phone,E-mailadres,E-mailadres,E-mailadres,Webpagina,Verjaardag,Speciale datum,Categorie\u00ebn,Notities";
            }
            case 10: {
                return "\u540d,\u30df\u30c9\u30eb \u30cd\u30fc\u30e0,\u59d3,\u656c\u79f0,\u4f1a\u793e\u540d,\u90e8\u7f72,\u5f79\u8077,\u756a\u5730 (\u4f1a\u793e),\u5e02\u753a\u6751 (\u4f1a\u793e),\u90fd\u9053\u5e9c\u770c (\u4f1a\u793e),\u90f5\u4fbf\u756a\u53f7 (\u4f1a\u793e),\u56fd (\u4f1a\u793e)/\u5730\u57df,\u756a\u5730 (\u81ea\u5b85),\u5e02\u753a\u6751 (\u81ea\u5b85),\u90fd\u9053\u5e9c\u770c (\u81ea\u5b85),\u90f5\u4fbf\u756a\u53f7 (\u81ea\u5b85),\u56fd (\u81ea\u5b85)/\u5730\u57df,\u756a\u5730 (\u305d\u306e\u4ed6),\u5e02\u753a\u6751 (\u305d\u306e\u4ed6),\u90fd\u9053\u5e9c\u770c (\u305d\u306e\u4ed6),\u90f5\u4fbf\u756a\u53f7 (\u305d\u306e\u4ed6),\u56fd (\u305d\u306e\u4ed6)/\u5730\u57df,\u4f1a\u793e FAX,\u4f1a\u793e\u96fb\u8a71,\u4f1a\u793e\u96fb\u8a71 2,\u81ea\u5b85 FAX,\u81ea\u5b85\u96fb\u8a71,\u81ea\u5b85\u96fb\u8a71 2,\u30dd\u30b1\u30c3\u30c8\u30d9\u30eb,\u4f1a\u793e\u4ee3\u8868\u96fb\u8a71,\u643a\u5e2f\u96fb\u8a71,\u305d\u306e\u4ed6\u306e\u96fb\u8a71,\u96fb\u5b50\u30e1\u30fc\u30eb \u30a2\u30c9\u30ec\u30b9,\u96fb\u5b50\u30e1\u30fc\u30eb 2 \u30a2\u30c9\u30ec\u30b9,\u96fb\u5b50\u30e1\u30fc\u30eb 3 \u30a2\u30c9\u30ec\u30b9,Web \u30da\u30fc\u30b8,\u8a95\u751f\u65e5,\u8a18\u5ff5\u65e5,\u5206\u985e,\u30e1\u30e2";
            }
            case 11: {
                return "\uc774\ub984,\uc911\uac04 \uc774\ub984,\uc131,\ud638\uce6d(\ud55c\uae00),\ud68c\uc0ac,\ubd80\uc11c,\uc9c1\ud568,\uadfc\ubb34\uc9c0 \uc8fc\uc18c \ubc88\uc9c0,\uadfc\ubb34\uc9c0 \uad6c/\uad70/\uc2dc,\uadfc\ubb34\uc9c0 \uc2dc/\ub3c4,\uadfc\ubb34\uc9c0 \uc6b0\ud3b8 \ubc88\ud638,\uadfc\ubb34\uc9c0 \uad6d\uac00/\uc9c0\uc5ed,\uc9d1 \ubc88\uc9c0,\uc9d1 \uc8fc\uc18c \uad6c/\uad70/\uc2dc,\uc9d1 \uc8fc\uc18c \uc2dc/\ub3c4,\uc9d1 \uc8fc\uc18c \uc6b0\ud3b8 \ubc88\ud638,\uc9d1 \uc8fc\uc18c \uad6d\uac00/\uc9c0\uc5ed,\uae30\ud0c0 \ubc88\uc9c0,\uae30\ud0c0 \uad6c/\uad70/\uc2dc,\uae30\ud0c0 \uc2dc/\ub3c4,\uae30\ud0c0 \uc6b0\ud3b8 \ubc88\ud638,\uae30\ud0c0 \uad6d\uac00/\uc9c0\uc5ed,\uadfc\ubb34\uc9c0 \ud329\uc2a4,\uadfc\ubb34\ucc98 \uc804\ud654,\uadfc\ubb34\ucc98 \uc804\ud654 2,\uc9d1 \ud329\uc2a4,\uc9d1 \uc804\ud654 \ubc88\ud638,\uc9d1 \uc804\ud654 2,\ud638\ucd9c\uae30,\ud68c\uc0ac \ub300\ud45c \uc804\ud654,\ud734\ub300\ud3f0,\uae30\ud0c0 \uc804\ud654,\uc804\uc790 \uba54\uc77c \uc8fc\uc18c,\uc804\uc790 \uba54\uc77c 2 \uc8fc\uc18c,\uc804\uc790 \uba54\uc77c 3 \uc8fc\uc18c,\uc6f9 \ud398\uc774\uc9c0,\uc0dd\uc77c,\uacb0\ud63c \uae30\ub150\uc77c,\ubc94\uc8fc \ud56d\ubaa9,\uba54\ubaa8";
            }
            case 12: {
                return "Imi\u00ea,Drugie imi\u00ea,Nazwisko,Sufiks,Firma,Dzia\u00b3,Stanowisko,Adres s\u00b3u\u00bfbowy - ulica,Adres s\u00b3u\u00bfbowy - miejscowo\u0153\u00e6,Adres s\u00b3u\u00bfbowy - wojew\u00f3dztwo,Adres s\u00b3u\u00bfbowy - kod pocztowy,Adres s\u00b3u\u00bfbowy - kraj/region,Adres domowy - ulica,Adres domowy - miejscowo\u0153\u00e6,Adres domowy - wojew\u00f3dztwo,Adres domowy - kod pocztowy,Adres domowy - kraj/region,Inny adres - ulica,Inny adres - miejscowo\u0153\u00e6,Inny adres - wojew\u00f3dztwo,Inny adres - kod pocztowy,Inny adres - kraj/region,Faks s\u00b3u\u00bfbowy,Telefon s\u00b3u\u00bfbowy,Telefon s\u00b3u\u00bfbowy 2,Faks domowy,Telefon domowy,Telefon domowy 2,Pager,G\u00b3\u00f3wny telefon do firmy,Telefon kom\u00f3rkowy,Other Phone,Adres e-mail,Adres e-mail,Adres e-mail,Strona sieci Web,Urodziny,Rocznica,Kategorie,Notatki";
            }
            case 13: 
        }
        return "\u00ddlk Ad\u00fd,\u00ddkinci Ad\u00fd,Soyad\u00fd,Sonek,\u00deirket,B\u00f6l\u00fcm,\u00dd\u00fe Unvan\u00fd,\u00dd\u00fe-Cadde,\u00dd\u00fe-\u00deehir,\u00dd\u00fe-B\u00f6lge,\u00dd\u00fe-Posta Kodu,\u00dd\u00fe-\u00dclke/B\u00f6lge,Ev-Cadde,Ev-\u00deehir,Ev-B\u00f6lge,Ev-Posta Kodu,Ev-\u00dclke/B\u00f6lge,Di\u00f0er-Cadde,Di\u00f0er-\u00deehir,Di\u00f0er-B\u00f6lge,Di\u00f0er-Posta Kodu,Di\u00f0er-\u00dclke/B\u00f6lge,\u00dd\u00fe Faks No,\u00dd\u00fe Telefon No,\u00dd\u00fe Telefonu 2,Ev-Faks No,Ev Telefonu,Ev Telefonu 2,\u00c7a\u00f0r\u00fd Cihaz\u00fd,\u00deirket Santral Telefonu,Cep Telefonu,Di\u011fer Tel,Elektronik Posta Adresi,Elektronik Posta Adresi,Elektronik Posta Adresi,Web Sayfas\u00fd,Do\u00f0um g\u00fcn\u00fc,Y\u00fdld\u00f6n\u00fcm\u00fc,Kategoriler,Notlar";
    }

    public void exportCSVForOutlook(String accountGuid, List<String> contactGuids, String filePath, LangCode langCode) {
        LOG.debug("exportCSVForOutlook 1");
        File getFilePath = new File(filePath);
        if (getFilePath != null) {
            try {
                BufferedWriter aFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(getFilePath), ContactServiceImpl.GetCharSet((LangCode)langCode)));
                if (aFileWriter != null) {
                    FieldStringFormat fieldStringFormat = new FieldStringFormat();
                    aFileWriter.append(ContactServiceImpl.GetOutlookCSVTitle((LangCode)langCode));
                    aFileWriter.append("\n");
                    for (String contactGuid : contactGuids) {
                        ContactInfoExVo contactInfoVo = this.contactPrivateService.getContactInfoExByGuid(contactGuid, accountGuid);
                        if (contactInfoVo == null) continue;
                        String note = "";
                        String first_name = "";
                        String last_name = "";
                        String prefix_name = "";
                        String suffix_name = "";
                        String middle_name = "";
                        if (contactInfoVo.getNames() != null) {
                            boolean isFirst = true;
                            for (ContactnameInfo contactnameInfo : contactInfoVo.getNames()) {
                                if (isFirst) {
                                    contactnameInfo.getFirstName();
                                    contactnameInfo.getLastName();
                                    first_name = contactnameInfo.getFirstName();
                                    last_name = contactnameInfo.getLastName();
                                    middle_name = contactnameInfo.getMiddleName();
                                    prefix_name = contactnameInfo.getPrefix();
                                    suffix_name = contactnameInfo.getSuffix();
                                    isFirst = false;
                                    continue;
                                }
                                note = note + this.AppendNoteValue(contactnameInfo.getFirstName(), "First");
                                note = note + this.AppendNoteValue(contactnameInfo.getLastName(), "Last");
                                note = note + this.AppendNoteValue(contactnameInfo.getFirstNamePronunce(), "First Phonetic");
                                note = note + this.AppendNoteValue(contactnameInfo.getLastNamePronunce(), "Last Phonetic");
                                note = note + this.AppendNoteValue(contactnameInfo.getMiddleName(), "Middle");
                                note = note + this.AppendNoteValue(contactnameInfo.getPrefix(), "Prefix");
                                note = note + this.AppendNoteValue(contactnameInfo.getSuffix(), "Suffix");
                            }
                        }
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)first_name, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)middle_name, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)last_name, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)suffix_name, (LangCode)langCode);
                        String company = "";
                        String department = "";
                        String job_title = "";
                        if (contactInfoVo.getJobinfos() != null) {
                            boolean isFirst = true;
                            for (ContactjobinfoInfo contactJobInfo : contactInfoVo.getJobinfos()) {
                                if (isFirst) {
                                    isFirst = false;
                                    company = contactJobInfo.getCompanyName();
                                    job_title = contactJobInfo.getJobTitle();
                                    department = contactJobInfo.getDepartment();
                                    continue;
                                }
                                note = note + this.AppendNoteValue(contactJobInfo.getCompanyName(), "Company");
                                note = note + this.AppendNoteValue(contactJobInfo.getCompanyPronunce(), "Company Phonetic");
                                note = note + this.AppendNoteValue(contactJobInfo.getJobTitle(), "Job Title");
                                note = note + this.AppendNoteValue(contactJobInfo.getDepartment(), "Department");
                            }
                        }
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)company, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)department, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)job_title, (LangCode)langCode);
                        boolean isExport = false;
                        if (contactInfoVo.getAddresses() != null) {
                            for (ContactaddressInfo contactaddressInfo : contactInfoVo.getAddresses()) {
                                if (contactaddressInfo.getType() != ContactFieldType.BUSINESS) continue;
                                if (!isExport) {
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getStreet(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getCity(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getState(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getZip(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getCountryName(), (LangCode)langCode);
                                    isExport = true;
                                    break;
                                }
                                note = note + this.AppendNoteValue(contactaddressInfo.GetFullAddress(), "Address (Work)");
                                break;
                            }
                        }
                        if (!isExport) {
                            for (int i = 0; i < 5; ++i) {
                                ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"", (LangCode)langCode);
                            }
                        }
                        isExport = false;
                        if (contactInfoVo.getAddresses() != null) {
                            for (ContactaddressInfo contactaddressInfo : contactInfoVo.getAddresses()) {
                                if (contactaddressInfo.getType() != ContactFieldType.HOME) continue;
                                if (!isExport) {
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getStreet(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getCity(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getState(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getZip(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getCountryName(), (LangCode)langCode);
                                    isExport = true;
                                    break;
                                }
                                note = note + this.AppendNoteValue(contactaddressInfo.GetFullAddress(), "Address (Home)");
                                break;
                            }
                        }
                        if (!isExport) {
                            for (int i = 0; i < 5; ++i) {
                                ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"", (LangCode)langCode);
                            }
                        }
                        isExport = false;
                        if (contactInfoVo.getAddresses() != null) {
                            for (ContactaddressInfo contactaddressInfo : contactInfoVo.getAddresses()) {
                                if (contactaddressInfo.getType() != ContactFieldType.OTHER) continue;
                                if (!isExport) {
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getStreet(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getCity(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getState(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getZip(), (LangCode)langCode);
                                    ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)contactaddressInfo.getCountryName(), (LangCode)langCode);
                                    isExport = true;
                                    break;
                                }
                                note = note + this.AppendNoteValue(contactaddressInfo.GetFullAddress(), "Address (Other)");
                                break;
                            }
                        }
                        if (!isExport) {
                            for (int i = 0; i < 5; ++i) {
                                ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)"", (LangCode)langCode);
                            }
                        }
                        String phone_work0 = "";
                        String phone_work1 = "";
                        String phone_home0 = "";
                        String phone_home1 = "";
                        String phone_work_fax = "";
                        String phone_home_fax = "";
                        String phone_mobile = "";
                        String phone_main = "";
                        String phone_pager = "";
                        String phone_other = "";
                        if (contactInfoVo.getPhones() != null) {
                            FieldStringFormat HomeStringFormat = new FieldStringFormat();
                            FieldStringFormat WorkStringFormat = new FieldStringFormat();
                            for (Object contactPhoneInfo : contactInfoVo.getPhones()) {
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactPhoneType[contactPhoneInfo.getType().ordinal()]) {
                                    case 1: {
                                        phone_home0 = HomeStringFormat.ConvertTwoValue(phone_home0, phone_home1, contactPhoneInfo.getValue(), note, "Phone(Home)");
                                        phone_home1 = HomeStringFormat.getFieldTwo();
                                        note = HomeStringFormat.getNote();
                                        break;
                                    }
                                    case 2: {
                                        phone_work0 = WorkStringFormat.ConvertTwoValue(phone_work0, phone_work1, contactPhoneInfo.getValue(), note, "Phone(Work)");
                                        phone_work1 = WorkStringFormat.getFieldTwo();
                                        note = WorkStringFormat.getNote();
                                        break;
                                    }
                                    case 3: {
                                        phone_home_fax = fieldStringFormat.ConvertValue(phone_home_fax, contactPhoneInfo.getValue(), note, "Phone(HomeFax)");
                                        note = fieldStringFormat.getNote();
                                        break;
                                    }
                                    case 4: {
                                        phone_work_fax = fieldStringFormat.ConvertValue(phone_work_fax, contactPhoneInfo.getValue(), note, "Phone(WorkFax)");
                                        note = fieldStringFormat.getNote();
                                        break;
                                    }
                                    case 5: {
                                        phone_other = fieldStringFormat.ConvertValue(phone_other, contactPhoneInfo.getValue(), note, "Phone(Other)");
                                        note = fieldStringFormat.getNote();
                                        break;
                                    }
                                    case 6: {
                                        phone_mobile = fieldStringFormat.ConvertValue(phone_mobile, contactPhoneInfo.getValue(), note, "Phone(Mobile)");
                                        note = fieldStringFormat.getNote();
                                        break;
                                    }
                                    case 7: {
                                        phone_main = fieldStringFormat.ConvertValue(phone_main, contactPhoneInfo.getValue(), note, "Phone(Main)");
                                        note = fieldStringFormat.getNote();
                                        break;
                                    }
                                    case 8: {
                                        phone_pager = fieldStringFormat.ConvertValue(phone_pager, contactPhoneInfo.getValue(), note, "Phone(Pager)");
                                        note = fieldStringFormat.getNote();
                                        break;
                                    }
                                    case 9: {
                                        note = "Phone(Google Voice) : " + contactPhoneInfo.getValue() + "\r";
                                        break;
                                    }
                                    case 10: {
                                        note = "Phone(iPhone) : " + contactPhoneInfo.getValue() + "\r";
                                    }
                                }
                            }
                        }
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_work_fax, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_work0, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_work1, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_home_fax, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_home0, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_home1, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_pager, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_main, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_mobile, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)phone_other, (LangCode)langCode);
                        String email_address1 = "";
                        String email_address2 = "";
                        String email_address3 = "";
                        if (contactInfoVo.getEmails() != null) {
                            Object contactPhoneInfo;
                            contactPhoneInfo = contactInfoVo.getEmails().iterator();
                            while (contactPhoneInfo.hasNext()) {
                                ContactemailInfo contactemailInfo = (ContactemailInfo)contactPhoneInfo.next();
                                if (StringUtil.IsStringNullorEmpty((String)email_address1)) {
                                    email_address1 = contactemailInfo.getValue();
                                    continue;
                                }
                                if (StringUtil.IsStringNullorEmpty((String)email_address2)) {
                                    email_address2 = contactemailInfo.getValue();
                                    continue;
                                }
                                if (StringUtil.IsStringNullorEmpty((String)email_address3)) {
                                    email_address3 = contactemailInfo.getValue();
                                    continue;
                                }
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactFieldType[contactemailInfo.getType().ordinal()]) {
                                    case 1: {
                                        note = note + "Email (Home) : " + contactemailInfo.getValue() + "\r";
                                        break;
                                    }
                                    case 2: {
                                        note = note + "Email (Work) : " + contactemailInfo.getValue() + "\r";
                                        break;
                                    }
                                    case 3: {
                                        note = note + "Email (Other) : " + contactemailInfo.getValue() + "\r";
                                    }
                                }
                            }
                        }
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)email_address1, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)email_address2, (LangCode)langCode);
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)email_address3, (LangCode)langCode);
                        String web_homepage = "";
                        if (contactInfoVo.getUrls() != null) {
                            for (ContacturlInfo contacturlInfo : contactInfoVo.getUrls()) {
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactUrlType[contacturlInfo.getType().ordinal()]) {
                                    case 1: {
                                        web_homepage = contacturlInfo.getValue();
                                        note = note + this.AppendNoteValue(contacturlInfo.getValue(), "URL (Homepage)");
                                        break;
                                    }
                                    case 2: {
                                        note = note + "URL (Home) : " + contacturlInfo.getValue() + "\r";
                                        break;
                                    }
                                    case 3: {
                                        note = note + "URL (Work) : " + contacturlInfo.getValue() + "\r";
                                        break;
                                    }
                                    case 4: {
                                        note = note + "URL (Profile) : " + contacturlInfo.getValue() + "\r";
                                        break;
                                    }
                                    case 5: {
                                        note = note + "URL (Blog) : " + contacturlInfo.getValue() + "\r";
                                        break;
                                    }
                                    case 6: {
                                        note = note + "URL (Other) : " + contacturlInfo.getValue() + "\r";
                                    }
                                }
                            }
                        }
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)web_homepage, (LangCode)langCode);
                        DateTimeFormatter outlooktimefmater = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
                        String birthday = "";
                        if (contactInfoVo.getBirthday() != null) {
                            birthday = outlooktimefmater.print((ReadableInstant)contactInfoVo.getBirthday());
                        }
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.DATE, (String)birthday, (LangCode)langCode);
                        String anniversary = "";
                        if (contactInfoVo.getDates() != null) {
                            for (ContactdateInfo contactdateInfo : contactInfoVo.getDates()) {
                                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactDateType[contactdateInfo.getType().ordinal()]) {
                                    case 1: {
                                        if (StringUtil.IsStringNullorEmpty((String)anniversary)) {
                                            anniversary = outlooktimefmater.print((ReadableInstant)contactdateInfo.getValue());
                                            break;
                                        }
                                        note = note + this.AppendNoteValue(outlooktimefmater.print((ReadableInstant)contactdateInfo.getValue()), "Anniversary");
                                        break;
                                    }
                                    case 2: {
                                        note = note + "Date (Other) : " + outlooktimefmater.print((ReadableInstant)contactdateInfo.getValue()) + "\r";
                                    }
                                }
                            }
                        }
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.DATE, (String)anniversary, (LangCode)langCode);
                        if (contactInfoVo.getNickname() != null) {
                            note = note + "Nickname : " + contactInfoVo.getNickname() + "\r";
                        }
                        String groupName = "";
                        if (contactInfoVo.getBelongCategories() != null) {
                            for (CategoryInfo categoryInfo : contactInfoVo.getBelongCategories()) {
                                if (categoryInfo.getCategoryType() != CategoryType.NORMAL) continue;
                                if (StringUtil.IsStringNullorEmpty((String)groupName)) {
                                    groupName = categoryInfo.getName();
                                    continue;
                                }
                                groupName = groupName + ";" + categoryInfo.getName();
                            }
                        }
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)groupName, (LangCode)langCode);
                        if (contactInfoVo.getNote() != null) {
                            note = note + contactInfoVo.getNote();
                        }
                        ContactServiceImpl.appendValueByLocal((Writer)aFileWriter, (FieldType)FieldType.STRING, (String)note, (LangCode)langCode);
                        ContactServiceImpl.appendValueBySeparator((Writer)aFileWriter, (String)"\r\n", (LangCode)langCode);
                    }
                }
                ((Writer)aFileWriter).flush();
                ((Writer)aFileWriter).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String appendValueByLocal(Writer aFileWriter, FieldType aValeType, String aValue, LangCode langCode) {
        String value = aValue;
        if (aValeType == FieldType.STRING) {
            if (aValue != null && aValue.length() > 0) {
                aValue = aValue.replace("\"", "\"\"");
                value = "\"" + aValue + "\"";
            } else {
                value = "";
            }
        } else if (aValeType == FieldType.DATE) {
            value = !StringUtil.IsStringNullorEmpty((String)aValue) ? "\"" + aValue + "\"" : "";
        }
        try {
            String getConvertString;
            if (value.length() > 0 && (getConvertString = ContactServiceImpl.UTF8ToASCIIString((String)value, (LangCode)langCode)) != null) {
                aFileWriter.append(value);
            }
            aFileWriter.append(",");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return aValue;
    }

    private static String GetCharSet(LangCode langCode) {
        String getCharSet = "US-ASCII";
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$LangCode[langCode.ordinal()]) {
            case 1: {
                getCharSet = "Big5";
                break;
            }
            case 2: {
                getCharSet = "GBK";
                break;
            }
            default: {
                getCharSet = "US-ASCII";
                break;
            }
            case 11: {
                getCharSet = "EUC-KR";
                break;
            }
            case 10: {
                getCharSet = "SHIFT-JIS";
            }
        }
        return getCharSet;
    }

    private static String UTF8ToASCIIString(String aUnicode, LangCode langCode) {
        String asciiString = null;
        String getCharSet = ContactServiceImpl.GetCharSet((LangCode)langCode);
        try {
            asciiString = new String(aUnicode.getBytes(getCharSet), getCharSet);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asciiString;
    }

    public boolean exportOneVCard(String accountGuid, String contactGuid, String filePath, String fileName, VCardTarget vcardTarget) {
        Path zipFileName = Paths.get(filePath, fileName);
        String strFileName = this.exportOneVCard2File(accountGuid, contactGuid, zipFileName.toString(), vcardTarget);
        return !StringUtil.IsStringNullorEmpty((String)strFileName);
    }

    private String exportOneVCard2File(String accountGuid, String contactGuid, String fileName, VCardTarget vcardTarget) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$VCardTarget[vcardTarget.ordinal()]) {
            case 1: {
                return this.exportOneVCard2AppleFile(accountGuid, contactGuid, fileName);
            }
        }
        return this.exportOneVCard2GoogleFile(accountGuid, contactGuid, fileName);
    }

    private String exportOneVCard2AppleFile(String accountGuid, String contactGuid, String fileName) {
        LOG.debug("exportOneVCard 1");
        String LABEL_PARAM = "LABEL";
        String NL = "\r\n";
        ContactInfoExVo contactInfoVo = this.contactPrivateService.getContactInfoExByGuid(contactGuid, accountGuid);
        String contactName = "";
        if (contactInfoVo != null) {
            block78: {
                String contactFirstName = "";
                String contactLastName = "";
                if (contactInfoVo.getNames() != null && contactInfoVo.getNames().size() > 0) {
                    contactFirstName = ((ContactnameInfo)contactInfoVo.getNames().get(0)).getFirstName();
                    contactLastName = ((ContactnameInfo)contactInfoVo.getNames().get(0)).getLastName();
                }
                if (StringUtil.IsStringNullorEmpty((String)contactFirstName) && StringUtil.IsStringNullorEmpty((String)contactLastName)) {
                    contactName = "empty";
                } else {
                    Account acnt = this.accountDao.findOne(accountGuid);
                    contactName = ContactServiceImpl.containsAsianScript((String)contactFirstName) || ContactServiceImpl.containsAsianScript((String)contactLastName) ? (acnt.getAccountPrivateSetting().getAsianSurnameOrder() == NameOrder.FIRSTNAME_LASTNAME ? contactFirstName + contactLastName : contactLastName + contactFirstName) : (acnt.getAccountPrivateSetting().getWesternSurnameOrder() == NameOrder.FIRSTNAME_LASTNAME ? contactFirstName + "_" + contactLastName : contactLastName + contactFirstName);
                }
                LOG.debug("exportOneVCard 2");
                BufferedWriter ptrCardBuffer = null;
                try {
                    ptrCardBuffer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
                }
                catch (Exception ee) {
                    return "";
                }
                try {
                    Iterator isFirstField2;
                    if (ptrCardBuffer == null) break block78;
                    ptrCardBuffer.append("BEGIN:VCARD").append(NL);
                    ptrCardBuffer.append("VERSION:3.0").append(NL);
                    if (contactInfoVo.getNames() != null && contactInfoVo.getNames().size() > 0) {
                        String connectName;
                        ContactnameInfo contactnameInfo = (ContactnameInfo)contactInfoVo.getNames().get(0);
                        String prefixName = contactnameInfo.getPrefix();
                        String firstName = contactnameInfo.getFirstName();
                        String middleName = contactnameInfo.getMiddleName();
                        String lastName = contactnameInfo.getLastName();
                        String suffixName = contactnameInfo.getSuffix();
                        boolean IsUTF8 = false;
                        ptrCardBuffer.append("FN");
                        if (!(ContactServiceImpl.IsASCII((String)lastName) && ContactServiceImpl.IsASCII((String)firstName) && ContactServiceImpl.IsASCII((String)middleName) && ContactServiceImpl.IsASCII((String)prefixName) && ContactServiceImpl.IsASCII((String)suffixName))) {
                            ptrCardBuffer.append(";CHARSET=UTF-8");
                            IsUTF8 = true;
                        }
                        if (ContactServiceImpl.isCJKString((String)(connectName = (String)prefixName + firstName + middleName + lastName + suffixName))) {
                            ptrCardBuffer.append(":").append(prefixName != null ? prefixName.trim() : "").append(lastName != null ? lastName.trim() : "").append(middleName != null ? middleName.trim() : "").append(firstName != null ? firstName.trim() : "").append(suffixName != null ? suffixName.trim() : "").append(NL);
                        } else {
                            ptrCardBuffer.append(":").append(prefixName != null ? prefixName.trim() : "").append(" ").append(firstName != null ? firstName.trim() : "").append(" ").append(middleName != null ? middleName.trim() : "").append(" ").append(lastName != null ? lastName.trim() : "").append(" ").append(suffixName != null ? suffixName.trim() : "").append(NL);
                        }
                        ptrCardBuffer.append("N");
                        if (IsUTF8) {
                            ptrCardBuffer.append(";CHARSET=UTF-8");
                        }
                        ptrCardBuffer.append(":").append(lastName != null ? lastName.trim() : "").append(";").append(firstName != null ? firstName.trim() : "").append(";").append(middleName != null ? middleName.trim() : "").append(";").append(prefixName != null ? prefixName.trim() : "").append(";").append(suffixName != null ? suffixName.trim() : "").append(NL);
                    }
                    if (contactInfoVo.getNickname() != null) {
                        String NikeName = contactInfoVo.getNickname();
                        ContactServiceImpl.appendField((Appendable)ptrCardBuffer, (String)"NICKNAME", (String)contactInfoVo.getNickname());
                    }
                    if (contactInfoVo.getEmails() != null) {
                        boolean isFirstField2 = true;
                        for (ContactemailInfo contactemailInfo : contactInfoVo.getEmails()) {
                            if (contactemailInfo.getValue() == null || contactemailInfo.getValue().length() <= 0) continue;
                            ptrCardBuffer.append("EMAIL;TYPE=INTERNET");
                            if (isFirstField2) {
                                isFirstField2 = false;
                                ptrCardBuffer.append(";TYPE=PREF");
                            }
                            isFirstField2 = false;
                            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactFieldType[contactemailInfo.getType().ordinal()]) {
                                case 1: {
                                    ptrCardBuffer.append(";TYPE=HOME");
                                    break;
                                }
                                case 2: {
                                    ptrCardBuffer.append(";TYPE=WORK");
                                    break;
                                }
                                case 3: {
                                    ptrCardBuffer.append(";LABEL=");
                                    ptrCardBuffer.append("Unknow");
                                }
                            }
                            if (!ContactServiceImpl.IsASCII((String)contactemailInfo.getValue())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":").append(contactemailInfo.getValue().trim()).append(NL);
                        }
                    }
                    if (contactInfoVo.getPhones() != null) {
                        for (ContactphoneInfo contactphoneInfo : contactInfoVo.getPhones()) {
                            if (contactphoneInfo.getValue() == null || contactphoneInfo.getValue().length() <= 0) continue;
                            ptrCardBuffer.append("TEL");
                            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactPhoneType[contactphoneInfo.getType().ordinal()]) {
                                case 1: {
                                    ptrCardBuffer.append(";TYPE=HOME");
                                    break;
                                }
                                case 2: {
                                    ptrCardBuffer.append(";TYPE=WORK");
                                    break;
                                }
                                case 3: {
                                    ptrCardBuffer.append(";TYPE=FAX;TYPE=HOME");
                                    break;
                                }
                                case 4: {
                                    ptrCardBuffer.append(";TYPE=FAX;TYPE=WORK");
                                    break;
                                }
                                case 6: {
                                    ptrCardBuffer.append(";TYPE=CELL");
                                    break;
                                }
                                case 7: {
                                    ptrCardBuffer.append(";TYPE=MAIN");
                                    break;
                                }
                                case 8: {
                                    ptrCardBuffer.append(";TYPE=PAGER");
                                    break;
                                }
                                case 10: {
                                    ptrCardBuffer.append(";TYPE=IPHONE;type=CELL;type=VOICE");
                                    break;
                                }
                                case 5: 
                                case 9: {
                                    ptrCardBuffer.append(";LABEL=");
                                    ptrCardBuffer.append("Unknow");
                                }
                            }
                            if (!ContactServiceImpl.IsASCII((String)contactphoneInfo.getValue())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":").append(contactphoneInfo.getValue().trim()).append(NL);
                        }
                    }
                    if (contactInfoVo.getJobinfos() != null && contactInfoVo.getJobinfos().size() > 0 && (isFirstField2 = contactInfoVo.getJobinfos().iterator()).hasNext()) {
                        String getTitile;
                        String getDepartment;
                        ContactjobinfoInfo contactjobinfoInfo = (ContactjobinfoInfo)isFirstField2.next();
                        ptrCardBuffer.append("ORG");
                        boolean hasData = false;
                        if (!StringUtil.IsStringNullorEmpty((String)contactjobinfoInfo.getCompanyName())) {
                            hasData = true;
                            if (!ContactServiceImpl.IsASCII((String)contactjobinfoInfo.getCompanyName())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                                ptrCardBuffer.append(":").append(contactjobinfoInfo.getCompanyName().trim());
                            } else {
                                ptrCardBuffer.append(":").append(contactjobinfoInfo.getCompanyName().trim());
                            }
                        }
                        if ((getDepartment = contactjobinfoInfo.getDepartment()) != null) {
                            hasData = true;
                            ptrCardBuffer.append(";").append(getDepartment.trim()).append(NL);
                        }
                        if (!hasData) {
                            ptrCardBuffer.append(";");
                        }
                        if ((getTitile = contactjobinfoInfo.getJobTitle()) != null) {
                            ptrCardBuffer.append("TITLE");
                            if (!ContactServiceImpl.IsASCII((String)getTitile)) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":").append(getTitile.trim()).append(NL);
                        }
                    }
                    if (contactInfoVo.getAddresses() != null && contactInfoVo.getAddresses().size() > 0) {
                        boolean isFirstField3 = true;
                        for (ContactaddressInfo contactaddressInfo : contactInfoVo.getAddresses()) {
                            String street = contactaddressInfo.getStreet();
                            String city = contactaddressInfo.getCity();
                            String region = contactaddressInfo.getState();
                            String zipcode = contactaddressInfo.getZip();
                            String country = contactaddressInfo.getCountryName();
                            String gps = "";
                            ptrCardBuffer.append("ADR");
                            if (isFirstField3) {
                                isFirstField3 = false;
                                ptrCardBuffer.append(";TYPE=PREF");
                            }
                            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactFieldType[contactaddressInfo.getType().ordinal()]) {
                                case 1: {
                                    ptrCardBuffer.append(";TYPE=HOME");
                                    break;
                                }
                                case 2: {
                                    ptrCardBuffer.append(";TYPE=WORK");
                                    break;
                                }
                                default: {
                                    ptrCardBuffer.append(";LABEL=");
                                    ptrCardBuffer.append("Unknow");
                                }
                            }
                            if (!(ContactServiceImpl.IsASCII((String)street) && ContactServiceImpl.IsASCII((String)city) && ContactServiceImpl.IsASCII((String)region) && ContactServiceImpl.IsASCII((String)zipcode) && ContactServiceImpl.IsASCII((String)country))) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":;;").append(street != null ? street.trim() : "").append(";").append(city != null ? city.trim() : "").append(";").append(region != null ? region.trim() : "").append(";").append(zipcode != null ? zipcode.trim() : "").append(";").append(country != null ? country.trim() : "").append(NL);
                            if (gps == null || gps.length() <= 0) continue;
                            ptrCardBuffer.append("GEO");
                            ptrCardBuffer.append(":").append(gps).append(NL);
                        }
                    }
                    if (contactInfoVo.getIMs() != null && contactInfoVo.getIMs().size() > 0) {
                        for (ContactIMInfo contactIMInfo : contactInfoVo.getIMs()) {
                            boolean IsExport = true;
                            if (StringUtil.IsStringNullorEmpty((String)contactIMInfo.getValue())) continue;
                            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactIMType[contactIMInfo.getType().ordinal()]) {
                                case 1: {
                                    ptrCardBuffer.append("X-WHATSAPP");
                                    break;
                                }
                                case 2: {
                                    ptrCardBuffer.append("X-ZOOM");
                                    break;
                                }
                                case 3: {
                                    ptrCardBuffer.append("X-LINE");
                                    break;
                                }
                                case 4: {
                                    ptrCardBuffer.append("X-WECHAT");
                                    break;
                                }
                                case 5: {
                                    ptrCardBuffer.append("X-MSN");
                                    break;
                                }
                                case 6: {
                                    ptrCardBuffer.append("X-SKYPE");
                                    break;
                                }
                                case 7: {
                                    ptrCardBuffer.append("X-QQ");
                                    break;
                                }
                                case 8: {
                                    ptrCardBuffer.append("X-YAHOO");
                                    break;
                                }
                                case 9: {
                                    ptrCardBuffer.append("X-ICQ");
                                    break;
                                }
                                case 10: {
                                    ptrCardBuffer.append("X-GTALK");
                                    break;
                                }
                                case 11: {
                                    ptrCardBuffer.append("X-JABBER");
                                    break;
                                }
                                case 12: {
                                    ptrCardBuffer.append("X-AIM");
                                    break;
                                }
                                default: {
                                    IsExport = false;
                                }
                            }
                            if (!IsExport) continue;
                            if (!ContactServiceImpl.IsASCII((String)contactIMInfo.getValue())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":").append(contactIMInfo.getValue().trim()).append(NL);
                        }
                    }
                    if (contactInfoVo.getUrls() != null) {
                        for (ContacturlInfo contacturlInfo : contactInfoVo.getUrls()) {
                            if (contacturlInfo.getType() != ContactUrlType.PERSONAL || StringUtil.IsStringNullorEmpty((String)contacturlInfo.getValue())) continue;
                            if (!ContactServiceImpl.IsASCII((String)contacturlInfo.getValue())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append("URL");
                            ptrCardBuffer.append(":").append(contacturlInfo.getValue().trim()).append(NL);
                            break;
                        }
                    }
                    if (!StringUtil.IsStringNullorEmpty((String)contactInfoVo.getNote())) {
                        ContactServiceImpl.appendField((Appendable)ptrCardBuffer, (String)"NOTE", (String)contactInfoVo.getNote());
                    }
                    if (contactInfoVo.getBirthday() != null) {
                        String date_string = contactInfoVo.getBirthday().toString().replace(" ", "T");
                        String[] splitValue = date_string.split("T");
                        String getDate = splitValue[0].trim();
                        ContactServiceImpl.appendField((Appendable)ptrCardBuffer, (String)"BDAY", (String)getDate);
                    }
                    for (ContactimageInfo contactimageInfo : contactInfoVo.getImages()) {
                        if (StringUtil.IsStringNullorEmpty((String)contactimageInfo.getGuid()) || contactimageInfo.getType() != ContactImageType.LOGO) continue;
                        byte[] arrayByte = new byte[]{};
                        try {
                            arrayByte = this.contactPrivateService.getImageContent(contactGuid, ContactImageType.LOGO);
                        }
                        catch (IOException e) {
                            LOG.debug("Card has no  exception : {}", (Object)e.getMessage());
                        }
                        String imageBase64 = Base64.encodeBase64String((byte[])arrayByte);
                        if (imageBase64.length() <= 0) break;
                        ptrCardBuffer.append("PHOTO;TYPE=JPEG;ENCODING=BASE64:");
                        ptrCardBuffer.append(imageBase64);
                        ptrCardBuffer.append(NL);
                        break;
                    }
                    ptrCardBuffer.append("END:VCARD").append(NL);
                    ((Writer)ptrCardBuffer).close();
                }
                catch (IOException e) {
                    LOG.debug("exportOneVCard exception msg={}", (Object)e.getMessage());
                    return "";
                }
            }
            return contactName;
        }
        LOG.debug("exportOneVCard fail");
        return "";
    }

    private static boolean containsAsianScript(String str) {
        LOG.debug("containsAsianScript string={}", (Object)str);
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isIdeographic(str.codePointAt(i))) continue;
            LOG.debug("containsAsianScript yes");
            return true;
        }
        LOG.debug("containsAsianScript no");
        return false;
    }

    private String exportOneVCard2GoogleFile(String accountGuid, String contactGuid, String fileName) {
        LOG.debug("exportOneVCard 1");
        String LABEL_PARAM = "LABEL";
        String NL = "\r\n";
        ContactInfoExVo contactInfoVo = this.contactPrivateService.getContactInfoExByGuid(contactGuid, accountGuid);
        String contactName = "";
        if (contactInfoVo != null) {
            block77: {
                String contactFirstName = "";
                String contactLastName = "";
                if (contactInfoVo.getNames() != null && contactInfoVo.getNames().size() > 0) {
                    contactFirstName = ((ContactnameInfo)contactInfoVo.getNames().get(0)).getFirstName();
                    contactLastName = ((ContactnameInfo)contactInfoVo.getNames().get(0)).getLastName();
                }
                if (StringUtil.IsStringNullorEmpty((String)contactFirstName) && StringUtil.IsStringNullorEmpty((String)contactLastName)) {
                    contactName = "empty";
                } else {
                    Account acnt = this.accountDao.findOne(accountGuid);
                    contactName = ContactServiceImpl.containsAsianScript((String)contactFirstName) || ContactServiceImpl.containsAsianScript((String)contactLastName) ? (acnt.getAccountPrivateSetting().getAsianSurnameOrder() == NameOrder.FIRSTNAME_LASTNAME ? contactFirstName + contactLastName : contactLastName + contactFirstName) : (acnt.getAccountPrivateSetting().getWesternSurnameOrder() == NameOrder.FIRSTNAME_LASTNAME ? contactFirstName + "_" + contactLastName : contactLastName + contactFirstName);
                }
                LOG.debug("exportOneVCard 2");
                BufferedWriter ptrCardBuffer = null;
                try {
                    ptrCardBuffer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
                }
                catch (Exception ee) {
                    return "";
                }
                try {
                    Iterator isFirstField2;
                    if (ptrCardBuffer == null) break block77;
                    ptrCardBuffer.append("BEGIN:VCARD").append(NL);
                    ptrCardBuffer.append("VERSION:3.0").append(NL);
                    if (contactInfoVo.getNames() != null && contactInfoVo.getNames().size() > 0) {
                        String connectName;
                        ContactnameInfo contactnameInfo = (ContactnameInfo)contactInfoVo.getNames().get(0);
                        String prefixName = contactnameInfo.getPrefix();
                        String firstName = contactnameInfo.getFirstName();
                        String middleName = contactnameInfo.getMiddleName();
                        String lastName = contactnameInfo.getLastName();
                        String suffixName = contactnameInfo.getSuffix();
                        boolean IsUTF8 = false;
                        ptrCardBuffer.append("FN");
                        if (!(ContactServiceImpl.IsASCII((String)lastName) && ContactServiceImpl.IsASCII((String)firstName) && ContactServiceImpl.IsASCII((String)middleName) && ContactServiceImpl.IsASCII((String)prefixName) && ContactServiceImpl.IsASCII((String)suffixName))) {
                            ptrCardBuffer.append(";CHARSET=UTF-8");
                            IsUTF8 = true;
                        }
                        if (ContactServiceImpl.isCJKString((String)(connectName = (String)prefixName + firstName + middleName + lastName + suffixName))) {
                            ptrCardBuffer.append(":").append(prefixName != null ? prefixName.trim() : "").append(lastName != null ? lastName.trim() : "").append(middleName != null ? middleName.trim() : "").append(firstName != null ? firstName.trim() : "").append(suffixName != null ? suffixName.trim() : "").append(NL);
                        } else {
                            ptrCardBuffer.append(":").append(prefixName != null ? prefixName.trim() : "").append(" ").append(firstName != null ? firstName.trim() : "").append(" ").append(middleName != null ? middleName.trim() : "").append(" ").append(lastName != null ? lastName.trim() : "").append(" ").append(suffixName != null ? suffixName.trim() : "").append(NL);
                        }
                        ptrCardBuffer.append("N");
                        if (IsUTF8) {
                            ptrCardBuffer.append(";CHARSET=UTF-8");
                        }
                        ptrCardBuffer.append(":").append(lastName != null ? lastName.trim() : "").append(";").append(firstName != null ? firstName.trim() : "").append(";").append(middleName != null ? middleName.trim() : "").append(";").append(prefixName != null ? prefixName.trim() : "").append(";").append(suffixName != null ? suffixName.trim() : "").append(NL);
                    }
                    if (contactInfoVo.getNickname() != null) {
                        String NikeName = contactInfoVo.getNickname();
                        ContactServiceImpl.appendField((Appendable)ptrCardBuffer, (String)"NICKNAME", (String)contactInfoVo.getNickname());
                    }
                    if (contactInfoVo.getEmails() != null) {
                        boolean isFirstField2 = true;
                        for (ContactemailInfo contactemailInfo : contactInfoVo.getEmails()) {
                            if (contactemailInfo.getValue() == null || contactemailInfo.getValue().length() <= 0) continue;
                            ptrCardBuffer.append("EMAIL;TYPE=INTERNET");
                            if (isFirstField2) {
                                isFirstField2 = false;
                                ptrCardBuffer.append(";TYPE=PREF");
                            }
                            isFirstField2 = false;
                            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactFieldType[contactemailInfo.getType().ordinal()]) {
                                case 1: {
                                    ptrCardBuffer.append(";TYPE=HOME");
                                    break;
                                }
                                case 2: {
                                    ptrCardBuffer.append(";TYPE=WORK");
                                    break;
                                }
                                case 3: {
                                    ptrCardBuffer.append(";LABEL=");
                                    ptrCardBuffer.append("Unknow");
                                }
                            }
                            if (!ContactServiceImpl.IsASCII((String)contactemailInfo.getValue())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":").append(contactemailInfo.getValue().trim()).append(NL);
                        }
                    }
                    if (contactInfoVo.getPhones() != null) {
                        for (ContactphoneInfo contactphoneInfo : contactInfoVo.getPhones()) {
                            if (contactphoneInfo.getValue() == null || contactphoneInfo.getValue().length() <= 0) continue;
                            ptrCardBuffer.append("TEL");
                            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactPhoneType[contactphoneInfo.getType().ordinal()]) {
                                case 1: {
                                    ptrCardBuffer.append(";TYPE=HOME");
                                    break;
                                }
                                case 2: {
                                    ptrCardBuffer.append(";TYPE=WORK");
                                    break;
                                }
                                case 3: {
                                    ptrCardBuffer.append(";TYPE=FAX;TYPE=HOME");
                                    break;
                                }
                                case 4: {
                                    ptrCardBuffer.append(";TYPE=FAX;TYPE=WORK");
                                    break;
                                }
                                case 6: {
                                    ptrCardBuffer.append(";TYPE=CELL");
                                    break;
                                }
                                case 7: {
                                    ptrCardBuffer.append(";TYPE=MAIN");
                                    break;
                                }
                                case 8: {
                                    ptrCardBuffer.append(";TYPE=PAGER");
                                    break;
                                }
                                case 5: 
                                case 9: 
                                case 10: {
                                    ptrCardBuffer.append(";LABEL=");
                                    ptrCardBuffer.append("Unknow");
                                }
                            }
                            if (!ContactServiceImpl.IsASCII((String)contactphoneInfo.getValue())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":").append(contactphoneInfo.getValue().trim()).append(NL);
                        }
                    }
                    if (contactInfoVo.getJobinfos() != null && contactInfoVo.getJobinfos().size() > 0 && (isFirstField2 = contactInfoVo.getJobinfos().iterator()).hasNext()) {
                        String getTitile;
                        String getDepartment;
                        ContactjobinfoInfo contactjobinfoInfo = (ContactjobinfoInfo)isFirstField2.next();
                        ptrCardBuffer.append("ORG");
                        boolean hasData = false;
                        if (!StringUtil.IsStringNullorEmpty((String)contactjobinfoInfo.getCompanyName())) {
                            hasData = true;
                            if (!ContactServiceImpl.IsASCII((String)contactjobinfoInfo.getCompanyName())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                                ptrCardBuffer.append(":").append(contactjobinfoInfo.getCompanyName().trim());
                            } else {
                                ptrCardBuffer.append(":").append(contactjobinfoInfo.getCompanyName().trim());
                            }
                        }
                        if ((getDepartment = contactjobinfoInfo.getDepartment()) != null) {
                            hasData = true;
                            ptrCardBuffer.append(";").append(getDepartment.trim()).append(NL);
                        }
                        if (!hasData) {
                            ptrCardBuffer.append(";");
                        }
                        if ((getTitile = contactjobinfoInfo.getJobTitle()) != null) {
                            ptrCardBuffer.append("TITLE");
                            if (!ContactServiceImpl.IsASCII((String)getTitile)) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":").append(getTitile.trim()).append(NL);
                        }
                    }
                    if (contactInfoVo.getAddresses() != null && contactInfoVo.getAddresses().size() > 0) {
                        boolean isFirstField3 = true;
                        for (ContactaddressInfo contactaddressInfo : contactInfoVo.getAddresses()) {
                            String street = contactaddressInfo.getStreet();
                            String city = contactaddressInfo.getCity();
                            String region = contactaddressInfo.getState();
                            String zipcode = contactaddressInfo.getZip();
                            String country = contactaddressInfo.getCountryName();
                            String gps = "";
                            ptrCardBuffer.append("ADR");
                            if (isFirstField3) {
                                isFirstField3 = false;
                                ptrCardBuffer.append(";TYPE=PREF");
                            }
                            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactFieldType[contactaddressInfo.getType().ordinal()]) {
                                case 1: {
                                    ptrCardBuffer.append(";TYPE=HOME");
                                    break;
                                }
                                case 2: {
                                    ptrCardBuffer.append(";TYPE=WORK");
                                    break;
                                }
                                default: {
                                    ptrCardBuffer.append(";LABEL=");
                                    ptrCardBuffer.append("Unknow");
                                }
                            }
                            if (!(ContactServiceImpl.IsASCII((String)street) && ContactServiceImpl.IsASCII((String)city) && ContactServiceImpl.IsASCII((String)region) && ContactServiceImpl.IsASCII((String)zipcode) && ContactServiceImpl.IsASCII((String)country))) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":;;").append(street != null ? street.trim() : "").append(";").append(city != null ? city.trim() : "").append(";").append(region != null ? region.trim() : "").append(";").append(zipcode != null ? zipcode.trim() : "").append(";").append(country != null ? country.trim() : "").append(NL);
                            if (gps == null || gps.length() <= 0) continue;
                            ptrCardBuffer.append("GEO");
                            ptrCardBuffer.append(":").append(gps).append(NL);
                        }
                    }
                    if (contactInfoVo.getIMs() != null && contactInfoVo.getIMs().size() > 0) {
                        for (ContactIMInfo contactIMInfo : contactInfoVo.getIMs()) {
                            boolean IsExport = true;
                            if (StringUtil.IsStringNullorEmpty((String)contactIMInfo.getValue())) continue;
                            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactIMType[contactIMInfo.getType().ordinal()]) {
                                case 1: {
                                    ptrCardBuffer.append("X-WHATSAPP");
                                    break;
                                }
                                case 2: {
                                    ptrCardBuffer.append("X-ZOOM");
                                    break;
                                }
                                case 3: {
                                    ptrCardBuffer.append("X-LINE");
                                    break;
                                }
                                case 4: {
                                    ptrCardBuffer.append("X-WECHAT");
                                    break;
                                }
                                case 5: {
                                    ptrCardBuffer.append("X-MSN");
                                    break;
                                }
                                case 6: {
                                    ptrCardBuffer.append("X-SKYPE");
                                    break;
                                }
                                case 7: {
                                    ptrCardBuffer.append("X-QQ");
                                    break;
                                }
                                case 8: {
                                    ptrCardBuffer.append("X-YAHOO");
                                    break;
                                }
                                case 9: {
                                    ptrCardBuffer.append("X-ICQ");
                                    break;
                                }
                                case 10: {
                                    ptrCardBuffer.append("X-GTALK");
                                    break;
                                }
                                case 11: {
                                    ptrCardBuffer.append("X-JABBER");
                                    break;
                                }
                                case 12: {
                                    ptrCardBuffer.append("X-AIM");
                                    break;
                                }
                                default: {
                                    IsExport = false;
                                }
                            }
                            if (!IsExport) continue;
                            if (!ContactServiceImpl.IsASCII((String)contactIMInfo.getValue())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append(":").append(contactIMInfo.getValue().trim()).append(NL);
                        }
                    }
                    if (contactInfoVo.getUrls() != null) {
                        for (ContacturlInfo contacturlInfo : contactInfoVo.getUrls()) {
                            if (contacturlInfo.getType() != ContactUrlType.PERSONAL || StringUtil.IsStringNullorEmpty((String)contacturlInfo.getValue())) continue;
                            if (!ContactServiceImpl.IsASCII((String)contacturlInfo.getValue())) {
                                ptrCardBuffer.append(";CHARSET=UTF-8");
                            }
                            ptrCardBuffer.append("URL");
                            ptrCardBuffer.append(":").append(contacturlInfo.getValue().trim()).append(NL);
                            break;
                        }
                    }
                    if (!StringUtil.IsStringNullorEmpty((String)contactInfoVo.getNote())) {
                        ContactServiceImpl.appendField((Appendable)ptrCardBuffer, (String)"NOTE", (String)contactInfoVo.getNote());
                    }
                    if (contactInfoVo.getBirthday() != null) {
                        String date_string = contactInfoVo.getBirthday().toString().replace(" ", "T");
                        String[] splitValue = date_string.split("T");
                        String getDate = splitValue[0].trim();
                        ContactServiceImpl.appendField((Appendable)ptrCardBuffer, (String)"BDAY", (String)getDate);
                    }
                    for (ContactimageInfo contactimageInfo : contactInfoVo.getImages()) {
                        if (StringUtil.IsStringNullorEmpty((String)contactimageInfo.getGuid()) || contactimageInfo.getType() != ContactImageType.LOGO) continue;
                        byte[] arrayByte = new byte[]{};
                        try {
                            arrayByte = this.contactPrivateService.getImageContent(contactGuid, ContactImageType.LOGO);
                        }
                        catch (IOException e) {
                            LOG.debug("Card has no  exception : {}", (Object)e.getMessage());
                        }
                        String imageBase64 = Base64.encodeBase64String((byte[])arrayByte);
                        if (imageBase64.length() <= 0) break;
                        ptrCardBuffer.append("PHOTO;TYPE=JPEG;ENCODING=BASE64:");
                        ptrCardBuffer.append(imageBase64);
                        ptrCardBuffer.append(NL);
                        break;
                    }
                    ptrCardBuffer.append("END:VCARD").append(NL);
                    ((Writer)ptrCardBuffer).close();
                }
                catch (IOException e) {
                    LOG.debug("exportOneVCard exception msg={}", (Object)e.getMessage());
                    return "";
                }
            }
            return contactName;
        }
        LOG.debug("exportOneVCard fail");
        return "";
    }

    public String exportVCardZip(String accountGuid, List<String> contactGuids, String filePath, String symbolName, String zipFileName, VCardTarget vcardTarget) {
        String exportFolderName;
        LOG.debug("exportVCardZip  A={} B={} C={} ", new Object[]{accountGuid, filePath, zipFileName});
        ArrayList<String> vcfFiles = new ArrayList<String>();
        ArrayList<String> contactNames = new ArrayList<String>();
        Path exportFolder = Paths.get(filePath, accountGuid);
        LOG.debug("exportVCardZip FolderName={} ", (Object)exportFolder.toString());
        String newExportFolderName = exportFolderName = exportFolder.toString();
        int idx = 1;
        while (true) {
            File theDir;
            if (!(theDir = new File(newExportFolderName)).exists()) break;
            newExportFolderName = exportFolderName + String.format("{%d)", idx);
            ++idx;
        }
        exportFolderName = newExportFolderName;
        exportFolder = Paths.get(exportFolderName, new String[0]);
        try {
            Files.createDirectories(exportFolder, new FileAttribute[0]);
        }
        catch (Exception e) {
            return "";
        }
        for (String contacgGuid : contactGuids) {
            Path vcfFileName = Paths.get(exportFolderName, contacgGuid + ".vcf");
            String strVCFName = this.exportOneVCard2File(accountGuid, contacgGuid, vcfFileName.toString(), vcardTarget);
            LOG.debug("exportVCardZip FileName={} ", (Object)strVCFName);
            if (StringUtil.IsStringNullorEmpty((String)strVCFName)) continue;
            vcfFiles.add(vcfFileName.toString());
            contactNames.add(strVCFName);
        }
        Path zipfile = Paths.get(filePath, zipFileName + ".zip");
        LOG.debug("exportVCardZip  file ={} ", (Object)zipfile.toString());
        if (vcfFiles.size() == 0) {
            LOG.debug("exportVCardZip  size =0");
            return "";
        }
        try {
            LOG.debug("exportVCardZip 1");
            FileOutputStream f = new FileOutputStream(zipfile.toString());
            LOG.debug("exportVCardZip 2");
            CheckedOutputStream ch = new CheckedOutputStream(f, new CRC32());
            LOG.debug("exportVCardZip 3");
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(ch));
            LOG.debug("exportVCardZip 4");
            for (int i = 0; i < vcfFiles.size(); ++i) {
                int c;
                String vcfFile = (String)vcfFiles.get(i);
                String contactName = "";
                contactName = i < 100 ? symbolName + String.format("%02d_", i) + (String)contactNames.get(i) + ".vcf" : symbolName + String.format("%d_", i) + (String)contactNames.get(i) + ".vcf";
                LOG.debug("exportVCardZip loop fil={}", (Object)vcfFile);
                LOG.debug("exportVCardZip loop cont={}", (Object)contactName);
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(vcfFile), "ISO8859_1"));
                if (in == null) continue;
                LOG.debug("exportVCardZip loop 2", (Object)vcfFile);
                out.putNextEntry(new ZipEntry(contactName));
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                in.close();
            }
            out.close();
            for (String fileName : vcfFiles) {
                try {
                    Path curfilepath = Paths.get(fileName, new String[0]);
                    LOG.debug("Delete file {}", (Object)curfilepath.toString());
                    Files.deleteIfExists(curfilepath);
                }
                catch (NoSuchFileException x) {
                    LOG.debug("Delete file NoSuchFileException msg={}", (Object)x.getMessage());
                }
                catch (DirectoryNotEmptyException x) {
                    LOG.debug("Delete file DirectoryNotEmptyException msg={}", (Object)x.getMessage());
                }
                catch (IOException x) {
                    LOG.debug("Delete file IOException msg={}", (Object)x.getMessage());
                }
            }
            try {
                ContactServiceImpl.DeleteDirectory((File)new File(exportFolderName));
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
            LOG.debug("exportVCardZip close");
        }
        catch (Exception e) {
            LOG.debug("exportVCardZip error ={}", (Object)e.getMessage());
            e.printStackTrace();
            return "";
        }
        return zipfile.toString();
    }

    private static void DeleteDirectory(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
                System.out.println("Directory is deleted : " + file.getAbsolutePath());
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    ContactServiceImpl.DeleteDirectory((File)fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                    System.out.println("Directory is deleted : " + file.getAbsolutePath());
                }
            }
        } else {
            file.delete();
            System.out.println("File is deleted : " + file.getAbsolutePath());
        }
    }

    private static boolean IsASCII(String fieldString) {
        if (StringUtil.IsStringNullorEmpty((String)fieldString)) {
            return true;
        }
        int nLength = fieldString.length();
        for (int i = 0; i < nLength; ++i) {
            if (CharUtils.isAscii((char)fieldString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String TransNextLineMark(String value) {
        if (StringUtil.IsStringNullorEmpty((String)value)) {
            return "";
        }
        String returnString = "";
        int nLength = value.length();
        for (int i = 0; i < nLength; ++i) {
            char curChar = value.charAt(i);
            returnString = curChar == '\n' ? returnString + "\\n" : returnString + curChar;
        }
        return returnString;
    }

    public static void appendField(Appendable aOut, String aName, String aValue) throws IOException {
        String enterString = "\r\n";
        if (aValue != null && aValue.length() > 0) {
            aOut.append(aName);
            if (!ContactServiceImpl.IsASCII((String)aValue)) {
                aOut.append(";CHARSET=UTF-8");
            }
            aOut.append(":").append(aValue).append(enterString);
        }
    }

    private static boolean isCJKString(String aFieldValue) {
        if (aFieldValue == null || aFieldValue.length() == 0) {
            return false;
        }
        for (char ptrChar : aFieldValue.toCharArray()) {
            if (!(ptrChar >= '\u3400' && ptrChar <= '\u4db5' || ptrChar >= '\u4e00' && ptrChar <= '\u9fbb' || ptrChar >= '\uf900' && ptrChar <= '\ufa2d' || ptrChar >= '\ufa30' && ptrChar <= '\ufa6a' || ptrChar >= '\ufa70' && ptrChar <= '\ufad9' || ptrChar >= '\uff66' && ptrChar <= '\uff9d' || ptrChar >= '\uffa1' && ptrChar <= '\uffdc' || ptrChar >= '\u3100' && ptrChar <= '\u312f' || ptrChar >= '\u3040' && ptrChar <= '\u30ff' || ptrChar >= '\u31f0' && ptrChar <= '\u31ff' || ptrChar >= '\uac00' && ptrChar <= '\ud7af' || ptrChar >= '\u1100' && ptrChar <= '\u11ff') && (ptrChar < '\u3130' || ptrChar > '\u318f')) continue;
            return true;
        }
        return false;
    }

    public boolean doesAccountOwnThis(String contactGuid, String accountGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("Contact not found.");
        }
        return contact.getOwnerAccount().getGuid().equals(accountGuid);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean deleteContactDeeply(String contactGuid) {
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("Contact not found");
        }
        if (!contact.getIsDeleted().booleanValue()) {
            throw new RequestArgumentNotValidException("This contact is not marked as deleted.");
        }
        DateTime currentTime = new DateTime();
        DateTime line = currentTime.minusDays(30);
        DateTime contactModifyTime = contact.getModifyTime();
        if (contactModifyTime.isAfter((ReadableInstant)line)) {
            return false;
        }
        List contactstatusforaccounts = this.contactStatusForAccountDao.findByContactGuid(contactGuid);
        for (Contactstatusforaccount status : contactstatusforaccounts) {
            String accountGuid = status.getAccount().getGuid();
            DateTime time = this.accountPrivateSettingService.getLastDeeplyDeletedContactTime(accountGuid);
            if (time != null && !contactModifyTime.isAfter((ReadableInstant)time)) continue;
            this.accountPrivateSettingService.setLastDeeplyDeletedContactTime(accountGuid, contactModifyTime);
        }
        this.contactStatusForAccountDao.delete((Iterable)contactstatusforaccounts);
        List canViewAccountGuids = this.accountDao.findGuidByCanViewContact(contactGuid);
        this.contactPublicService.shareContactToAccounts(contactGuid, canViewAccountGuids, ListSetBehavior.REMOVE_ALL, currentTime);
        this.contactPrivateService.cleanAllContactFields(contact);
        this.contactSimpleInfoDao.delete((Object)contact.getContactsimpleinfo());
        this.contactfulltextDao.delete((Object)contact.getContactfulltexts());
        this.contactPrivateService.clearContactContentImageByTypes(contact, new ContactImageType[]{ContactImageType.FRONT, ContactImageType.REAR, ContactImageType.LOGO});
        this.contactDao.delete((Object)contact);
        return true;
    }

    public List<ContactSimpleInfoCustomerDto> getContactSimpleInfosForCustomerFromModifiedTimeByAccount(DateTime timeFrom, boolean isDeletedSkip, int contactNumberGet, String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("Account is not found.");
        }
        Globalinfo typeInfo = this.globalInfoService.getPropertiesByKey("DATABASE_TYPE");
        DatabaseType databaseType = DatabaseType.valueOf((String)typeInfo.getConfigValue());
        String strStartTime = ApplicationConfig.DATE_TIME_FORMATTER.print((ReadableInstant)timeFrom);
        List contactGuids = new ArrayList();
        contactGuids = !isDeletedSkip ? (DatabaseType.MSSQL.equals((Object)databaseType) ? this.contactDao.findGuidFromTimeByAccountPrivateWithDeleted_MSSQL(strStartTime, contactNumberGet, account.getGuid()) : this.contactDao.findGuidFromTimeByAccountPrivateWithDeleted(strStartTime, contactNumberGet, account.getGuid())) : (DatabaseType.MSSQL.equals((Object)databaseType) ? this.contactDao.findGuidFromTimeByAccountPrivate_MSSQL(strStartTime, contactNumberGet, account.getGuid()) : this.contactDao.findGuidFromTimeByAccountPrivate(strStartTime, contactNumberGet, account.getGuid()));
        List contacts = this.contactDao.findByGuidIn(contactGuids);
        List<ContactSimpleInfoCustomerDto> result = contacts.stream().map(c -> new ContactSimpleInfoCustomerDto(c)).collect(Collectors.toList());
        return result;
    }

    public List<ContactSimpleInfoCustomerDto> getContactSimpleInfosForCustomerFromModifiedTimeByOwner(DateTime timeFrom, boolean isDeletedSkip, int contactNumberGet, String accountGuid) {
        Account owner = this.accountDao.findOne(accountGuid);
        if (owner == null) {
            throw new ItemNotFoundException("Account is not found.");
        }
        PageRequest pageRequest = new PageRequest(0, contactNumberGet, Sort.Direction.ASC, new String[]{"modifytime"});
        Page contactPage = null;
        contactPage = !isDeletedSkip ? this.contactDao.findContactPageFromTimeByOwnerWithDeleted(timeFrom, owner.getGuid(), (Pageable)pageRequest) : this.contactDao.findContactPageFromTimeByOwner(timeFrom, owner.getGuid(), (Pageable)pageRequest);
        List<ContactSimpleInfoCustomerDto> result = contactPage.getContent().stream().map(c -> new ContactSimpleInfoCustomerDto(c)).collect(Collectors.toList());
        return result;
    }

    public List<ContactSimpleInfoCustomerDto> getContactSimpleInfosForCustomerFromModifiedTime(DateTime timeFrom, boolean isDeletedSkip, int contactNumberGet) {
        PageRequest pageRequest = new PageRequest(0, contactNumberGet, Sort.Direction.ASC, new String[]{"modifytime"});
        Page contactPage = null;
        contactPage = !isDeletedSkip ? this.contactDao.findContactPageFromTimeWithDeleted(timeFrom, (Pageable)pageRequest) : this.contactDao.findContactPageFromTime(timeFrom, (Pageable)pageRequest);
        List<ContactSimpleInfoCustomerDto> result = contactPage.getContent().stream().map(c -> new ContactSimpleInfoCustomerDto(c)).collect(Collectors.toList());
        return result;
    }

    public List<String> getContactGuidsDeletedOrderByModifyTime() {
        return this.contactDao.findGuidDeletedAndOrderByModifyTimeAsc();
    }

    public void setDeeplyDeleteContactJobStatus(boolean isDeleting) {
        DEEPLY_DELETE_CONTACTS_PROCESSING.set(isDeleting);
    }

    public boolean getDeeplyDeleteContactJobStatus() {
        return DEEPLY_DELETE_CONTACTS_PROCESSING.get();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setAllContactModifyTimeInSearch(double timeLongValue) {
        this.contactDao.setAllModifyTimeInSearch(timeLongValue);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updatContactModifyTimeInSearch(List<Contact> needToReindexContacts) {
        for (Contact needToReindexContact : needToReindexContacts) {
            this.contactDao.updateContactModifyTimeInSearchByGuid(needToReindexContact.getGuid(), needToReindexContact.getModifytimeforsearch());
        }
    }

    public double getSearchEngineIndexInitializationPercentage() {
        long contactNumber = this.contactDao.count();
        double percent = 0.0;
        if (contactNumber != 0L) {
            long indexContactCount = this.contactDao.countByModifyTimeForSearchNewerThanModifyTimeInSearch();
            LOG.debug("ContactNumber:{}, Contact index contactCount:{}", (Object)contactNumber, (Object)indexContactCount);
            percent = (double)(contactNumber - indexContactCount) * 100.0 / (double)contactNumber;
        }
        return percent;
    }
}

