/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.PenpowerCountryMapperUtil;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.contactsystem.CustomExchangeService;
import com.penpower.worldcard.team.contactsystem.exchange.vo.contact.ExchangeContactBasicInfo;
import com.penpower.worldcard.team.contactsystem.exchange.vo.contact.ExchangeContactWithPicture;
import com.penpower.worldcard.team.contactsystem.office365.vo.Office365PagingListResponse;
import com.penpower.worldcard.team.contactsystem.office365.vo.contact.Office365ContactOrigin;
import com.penpower.worldcard.team.contactsystem.office365.vo.contact.Office365DeltaQueryContact;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365EmailAddress;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365Phone;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365PhoneType;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365PhysicalAddress;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365Website;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.QContactzOriginContact;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactServerSettingsWithTokenDto;
import com.penpower.worldcard.team.dto.ContactStatusSyncInfo;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactdateInfo;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.dto.ContacturlInfo;
import com.penpower.worldcard.team.dto.Office365SyncInfoWithDeltaLink;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.enums.ContactDateType;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.ContactPhoneType;
import com.penpower.worldcard.team.enums.ContactServerExportMode;
import com.penpower.worldcard.team.enums.ContactUrlType;
import com.penpower.worldcard.team.enums.CountryCode;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import com.penpower.worldcard.team.enums.SupportContactServer;
import com.penpower.worldcard.team.enums.UpdateComponent;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.scheduler.job.SyncContactsOfAccountsWithContactServerJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactServerOperationService;
import com.penpower.worldcard.team.service.ExchangeOperationService;
import com.penpower.worldcard.team.service.Office365OperationService;
import com.penpower.worldcard.team.service.QContactzOperationService;
import com.penpower.worldcard.team.service.impl.ContactServerOperationServiceImpl;
import com.penpower.worldcard.team.service.impl.ExchangeOperationServiceImpl;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactServerSyncInfoForContactServer;
import com.penpower.worldcard.team.web.api.vo.ContactServerSyncInfoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import com.penpower.worldcard.team.web.api.vo.ContactVoWithImageId;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import microsoft.exchange.webservices.data.core.enumeration.property.EmailAddressKey;
import microsoft.exchange.webservices.data.core.enumeration.property.PhoneNumberKey;
import microsoft.exchange.webservices.data.core.enumeration.property.PhysicalAddressKey;
import microsoft.exchange.webservices.data.property.complex.EmailAddressDictionary;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import microsoft.exchange.webservices.data.property.complex.PhoneNumberDictionary;
import microsoft.exchange.webservices.data.property.complex.PhysicalAddressDictionary;
import microsoft.exchange.webservices.data.property.complex.PhysicalAddressEntry;
import okhttp3.OkHttpClient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContactServerOperationServiceImpl
implements ContactServerOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(ContactServerOperationServiceImpl.class);
    @Autowired
    private ContactStatusForAccountDao contactStatusForAccountDao;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private Office365OperationService office365OperationService;
    @Autowired
    private ExchangeOperationService exchangeOperationService;
    @Autowired
    private QContactzOperationService qContactzOperationService;
    @Autowired
    private ContactDao contactDao;

    public ContactServerSyncInfoForContactServer getRecordSyncInfo(String accountGuid, String contactServerId, ContactServerSettingsWithTokenDto contactServerSetting, String office365ContactFolderId, CustomExchangeService exchangeService, boolean isFirstTimeSync, OkHttpClient client) throws Exception {
        if (StringUtils.isEmpty((CharSequence)contactServerId)) {
            return null;
        }
        SupportContactServer supportContactServer = contactServerSetting.getSupportContactServer();
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
            boolean needFindDeletedItem = !isFirstTimeSync;
            ExchangeContactBasicInfo contactRecord = this.exchangeOperationService.findContactRecord(contactServerId, needFindDeletedItem, exchangeService);
            if (contactRecord == null) {
                return null;
            }
            return new ContactServerSyncInfoForContactServer(contactServerId, contactRecord.isDeleted(), contactRecord.getLastModifiedDateTime(), contactServerSetting.getAccount());
        }
        if (SupportContactServer.OFFICE365.equals((Object)supportContactServer)) {
            String accessToken = contactServerSetting.getBasicToken() != null ? contactServerSetting.getBasicToken().getAccess_token() : "";
            Office365ContactOrigin contactRecord = this.office365OperationService.findContactRecordByContactServerId(contactServerId, accessToken, client);
            if (contactRecord == null) {
                return null;
            }
            if (contactRecord.getParentFolderId().equals(office365ContactFolderId)) {
                return new ContactServerSyncInfoForContactServer(contactServerId, false, contactRecord.getLastModifiedDateTime(), contactServerSetting.getAccount());
            }
            if (isFirstTimeSync) {
                return null;
            }
            return new ContactServerSyncInfoForContactServer(contactServerId, true, contactRecord.getLastModifiedDateTime(), contactServerSetting.getAccount());
        }
        if (SupportContactServer.QCONTACTZ.equals((Object)supportContactServer)) {
            ContactServerSyncInfoForContactServer syncInfo4contactServer = null;
            String accessToken = contactServerSetting.getQcontactzAuthToken();
            QContactzOriginContact contactRecord = this.qContactzOperationService.findContactRecordByContactServerId(accessToken, contactServerId, false, client);
            if (contactRecord != null) {
                boolean isActive = contactRecord.getActive();
                if (isActive) {
                    syncInfo4contactServer = new ContactServerSyncInfoForContactServer(contactServerId, false, contactRecord.getUpdatedOn(), contactServerSetting.getAccount());
                } else if (!isFirstTimeSync) {
                    syncInfo4contactServer = new ContactServerSyncInfoForContactServer(contactServerId, true, contactRecord.getUpdatedOn(), contactServerSetting.getAccount());
                }
            }
            return syncInfo4contactServer;
        }
        return null;
    }

    public boolean deleteRecord(ContactServerSettingsWithTokenDto contactServerSetting, String contactServerId, CustomExchangeService exchangeService, OkHttpClient client) throws Exception {
        SupportContactServer supportContactServer = contactServerSetting.getSupportContactServer();
        if (StringUtils.isEmpty((CharSequence)contactServerId)) {
            return false;
        }
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
            ExchangeContactBasicInfo contactRecord = this.exchangeOperationService.findContactRecord(contactServerId, false, exchangeService);
            if (contactRecord != null) {
                return this.exchangeOperationService.deleteContactRecord(contactRecord.getItem(), exchangeService);
            }
        } else {
            if (SupportContactServer.OFFICE365.equals((Object)supportContactServer)) {
                String accessToken = contactServerSetting.getBasicToken() != null ? contactServerSetting.getBasicToken().getAccess_token() : "";
                return this.office365OperationService.deleteContactRecord(contactServerId, accessToken, client);
            }
            if (SupportContactServer.QCONTACTZ.equals((Object)supportContactServer)) {
                return this.qContactzOperationService.deleteContactRecord(contactServerSetting.getQcontactzAuthToken(), contactServerId, client);
            }
        }
        return false;
    }

    public String getExportContactServerId(String accountGuid, String contactGuid, SupportContactServer supportContactServer) {
        Contactstatusforaccount status = this.getContactStatusForAccount(accountGuid, contactGuid);
        ContactServerSettingsWithTokenDto contactServerSetting = this.accountPrivateSettingService.getContactServerSettings(accountGuid);
        if (SupportContactServer.EXCHANGE.equals((Object)contactServerSetting.getSupportContactServer())) {
            String contactServerAccount = contactServerSetting.getExchangeAccountUniqueId();
            String contactServerId = status.getExporttoexchangeid();
            if (contactServerAccount != null && contactServerAccount.equals(status.getExchangeaccount())) {
                return contactServerId;
            }
            return null;
        }
        if (SupportContactServer.OFFICE365.equals((Object)contactServerSetting.getSupportContactServer())) {
            String contactServerAccount = contactServerSetting.getAccount();
            String contactServerId = status.getExporttooffice365id();
            if (contactServerAccount.equals(status.getOffice365account())) {
                return contactServerId;
            }
            return null;
        }
        if (SupportContactServer.QCONTACTZ.equals((Object)contactServerSetting.getSupportContactServer())) {
            String contactServerAccount = contactServerSetting.getQcontactzAccountId();
            String contactServerId = status.getExporttoqcontactzid();
            if (contactServerAccount.equals(status.getQcontactzaccount())) {
                return contactServerId;
            }
            return null;
        }
        return null;
    }

    private Contactstatusforaccount getContactStatusForAccount(String accountGuid, String contactGuid) {
        List statusList = this.contactStatusForAccountDao.findByAccountGuidAndContactGuid(accountGuid, contactGuid);
        if (CollectionUtils.isEmpty((Collection)statusList)) {
            throw new ItemNotFoundException("[getExportedContactServerID]: Can not find status.");
        }
        return (Contactstatusforaccount)statusList.get(0);
    }

    public Office365SyncInfoWithDeltaLink getOffice365SyncInfosByDeltaQuery(String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, String previousDeltaLink, OkHttpClient client) {
        if (contactServerSetting.getSupportContactServer().equals((Object)SupportContactServer.OFFICE365)) {
            ArrayList<ContactServerSyncInfoForContactServer> syncInfos = new ArrayList<ContactServerSyncInfoForContactServer>();
            String accessToken = contactServerSetting.getBasicToken() != null ? contactServerSetting.getBasicToken().getAccess_token() : "";
            String nextLink = StringUtils.isEmpty((CharSequence)previousDeltaLink) ? "" : previousDeltaLink;
            String newDeltaLink = "";
            do {
                Office365PagingListResponse deltaQueryResult = this.office365OperationService.executeContactDeltaQuery(accessToken, nextLink, client);
                LOG.debug("deltaQueryResult={}", (Object)deltaQueryResult);
                nextLink = deltaQueryResult.getNextLink();
                if (CollectionUtils.isNotEmpty((Collection)deltaQueryResult.getValue())) {
                    for (Office365DeltaQueryContact result : deltaQueryResult.getValue()) {
                        ContactServerSyncInfoForContactServer syncinfo = new ContactServerSyncInfoForContactServer();
                        syncinfo.setContactServerId(result.getId());
                        syncinfo.setSyncContacServerAccount(contactServerSetting.getAccount());
                        if (result.getRemoved() == null) {
                            syncinfo.setDeleted(false);
                            syncinfo.setModifiedTime(result.getLastModifiedDateTime());
                        } else {
                            syncinfo.setDeleted(true);
                            syncinfo.setModifiedTime(DateTime.now());
                        }
                        syncInfos.add(syncinfo);
                    }
                }
                newDeltaLink = deltaQueryResult.getDeltaLink();
            } while (StringUtils.isNotEmpty((CharSequence)nextLink));
            return new Office365SyncInfoWithDeltaLink(syncInfos, newDeltaLink);
        }
        return null;
    }

    public List<ContactServerSyncInfoForContactServer> getContactServerSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime, ContactServerSettingsWithTokenDto contactServerSetting, CustomExchangeService exchangeService, OkHttpClient client) throws Exception {
        boolean isFirstTimeSync = lastSyncCompletedTime == null || lastSyncCompletedTime.equals((Object)GlobalUtils.getEarliestTime());
        DateTime lastTime = lastSyncCompletedTime == null ? GlobalUtils.getEarliestTime() : lastSyncCompletedTime;
        List<Object> syncInfos = new ArrayList<ContactServerSyncInfoForContactServer>();
        if (SupportContactServer.EXCHANGE.equals((Object)contactServerSetting.getSupportContactServer())) {
            boolean needFindDeletedItem = !isFirstTimeSync;
            syncInfos = this.exchangeOperationService.findModifiedContactRecordsSyncInfosAfterSpecifiedTime(lastTime, needFindDeletedItem, contactServerSetting.getExchangeAccountUniqueId(), exchangeService);
        } else if (SupportContactServer.QCONTACTZ.equals((Object)contactServerSetting.getSupportContactServer())) {
            boolean deletedIncluded = !isFirstTimeSync;
            String token = contactServerSetting.getQcontactzAuthToken();
            syncInfos = this.qContactzOperationService.findContactListRecord4Sync(token, lastTime, deletedIncluded, client);
        }
        return syncInfos;
    }

    public List<ContactServerSyncInfoForWCT> getWctSyncInfosByAccount(String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, DateTime lastSyncCompletedTime, boolean isFirstTimeSync) {
        DateTime lastTime = lastSyncCompletedTime == null ? GlobalUtils.getEarliestTime() : lastSyncCompletedTime;
        List syncStatusList = new ArrayList();
        syncStatusList = SupportContactServer.QCONTACTZ.equals((Object)contactServerSetting.getSupportContactServer()) && ContactServerExportMode.AUTO_EXPORT.equals((Object)contactServerSetting.getContactServerExportMode()) ? this.contactStatusForAccountDao.findContactUndeletedByAccountAndModifyTimeForContactServerSync(accountGuid, lastTime) : (isFirstTimeSync ? this.contactStatusForAccountDao.findContactUndeletedByAccountAndModifyTimeForContactServerSync(accountGuid, lastTime) : this.contactStatusForAccountDao.findContactByAccountAndModifyTimeForContactServerSync(accountGuid, lastTime));
        ArrayList<ContactServerSyncInfoForWCT> syncInfos = new ArrayList<ContactServerSyncInfoForWCT>();
        for (ContactStatusSyncInfo syncStatus : syncStatusList) {
            Contactstatusforaccount status = syncStatus.getContactStatusForAccount();
            if (status != null && status.getIsdeletedfromaccount().booleanValue() && status.getModifyTimeForContactServerSync().isBefore((ReadableInstant)lastTime)) continue;
            ContactServerSyncInfoForWCT syncInfo = this.getContactServerSyncInfoForWCTFromStatus(syncStatus, contactServerSetting.getSupportContactServer());
            syncInfos.add(syncInfo);
        }
        syncInfos.sort((p1, p2) -> p1.getModifiedTime().compareTo((ReadableInstant)p2.getModifiedTime()));
        return syncInfos;
    }

    public DateTime getModifyTimeForContactServer(String accountGuid, SupportContactServer supportContactServer, String contactServerId, String contactServerAccount) {
        List statusList = new ArrayList();
        ContactStatusSyncInfo status = null;
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
            statusList = this.contactStatusForAccountDao.findByAccountAndExchangeAccountAndContactID(accountGuid, contactServerAccount, contactServerId);
            if (CollectionUtils.isNotEmpty(statusList)) {
                status = (ContactStatusSyncInfo)statusList.get(0);
            }
        } else if (SupportContactServer.OFFICE365.equals((Object)supportContactServer) && CollectionUtils.isNotEmpty(statusList = this.contactStatusForAccountDao.findByAccountAndOffice365AccountAndContactID(accountGuid, contactServerAccount, contactServerId))) {
            status = statusList.stream().filter(i -> i.getContactStatusForAccount().getExporttooffice365id().equals(contactServerId)).findFirst().get();
            if (statusList.size() > 1) {
                LOG.debug("status more than 1={}, select corrected={}", statusList, (Object)status);
            }
        }
        if (status == null) {
            return null;
        }
        return this.getContactServerSyncInfoForWCTFromStatus(status, supportContactServer).getModifiedTime();
    }

    public void updateWCTModifyTimeForSync(String accountGuid, SupportContactServer supportContactServer, ContactServerSyncInfoForContactServer syncInfo, SyncContactsOfAccountsWithContactServerJob.ContactServerSyncActionType contactServerSyncActionType) {
        List syncStatusList = new ArrayList();
        ContactStatusSyncInfo syncStatus = null;
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
            syncStatusList = this.contactStatusForAccountDao.findByAccountAndExchangeAccountAndContactID(accountGuid, syncInfo.getSyncContacServerAccount(), syncInfo.getContactServerId());
            syncStatus = (ContactStatusSyncInfo)syncStatusList.get(0);
        } else if (SupportContactServer.OFFICE365.equals((Object)supportContactServer) && CollectionUtils.isNotEmpty(syncStatusList = this.contactStatusForAccountDao.findByAccountAndOffice365AccountAndContactID(accountGuid, syncInfo.getSyncContacServerAccount(), syncInfo.getContactServerId()))) {
            syncStatus = syncStatusList.stream().filter(i -> i.getContactStatusForAccount().getExporttooffice365id().equals(syncInfo.getContactServerId())).findFirst().get();
        }
        if (syncStatus != null) {
            DateTime statusModifyTime;
            Contactstatusforaccount status = syncStatus.getContactStatusForAccount();
            String contactGuid = syncStatus.getContactGuid();
            DateTime contactContentModifyTime = syncStatus.getModifyTime() == null ? GlobalUtils.getEarliestTime() : syncStatus.getModifyTime();
            DateTime dateTime = statusModifyTime = status.getModifyTimeForContactServerSync() == null ? GlobalUtils.getEarliestTime() : status.getModifyTimeForContactServerSync();
            if (contactServerSyncActionType == SyncContactsOfAccountsWithContactServerJob.ContactServerSyncActionType.WCT_ADD || contactServerSyncActionType == SyncContactsOfAccountsWithContactServerJob.ContactServerSyncActionType.WCT_DELETE) {
                Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
                contact.setModifyTimeForContactServerSync(statusModifyTime);
                this.contactDao.saveAndFlush((Object)contact);
            } else if (contactServerSyncActionType == SyncContactsOfAccountsWithContactServerJob.ContactServerSyncActionType.WCT_UPDATE) {
                status.setModifyTimeForContactServerSync(contactContentModifyTime);
                this.contactStatusForAccountDao.saveAndFlush((Object)status);
            }
        }
    }

    private ContactServerSyncInfoForWCT getContactServerSyncInfoForWCTFromStatus(ContactStatusSyncInfo syncStatus, SupportContactServer supportContactServer) {
        Contactstatusforaccount status = syncStatus.getContactStatusForAccount();
        boolean isDeleted = status.getIsdeletedfromaccount();
        DateTime modifyTime = status.getModifyTimeForContactServerSync();
        DateTime contactModifyTime = syncStatus.getModifyTime();
        boolean isUpdatedByLastContactServerSync = false;
        if (modifyTime != null && contactModifyTime != null) {
            isUpdatedByLastContactServerSync = modifyTime.isEqual((ReadableInstant)contactModifyTime);
        }
        if (!status.getIsdeletedfromaccount().booleanValue() && contactModifyTime != null && contactModifyTime.isAfter((ReadableInstant)modifyTime)) {
            modifyTime = contactModifyTime;
        }
        if (modifyTime == null && contactModifyTime != null) {
            modifyTime = contactModifyTime;
        } else if (modifyTime == null && contactModifyTime == null) {
            modifyTime = GlobalUtils.getEarliestTime();
        }
        ContactServerSyncInfoForWCT syncInfo = null;
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
            syncInfo = new ContactServerSyncInfoForWCT(syncStatus.getContactGuid(), status.getPreviousModifiedTimeForExchange(), status.getExporttoexchangeid(), Boolean.valueOf(isDeleted), modifyTime, status.getExchangeaccount(), isUpdatedByLastContactServerSync);
        } else if (SupportContactServer.OFFICE365.equals((Object)supportContactServer)) {
            syncInfo = new ContactServerSyncInfoForWCT(syncStatus.getContactGuid(), status.getPreviousModifiedTimeForOffice365(), status.getExporttooffice365id(), Boolean.valueOf(isDeleted), modifyTime, status.getOffice365account(), isUpdatedByLastContactServerSync);
        } else if (SupportContactServer.QCONTACTZ.equals((Object)supportContactServer)) {
            syncInfo = new ContactServerSyncInfoForWCT(syncStatus.getContactGuid(), status.getPreviousModifiedTimeForQContactz(), status.getExporttoqcontactzid(), Boolean.valueOf(isDeleted), modifyTime, status.getQcontactzaccount(), isUpdatedByLastContactServerSync);
        }
        return syncInfo;
    }

    @Transactional(propagation=Propagation.NEVER, rollbackFor={Exception.class})
    public void exportToContactServer(ContactServerSettingsWithTokenDto contactServerSetting, ContactInfoForResponse contactInfo, String accountGuid, boolean isForSync, CustomExchangeService exchangeService, OkHttpClient client) throws Exception {
        SupportContactServer supportContactServer = contactServerSetting.getSupportContactServer();
        String contactServerId = null;
        DateTime contactServerModifyTime = null;
        if (supportContactServer.equals((Object)SupportContactServer.EXCHANGE)) {
            ExchangeContactBasicInfo contactRecord = this.exchangeOperationService.createContactRecord(contactInfo, exchangeService);
            contactServerId = contactRecord.getContactServerId();
            contactServerModifyTime = isForSync ? contactRecord.getLastModifiedDateTime() : null;
            this.setExportContactServerInfo(accountGuid, contactInfo.getGuid(), contactServerId, contactServerSetting.getExchangeAccountUniqueId(), contactServerModifyTime, contactServerSetting);
        } else if (supportContactServer.equals((Object)SupportContactServer.OFFICE365)) {
            String accessToken = contactServerSetting.getBasicToken() != null ? contactServerSetting.getBasicToken().getAccess_token() : "";
            Office365ContactOrigin contactRecord = this.office365OperationService.insertContactRecord(contactInfo, accessToken, client);
            boolean isUpdatedLogo = this.office365OperationService.updateContactLogoIfExist(contactRecord.getContactIdentifier(), contactInfo, accessToken, client);
            if (isUpdatedLogo) {
                DateTime previousModifyTime = contactRecord.getLastModifiedDateTime();
                if ((contactRecord = this.office365OperationService.findContactSimpleRecord(contactRecord.getContactIdentifier(), accessToken, client)).getLastModifiedDateTime().isAfter((ReadableInstant)previousModifyTime)) {
                    LOG.debug("previousModifyTime={}, newModifyTimeTime={}", (Object)previousModifyTime, (Object)contactRecord.getLastModifiedDateTime());
                }
            }
            contactServerId = contactRecord.getContactIdentifier();
            contactServerModifyTime = isForSync ? contactRecord.getLastModifiedDateTime() : null;
            this.setExportContactServerInfo(accountGuid, contactInfo.getGuid(), contactServerId, contactServerSetting.getAccount(), contactServerModifyTime, contactServerSetting);
        } else if (SupportContactServer.QCONTACTZ.equals((Object)supportContactServer)) {
            String accessToken = contactServerSetting.getQcontactzAuthToken();
            QContactzOriginContact contactRecord = this.qContactzOperationService.insertContactRecord(contactInfo, accessToken, client);
            contactServerId = contactRecord.getId();
            contactServerModifyTime = isForSync ? contactRecord.getUpdatedOn() : null;
            this.setExportContactServerInfo(accountGuid, contactInfo.getGuid(), contactServerId, contactServerSetting.getQcontactzAccountId(), contactServerModifyTime, contactServerSetting);
        }
    }

    @Transactional(propagation=Propagation.NEVER, rollbackFor={Exception.class})
    public void updateContactToContactServer(ContactServerSettingsWithTokenDto contactServerSetting, String contactServerId, ContactInfoForResponse contactInfo, String accountGuid, boolean isForSync, String office365ContactFolderId, CustomExchangeService exchangeService, OkHttpClient client) throws Exception {
        DateTime contactServerModifyTime = null;
        if (SupportContactServer.EXCHANGE.equals((Object)contactServerSetting.getSupportContactServer())) {
            ExchangeContactBasicInfo contactRecord = this.exchangeOperationService.findContactRecord(contactServerId, true, exchangeService);
            if (contactRecord == null || contactRecord.isDeleted()) {
                this.exportToContactServer(contactServerSetting, contactInfo, accountGuid, isForSync, exchangeService, client);
            } else {
                contactRecord = this.exchangeOperationService.updateContactRecord(contactRecord.getItem(), contactInfo, exchangeService);
                contactServerModifyTime = isForSync ? contactRecord.getLastModifiedDateTime() : null;
                this.setExportContactServerInfo(accountGuid, contactInfo.getGuid(), contactRecord.getContactServerId(), contactServerSetting.getExchangeAccountUniqueId(), contactServerModifyTime, contactServerSetting);
            }
        } else if (SupportContactServer.OFFICE365.equals((Object)contactServerSetting.getSupportContactServer())) {
            String accessToken = contactServerSetting.getBasicToken() != null ? contactServerSetting.getBasicToken().getAccess_token() : "";
            Office365ContactOrigin contactRecord = this.office365OperationService.findContactRecordByContactServerId(contactServerId, accessToken, client);
            if (contactRecord == null || !contactRecord.getParentFolderId().equals(office365ContactFolderId)) {
                this.exportToContactServer(contactServerSetting, contactInfo, accountGuid, isForSync, exchangeService, client);
            } else {
                boolean isUpdatedLogo = this.office365OperationService.updateContactLogoIfExist((contactRecord = this.office365OperationService.updateContactRecord(contactInfo, contactServerId, accessToken, contactRecord, isForSync, client)).getContactIdentifier(), contactInfo, accessToken, client);
                if (isUpdatedLogo) {
                    DateTime previousModifyTime = contactRecord.getLastModifiedDateTime();
                    if ((contactRecord = this.office365OperationService.findContactSimpleRecord(contactRecord.getContactIdentifier(), accessToken, client)).getLastModifiedDateTime().isAfter((ReadableInstant)previousModifyTime)) {
                        LOG.debug("contactServerId={}, contactId={}, previousModifyTime={}, newModifyTimeTime={}", new Object[]{contactRecord.getContactIdentifier(), contactInfo.getGuid(), previousModifyTime, contactRecord.getLastModifiedDateTime()});
                    }
                }
                contactServerModifyTime = isForSync ? contactRecord.getLastModifiedDateTime() : null;
                this.setExportContactServerInfo(accountGuid, contactInfo.getGuid(), contactRecord.getContactIdentifier(), contactServerSetting.getAccount(), contactServerModifyTime, contactServerSetting);
            }
        } else if (SupportContactServer.QCONTACTZ.equals((Object)contactServerSetting.getSupportContactServer())) {
            String accessToken = contactServerSetting.getQcontactzAuthToken();
            QContactzOriginContact contactRecord = this.qContactzOperationService.findContactRecordByContactServerId(accessToken, contactServerId, false, client);
            if (contactRecord == null || !contactRecord.getActive().booleanValue()) {
                this.exportToContactServer(contactServerSetting, contactInfo, accountGuid, isForSync, exchangeService, client);
            } else {
                contactRecord = this.qContactzOperationService.updateContactRecord(contactInfo, contactServerId, accessToken, contactRecord, isForSync, client);
                contactServerModifyTime = isForSync ? contactRecord.getUpdatedOn() : null;
                this.setExportContactServerInfo(accountGuid, contactInfo.getGuid(), contactServerId, contactServerSetting.getQcontactzAccountId(), contactServerModifyTime, contactServerSetting);
            }
        }
    }

    public ContactServerSyncInfoForWCT getWctSyncInfoByCorrespondingContactServerSyncInfo(String accountGuid, ContactServerSyncInfoForContactServer syncInfoContactServer, ContactServerSettingsWithTokenDto contactServerSetting) throws Exception {
        List statusList = new ArrayList();
        ContactStatusSyncInfo syncStatus = null;
        if (SupportContactServer.EXCHANGE.equals((Object)contactServerSetting.getSupportContactServer())) {
            statusList = this.contactStatusForAccountDao.findByAccountAndExchangeAccountAndContactID(accountGuid, syncInfoContactServer.getSyncContacServerAccount(), syncInfoContactServer.getContactServerId());
            if (CollectionUtils.isNotEmpty(statusList)) {
                syncStatus = (ContactStatusSyncInfo)statusList.get(0);
            }
        } else if (SupportContactServer.OFFICE365.equals((Object)contactServerSetting.getSupportContactServer())) {
            statusList = this.contactStatusForAccountDao.findByAccountAndOffice365AccountAndContactID(accountGuid, syncInfoContactServer.getSyncContacServerAccount(), syncInfoContactServer.getContactServerId());
            if (CollectionUtils.isNotEmpty(statusList)) {
                syncStatus = statusList.stream().filter(s -> s.getContactStatusForAccount().getExporttooffice365id().equals(syncInfoContactServer.getContactServerId())).findFirst().get();
            }
        } else if (SupportContactServer.QCONTACTZ.equals((Object)contactServerSetting.getSupportContactServer()) && CollectionUtils.isNotEmpty(statusList = this.contactStatusForAccountDao.findByAccountAndQContactzAccountAndContactID(accountGuid, syncInfoContactServer.getSyncContacServerAccount(), syncInfoContactServer.getContactServerId()))) {
            syncStatus = (ContactStatusSyncInfo)statusList.get(0);
        }
        if (syncStatus == null) {
            return null;
        }
        if (statusList.size() >= 2) {
            LOG.error("error");
            LOG.error("statusList.size()={}, statusList={}", (Object)statusList.size(), statusList);
        }
        ContactServerSyncInfoForWCT syncInfoWCT = this.getSyncInfoForWctFromStatus(syncStatus, contactServerSetting.getSupportContactServer());
        return syncInfoWCT;
    }

    private ContactServerSyncInfoForWCT getSyncInfoForWctFromStatus(ContactStatusSyncInfo syncStatus, SupportContactServer supportContactServer) {
        Contactstatusforaccount status = syncStatus.getContactStatusForAccount();
        boolean isDeleted = status.getIsdeletedfromaccount();
        DateTime modifyTime = status.getModifyTimeForContactServerSync();
        DateTime contactModifyTime = syncStatus.getModifyTime();
        boolean isUpdatedByLastContactServerSync = false;
        if (modifyTime != null && contactModifyTime != null) {
            isUpdatedByLastContactServerSync = modifyTime.isEqual((ReadableInstant)contactModifyTime);
        }
        if (!isDeleted && contactModifyTime != null && contactModifyTime.isAfter((ReadableInstant)modifyTime)) {
            modifyTime = contactModifyTime;
        }
        if (SupportContactServer.OFFICE365.equals((Object)supportContactServer)) {
            DateTime previousModifyTime = status.getPreviousModifiedTimeForOffice365() == null ? GlobalUtils.getEarliestTime() : status.getPreviousModifiedTimeForOffice365();
            ContactServerSyncInfoForWCT syncInfo = new ContactServerSyncInfoForWCT(syncStatus.getContactGuid(), previousModifyTime, status.getExporttooffice365id(), Boolean.valueOf(isDeleted), modifyTime, status.getOffice365account(), isUpdatedByLastContactServerSync);
            return syncInfo;
        }
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
            DateTime previousModifyTime = status.getPreviousModifiedTimeForExchange() == null ? GlobalUtils.getEarliestTime() : status.getPreviousModifiedTimeForExchange();
            ContactServerSyncInfoForWCT syncInfo = new ContactServerSyncInfoForWCT(syncStatus.getContactGuid(), previousModifyTime, status.getExporttoexchangeid(), Boolean.valueOf(isDeleted), modifyTime, status.getExchangeaccount(), isUpdatedByLastContactServerSync);
            return syncInfo;
        }
        if (SupportContactServer.QCONTACTZ.equals((Object)supportContactServer)) {
            DateTime previousModifyTime = status.getPreviousModifiedTimeForQContactz() == null ? GlobalUtils.getEarliestTime() : status.getPreviousModifiedTimeForQContactz();
            ContactServerSyncInfoForWCT syncInfo = new ContactServerSyncInfoForWCT(syncStatus.getContactGuid(), previousModifyTime, status.getExporttoqcontactzid(), Boolean.valueOf(isDeleted), modifyTime, status.getQcontactzaccount(), isUpdatedByLastContactServerSync);
            return syncInfo;
        }
        return null;
    }

    public ContactVoWithImageId getContactCreationVoByContactServerId(String accountGuid, String contactServerId, ContactServerSettingsWithTokenDto contactServerSetting, CustomExchangeService exchangeService, OkHttpClient client) throws Exception {
        if (StringUtil.IsStringNullorEmpty((String)contactServerId)) {
            return null;
        }
        SupportContactServer supportContactServer = contactServerSetting.getSupportContactServer();
        ContactCreationVo resultVo = new ContactCreationVo();
        String logoImageFileGuid = null;
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
            ExchangeContactWithPicture record = this.exchangeOperationService.findContactRecordDetailWithPicture(contactServerId, exchangeService);
            microsoft.exchange.webservices.data.core.service.item.Contact contact = record.getContact();
            if (contact == null) {
                throw new ItemNotFoundException("exchange contact record not found");
            }
            ContactInfoForRequest contactInfo = this.getContactCreationVoFromExchangeRecord(contact);
            if (record.isHasPicture()) {
                logoImageFileGuid = this.contactPrivateService.createContactImage(record.getImageContent());
            }
            resultVo = new ContactCreationVo();
            BeanUtils.copyProperties((Object)contactInfo, (Object)resultVo);
            resultVo.setCreatorAccountGuid(accountGuid);
            resultVo.setClientCreatedTime(new DateTime((Object)record.getContact().getDateTimeCreated()));
        } else if (SupportContactServer.OFFICE365.equals((Object)supportContactServer)) {
            String accessToken = contactServerSetting.getBasicToken() != null ? contactServerSetting.getBasicToken().getAccess_token() : "";
            Office365ContactOrigin record = this.office365OperationService.findContactRecordByContactServerId(contactServerId, accessToken, client);
            ContactInfoForRequest contactInfo = this.getContactCreationVoFromOffice365Record(record);
            byte[] imageContent = this.office365OperationService.findContactPhoto(contactServerId, accessToken, client);
            if (imageContent != null) {
                logoImageFileGuid = this.contactPrivateService.createContactImage(imageContent);
            }
            resultVo = new ContactCreationVo();
            BeanUtils.copyProperties((Object)contactInfo, (Object)resultVo);
            resultVo.setCreatorAccountGuid(accountGuid);
            resultVo.setClientCreatedTime(record.getCreatedDateTime());
        } else if (SupportContactServer.QCONTACTZ.equals((Object)supportContactServer)) {
            String token = contactServerSetting.getQcontactzAuthToken();
            QContactzOriginContact contactRecord = this.qContactzOperationService.findContactRecordByContactServerId(token, contactServerId, false, client);
            ContactInfoForRequest contactInfo = this.qContactzOperationService.findContactCreationVoFromQContactzRecord(token, contactRecord, client);
            String url = String.format("%smcsapi%s", "http://localhost:8080/", contactRecord.getProfilePicture());
            byte[] contactProfile = this.qContactzOperationService.findContactProfile(token, url, client);
            LOG.debug("contactProfile url: {}", (Object)url, (Object)contactRecord.getProfilePicture());
            if (contactProfile != null) {
                logoImageFileGuid = this.contactPrivateService.createContactImage(contactProfile);
            }
            resultVo = new ContactCreationVo();
            BeanUtils.copyProperties((Object)contactInfo, (Object)resultVo);
            resultVo.setCreatorAccountGuid(accountGuid);
            resultVo.setClientCreatedTime(contactRecord.getCreatedOn());
        }
        return new ContactVoWithImageId(resultVo, null, logoImageFileGuid);
    }

    private ContactInfoForRequest getContactCreationVoFromOffice365Record(Office365ContactOrigin contactRecord) {
        Office365PhoneType phoneType;
        ContactInfoForRequest resultVo = new ContactInfoForRequest();
        ContactnameInfo name = new ContactnameInfo();
        try {
            name.setLastName(contactRecord.getSurname());
            name.setFirstName(contactRecord.getGivenName());
            name.setMiddleName(contactRecord.getMiddleName());
            name.setPrefix(contactRecord.getGeneration());
            name.setFirstNamePronunce(contactRecord.getYomiGivenName());
            name.setLastNamePronunce(contactRecord.getYomiSurname());
            name.setRecognizeSource(RecognizeSourceType.MANUAL);
            resultVo.getNames().add(name);
            resultVo.setNickname(contactRecord.getNickName());
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)contactRecord.getCompanyName()) || StringUtils.isNotEmpty((CharSequence)contactRecord.getDepartment()) || StringUtils.isNotEmpty((CharSequence)contactRecord.getJobTitle()) || StringUtils.isNotEmpty((CharSequence)contactRecord.getYomiCompanyName())) {
                ContactjobinfoInfo jobInfo = new ContactjobinfoInfo(contactRecord.getCompanyName(), contactRecord.getDepartment(), contactRecord.getJobTitle(), RecognizeSourceType.MANUAL);
                jobInfo.setCompanyPronunce(contactRecord.getYomiCompanyName());
                resultVo.getJobinfos().add(jobInfo);
            }
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        try {
            List contactPhoneRecords = contactRecord.getPhones();
            block36: for (Office365Phone contactPhoneRecord : contactPhoneRecords) {
                phoneType = contactPhoneRecord.getType();
                String phoneNumber = contactPhoneRecord.getNumber();
                if (!StringUtils.isNotEmpty((CharSequence)phoneNumber)) continue;
                ContactphoneInfo phone = new ContactphoneInfo(phoneNumber, ContactPhoneType.OTHER_TEL, RecognizeSourceType.MANUAL);
                switch (1.$SwitchMap$com$penpower$worldcard$team$contactsystem$office365$vo$resourcetype$Office365PhoneType[phoneType.ordinal()]) {
                    case 1: {
                        phone.setType(ContactPhoneType.BUSINESS_TEL);
                        break;
                    }
                    case 2: {
                        phone.setType(ContactPhoneType.BUSINESS_FAX);
                        break;
                    }
                    case 3: {
                        phone.setType(ContactPhoneType.HOME_TEL);
                        break;
                    }
                    case 4: {
                        phone.setType(ContactPhoneType.HOME_FAX);
                        break;
                    }
                    case 5: {
                        phone.setType(ContactPhoneType.CELL);
                        break;
                    }
                    case 6: {
                        phone.setType(ContactPhoneType.OTHER_TEL);
                        break;
                    }
                    case 7: {
                        continue block36;
                    }
                    case 8: {
                        phone.setType(ContactPhoneType.BBCALL);
                        break;
                    }
                    default: {
                        continue block36;
                    }
                }
                resultVo.getPhones().add(phone);
            }
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        try {
            List contactAddressRecords = contactRecord.getPostalAddresses();
            block37: for (Office365PhysicalAddress contactAddressRecord : contactAddressRecords) {
                phoneType = contactAddressRecord.getType();
                if (!StringUtils.isNotEmpty((CharSequence)contactAddressRecord.getCity()) && !StringUtils.isNotEmpty((CharSequence)contactAddressRecord.getCountryOrRegion()) && !StringUtils.isNotEmpty((CharSequence)contactAddressRecord.getPostalCode()) && !StringUtils.isNotEmpty((CharSequence)contactAddressRecord.getPostOfficeBox()) && !StringUtils.isNotEmpty((CharSequence)contactAddressRecord.getState()) && !StringUtils.isNotEmpty((CharSequence)contactAddressRecord.getStreet())) continue;
                int addressFormat = 0;
                String countryName = contactAddressRecord.getCountryOrRegion();
                CountryCode countryCode = null;
                try {
                    countryCode = PenpowerCountryMapperUtil.getCountryCode((String)contactAddressRecord.getCountryOrRegion());
                }
                catch (Exception ex) {
                    LOG.error("{}", (Throwable)ex);
                }
                ContactaddressInfo address = new ContactaddressInfo(countryName, contactAddressRecord.getCity(), contactAddressRecord.getState(), contactAddressRecord.getStreet(), contactAddressRecord.getPostalCode(), Integer.valueOf(addressFormat), ContactFieldType.OTHER, RecognizeSourceType.MANUAL);
                address.setCountryCode(countryCode == null ? null : countryCode.toString().toLowerCase());
                switch (1.$SwitchMap$com$penpower$worldcard$team$contactsystem$office365$vo$resourcetype$Office365PhysicalAddressType[phoneType.ordinal()]) {
                    case 1: {
                        address.setType(ContactFieldType.BUSINESS);
                        break;
                    }
                    case 2: {
                        address.setType(ContactFieldType.HOME);
                        break;
                    }
                    case 3: {
                        address.setType(ContactFieldType.OTHER);
                        break;
                    }
                    case 4: {
                        continue block37;
                    }
                    default: {
                        continue block37;
                    }
                }
                resultVo.getAddresses().add(address);
            }
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        try {
            List emailAddressRecords = contactRecord.getEmailAddresses();
            for (Office365EmailAddress emailAddressRecord : emailAddressRecords) {
                if (!StringUtils.isNotEmpty((CharSequence)emailAddressRecord.getAddress())) continue;
                ContactemailInfo mail = new ContactemailInfo(emailAddressRecord.getAddress(), ContactFieldType.BUSINESS, RecognizeSourceType.MANUAL);
                resultVo.getEmails().add(mail);
            }
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        try {
            if (contactRecord.getBirthday() != null) {
                resultVo.setBirthday(contactRecord.getBirthday());
            } else {
                resultVo.setBirthday(null);
            }
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        try {
            if (contactRecord.getWeddingAnniversary() != null) {
                LocalDate celebrationDate = contactRecord.getWeddingAnniversary();
                DateTime anniversary = new DateTime(celebrationDate.getYear(), celebrationDate.getMonthValue(), celebrationDate.getDayOfMonth(), 0, 0, DateTimeZone.UTC);
                ContactdateInfo date = new ContactdateInfo();
                date.setGuid(UUIDGenerator.getRandomUUID());
                date.setType(ContactDateType.CELEBRATION);
                date.setValue(anniversary);
                resultVo.getDates().add(date);
            }
        }
        catch (Exception ex) {
            LOG.info("", (Throwable)ex);
        }
        try {
            resultVo.setNote(StringUtils.isBlank((CharSequence)contactRecord.getPersonalNotes()) ? "" : contactRecord.getPersonalNotes());
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        try {
            List websiteRecords = contactRecord.getWebsites();
            for (Office365Website websiteRecord : websiteRecords) {
                if (!StringUtils.isNotEmpty((CharSequence)websiteRecord.getAddress())) continue;
                ContacturlInfo url = new ContacturlInfo(websiteRecord.getAddress(), ContactUrlType.BUSINESS, RecognizeSourceType.MANUAL);
                resultVo.getUrls().add(url);
            }
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        return resultVo;
    }

    private ContactInfoForRequest getContactCreationVoFromExchangeRecord(microsoft.exchange.webservices.data.core.service.item.Contact contact) throws Exception {
        ContactInfoForRequest resultVo;
        block51: {
            resultVo = new ContactInfoForRequest();
            ContactnameInfo name = new ContactnameInfo();
            try {
                if (contact.getCompleteName() != null) {
                    name.setLastName(contact.getCompleteName().getSurname());
                    name.setFirstName(contact.getCompleteName().getGivenName());
                    name.setMiddleName(contact.getCompleteName().getMiddleName());
                    name.setPrefix(contact.getCompleteName().getSuffix());
                    name.setFirstNamePronunce(contact.getCompleteName().getYomiGivenName());
                    name.setLastNamePronunce(contact.getCompleteName().getYomiSurname());
                    name.setRecognizeSource(RecognizeSourceType.MANUAL);
                    resultVo.getNames().add(name);
                }
                resultVo.setNickname(contact.getNickName());
            }
            catch (Exception ex) {
                LOG.info("", (Throwable)ex);
            }
            try {
                String companyPronounce = null;
                if (contact.getExtendedProperties().getCount() > 0) {
                    try {
                        Optional<String> companyPronounceOptional = contact.getExtendedProperties().getItems().stream().filter(property -> property.getPropertyDefinition().equals((Object)ExchangeOperationServiceImpl.COMPANY_PRONOUNCE_PROPERTY_DEFINITION)).map(property -> property.getValue().toString()).findFirst();
                        companyPronounce = companyPronounceOptional.get();
                    }
                    catch (Exception companyPronounceOptional) {
                        // empty catch block
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)contact.getCompanyName()) || StringUtils.isNotEmpty((CharSequence)contact.getDepartment()) || StringUtils.isNotEmpty((CharSequence)contact.getJobTitle()) || StringUtils.isNotEmpty(companyPronounce)) {
                    ContactjobinfoInfo jobInfo = new ContactjobinfoInfo(contact.getCompanyName(), contact.getDepartment(), contact.getJobTitle(), RecognizeSourceType.MANUAL);
                    if (StringUtils.isNotEmpty((CharSequence)companyPronounce)) {
                        jobInfo.setCompanyPronunce(companyPronounce);
                    } else {
                        jobInfo.setCompanyPronunce("");
                    }
                    resultVo.getJobinfos().add(jobInfo);
                }
            }
            catch (Exception ex) {
                LOG.info("", (Throwable)ex);
            }
            try {
                ContactphoneInfo phone;
                PhoneNumberDictionary phoneNumberDict = contact.getPhoneNumbers();
                if (phoneNumberDict.contains((Object)PhoneNumberKey.Pager) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.Pager))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.Pager), ContactPhoneType.BBCALL, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
                if (phoneNumberDict.contains((Object)PhoneNumberKey.BusinessFax) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.BusinessFax))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.BusinessFax), ContactPhoneType.BUSINESS_FAX, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
                if (phoneNumberDict.contains((Object)PhoneNumberKey.BusinessPhone) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.BusinessPhone))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.BusinessPhone), ContactPhoneType.BUSINESS_TEL, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
                if (phoneNumberDict.contains((Object)PhoneNumberKey.BusinessPhone2) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.BusinessPhone2))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.BusinessPhone2), ContactPhoneType.BUSINESS_TEL, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
                if (phoneNumberDict.contains((Object)PhoneNumberKey.MobilePhone) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.MobilePhone))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.MobilePhone), ContactPhoneType.CELL, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
                if (phoneNumberDict.contains((Object)PhoneNumberKey.HomeFax) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.HomeFax))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.HomeFax), ContactPhoneType.HOME_FAX, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
                if (phoneNumberDict.contains((Object)PhoneNumberKey.HomePhone) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.HomePhone))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.HomePhone), ContactPhoneType.HOME_TEL, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
                if (phoneNumberDict.contains((Object)PhoneNumberKey.HomePhone2) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.HomePhone2))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.HomePhone2), ContactPhoneType.HOME_TEL, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
                if (phoneNumberDict.contains((Object)PhoneNumberKey.PrimaryPhone) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.PrimaryPhone))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.PrimaryPhone), ContactPhoneType.MAIN, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
                if (phoneNumberDict.contains((Object)PhoneNumberKey.OtherTelephone) && StringUtils.isNotEmpty((CharSequence)phoneNumberDict.getPhoneNumber(PhoneNumberKey.OtherTelephone))) {
                    phone = new ContactphoneInfo(phoneNumberDict.getPhoneNumber(PhoneNumberKey.OtherTelephone), ContactPhoneType.OTHER_TEL, RecognizeSourceType.MANUAL);
                    resultVo.getPhones().add(phone);
                }
            }
            catch (Exception ex) {
                LOG.info("", (Throwable)ex);
            }
            try {
                CountryCode countryCode;
                ContactaddressInfo address;
                String countryName;
                int addressFormat;
                PhysicalAddressEntry addressRecord;
                PhysicalAddressDictionary addressDict = contact.getPhysicalAddresses();
                if (addressDict.contains((Object)PhysicalAddressKey.Business) && (StringUtils.isNotEmpty((CharSequence)(addressRecord = addressDict.getPhysicalAddress(PhysicalAddressKey.Business)).getCountryOrRegion()) || StringUtils.isNotEmpty((CharSequence)addressRecord.getCity()) || StringUtils.isNotEmpty((CharSequence)addressRecord.getState()) || StringUtils.isNotEmpty((CharSequence)addressRecord.getStreet()) || StringUtils.isNotEmpty((CharSequence)addressRecord.getPostalCode()))) {
                    addressFormat = 0;
                    countryName = addressRecord.getCountryOrRegion();
                    address = new ContactaddressInfo(countryName, addressRecord.getCity(), addressRecord.getState(), addressRecord.getStreet(), addressRecord.getPostalCode(), Integer.valueOf(addressFormat), ContactFieldType.BUSINESS, RecognizeSourceType.MANUAL);
                    countryCode = null;
                    try {
                        countryCode = PenpowerCountryMapperUtil.getCountryCode((String)countryName);
                    }
                    catch (Exception ex) {
                        LOG.error("{}", (Throwable)ex);
                    }
                    address.setCountryCode(countryCode == null ? null : countryCode.toString().toLowerCase());
                    resultVo.getAddresses().add(address);
                }
                if (addressDict.contains((Object)PhysicalAddressKey.Home) && (StringUtils.isNotEmpty((CharSequence)(addressRecord = addressDict.getPhysicalAddress(PhysicalAddressKey.Home)).getCountryOrRegion()) || StringUtils.isNotEmpty((CharSequence)addressRecord.getCity()) || StringUtils.isNotEmpty((CharSequence)addressRecord.getState()) || StringUtils.isNotEmpty((CharSequence)addressRecord.getStreet()) || StringUtils.isNotEmpty((CharSequence)addressRecord.getPostalCode()))) {
                    addressFormat = 0;
                    countryName = addressRecord.getCountryOrRegion();
                    address = new ContactaddressInfo(countryName, addressRecord.getCity(), addressRecord.getState(), addressRecord.getStreet(), addressRecord.getPostalCode(), Integer.valueOf(addressFormat), ContactFieldType.HOME, RecognizeSourceType.MANUAL);
                    countryCode = null;
                    try {
                        countryCode = PenpowerCountryMapperUtil.getCountryCode((String)countryName);
                    }
                    catch (Exception ex) {
                        LOG.error("{}", (Throwable)ex);
                    }
                    address.setCountryCode(countryCode == null ? null : countryCode.toString().toLowerCase());
                    resultVo.getAddresses().add(address);
                }
                if (!addressDict.contains((Object)PhysicalAddressKey.Other) || !StringUtils.isNotEmpty((CharSequence)(addressRecord = addressDict.getPhysicalAddress(PhysicalAddressKey.Other)).getCountryOrRegion()) && !StringUtils.isNotEmpty((CharSequence)addressRecord.getCity()) && !StringUtils.isNotEmpty((CharSequence)addressRecord.getState()) && !StringUtils.isNotEmpty((CharSequence)addressRecord.getStreet()) && !StringUtils.isNotEmpty((CharSequence)addressRecord.getPostalCode())) break block51;
                addressFormat = 0;
                countryName = addressRecord.getCountryOrRegion();
                address = new ContactaddressInfo(countryName, addressRecord.getCity(), addressRecord.getState(), addressRecord.getStreet(), addressRecord.getPostalCode(), Integer.valueOf(addressFormat), ContactFieldType.OTHER, RecognizeSourceType.MANUAL);
                countryCode = null;
                try {
                    countryCode = PenpowerCountryMapperUtil.getCountryCode((String)countryName);
                }
                catch (Exception ex) {
                    LOG.error("{}", (Throwable)ex);
                }
                address.setCountryCode(countryCode == null ? null : countryCode.toString().toLowerCase());
                resultVo.getAddresses().add(address);
            }
            catch (Exception ex) {
                LOG.info("", (Throwable)ex);
            }
        }
        try {
            ContactemailInfo mail;
            EmailAddressDictionary emailDict = contact.getEmailAddresses();
            if (emailDict.contains((Object)EmailAddressKey.EmailAddress1) && StringUtils.isNotEmpty((CharSequence)emailDict.getEmailAddress(EmailAddressKey.EmailAddress1).getAddress())) {
                mail = new ContactemailInfo(emailDict.getEmailAddress(EmailAddressKey.EmailAddress1).getAddress(), ContactFieldType.BUSINESS, RecognizeSourceType.MANUAL);
                resultVo.getEmails().add(mail);
            }
            if (emailDict.contains((Object)EmailAddressKey.EmailAddress2) && StringUtils.isNotEmpty((CharSequence)emailDict.getEmailAddress(EmailAddressKey.EmailAddress2).getAddress())) {
                mail = new ContactemailInfo(emailDict.getEmailAddress(EmailAddressKey.EmailAddress2).getAddress(), ContactFieldType.BUSINESS, RecognizeSourceType.MANUAL);
                resultVo.getEmails().add(mail);
            }
            if (emailDict.contains((Object)EmailAddressKey.EmailAddress3) && StringUtils.isNotEmpty((CharSequence)emailDict.getEmailAddress(EmailAddressKey.EmailAddress3).getAddress())) {
                mail = new ContactemailInfo(emailDict.getEmailAddress(EmailAddressKey.EmailAddress3).getAddress(), ContactFieldType.BUSINESS, RecognizeSourceType.MANUAL);
                resultVo.getEmails().add(mail);
            }
        }
        catch (Exception ex) {
            LOG.info("", (Throwable)ex);
        }
        try {
            if (contact.getBirthday() != null) {
                DateTime birthday = new DateTime((Object)contact.getBirthday());
                resultVo.setBirthday(birthday);
            } else {
                resultVo.setBirthday(null);
            }
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        try {
            if (contact.getWeddingAnniversary() != null) {
                DateTime anniversary = new DateTime((Object)contact.getWeddingAnniversary());
                ContactdateInfo date = new ContactdateInfo();
                date.setGuid(UUIDGenerator.getRandomUUID());
                date.setType(ContactDateType.CELEBRATION);
                date.setValue(anniversary);
                resultVo.getDates().add(date);
            }
        }
        catch (Exception ex) {
            LOG.debug("", (Throwable)ex);
        }
        try {
            MessageBody note = contact.getBody();
            if (note != null) {
                resultVo.setNote(StringUtils.isBlank((CharSequence)note.toString()) ? "" : note.toString());
            }
        }
        catch (Exception ex) {
            LOG.info("", (Throwable)ex);
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)contact.getBusinessHomePage())) {
                ContacturlInfo url = new ContacturlInfo(contact.getBusinessHomePage(), ContactUrlType.BUSINESS, RecognizeSourceType.MANUAL);
                resultVo.getUrls().add(url);
            }
        }
        catch (Exception ex) {
            LOG.info("", (Throwable)ex);
        }
        return resultVo;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setExportContactServerInfo(String accountGuid, String contactGuid, String contactServerId, String syncContacServerAccount, DateTime modifiedTime, ContactServerSettingsWithTokenDto contactServerSetting) {
        List statusList = this.contactStatusForAccountDao.findByAccountGuidAndContactGuid(accountGuid, contactGuid);
        if (CollectionUtils.isEmpty((Collection)statusList)) {
            throw new ItemNotFoundException("[setExportContactServerInfo]: Can not find status.");
        }
        if (statusList.size() > 1) {
            LOG.error("status list size more than 1 = {}", (Object)statusList);
        }
        Contactstatusforaccount status = (Contactstatusforaccount)statusList.get(0);
        if (SupportContactServer.EXCHANGE.equals((Object)contactServerSetting.getSupportContactServer())) {
            if (StringUtils.isNotEmpty((CharSequence)contactServerId)) {
                status.setExporttoexchangeid(contactServerId);
            }
            if (StringUtils.isNotEmpty((CharSequence)syncContacServerAccount)) {
                status.setExchangeaccount(syncContacServerAccount);
            }
            if (modifiedTime != null) {
                status.setPreviousModifiedTimeForExchange(modifiedTime);
            }
        } else if (SupportContactServer.OFFICE365.equals((Object)contactServerSetting.getSupportContactServer())) {
            if (StringUtils.isNotEmpty((CharSequence)contactServerId)) {
                status.setExporttooffice365id(contactServerId);
            }
            if (StringUtils.isNotEmpty((CharSequence)syncContacServerAccount)) {
                status.setOffice365account(syncContacServerAccount);
            }
            if (modifiedTime != null) {
                status.setPreviousModifiedTimeForOffice365(modifiedTime);
            }
        } else if (SupportContactServer.QCONTACTZ.equals((Object)contactServerSetting.getSupportContactServer())) {
            if (StringUtils.isNotEmpty((CharSequence)contactServerId)) {
                status.setExporttoqcontactzid(contactServerId);
            }
            if (StringUtils.isNotEmpty((CharSequence)syncContacServerAccount)) {
                status.setQcontactzaccount(syncContacServerAccount);
            }
            if (modifiedTime != null) {
                status.setPreviousModifiedTimeForQContactz(modifiedTime);
            }
        }
        this.contactStatusForAccountDao.save((Object)status);
    }

    public ContactVoWithImageId getContactUpdateVoByContactServerId(ContactServerSyncInfoForWCT syncInfoWCT, ContactInfoForRequest originContact, ContactServerSettingsWithTokenDto contactServerSetting, CustomExchangeService exchangeService, OkHttpClient client) throws Exception {
        String contactServerId = syncInfoWCT.getContactServerId();
        if (StringUtils.isEmpty((CharSequence)contactServerId)) {
            return null;
        }
        ContactInfoForRequest contactInfo = null;
        DateTime lastModifiedTime = null;
        String logoImageFileGuid = null;
        if (contactServerSetting.getSupportContactServer().equals((Object)SupportContactServer.EXCHANGE)) {
            ExchangeContactWithPicture record = this.exchangeOperationService.findContactRecordDetailWithPicture(contactServerId, exchangeService);
            if (record == null || record.getContact() == null) {
                return null;
            }
            contactInfo = this.getContactCreationVoFromExchangeRecord(record.getContact());
            lastModifiedTime = new DateTime((Object)record.getContact().getLastModifiedTime());
            if (record.isHasPicture()) {
                logoImageFileGuid = this.contactPrivateService.createContactImage(record.getImageContent());
            }
            LOG.debug("getContactCreationVoFromExchangeRecord contactInfo={}", (Object)contactInfo);
        } else if (contactServerSetting.getSupportContactServer().equals((Object)SupportContactServer.OFFICE365)) {
            String accessToken = contactServerSetting.getBasicToken() != null ? contactServerSetting.getBasicToken().getAccess_token() : "";
            Office365ContactOrigin record = this.office365OperationService.findContactRecordByContactServerId(contactServerId, accessToken, client);
            contactInfo = this.getContactCreationVoFromOffice365Record(record);
            lastModifiedTime = record.getLastModifiedDateTime();
            LOG.debug("getContactCreationVoFromOffice365Record contactInfo={}", (Object)contactInfo);
            byte[] imageContent = this.office365OperationService.findContactPhoto(contactServerId, accessToken, client);
            if (imageContent != null) {
                logoImageFileGuid = this.contactPrivateService.createContactImage(imageContent);
            }
        } else if (SupportContactServer.QCONTACTZ.equals((Object)contactServerSetting.getSupportContactServer())) {
            String token = contactServerSetting.getQcontactzAuthToken();
            QContactzOriginContact contactRecord = this.qContactzOperationService.findContactRecordByContactServerId(token, contactServerId, false, client);
            contactInfo = this.qContactzOperationService.findContactCreationVoFromQContactzRecord(token, contactRecord, client);
            lastModifiedTime = contactRecord.getUpdatedOn();
            String url = String.format("%smcsapi%s", "http://localhost:8080/", contactRecord.getProfilePicture());
            byte[] contactProfile = this.qContactzOperationService.findContactProfile(token, url, client);
            LOG.debug("contactProfile url: {}", (Object)url);
            if (contactProfile != null) {
                logoImageFileGuid = this.contactPrivateService.createContactImage(contactProfile);
            }
        }
        contactInfo = this.mergeContactRecordWithOriginContact(contactInfo, originContact, contactServerSetting.getSupportContactServer());
        ContactUpdateVo resultVo = new ContactUpdateVo();
        BeanUtils.copyProperties((Object)contactInfo, (Object)resultVo);
        resultVo.setContactGuid(syncInfoWCT.getContactGuid());
        resultVo.setUpdateComponents(new UpdateComponent[]{UpdateComponent.UC_CONTENT, UpdateComponent.UC_LOGO});
        resultVo.setdisplayModifyTime(lastModifiedTime);
        resultVo.setLogoImageFileGuid(logoImageFileGuid);
        return new ContactVoWithImageId(null, resultVo, logoImageFileGuid);
    }

    private <T> List<T> mergeContactServerListToOriginListForSameType(List<T> contactServer, List<T> origin, SupportContactServer supportContactServer) {
        T contactTypeObj;
        if (contactServer == null) {
            contactServer = new ArrayList<T>();
        }
        if (origin == null) {
            origin = new ArrayList<T>();
        }
        if (CollectionUtils.isEmpty(contactServer) && CollectionUtils.isEmpty(origin)) {
            return new ArrayList();
        }
        int originContactStartPosition = contactServer.size();
        T t = contactTypeObj = contactServer.size() > 0 ? contactServer.get(0) : origin.get(0);
        if (SupportContactServer.QCONTACTZ.equals((Object)supportContactServer) && contactServer.size() > 0 && origin.size() > 0) {
            if (contactServer.get(0) instanceof ContactnameInfo && origin.get(0) instanceof ContactnameInfo) {
                ContactnameInfo nameInfo = (ContactnameInfo)origin.get(0);
                if (StringUtils.isNotEmpty((CharSequence)nameInfo.getFirstNamePronunce())) {
                    ((ContactnameInfo)contactServer.get(0)).setFirstNamePronunce(nameInfo.getFirstNamePronunce());
                }
                if (StringUtils.isNotEmpty((CharSequence)nameInfo.getLastNamePronunce())) {
                    ((ContactnameInfo)contactServer.get(0)).setLastNamePronunce(nameInfo.getLastNamePronunce());
                }
                if (StringUtils.isNotEmpty((CharSequence)nameInfo.getSuffix())) {
                    ((ContactnameInfo)contactServer.get(0)).setSuffix(nameInfo.getSuffix());
                }
            } else if (contactServer.get(0) instanceof ContactjobinfoInfo && origin.get(0) instanceof ContactjobinfoInfo) {
                ContactjobinfoInfo jobInfo = (ContactjobinfoInfo)origin.get(0);
                if (StringUtils.isNotEmpty((CharSequence)jobInfo.getDepartment())) {
                    ((ContactjobinfoInfo)contactServer.get(0)).setDepartment(jobInfo.getDepartment());
                }
                if (StringUtils.isNotEmpty((CharSequence)jobInfo.getJobTitle())) {
                    ((ContactjobinfoInfo)contactServer.get(0)).setJobTitle(jobInfo.getJobTitle());
                }
            }
        }
        if (contactTypeObj != null) {
            ContactPhoneType type;
            if (contactTypeObj instanceof ContactaddressInfo || contactTypeObj instanceof ContactjobinfoInfo || contactTypeObj instanceof ContactnameInfo) {
                originContactStartPosition = 1;
            } else if (contactTypeObj instanceof ContactdateInfo) {
                originContactStartPosition = ContactDateType.CELEBRATION.equals((Object)((ContactdateInfo)contactTypeObj).getType()) ? 1 : 0;
            } else if (contactTypeObj instanceof ContacturlInfo) {
                originContactStartPosition = ContactUrlType.BUSINESS.equals((Object)((ContacturlInfo)contactTypeObj).getType()) ? 1 : 0;
            } else if (contactTypeObj instanceof ContactemailInfo) {
                originContactStartPosition = ContactFieldType.BUSINESS.equals((Object)((ContactemailInfo)contactTypeObj).getType()) ? 3 : 0;
            } else if (contactTypeObj instanceof ContactphoneInfo && SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
                type = ((ContactphoneInfo)contactTypeObj).getType();
                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactPhoneType[type.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        originContactStartPosition = 1;
                        break;
                    }
                    case 7: 
                    case 8: {
                        originContactStartPosition = 2;
                        break;
                    }
                    default: {
                        originContactStartPosition = 0;
                        break;
                    }
                }
            } else if (contactTypeObj instanceof ContactphoneInfo && SupportContactServer.OFFICE365.equals((Object)supportContactServer)) {
                type = ((ContactphoneInfo)contactTypeObj).getType();
                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactPhoneType[type.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        originContactStartPosition = 1;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        originContactStartPosition = 2;
                        break;
                    }
                    default: {
                        originContactStartPosition = 0;
                    }
                }
            }
        }
        ArrayList<T> mergeList = new ArrayList<T>();
        if (origin.size() > contactServer.size() && originContactStartPosition <= origin.size()) {
            mergeList.addAll(contactServer);
            mergeList.addAll(origin.subList(originContactStartPosition, origin.size()));
        } else {
            mergeList.addAll(contactServer);
        }
        return mergeList;
    }

    private <T> List<T> internalGetMergeResult(List<T> originContacts, List<T> contactServers, int maxSize, SupportContactServer supportContactServer) {
        ContactFieldType type;
        LinkedHashMap<Object, List> originTypeMap = new LinkedHashMap<Object, List>();
        LinkedHashMap<Object, List> contactServerTypeMap = new LinkedHashMap<Object, List>();
        for (T origin : originContacts) {
            if (origin instanceof ContactaddressInfo) {
                type = ((ContactaddressInfo)origin).getType();
                originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
                continue;
            }
            if (origin instanceof ContactemailInfo) {
                type = ((ContactemailInfo)origin).getType();
                originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
                continue;
            }
            if (origin instanceof ContactphoneInfo) {
                type = ((ContactphoneInfo)origin).getType();
                originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
                continue;
            }
            if (origin instanceof ContactdateInfo) {
                type = ((ContactdateInfo)origin).getType();
                originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
                continue;
            }
            if (!(origin instanceof ContacturlInfo)) continue;
            type = ((ContacturlInfo)origin).getType();
            originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
        }
        for (T inContactServer : contactServers) {
            if (inContactServer instanceof ContactaddressInfo) {
                type = ((ContactaddressInfo)inContactServer).getType();
                contactServerTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inContactServer);
                originTypeMap.computeIfAbsent(type, i -> new ArrayList());
                continue;
            }
            if (inContactServer instanceof ContactemailInfo) {
                type = ((ContactemailInfo)inContactServer).getType();
                contactServerTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inContactServer);
                originTypeMap.computeIfAbsent(type, i -> new ArrayList());
                continue;
            }
            if (inContactServer instanceof ContactphoneInfo) {
                type = ((ContactphoneInfo)inContactServer).getType();
                contactServerTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inContactServer);
                originTypeMap.computeIfAbsent(type, i -> new ArrayList());
                continue;
            }
            if (inContactServer instanceof ContactdateInfo) {
                type = ((ContactdateInfo)inContactServer).getType();
                contactServerTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inContactServer);
                originTypeMap.computeIfAbsent(type, i -> new ArrayList());
                continue;
            }
            if (!(inContactServer instanceof ContacturlInfo)) continue;
            type = ((ContacturlInfo)inContactServer).getType();
            contactServerTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inContactServer);
            originTypeMap.computeIfAbsent(type, i -> new ArrayList());
        }
        List mergeResult = originTypeMap.entrySet().stream().map(originEntry -> this.mergeContactServerListToOriginListForSameType((List)contactServerTypeMap.get(originEntry.getKey()), (List)originEntry.getValue(), supportContactServer)).flatMap(i -> i.stream()).limit(maxSize).collect(Collectors.toList());
        return mergeResult;
    }

    private ContactInfoForRequest mergeContactRecordWithOriginContact(ContactInfoForRequest contactInfoInContactServer, ContactInfoForRequest originContact, SupportContactServer supportContactServer) {
        List mergeAddresses = this.internalGetMergeResult(originContact.getAddresses(), contactInfoInContactServer.getAddresses(), 6, supportContactServer);
        originContact.setAddresses(mergeAddresses);
        List mergeEmails = this.internalGetMergeResult(originContact.getEmails(), contactInfoInContactServer.getEmails(), 6, supportContactServer);
        originContact.setEmails(mergeEmails);
        List mergePhones = this.internalGetMergeResult(originContact.getPhones(), contactInfoInContactServer.getPhones(), 16, supportContactServer);
        originContact.setPhones(mergePhones);
        List mergeDates = this.internalGetMergeResult(originContact.getDates(), contactInfoInContactServer.getDates(), 4, supportContactServer);
        originContact.setDates(mergeDates);
        List mergeUrls = this.internalGetMergeResult(originContact.getUrls(), contactInfoInContactServer.getUrls(), 6, supportContactServer);
        originContact.setUrls(mergeUrls);
        List mergeJobs = this.mergeContactServerListToOriginListForSameType(contactInfoInContactServer.getJobinfos(), originContact.getJobinfos(), supportContactServer).stream().limit(6L).collect(Collectors.toList());
        originContact.setJobinfos(mergeJobs);
        List mergeNames = this.mergeContactServerListToOriginListForSameType(contactInfoInContactServer.getNames(), originContact.getNames(), supportContactServer).stream().limit(4L).collect(Collectors.toList());
        originContact.setNames(mergeNames);
        originContact.setBirthday(contactInfoInContactServer.getBirthday());
        originContact.setNickname(contactInfoInContactServer.getNickname());
        originContact.setNote(StringUtils.isBlank((CharSequence)contactInfoInContactServer.getNote()) ? "" : contactInfoInContactServer.getNote());
        return originContact;
    }

    public void exportContactCheck(ContactInfoForResponse contactInfo) {
    }
}

