/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.OkHttpUtils;
import com.penpower.worldcard.team.contactsystem.ContactServerBasicToken;
import com.penpower.worldcard.team.contactsystem.CustomExchangeService;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.QContactzAuthInfo;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.QContactzAuthResponse;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.QContactzSecurityInfo;
import com.penpower.worldcard.team.dto.ContactServerSettingsDto;
import com.penpower.worldcard.team.dto.ContactServerSettingsDtoFull;
import com.penpower.worldcard.team.dto.ContactServerSettingsWithTokenDto;
import com.penpower.worldcard.team.dto.QContactzAuthTokenDto;
import com.penpower.worldcard.team.enums.ContactServerExportMode;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.QContactzQuestionOptions;
import com.penpower.worldcard.team.enums.QContactzSecurityType;
import com.penpower.worldcard.team.enums.SupportContactServer;
import com.penpower.worldcard.team.exception.CRMLoginException;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.exception.ForbiddenException;
import com.penpower.worldcard.team.exception.HttpConnectionException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.ContactServerAuthService;
import com.penpower.worldcard.team.service.Office365OperationService;
import com.penpower.worldcard.team.service.QContactzOperationService;
import com.penpower.worldcard.team.web.api.vo.response.QContactzAuthInfoResponseResult;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
public class ContactServerAuthServiceImpl
implements ContactServerAuthService {
    private static final Logger LOG = LoggerFactory.getLogger(ContactServerAuthServiceImpl.class);
    private static final String QCONTACTZ_GET_TOKEN_PATH = String.format("%smcsapi/api/v1/authenticate", "http://localhost:8080/");
    @Autowired
    private Office365OperationService office365OperationService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private QContactzOperationService qContactzOperationService;
    private Gson gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();

    public String testConnectionAndGetExchangeUniqueId(ContactServerSettingsDtoFull contactServerSetting) {
        try (CustomExchangeService exchangeService = new CustomExchangeService();){
            SupportContactServer supportContactServer = contactServerSetting.getSupportContactServer();
            if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
                String serverUrl = String.format("https://%s/EWS/Exchange.asmx", contactServerSetting.getServerUrl());
                exchangeService.setUrl(new URI(serverUrl));
                String account = contactServerSetting.getAccount();
                String password = contactServerSetting.getPassword();
                if (GlobalUtils.isAdAccountPattern((String)contactServerSetting.getAccount())) {
                    LOG.debug("account={} is ad account Pattern", (Object)contactServerSetting.getAccount());
                    String separator = "\\";
                    String[] accountAndDomain = account.split(Pattern.quote(separator));
                    exchangeService.setCredentials((ExchangeCredentials)new WebCredentials(accountAndDomain[1], password, accountAndDomain[0]));
                } else {
                    exchangeService.setCredentials((ExchangeCredentials)new WebCredentials(account, password));
                }
                PropertySet property = new PropertySet(BasePropertySet.IdOnly);
                Folder rootFolder = Folder.bind((ExchangeService)exchangeService, (WellKnownFolderName)WellKnownFolderName.Root, (PropertySet)property);
                Folder contactFolder = Folder.bind((ExchangeService)exchangeService, (WellKnownFolderName)WellKnownFolderName.Contacts, (PropertySet)property);
                if (rootFolder == null || contactFolder == null) {
                    throw new HttpConnectionException("Can't find root folder or contact folder");
                }
                int rootFolderCode = Math.abs(rootFolder.getId().hashCode());
                int contactFolderCode = Math.abs(contactFolder.getId().hashCode());
                String string = String.valueOf(rootFolderCode) + String.valueOf(contactFolderCode);
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkExchangeServiceUrl(String contactServerUrl) {
        try (CustomExchangeService exchangeService = new CustomExchangeService();){
            String serverUrl = String.format("https://%s/EWS/Exchange.asmx", contactServerUrl);
            exchangeService.setUrl(new URI(serverUrl));
            exchangeService.getServerTimeZones();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContactServerBasicToken getContactServerBasicTokenByCode(SupportContactServer supportContactServer, String code, OkHttpClient client) {
        FormBody requestBody = new FormBody.Builder().add("client_id", "c77ac372-905f-41ef-9c29-98f7dc81a24c").add("scope", "openid offline_access Contacts.ReadWrite User.ReadWrite Files.ReadWrite.All Mail.ReadWrite").add("redirect_uri", "https://office365-oauth.worldcardteam.com").add("grant_type", "authorization_code").add("client_secret", "[@4nWW=Zwl@brkvuBF7C4s4GrsY4Cglj").add("code", code).build();
        String url = "https://login.microsoftonline.com/common/oauth2/v2.0/token";
        Request request = new Request.Builder().post((RequestBody)requestBody).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("request={}, response={}", (Object)url, (Object)responseString);
            if (response.isSuccessful()) {
                ContactServerBasicToken contactServerBasicToken = (ContactServerBasicToken)GlobalUtils.getObjectFromJson((String)responseString, ContactServerBasicToken.class);
                return contactServerBasicToken;
            }
            LOG.error("getContactServerBasicTokenByCode failed");
            LOG.error("code={},url={}, responseString={}", new Object[]{code, url, responseString});
            throw new HttpConnectionException(responseString);
        }
        catch (IOException ex) {
            LOG.error("getContactServerBasicTokenByCode failed");
            LOG.error("code={},url={}", (Object)code, (Object)url);
            LOG.error(ex.toString());
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContactServerBasicToken refreshToken(SupportContactServer supportContactServer, String refreshToken, Platform settingPlatform, OkHttpClient client) {
        FormBody requestBody = null;
        if (Platform.WEB.equals((Object)settingPlatform)) {
            LOG.info("Refresh token by web");
            requestBody = new FormBody.Builder().add("client_id", "c77ac372-905f-41ef-9c29-98f7dc81a24c").add("client_secret", "[@4nWW=Zwl@brkvuBF7C4s4GrsY4Cglj").add("grant_type", "refresh_token").add("refresh_token", refreshToken).build();
        } else if (Platform.IOS.equals((Object)settingPlatform) || Platform.MAC.equals((Object)settingPlatform) || Platform.IPAD.equals((Object)settingPlatform)) {
            LOG.info("Refresh token by ios/mac");
            requestBody = new FormBody.Builder().add("client_id", "df5fa9a6-88ba-464b-8a9e-c9ef2291c65f").add("grant_type", "refresh_token").add("refresh_token", refreshToken).build();
        } else if (Platform.PC.equals((Object)settingPlatform)) {
            LOG.info("Refresh token by pc");
            requestBody = new FormBody.Builder().add("client_id", "8f3d8c8f-62e0-450d-b861-8d539189c53b").add("client_secret", "sFJzh_70?mKV[lfGL4L1tb-/-@gXS3JQ").add("grant_type", "refresh_token").add("refresh_token", refreshToken).build();
        } else if (Platform.ANDROID.equals((Object)settingPlatform) || Platform.ANDROID_TABLET.equals((Object)settingPlatform)) {
            LOG.info("Refresh token by android");
            requestBody = new FormBody.Builder().add("client_id", "24b64c51-eb73-412b-a9f7-51da2aac53bc").add("grant_type", "refresh_token").add("refresh_token", refreshToken).build();
        }
        String url = "https://login.microsoftonline.com/common/oauth2/v2.0/token";
        Request request = new Request.Builder().post((RequestBody)requestBody).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("request={}, response={}", (Object)url, (Object)responseString);
            if (response.isSuccessful()) {
                ContactServerBasicToken contactServerBasicToken = (ContactServerBasicToken)GlobalUtils.getObjectFromJson((String)responseString, ContactServerBasicToken.class);
                return contactServerBasicToken;
            }
            LOG.error("refresh token failed={}", (Object)responseString);
            throw new ForbiddenException(responseString + ":401");
        }
        catch (IOException ex) {
            LOG.error("refresh token failed={}", (Throwable)ex);
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QContactzAuthInfoResponseResult setQContactzAccessToken(QContactzAuthTokenDto qContactzAuthTokenDto, String userGuid, Platform platform, OkHttpClient client) {
        String jsonBody = this.gson.toJson((Object)qContactzAuthTokenDto);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonBody);
        Request request = new Request.Builder().url(QCONTACTZ_GET_TOKEN_PATH).post(requestBody).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("{}, url={}, responseString={}", new Object[]{jsonBody, QCONTACTZ_GET_TOKEN_PATH, responseString});
            if (!response.isSuccessful()) {
                throw new HttpConnectionException(responseString);
            }
            QContactzAuthResponse qContactzAuthResponse = (QContactzAuthResponse)this.gson.fromJson(responseString, QContactzAuthResponse.class);
            if (!qContactzAuthResponse.isStatus()) {
                throw new CRMLoginException(String.format("Failed to authenticate token. [code]: %s, [message]: %s", qContactzAuthResponse.getStatusCode(), qContactzAuthResponse.getMessage()));
            }
            QContactzAuthInfo qContactzAuthInfo = qContactzAuthResponse.getData();
            if (!qContactzAuthInfo.isAuthPassed()) {
                QContactzAuthInfo securityQuestionInfo;
                if (!QContactzSecurityType.USER.equals((Object)qContactzAuthTokenDto.getSecurityType())) {
                    throw new CRMOperationException("Failed to authenticate token.");
                }
                if (QContactzSecurityType.QUESTION.equals((Object)qContactzAuthInfo.getAnotherVerification())) {
                    securityQuestionInfo = this.getQContactzSecurityQuestion(qContactzAuthTokenDto, client);
                    qContactzAuthInfo.setSecurityQuestionNo(securityQuestionInfo.getSecurityQuestionNo());
                    qContactzAuthInfo.setSecurityQuestionText(securityQuestionInfo.getSecurityQuestionText());
                }
                securityQuestionInfo = new QContactzAuthInfoResponseResult("Need 2 step verification", new QContactzSecurityInfo(qContactzAuthInfo));
                return securityQuestionInfo;
            }
            ContactServerSettingsWithTokenDto contactServerSettings = new ContactServerSettingsWithTokenDto();
            contactServerSettings.setAccount(qContactzAuthInfo.getUserName());
            contactServerSettings.setQcontactzAccountId(qContactzAuthInfo.getUserId());
            contactServerSettings.setQcontactzAccountSid(qContactzAuthInfo.getSid());
            contactServerSettings.setQcontactzAuthToken(qContactzAuthInfo.getToken());
            contactServerSettings.setContactServerExportMode(ContactServerExportMode.MANUAL_EXPORT);
            contactServerSettings.setSupportContactServer(SupportContactServer.QCONTACTZ);
            contactServerSettings.setLastUpdateTokenTime(DateTime.now());
            contactServerSettings.setSettingPlatform(platform);
            this.accountPrivateSettingService.setUserContactServerSettings(userGuid, (ContactServerSettingsDto)contactServerSettings, null);
            QContactzAuthInfoResponseResult qContactzAuthInfoResponseResult = new QContactzAuthInfoResponseResult("Set QContactz token success.", new QContactzSecurityInfo(qContactzAuthInfo));
            return qContactzAuthInfoResponseResult;
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
        catch (HttpConnectionException ex) {
            LOG.error("getQContactzAuthToken failed");
            LOG.error("{},url={}, responseString={}", new Object[]{jsonBody, QCONTACTZ_GET_TOKEN_PATH, ex.getMessage()});
            LOG.error(ex.toString());
            throw ex;
        }
        catch (CRMLoginException ex) {
            LOG.error("getQContactzAuthToken failed");
            LOG.error("{},url={}, responseString={}", new Object[]{jsonBody, QCONTACTZ_GET_TOKEN_PATH, ex.getMessage()});
            LOG.error(ex.toString());
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String refreshQContactzAuthToken(ContactServerSettingsWithTokenDto settingsWithTokenDto, OkHttpClient client) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("username", settingsWithTokenDto.getAccount());
        dataMap.put("sid", settingsWithTokenDto.getQcontactzAccountSid());
        String jsonBody = this.gson.toJson(dataMap);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonBody);
        Request request = new Request.Builder().url(QCONTACTZ_GET_TOKEN_PATH).post(requestBody).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("{}, url={}, responseString={}", new Object[]{jsonBody, QCONTACTZ_GET_TOKEN_PATH, responseString});
            if (!response.isSuccessful()) {
                throw new HttpConnectionException(responseString);
            }
            QContactzAuthResponse qContactzAuthResponse = (QContactzAuthResponse)this.gson.fromJson(responseString, QContactzAuthResponse.class);
            QContactzAuthInfo qContactzAuthInfo = qContactzAuthResponse.getData();
            if (!qContactzAuthInfo.isAuthPassed()) {
                throw new HttpConnectionException(responseString);
            }
            String string = qContactzAuthInfo.getToken();
            return string;
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage());
        }
        catch (HttpConnectionException ex) {
            LOG.error("refreshQContactzAuthToken failed {}");
            LOG.error("request:{}, error:{}", (Object)QCONTACTZ_GET_TOKEN_PATH, (Object)ex.getMessage());
            throw new HttpConnectionException(ex.getMessage());
        }
    }

    private QContactzAuthInfo getQContactzSecurityQuestion(QContactzAuthTokenDto dto, OkHttpClient client) {
        QContactzAuthInfo qContactzAuthInfo = this.getQContactzAnotherVerification(dto.getUsername(), dto.getPassword(), QContactzSecurityType.QUESTION, dto.getQlang(), client);
        LOG.debug(GlobalUtils.getJsonString((Object)qContactzAuthInfo));
        return qContactzAuthInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QContactzAuthInfo getQContactzAnotherVerification(String username, String password, QContactzSecurityType securityType, String qlang, OkHttpClient client) {
        QContactzAuthTokenDto qContactzAuthTokenDto = new QContactzAuthTokenDto(username, password, securityType, qlang);
        String jsonBody = this.gson.toJson((Object)qContactzAuthTokenDto);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonBody);
        Request request = new Request.Builder().url(QCONTACTZ_GET_TOKEN_PATH).post(requestBody).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("{}, url={}, responseString={}", new Object[]{jsonBody, QCONTACTZ_GET_TOKEN_PATH, responseString});
            if (!response.isSuccessful()) {
                throw new HttpConnectionException(responseString);
            }
            QContactzAuthResponse qContactzAuthResponse = (QContactzAuthResponse)this.gson.fromJson(responseString, QContactzAuthResponse.class);
            if (!qContactzAuthResponse.isStatus()) {
                throw new CRMLoginException(String.format("Failed to aithenticate with another method. [code]: %s, [message]: %s", qContactzAuthResponse.getStatusCode(), qContactzAuthResponse.getMessage()));
            }
            QContactzAuthInfo qContactzAuthInfo = qContactzAuthResponse.getData();
            if (QContactzSecurityType.QUESTION.equals((Object)securityType) && QContactzQuestionOptions.CUSTOM.getValue().intValue() != qContactzAuthInfo.getSecurityQuestionNo()) {
                this.getContactzSecurityQuestionByLang(qContactzAuthTokenDto, qContactzAuthInfo, client);
            }
            QContactzAuthInfo qContactzAuthInfo2 = qContactzAuthInfo;
            return qContactzAuthInfo2;
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
        catch (HttpConnectionException ex) {
            LOG.error("getQContactzAnotherVerification failed");
            LOG.error("{}, url={}, responseString={}", new Object[]{jsonBody, QCONTACTZ_GET_TOKEN_PATH, ex.getMessage()});
            LOG.error(ex.toString());
            throw ex;
        }
    }

    private void getContactzSecurityQuestionByLang(QContactzAuthTokenDto dto, QContactzAuthInfo info, OkHttpClient client) {
        String url = String.format("http://localhost:8080/cgi-bin/authLogin.cgi?user=%s&pwd=%s&q_lang=%s&get_question=1&force_to_check_2sv=1", dto.getUsername(), dto.getPassword(), dto.getQlang());
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("url={}, responseString={}", (Object)url, (Object)responseString);
            if (!response.isSuccessful()) {
                throw new HttpConnectionException(responseString);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(responseString)));
            String securityQuestionText = doc.getElementsByTagName("system_question_text").item(0).getTextContent();
            LOG.debug("securityQuestionText: {}", (Object)securityQuestionText);
            info.setSecurityQuestionText(securityQuestionText);
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
        catch (HttpConnectionException ex) {
            LOG.error("getContactzSecurityQuestionByLang failed");
            LOG.error("url={}, responseString={}", (Object)url, (Object)ex.getMessage());
            LOG.error(ex.toString());
            throw ex;
        }
    }

    public void testAccessTokenForOffice365(String accessToken, OkHttpClient client) {
        ContactServerSettingsWithTokenDto contactServerSetting = new ContactServerSettingsWithTokenDto();
        contactServerSetting.setBasicToken(new ContactServerBasicToken(accessToken, ""));
        contactServerSetting.setSupportContactServer(SupportContactServer.OFFICE365);
        this.office365OperationService.findContactFolderId(contactServerSetting, client);
    }

    public String getQContactzAppVersion(OkHttpClient client) throws IOException {
        this.checkQContactExistence(client);
        Path path = Paths.get("/share/CACHEDEV1_DATA/.qpkg/qcontactz/shell/qcontactz.conf", new String[0]);
        Stream<String> configLines = Files.lines(path);
        String version = configLines.filter(line -> line.contains("QPKG_VERSION=")).map(line -> line.split("=")[1]).findFirst().get();
        configLines.close();
        return version;
    }

    private void checkQContactExistence(OkHttpClient client) {
        String url = "http://localhost:8080//mcsapi/api/v1/ping";
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new ItemNotFoundException("Qcontactz server not found");
            }
        }
        catch (Exception ex) {
            LOG.error(ex.toString());
            throw new ItemNotFoundException("Qcontactz server not found");
        }
    }
}

