/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.hankcs.hanlp.HanLP;
import com.penpower.worldcard.team.Utils.CollectionUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.dao.CategoryDao;
import com.penpower.worldcard.team.dao.ContactSimpleInfoDao;
import com.penpower.worldcard.team.dao.CustomFieldDao;
import com.penpower.worldcard.team.dto.AccountCondition;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AdvancedSearchInfo;
import com.penpower.worldcard.team.dto.CategoryCondition;
import com.penpower.worldcard.team.dto.ContactInfoCondition;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.dto.CusomFieldSearchInfo;
import com.penpower.worldcard.team.dto.CustomFieldCondition;
import com.penpower.worldcard.team.dto.NumberInterval;
import com.penpower.worldcard.team.dto.SearchInfo;
import com.penpower.worldcard.team.dto.TimeCondition;
import com.penpower.worldcard.team.dto.TimeInterval;
import com.penpower.worldcard.team.entity.Customfield;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.CategoryType;
import com.penpower.worldcard.team.enums.ContactRangeType;
import com.penpower.worldcard.team.enums.ContactsimpleinfoSortField;
import com.penpower.worldcard.team.enums.CustomFieldCategory;
import com.penpower.worldcard.team.enums.CustomFieldContactAttribute;
import com.penpower.worldcard.team.enums.LogicWithPreviousAllResults;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.enums.SearchableField;
import com.penpower.worldcard.team.enums.ShareRule;
import com.penpower.worldcard.team.enums.UnicodeFontType;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.SearchEngineIndexMissingException;
import com.penpower.worldcard.team.exception.SearchEngineNotRunningException;
import com.penpower.worldcard.team.exception.SearchEngineRuntimeException;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.ContactSearchService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.impl.ContactSearchServiceImpl;
import com.penpower.worldcard.team.web.api.vo.AdvancedSearchVo;
import com.penpower.worldcard.team.web.api.vo.PageInfoVo;
import com.penpower.worldcard.team.web.api.vo.SearchPageSetting;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.join.query.HasChildQueryBuilder;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContactSearchServiceImpl
implements ContactSearchService {
    private static final String INDEX_NOT_FOUND_EXCEPTION = "index_not_found_exception";
    private static final int MAX_SEARCH_INFOS_NUMBER = 3;
    private static final String BELONG_CATEGORIES = "belongCategories";
    private static final String BE_SHARED_AND_OWNER_ACCOUNT_GUIDS = "beSharedAndOwnerAccountGuids";
    private static final String TOTAL_CONTENT = "totalContent";
    private static final String AUTOCOMPLETE_FIELD = "autocompleteField";
    private static final Logger LOG = LoggerFactory.getLogger(ContactSearchServiceImpl.class);
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager scheduleManager;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ContactSimpleInfoDao contactSimpleInfoDao;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private AccountService accountService;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    @Qualifier(value="searchEngineIndex")
    private String searchEngineIndex;

    public PageInfoVo<List<ContactSimpleInfoDto>> searchContactForAdvanced(AdvancedSearchVo advancedSearchVo, AccountInfo loginUser) {
        ContactRangeType contactRangeType = advancedSearchVo.getContactRangetype();
        QueryBuilder queryBuilder = null;
        this.checkPageAndPageSize(advancedSearchVo.getPage().intValue(), advancedSearchVo.getPageSize().intValue());
        queryBuilder = this.isAdmin(loginUser) ? this.createQueryForAdvanced(advancedSearchVo, loginUser.getGuid(), contactRangeType, true) : this.createQueryForAdvanced(advancedSearchVo, loginUser.getGuid(), contactRangeType, false);
        return this.searchWithContactRangeType((SearchPageSetting)advancedSearchVo, loginUser.getGuid(), queryBuilder);
    }

    public PageInfoVo<List<ContactSimpleInfoDto>> searchContactForNormal(String keyword, SearchPageSetting searchPageSetting, AccountInfo loginUser) {
        ContactRangeType contactRangeType = searchPageSetting.getContactRangetype();
        QueryBuilder queryBuilder = null;
        queryBuilder = this.isAdmin(loginUser) ? this.createQueryForNormal(TOTAL_CONTENT, keyword, loginUser.getGuid(), contactRangeType, true) : this.createQueryForNormal(TOTAL_CONTENT, keyword, loginUser.getGuid(), contactRangeType, false);
        return this.searchWithContactRangeType(searchPageSetting, loginUser.getGuid(), queryBuilder);
    }

    private void checkPageAndPageSize(int page, int pageSize) {
        if (page < 0 || pageSize <= 0) {
            throw new RequestArgumentNotValidException("the page value cannot be less than 0 or pageSize cannot be less than equal to 0 value.");
        }
    }

    private QueryBuilder createQueryForNormal(String fieldName, String keyword, String userGuid, ContactRangeType contactRangeType, boolean isAdmin) {
        BoolQueryBuilder contactInfoQuery = new BoolQueryBuilder();
        BoolQueryBuilder contactVisibilityQuery = new BoolQueryBuilder();
        BoolQueryBuilder allQuery = new BoolQueryBuilder();
        boolean keywordContainsChineseWord = GlobalUtils.stringContainsChineseWord((String)keyword);
        if (keywordContainsChineseWord) {
            String big5Keyword = this.getKeyWordByUnicodeType(keyword, UnicodeFontType.BIG5);
            String gbKeyword = this.getKeyWordByUnicodeType(keyword, UnicodeFontType.GB);
            contactInfoQuery.filter((QueryBuilder)QueryBuilders.disMaxQuery().add((QueryBuilder)QueryBuilders.matchPhraseQuery((String)fieldName, (Object)big5Keyword)).add((QueryBuilder)QueryBuilders.matchPhraseQuery((String)fieldName, (Object)keyword)).add((QueryBuilder)QueryBuilders.matchPhraseQuery((String)fieldName, (Object)gbKeyword)));
            LOG.debug("SearchFieldName:{}, big5Keyword:{}, keyword:{}, gbKeyword:{}", new Object[]{fieldName, big5Keyword, keyword, gbKeyword});
        } else {
            keyword = keyword.toLowerCase();
            contactInfoQuery.filter((QueryBuilder)QueryBuilders.matchPhraseQuery((String)fieldName, (Object)keyword));
            LOG.debug("SearchFieldName:{}, keyword:{}", (Object)fieldName, (Object)keyword);
        }
        contactVisibilityQuery = this.getContactVisibilityQuery(userGuid, contactRangeType, isAdmin);
        allQuery.should((QueryBuilder)JoinQueryBuilders.hasChildQuery((String)"contactvisibility", (QueryBuilder)contactVisibilityQuery, (ScoreMode)ScoreMode.None));
        allQuery.should((QueryBuilder)contactInfoQuery);
        allQuery.minimumShouldMatch(2);
        return allQuery;
    }

    private PageInfoVo<List<ContactSimpleInfoDto>> searchWithContactRangeType(SearchPageSetting searchPageSetting, String userGuid, QueryBuilder queryBuilder) {
        int page = searchPageSetting.getPage();
        int pageSize = searchPageSetting.getPageSize();
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        String sortFieldName = this.getSortFieldName(searchPageSetting.getContactsimpleinfoSortField(), nameDisplayOrderSettingType);
        SortOrder sortOrder = SortOrder.fromString((String)searchPageSetting.getSortDirection().toString());
        SearchRequest searchRequest = new SearchRequest(new String[]{this.searchEngineIndex});
        searchRequest.source().query(queryBuilder).from(page * pageSize).size(pageSize).sort(sortFieldName, sortOrder).fetchSource(false);
        try {
            SearchResponse response = this.client.search(searchRequest, new Header[0]);
            SearchHits searchHits = response.getHits();
            ArrayList<String> contactGuids = new ArrayList<String>();
            for (SearchHit hit : searchHits) {
                contactGuids.add(hit.getId());
            }
            PageInfoVo pageResult = this.convertToPageResult(contactGuids, nameDisplayOrderSettingType, searchHits.getTotalHits(), pageSize);
            return pageResult;
        }
        catch (ConnectException e) {
            throw new SearchEngineNotRunningException("Search engine is not running");
        }
        catch (ElasticsearchException e) {
            if (e.getMessage().contains(INDEX_NOT_FOUND_EXCEPTION)) {
                throw new SearchEngineIndexMissingException("Search engine indexing data is missing");
            }
            throw new SearchEngineRuntimeException(e.getMessage());
        }
        catch (SearchEngineRuntimeException | IOException e) {
            throw new SearchEngineRuntimeException(e.getMessage());
        }
    }

    private PageInfoVo<List<ContactSimpleInfoDto>> convertToPageResult(List<String> contactSimpleInfoGuids, NameDisplayOrderSettingType nameDisplayOrderSettingType, long totalCount, int pageSize) {
        if (totalCount == 0L) {
            LOG.debug("No search result found ... , return empty result array.");
            return new PageInfoVo(0L, 0, new ArrayList());
        }
        Long findSimpleInfoStart = System.currentTimeMillis();
        List contactSimpleInfos = this.contactSimpleInfoDao.findByContactGuids(contactSimpleInfoGuids);
        Collections.sort(contactSimpleInfos, Comparator.comparing(item -> contactSimpleInfoGuids.indexOf(item.getContact().getGuid())));
        LOG.debug("FindSimpleInfo time:{}", (Object)(System.currentTimeMillis() - findSimpleInfoStart));
        Long transToContactSimpleInfoDtoStart = System.currentTimeMillis();
        List result = contactSimpleInfos.stream().filter(Objects::nonNull).map(contactSimpleInfo -> new ContactSimpleInfoDto(contactSimpleInfo, nameDisplayOrderSettingType, contactSimpleInfo.getContact())).collect(Collectors.toList());
        LOG.debug("ContactSimpleInfos to ContactSimpleInfoDtos time:{}", (Object)(System.currentTimeMillis() - transToContactSimpleInfoDtoStart));
        int totalPage = (int)Math.ceil((double)totalCount / (double)pageSize);
        PageInfoVo pageResult = new PageInfoVo(totalCount, totalPage, result);
        return pageResult;
    }

    private String getSortFieldName(ContactsimpleinfoSortField contactsimpleinfoSortField, NameDisplayOrderSettingType nameDisplayOrderSettingType) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactsimpleinfoSortField[contactsimpleinfoSortField.ordinal()]) {
            case 1: {
                return contactsimpleinfoSortField.getTableName() + "." + "keywordfield";
            }
            case 2: {
                return "createTime";
            }
            case 3: {
                return contactsimpleinfoSortField.getTableName() + "." + "keywordfield";
            }
            case 4: {
                return "jobTitle.keywordfield";
            }
            case 5: {
                if (NameDisplayOrderSettingType.EAST_FL_WEST_FL.equals((Object)nameDisplayOrderSettingType)) {
                    return "fullnameeastfirstwestfirst";
                }
                if (NameDisplayOrderSettingType.EAST_FL_WEST_LF.equals((Object)nameDisplayOrderSettingType)) {
                    return "fullnameeastfirstwestlast";
                }
                if (NameDisplayOrderSettingType.EAST_LF_WEST_FL.equals((Object)nameDisplayOrderSettingType)) {
                    return "fullnameeastlastwestfirst";
                }
                return "fullnameeastlastwestlast";
            }
        }
        return null;
    }

    private QueryBuilder createQueryForAdvanced(AdvancedSearchVo advancedSearchVo, String userGuid, ContactRangeType contactRangeType, boolean isAdmin) {
        List categoryGuids;
        QueryBuilder queryBuilder;
        LogicWithPreviousAllResults logic;
        AdvancedSearchInfo advancedSearchInfo = advancedSearchVo.getAdvancedSearchInfo();
        ContactInfoCondition contactInfoCondition = advancedSearchInfo.getContactInfoCondition();
        CategoryCondition categoryCondition = advancedSearchInfo.getCategoryCondition();
        TimeCondition timeCondition = advancedSearchInfo.getTimeCondition();
        AccountCondition accountCondition = advancedSearchInfo.getAccountCondition();
        CustomFieldCondition customFieldCondition = advancedSearchInfo.getCustomFieldCondition();
        BoolQueryBuilder contactInfoQuery = null;
        BoolQueryBuilder customFieldQuery = null;
        HasChildQueryBuilder categoryQuery = null;
        RangeQueryBuilder timeQuery = null;
        TermsQueryBuilder accountQuery = null;
        if (contactInfoCondition != null && !CollectionUtil.collectionEmpty((Collection)contactInfoCondition.getSearchinfos())) {
            contactInfoQuery = new BoolQueryBuilder();
            int searchInfoIndex = 0;
            for (SearchInfo searchInfo : contactInfoCondition.getSearchinfos()) {
                logic = searchInfo.getLogicWithPreviousAllResults();
                this.verifyLogicExistence(searchInfoIndex, logic);
                queryBuilder = this.getSubQuery((Object)searchInfo);
                contactInfoQuery = this.connectQueryWithLogic(searchInfoIndex, queryBuilder, logic, contactInfoQuery);
                ++searchInfoIndex;
            }
            if (searchInfoIndex > 3) {
                throw new RequestArgumentNotValidException(String.format("Can't set more than [%s] searchInfo in contactInfoCondition", 3));
            }
        }
        if (customFieldCondition != null && !CollectionUtil.collectionEmpty((Collection)customFieldCondition.getCustomFieldSearchInfos())) {
            customFieldQuery = new BoolQueryBuilder();
            int customFieldSearchInfoIndex = 0;
            for (CusomFieldSearchInfo customFieldSearchInfo : customFieldCondition.getCustomFieldSearchInfos()) {
                logic = customFieldSearchInfo.getLogicWithPreviousAllResults();
                this.verifyLogicExistence(customFieldSearchInfoIndex, logic);
                queryBuilder = this.getSubQuery((Object)customFieldSearchInfo);
                customFieldQuery = this.connectQueryWithLogic(customFieldSearchInfoIndex, queryBuilder, logic, customFieldQuery);
                ++customFieldSearchInfoIndex;
            }
            if (customFieldSearchInfoIndex > 3) {
                throw new RequestArgumentNotValidException(String.format("Can't set more than [%s] customFieldSearchInfo in customFieldCondition", 3));
            }
        }
        if (categoryCondition != null && ContactRangeType.PRIVATE.equals((Object)contactRangeType) && !CollectionUtil.collectionEmpty((Collection)(categoryGuids = categoryCondition.getCategoryGuids()))) {
            categoryQuery = JoinQueryBuilders.hasChildQuery((String)"contactvisibility", (QueryBuilder)QueryBuilders.termsQuery((String)SearchableField.CATEGORY.getEsName(), (Collection)categoryGuids), (ScoreMode)ScoreMode.None);
        }
        if (timeCondition != null && timeCondition.getField() != null) {
            this.verifyBeingEndCorrectness(timeCondition.getBeginTimeMills(), timeCondition.getEndTimeMills());
            timeQuery = QueryBuilders.rangeQuery((String)timeCondition.getField().getEsName()).gte((Object)timeCondition.getBeginTimeMills()).lte((Object)timeCondition.getEndTimeMills());
        }
        if (accountCondition != null && accountCondition.getField() != null) {
            accountQuery = QueryBuilders.termsQuery((String)accountCondition.getField().getEsName(), (Collection)accountCondition.getAccountGuids());
        }
        BoolQueryBuilder contactVisibilityQuery = this.getContactVisibilityQuery(userGuid, contactRangeType, isAdmin);
        BoolQueryBuilder allQuery = this.combineQuery(contactVisibilityQuery, Arrays.asList(contactInfoQuery, customFieldQuery, categoryQuery, timeQuery, accountQuery));
        return allQuery;
    }

    private void verifyBeginEndCorrectness(Double beginValue, Double endValue) {
        if (beginValue != null && endValue != null && beginValue > endValue) {
            throw new RequestArgumentNotValidException("EndNumber should be greater or equal than beginNumber");
        }
    }

    private void verifyBeingEndCorrectness(Long beginValue, Long endValue) {
        if (beginValue != null && endValue != null && beginValue.doubleValue() > endValue.doubleValue()) {
            throw new RequestArgumentNotValidException("EndTime should be greater or equal than beginTime");
        }
    }

    private BoolQueryBuilder connectQueryWithLogic(int infoIndex, QueryBuilder newArrivalQuery, LogicWithPreviousAllResults logic, BoolQueryBuilder currentQuery) {
        if (infoIndex == 0) {
            currentQuery.filter(newArrivalQuery);
        } else if (LogicWithPreviousAllResults.AND.equals((Object)logic)) {
            BoolQueryBuilder lastQuery = currentQuery;
            currentQuery = new BoolQueryBuilder();
            currentQuery.filter((QueryBuilder)lastQuery);
            currentQuery.filter(newArrivalQuery);
        } else {
            BoolQueryBuilder lastQuery = currentQuery;
            currentQuery = new BoolQueryBuilder();
            currentQuery.should((QueryBuilder)lastQuery);
            currentQuery.should(newArrivalQuery);
        }
        return currentQuery;
    }

    private QueryBuilder getSubQuery(Object searchInfo) {
        QueryBuilder queryBuilder = null;
        if (searchInfo instanceof CusomFieldSearchInfo) {
            queryBuilder = this.getCustomFieldQueryBuilder(searchInfo);
        } else if (searchInfo instanceof SearchInfo) {
            SearchInfo info = (SearchInfo)searchInfo;
            queryBuilder = QueryBuilders.matchPhraseQuery((String)info.getField().getEsName(), (Object)info.getKeyword());
        } else {
            LOG.debug("Type not support");
        }
        return queryBuilder;
    }

    private QueryBuilder getCustomFieldQueryBuilder(Object searchInfo) {
        CusomFieldSearchInfo info = (CusomFieldSearchInfo)searchInfo;
        MatchPhraseQueryBuilder queryBuilder = null;
        String customFieldGuid = info.getCustomFieldGuid();
        Customfield custom = (Customfield)this.customFieldDao.findOne((Serializable)((Object)customFieldGuid));
        if (custom == null || custom.getCustomfieldcategory() != CustomFieldCategory.CONTACT) {
            throw new RequestArgumentNotValidException(String.format("Provided customFieldGuid[%s] not found or wrong category type", customFieldGuid));
        }
        if (custom != null && CustomFieldCategory.CONTACT.equals((Object)custom.getCustomfieldcategory())) {
            CustomFieldContactAttribute contactAttribute = custom.getCustomfieldcontactattribute();
            String keyword = info.getKeyword();
            List picklistContentGuids = info.getPicklistContentGuids();
            NumberInterval numberInterval = info.getNumberInterval();
            TimeInterval timeInterval = info.getTimeInterval();
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$CustomFieldContactAttribute[contactAttribute.ordinal()]) {
                case 1: 
                case 2: {
                    if (timeInterval != null && StringUtils.isEmpty((CharSequence)keyword) && numberInterval == null && CollectionUtil.collectionEmpty((Collection)picklistContentGuids)) {
                        this.verifyBeingEndCorrectness(timeInterval.getBeginTimeMills(), timeInterval.getEndTimeMills());
                        queryBuilder = QueryBuilders.rangeQuery((String)customFieldGuid).gte((Object)timeInterval.getBeginTimeMills()).lte((Object)timeInterval.getEndTimeMills());
                        break;
                    }
                    throw new RequestArgumentNotValidException(String.format("CustomFieldGuid[%s] only accept [timeInterval] property and can't be null", customFieldGuid));
                }
                case 3: 
                case 4: {
                    if (numberInterval != null && StringUtils.isEmpty((CharSequence)keyword) && timeInterval == null && CollectionUtil.collectionEmpty((Collection)picklistContentGuids)) {
                        this.verifyBeginEndCorrectness(numberInterval.getBeginNumber(), numberInterval.getEndNumber());
                        queryBuilder = QueryBuilders.rangeQuery((String)customFieldGuid).gte((Object)numberInterval.getBeginNumber()).lte((Object)numberInterval.getEndNumber());
                        break;
                    }
                    throw new RequestArgumentNotValidException(String.format("CustomFieldGuid[%s] only accept [numberInterval] property and can't be null", customFieldGuid));
                }
                case 5: {
                    if (!CollectionUtil.collectionEmpty((Collection)picklistContentGuids) && StringUtils.isEmpty((CharSequence)keyword) && timeInterval == null && numberInterval == null) {
                        customFieldGuid = customFieldGuid + "." + "keywordfield";
                        queryBuilder = QueryBuilders.termsQuery((String)customFieldGuid, (Collection)picklistContentGuids);
                        break;
                    }
                    throw new RequestArgumentNotValidException(String.format("CustomFieldGuid[%s] only accept [picklistContentGuids] property and can't be null", customFieldGuid));
                }
                case 6: 
                case 7: 
                case 8: {
                    if (keyword != null && numberInterval == null && timeInterval == null && CollectionUtil.collectionEmpty((Collection)picklistContentGuids)) {
                        queryBuilder = QueryBuilders.matchPhraseQuery((String)customFieldGuid, (Object)keyword);
                        break;
                    }
                    throw new RequestArgumentNotValidException(String.format("CustomFieldGuid[%s] only accept [keyword] property and can't be null", customFieldGuid));
                }
            }
        }
        return queryBuilder;
    }

    private BoolQueryBuilder combineQuery(BoolQueryBuilder contactVisibilityQuery, List<QueryBuilder> conditionQuerys) {
        int numberOfQuery = 0;
        BoolQueryBuilder allQuery = new BoolQueryBuilder();
        allQuery.should((QueryBuilder)JoinQueryBuilders.hasChildQuery((String)"contactvisibility", (QueryBuilder)contactVisibilityQuery, (ScoreMode)ScoreMode.None));
        ++numberOfQuery;
        for (QueryBuilder queryBuilder : conditionQuerys) {
            if (queryBuilder == null) continue;
            allQuery.should(queryBuilder);
            ++numberOfQuery;
        }
        allQuery.minimumShouldMatch(numberOfQuery);
        return allQuery;
    }

    private void verifyLogicExistence(int listIndex, LogicWithPreviousAllResults logic) {
        if (listIndex != 0 && logic == null) {
            throw new RequestArgumentNotValidException("Must provide [LogicWithPreviousAllResults] except for the first searhInfo");
        }
    }

    private String getKeyWordByUnicodeType(String keyword, UnicodeFontType unicodeFontType) {
        try {
            char[] chars = keyword.toCharArray();
            StringBuilder sb = new StringBuilder();
            for (char c : chars) {
                if (UnicodeFontType.BIG5.equals((Object)unicodeFontType)) {
                    sb.append(HanLP.convertToTraditionalChinese((String)String.valueOf(c)));
                    continue;
                }
                sb.append(HanLP.convertToSimplifiedChinese((String)String.valueOf(c)));
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return keyword;
        }
    }

    public List<String> getContactAutocompleteList(AccountInfo user, String keyword, ContactRangeType contactRangeType) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.searchEngineIndex});
        QueryBuilder queryBuilder = this.createQueryForNormal(AUTOCOMPLETE_FIELD, keyword, user.getGuid(), contactRangeType, this.isAdmin(user));
        searchRequest.source().query(queryBuilder).fetchSource(false).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"autocomplete").field("autocompleteField.keywordfield")).includeExclude(new IncludeExclude(this.getRegExpForAutocomplete(keyword), null)).size(10).executionHint("map"));
        ArrayList<String> result = new ArrayList<String>();
        try {
            SearchResponse response = this.client.search(searchRequest, new Header[0]);
            ParsedStringTerms stringTerms = (ParsedStringTerms)response.getAggregations().asMap().get("autocomplete");
            result.addAll(stringTerms.getBuckets().stream().map(bucket -> bucket.getKeyAsString()).collect(Collectors.toList()));
        }
        catch (ConnectException e) {
            throw new SearchEngineNotRunningException("Search engine is not running");
        }
        catch (ElasticsearchException e) {
            if (e.getMessage().contains(INDEX_NOT_FOUND_EXCEPTION)) {
                throw new SearchEngineIndexMissingException("Search engine indexing data is missing");
            }
            throw new SearchEngineRuntimeException(e.getMessage());
        }
        catch (SearchEngineRuntimeException | IOException e) {
            throw new SearchEngineRuntimeException(e.getMessage());
        }
        return result;
    }

    private String getRegExpForAutocomplete(String keyword) {
        char[] keywords;
        boolean keywordContainsChineseWord = GlobalUtils.stringContainsChineseWord((String)keyword);
        if (!keywordContainsChineseWord) {
            return keyword + ".*";
        }
        StringBuilder result = new StringBuilder();
        for (char word : keywords = keyword.toCharArray()) {
            String big5Keyword = this.getKeyWordByUnicodeType(word, UnicodeFontType.BIG5);
            String gbKeyword = this.getKeyWordByUnicodeType(word, UnicodeFontType.GB);
            result.append(String.format("[%s|%s]", big5Keyword, gbKeyword));
        }
        result.append(".*");
        LOG.debug(result.toString());
        return result.toString();
    }

    private String getKeyWordByUnicodeType(char word, UnicodeFontType unicodeFontType) {
        if (UnicodeFontType.BIG5.equals((Object)unicodeFontType)) {
            return HanLP.convertToTraditionalChinese((String)String.valueOf(word));
        }
        return HanLP.convertToSimplifiedChinese((String)String.valueOf(word));
    }

    public boolean isAdmin(AccountInfo user) {
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SHARE_RULE", user.getCompanyGuid());
        return ShareRule.ALL.equals((Object)ShareRule.valueOf((String)globalinfocompany.getConfigValue())) || UserRole.ADMIN.equals((Object)user.getRole());
    }

    public BoolQueryBuilder getContactVisibilityQuery(String userGuid, ContactRangeType contactRangeType, boolean isAdmin) {
        BoolQueryBuilder contactVisibilityQuery = new BoolQueryBuilder();
        if (ContactRangeType.PUBLIC.equals((Object)contactRangeType)) {
            if (isAdmin) {
                List allSameCompanyGuids = this.accountService.getAllAccountGuidsInTheSameCompany(userGuid);
                contactVisibilityQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)BE_SHARED_AND_OWNER_ACCOUNT_GUIDS, (Collection)allSameCompanyGuids));
            } else {
                List allSubordinateGuids = this.accountService.getAllSubordinateGuids(userGuid).stream().distinct().collect(Collectors.toList());
                LOG.debug("Account[{}] all subordinates:{}", (Object)userGuid, allSubordinateGuids);
                allSubordinateGuids.add(userGuid);
                contactVisibilityQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)BE_SHARED_AND_OWNER_ACCOUNT_GUIDS, allSubordinateGuids));
            }
        } else {
            String categoryTypeAllGuid = this.categoryDao.findGuidByOwnerGuidAndCategoryType(userGuid, CategoryType.ALL);
            LOG.debug("categoryTypeAllGuid:{}", (Object)categoryTypeAllGuid);
            contactVisibilityQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)BELONG_CATEGORIES, (String)categoryTypeAllGuid));
        }
        contactVisibilityQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"isDeleted", (boolean)false));
        return contactVisibilityQuery;
    }
}

