/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.common.base.Joiner;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.config.ApplicationConfig;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.CategoryDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactSimpleInfoDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.dto.mapper.DtoMapper;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.ContactField;
import com.penpower.worldcard.team.enums.DatabaseType;
import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.web.api.vo.GuidWithData;
import com.penpower.worldcard.team.web.api.vo.IntervalFilter;
import com.penpower.worldcard.team.web.api.vo.PageInfo;
import com.penpower.worldcard.team.web.api.vo.response.PageResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContactPublicServiceImpl
implements ContactPublicService {
    private final Logger LOG = LoggerFactory.getLogger(ContactPublicServiceImpl.class);
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private ContactSimpleInfoDao contactSimpleInfoDao;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    @Qualifier(value="accountInfoDtoMapper")
    private DtoMapper<Account, AccountInfo> accountInfoDtoMapper;
    @Autowired
    private ContactStatusForAccountDao contactStatusForAccountDao;

    private void shareContactToAccounts(Contact contact, List<Account> accounts, ListSetBehavior behavior, DateTime passedTime) {
        List<Account> accountsCanView;
        List<Account> finalAccountsCanView = accountsCanView = contact.getAccountsCanView();
        if (behavior.equals((Object)ListSetBehavior.ADD)) {
            accountsCanView.addAll(accounts);
        }
        if (behavior.equals((Object)ListSetBehavior.OVERWRITE)) {
            accountsCanView = accounts;
        }
        if (behavior.equals((Object)ListSetBehavior.REMOVE)) {
            List accountsRemove = accounts.stream().filter(a -> finalAccountsCanView.contains(a)).collect(Collectors.toList());
            accountsCanView.removeAll(accountsRemove);
        }
        if (behavior.equals((Object)ListSetBehavior.REMOVE_ALL)) {
            accountsCanView.clear();
        }
        List distinctAccounts = accountsCanView.stream().distinct().collect(Collectors.toList());
        contact.setAccountsCanView(distinctAccounts);
        List accountGuids = distinctAccounts.stream().map(a -> a.getGuid()).collect(Collectors.toList());
        String serialGuid = Joiner.on((String)",").skipNulls().join(accountGuids);
        contact.setAccountscanviewsha1(DigestUtils.sha1Hex((String)serialGuid));
        this.LOG.debug("[Ralph Debug modify time] share contact ,behavior: {}", (Object)behavior);
        if (passedTime == null) {
            DateTime time = new DateTime();
            this.LOG.debug("[Ralph Debug modify time] share contact no passed time({}),setModifyTime: {}", (Object)contact.getGuid(), (Object)time);
            contact.setModifyTime(time);
        } else {
            this.LOG.debug("[Ralph Debug modify time] share contact has passed time({}),setModifyTime: {}", (Object)contact.getGuid(), (Object)passedTime);
            contact.setModifyTime(passedTime);
        }
        contact.setModifytimeforsearch((double)new DateTime().getMillis());
        this.contactDao.save((Object)contact);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void shareContactToAccounts(String contactGuid, List<String> accountGuids, ListSetBehavior shareBehavior, DateTime passedTime) {
        ArrayList shareAccountGuids;
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("Contact not found.");
        }
        ArrayList<Object> arrayList = shareAccountGuids = CollectionUtils.isEmpty(accountGuids) ? new ArrayList() : new ArrayList<String>(accountGuids);
        if (!ListSetBehavior.REMOVE.equals((Object)shareBehavior) && !ListSetBehavior.REMOVE_ALL.equals((Object)shareBehavior)) {
            String contactOwnerGuid = contact.getOwnerAccount().getGuid();
            shareAccountGuids.remove(contactOwnerGuid);
        }
        List shareAccounts = CollectionUtils.isEmpty(shareAccountGuids) ? new ArrayList() : this.accountDao.findByGuidList(shareAccountGuids);
        this.shareContactToAccounts(contact, shareAccounts, shareBehavior, passedTime);
    }

    private List<String> getContactGuidsAllIcanView(String myAccountGuid) {
        HashSet<String> contactGuidSet = new HashSet<String>();
        List canViewAccountGuids = this.accountService.getAllSubordinateGuids(myAccountGuid);
        canViewAccountGuids.add(myAccountGuid);
        List<String> contactGuids = this.contactDao.findGuidCanViewByAccounts(canViewAccountGuids);
        contactGuidSet.addAll(contactGuids);
        contactGuids = this.contactDao.findGuidOwnedByAccounts(canViewAccountGuids);
        contactGuidSet.addAll(contactGuids);
        contactGuids = contactGuidSet.stream().collect(Collectors.toList());
        return contactGuids;
    }

    public PageResult<ContactSimpleInfoDto> getContactsAllIcanView(String myAccountGuid, PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter) {
        this.LOG.debug("getContactsAllIcanView myAccountGuid = {} ", (Object)myAccountGuid);
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        List canViewAccountGuids = this.accountService.getAllSubordinateGuids(myAccountGuid);
        canViewAccountGuids.add(myAccountGuid);
        this.LOG.debug("getContactsAllIcanView canViewAccountGuids = {} ", (Object)canViewAccountGuids);
        String orderByString = GlobalUtils.getSortString(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        String strStartTime = ApplicationConfig.DATE_TIME_FORMATTER.print((ReadableInstant)intervalFilter.getTimeStart());
        String strEndTime = ApplicationConfig.DATE_TIME_FORMATTER.print((ReadableInstant)intervalFilter.getTimeEnd());
        this.LOG.debug("orderByString:{}", (Object)orderByString);
        this.LOG.debug("strStartTime:{}", (Object)strStartTime);
        this.LOG.debug("strEndTime:{}", (Object)strEndTime);
        Globalinfo typeInfo = this.globalInfoService.getPropertiesByKey("DATABASE_TYPE");
        DatabaseType databaseType = DatabaseType.valueOf((String)typeInfo.getConfigValue());
        List allSimpleInfoGuids = new ArrayList();
        allSimpleInfoGuids = DatabaseType.MSSQL.equals((Object)databaseType) ? this.contactSimpleInfoDao.findGuidAllCanViewByAccounts_MSSQL(canViewAccountGuids, orderByString, strStartTime, strEndTime) : this.contactSimpleInfoDao.findGuidAllCanViewByAccounts(canViewAccountGuids, orderByString, strStartTime, strEndTime);
        this.LOG.debug("allSimpleInfoGuids:{}", allSimpleInfoGuids);
        return this.contactPrivateService.transListToContactSimpleInfoDtoPage(allSimpleInfoGuids, pageInfo.getNumberPerPage(), Integer.valueOf(pageInfo.getPageIndex()), nameDisplayOrderSettingType);
    }

    public PageResult<ContactSimpleInfoDto> getContactsSharedByAccount(String myAccountGuid, String shareAccountGuid, PageInfo<ContactField> pageInfo, IntervalFilter intervalFilter) {
        this.LOG.debug("getContactsSharedByAccount myAccountGuid = {} shareAccountGuid ={}", (Object)myAccountGuid, (Object)shareAccountGuid);
        NameDisplayOrderSettingType nameDisplayOrderSettingType = this.accountPrivateSettingService.getNameDisplayOrderSetting();
        Sort sort = GlobalUtils.getSortProperty(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        List canViewAccountGuids = this.accountService.getAllSubordinateGuids(myAccountGuid);
        canViewAccountGuids.add(myAccountGuid);
        List allSimpleInfoGuids = this.contactSimpleInfoDao.findGuidOwnedByXandCanViewByYs(shareAccountGuid, canViewAccountGuids, sort, intervalFilter.getTimeStart(), intervalFilter.getTimeEnd());
        return this.contactPrivateService.transListToContactSimpleInfoDtoPage(allSimpleInfoGuids, pageInfo.getNumberPerPage(), Integer.valueOf(pageInfo.getPageIndex()), nameDisplayOrderSettingType);
    }

    public Long countContactsAllIcanView(String myAccountGuid) {
        Account myAccount = this.accountDao.findOne(myAccountGuid);
        if (myAccount == null) {
            return 0L;
        }
        List contactGuids = this.getContactGuidsAllIcanView(myAccountGuid);
        return contactGuids.size();
    }

    public Map<AccountInfo, Long> getAccountsShareToAccounts(List<String> accountGuids, IntervalFilter intervalFilter) {
        Map<AccountInfo, Long> shareMap = new HashMap<AccountInfo, Long>();
        List contacts = this.contactDao.findCanViewByAccounts(accountGuids, intervalFilter.getTimeStart(), intervalFilter.getTimeEnd());
        if (CollectionUtils.isEmpty((Collection)contacts)) {
            return shareMap;
        }
        Map<String, Long> map = contacts.stream().distinct().collect(Collectors.groupingBy(c -> c.getOwnerGuid(), Collectors.counting()));
        shareMap = map.entrySet().stream().collect(Collectors.toMap(e -> this.accountService.getAccountInfo((String)e.getKey(), null), Map.Entry::getValue));
        shareMap.forEach((acc, count) -> System.out.println("account: " + acc.getEmail() + ", number: " + count));
        return shareMap;
    }

    private AccountInfo getDtoFromEntity(Account account) {
        if (account == null) {
            return null;
        }
        this.LOG.debug("ContactPublicServiceImpl getDtoFromEntity");
        return (AccountInfo)this.accountInfoDtoMapper.transformToDto((Object)account);
    }

    public List<String> getAccountGuidsSharedByContact(String contactGuid) {
        List accountGuidsShared = this.accountDao.findGuidByCanViewContact(contactGuid);
        return accountGuidsShared;
    }

    public List<AccountInfo> getAccountsSharedByContact(String contactGuid) {
        List<Object> accountInfosShared = new ArrayList<AccountInfo>();
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            return accountInfosShared;
        }
        List accountsShared = contact.getAccountsCanView();
        if (CollectionUtils.isEmpty((Collection)accountsShared)) {
            return accountInfosShared;
        }
        accountInfosShared = accountsShared.stream().map(a -> this.getDtoFromEntity(a)).collect(Collectors.toList());
        return accountInfosShared;
    }

    public List<GuidWithData<Boolean>> getDownloadStatusOfContactsByAccount(String accountGuid, List<String> contactGuids) {
        ArrayList<GuidWithData<Boolean>> status = new ArrayList<GuidWithData<Boolean>>();
        if (CollectionUtils.isEmpty(contactGuids)) {
            return status;
        }
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return status;
        }
        for (String contactGuid : contactGuids) {
            boolean isDownloadedToPrivate;
            Long count = this.contactStatusForAccountDao.countByAccountAndContact(accountGuid, contactGuid);
            boolean bl = isDownloadedToPrivate = count > 0L;
            if (isDownloadedToPrivate) {
                status.add((GuidWithData<Boolean>)new GuidWithData(contactGuid, (Object)true));
                continue;
            }
            status.add((GuidWithData<Boolean>)new GuidWithData(contactGuid, (Object)false));
        }
        return status;
    }

    public List<String> getContactGuidsBeSharedByAccount(String accountGuid) {
        List contactGuids = this.contactDao.findGuidCanViewByAccount(accountGuid);
        return contactGuids;
    }

    public void markDownloadStatusOfContactsByAccount(List<ContactSimpleInfoDto> contactDtos, String accountGuid) {
        if (CollectionUtils.isEmpty(contactDtos)) {
            return;
        }
        List contactGuids = contactDtos.stream().map(d -> d.getContactGuid()).collect(Collectors.toList());
        List downloadStatuses = this.getDownloadStatusOfContactsByAccount(accountGuid, contactGuids);
        for (ContactSimpleInfoDto dto : contactDtos) {
            String guid = dto.getContactGuid();
            if (!downloadStatuses.stream().anyMatch(s -> s.getGuid().equals(guid) && (Boolean)s.getData() == true)) continue;
            dto.setIsdownloadedtoprivate(Boolean.valueOf(true));
        }
    }

    public List<String> getByContactGuid(String contactGuid) {
        List<String> categoryGuids = this.categoryDao.findByContactGuid(contactGuid).stream().filter(c -> !c.isDeleted()).map(c -> c.getGuid()).collect(Collectors.toList());
        return categoryGuids;
    }
}

