/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.CompanyDao;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.ShareRule;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CompanyServiceImpl
implements CompanyService {
    private static final Logger LOG = LoggerFactory.getLogger(CompanyServiceImpl.class);
    @Autowired
    private CompanyDao companyDao;
    @Autowired
    CompanyGlobalInfoService companyGlobalInfoService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Company createCompany(String guid, String companyName, String companyTel) {
        Globalinfocompany ipConstraintType;
        Company company = new Company();
        company.setName(companyName);
        company.setTelphone(companyTel);
        company.setGuid(guid);
        this.companyDao.save((Object)company);
        Globalinfocompany serverKey = this.companyGlobalInfoService.getPropertiesByKey("SERVER_ID", company);
        if (serverKey == null) {
            LOG.info("{} properites wasn't found , create new one...", (Object)"SERVER_ID");
            this.companyGlobalInfoService.createNewProperties("SERVER_ID", UUIDGenerator.getRandomUUID(), company);
        }
        if ((ipConstraintType = this.companyGlobalInfoService.getPropertiesByKey("IP_NEED_TO_CONSTRAINT", company)) == null) {
            this.companyGlobalInfoService.createNewProperties("IP_NEED_TO_CONSTRAINT", "false", company);
        }
        Globalinfocompany ipShareRule = this.companyGlobalInfoService.getPropertiesByKey("SHARE_RULE", company);
        if (ipConstraintType == null) {
            this.companyGlobalInfoService.createNewProperties("SHARE_RULE", ShareRule.BY_SETTING.toString(), company);
        }
        return company;
    }

    public Company findOne(String guid) {
        Company company = this.companyDao.findByguid(guid);
        return company;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void UpdateCompany(Company company) {
        this.companyDao.save((Object)company);
    }

    @Transactional
    public void ChangeGuid(String oldGuid, String newGuid) {
        Company company = (Company)this.companyDao.findOne((Serializable)((Object)oldGuid));
        if (company != null) {
            this.companyDao.delete((Object)company);
            this.companyDao.flush();
            company.setGuid(newGuid);
            this.companyDao.save((Object)company);
        }
    }

    public List<Company> FindAllCompany() {
        return this.companyDao.findAll();
    }

    public void DeleteCompany(String guid) {
        try {
            this.companyDao.delete((Serializable)((Object)guid));
            this.companyDao.flush();
        }
        catch (Exception e) {
            LOG.info("delete company exception={}", (Object)e.getMessage());
        }
    }

    public void DeleteCompany(Company company) {
        try {
            this.companyDao.delete((Object)company);
            this.companyDao.flush();
        }
        catch (Exception e) {
            LOG.info("delete company exception={}", (Object)e.getMessage());
        }
    }
}

