/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.GlobalinfoCompanyDao;
import com.penpower.worldcard.team.dto.ProxySettingInfo;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.impl.GlobalInfoServiceImpl;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CompanyGlobalInfoServiceImpl
implements CompanyGlobalInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalInfoServiceImpl.class);
    @Autowired
    private GlobalinfoCompanyDao globalinfoCompanyDao;

    public List<Globalinfocompany> getAllProperties(String companyGuid) {
        return this.globalinfoCompanyDao.findAllForCompany(companyGuid);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public Globalinfocompany createNewProperties(String key, long value, String companyGuid) {
        Globalinfocompany globalinfoCompany = this.globalinfoCompanyDao.findByConfigkey(key, companyGuid);
        if (globalinfoCompany == null) {
            LOG.info("create new properties : {} ", (Object)globalinfoCompany);
            globalinfoCompany = new Globalinfocompany();
            globalinfoCompany.setGuid(UUIDGenerator.getRandomUUID());
            globalinfoCompany.setConfigKey(key);
            globalinfoCompany.setCompanyGuid(companyGuid);
        }
        globalinfoCompany.setConfigValue(Long.toString(value));
        Globalinfocompany result = (Globalinfocompany)this.globalinfoCompanyDao.saveAndFlush((Object)globalinfoCompany);
        LOG.info("createNewProperties result {} ", (Object)result);
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public Globalinfocompany createNewProperties(String key, String value, String companyGuid) {
        Globalinfocompany globalinfoCompany = this.globalinfoCompanyDao.findByConfigkey(key, companyGuid);
        if (globalinfoCompany == null) {
            LOG.info("create new properties : {} ", (Object)globalinfoCompany);
            globalinfoCompany = new Globalinfocompany();
            globalinfoCompany.setGuid(UUIDGenerator.getRandomUUID());
            globalinfoCompany.setConfigKey(key);
            globalinfoCompany.setCompanyGuid(companyGuid);
        }
        globalinfoCompany.setConfigValue(value);
        Globalinfocompany result = (Globalinfocompany)this.globalinfoCompanyDao.saveAndFlush((Object)globalinfoCompany);
        LOG.info("createNewProperties result {} ", (Object)result);
        return result;
    }

    public String getPropertiesStringByKey(String key, String companyGuid) {
        LOG.debug("Find by ke : {} ", (Object)key);
        Globalinfocompany globalinfoCompany = this.globalinfoCompanyDao.findByConfigkey(key, companyGuid);
        LOG.debug("globalInfo : {} ", (Object)globalinfoCompany);
        if (globalinfoCompany != null) {
            return globalinfoCompany.getConfigValue();
        }
        return "";
    }

    public Globalinfocompany getPropertiesByKey(String key, String companyGuid) {
        Globalinfocompany globalinfoCompany = this.globalinfoCompanyDao.findByConfigkey(key, companyGuid);
        return globalinfoCompany;
    }

    public List<Globalinfocompany> getAllProperties(Company company) {
        return this.globalinfoCompanyDao.findAllForCompany(company.getGuid());
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public Globalinfocompany createNewProperties(String key, String value, Company company) {
        Globalinfocompany globalinfoCompany = this.globalinfoCompanyDao.findByConfigkey(key, company.getGuid());
        if (globalinfoCompany == null) {
            LOG.debug("create new properties : {} ", (Object)globalinfoCompany);
            globalinfoCompany = new Globalinfocompany();
            globalinfoCompany.setGuid(UUIDGenerator.getRandomUUID());
            globalinfoCompany.setConfigKey(key);
            globalinfoCompany.setCompanyGuid(company.getGuid());
        }
        globalinfoCompany.setConfigValue(value);
        Globalinfocompany result = (Globalinfocompany)this.globalinfoCompanyDao.saveAndFlush((Object)globalinfoCompany);
        return result;
    }

    public String getStringByKeyWithDefault(String key, String defaultString, String companyGuid) {
        Globalinfocompany globalinfocompany = this.getPropertiesByKey(key, companyGuid);
        if (globalinfocompany != null) {
            if (StringUtil.IsStringNullorEmpty((String)globalinfocompany.getConfigValue())) {
                this.updatePropertyValue(globalinfocompany.getGuid(), defaultString);
                return defaultString;
            }
            return globalinfocompany.getConfigValue();
        }
        this.createNewProperties(key, defaultString, companyGuid);
        return defaultString;
    }

    public int getValueByKeyWithDefault(String key, int defaultValue, String companyGuid) {
        Globalinfocompany globalinfocompany = this.getPropertiesByKey(key, companyGuid);
        if (globalinfocompany != null) {
            if (StringUtil.IsStringNullorEmpty((String)globalinfocompany.getConfigValue())) {
                this.updatePropertyValue(globalinfocompany.getGuid(), Integer.toString(defaultValue));
                return defaultValue;
            }
            return Integer.valueOf(globalinfocompany.getConfigValue());
        }
        this.createNewProperties(key, Integer.toString(defaultValue), companyGuid);
        return defaultValue;
    }

    public String getPropertiesStringByKey(String key, Company company) {
        LOG.debug("Find by ke : {} ", (Object)key);
        Globalinfocompany globalinfoCompany = this.globalinfoCompanyDao.findByConfigkey(key, company.getGuid());
        LOG.debug("globalInfo : {} ", (Object)globalinfoCompany);
        if (globalinfoCompany != null) {
            return globalinfoCompany.getConfigValue();
        }
        return "";
    }

    public Globalinfocompany getPropertiesByKey(String key, Company company) {
        Globalinfocompany globalinfoCompany = this.globalinfoCompanyDao.findByConfigkey(key, company.getGuid());
        return globalinfoCompany;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updatePropertyValue(String id, String value) {
        Globalinfocompany globalinfoCompany = (Globalinfocompany)this.globalinfoCompanyDao.findOne((Serializable)((Object)id));
        globalinfoCompany.setConfigValue(value);
        this.globalinfoCompanyDao.save((Object)globalinfoCompany);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void deleteProperty(String guid) {
        this.globalinfoCompanyDao.delete((Serializable)((Object)guid));
    }

    public OkHttpClient getOKHttpClientWithProxy(String companyGuid) {
        Globalinfocompany proxySettingInfo = this.getPropertiesByKey("PROXY_SETTING", companyGuid);
        LOG.debug("proxySettingInfo={}", (Object)proxySettingInfo);
        if (proxySettingInfo == null) {
            return new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        }
        ProxySettingInfo proxySetting = (ProxySettingInfo)new Gson().fromJson(proxySettingInfo.getConfigValue(), ProxySettingInfo.class);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySetting.getHost(), proxySetting.getPort()));
        OkHttpClient client = new OkHttpClient.Builder().proxy(proxy).build();
        return client;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public Globalinfocompany getPropertiesByServiceId(String serviceId) {
        Globalinfocompany globalinfoCompany = this.globalinfoCompanyDao.findByConfigkeyAndConfigvalue("SUBSCRIBE_SERVICEID", serviceId);
        return globalinfoCompany;
    }
}

