/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.CategoryDao;
import com.penpower.worldcard.team.dto.CategoryInfo;
import com.penpower.worldcard.team.dto.CategoryOrderInfo;
import com.penpower.worldcard.team.dto.CategoryOrderInfoEx;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Category;
import com.penpower.worldcard.team.enums.CategoryType;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RecordEqualException;
import com.penpower.worldcard.team.exception.RecordUpdateException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.SpecifiedGuidConflictException;
import com.penpower.worldcard.team.service.CategoryService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CategoryServiceImpl
implements CategoryService {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryServiceImpl.class);
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private AccountDao accountDao;

    public List<CategoryInfo> getCategories(String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        List<Object> categoryInfos = new ArrayList<CategoryInfo>();
        List categories = account.getCategories();
        if (CollectionUtils.isEmpty((Collection)categories)) {
            return categoryInfos;
        }
        categories.sort((o1, o2) -> o1.getDisplayOrder() - o2.getDisplayOrder());
        categoryInfos = categories.stream().filter(cate -> !cate.isDeleted()).map(cate -> new CategoryInfo(cate)).collect(Collectors.toList());
        return categoryInfos;
    }

    public CategoryOrderInfo getCategoriesOrder(String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        CategoryOrderInfo categoryOrderInfo = new CategoryOrderInfo();
        List categories = account.getCategories();
        if (CollectionUtils.isEmpty((Collection)categories)) {
            return categoryOrderInfo;
        }
        categories.sort((o1, o2) -> o1.getDisplayOrder() - o2.getDisplayOrder());
        categoryOrderInfo.setOrderedCategoryGuids(categories.stream().filter(cate -> !cate.isDeleted()).map(cate -> new String(cate.getGuid())).collect(Collectors.toList()));
        categoryOrderInfo.setCategoryOrderModifyTime(account.getCategoryOrderUpdateTime());
        return categoryOrderInfo;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void undeleteCategory(String categoryGuid) {
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        if (category != null && category.isDeleted()) {
            category.setDeleted(false);
            category.setUpdateTime(new DateTime());
            this.categoryDao.save((Object)category);
            Account owner = category.getOwneraccount();
            DateTime curTime = new DateTime();
            owner.setCategoryOrderUpdateTime(curTime);
            LOG.debug("[CategoryOrderIssue](undeleteCategory) setCategoryOrderUpdateTime(): {}", (Object)curTime);
            this.accountDao.save((Object)owner);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteCategory_Fail(String categoryGuid) {
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        if (category == null) {
            throw new ItemNotFoundException("Category not found.");
        }
        category.setDeleted(false);
        this.categoryDao.save((Object)category);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteCategory_Begin(String categoryGuid) {
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        if (category == null) {
            throw new ItemNotFoundException("Category not found.");
        }
        category.setDeleted(true);
        this.categoryDao.save((Object)category);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public CategoryInfo deleteCategory_End(String categoryGuid, String categoryOwnerGuid, boolean bySync) {
        Account categoryOwner = this.accountDao.findOne(categoryOwnerGuid);
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        if (category == null || categoryOwner == null) {
            throw new ItemNotFoundException("Category or Category owner not found.");
        }
        DateTime curTime = new DateTime();
        category.setUpdateTime(curTime);
        if (!bySync) {
            categoryOwner.setCategoryOrderUpdateTime(curTime);
            LOG.debug("[CategoryOrderIssue](deleteCategory_End) setCategoryOrderUpdateTime(): {}", (Object)curTime);
        }
        this.categoryDao.save((Object)category);
        this.accountDao.save((Object)categoryOwner);
        return new CategoryInfo(category);
    }

    public Category getDefaultCategoryByAccountAndType(Account account, CategoryType type) {
        Category category = this.categoryDao.findFirstByOwneraccountAndCategorytype(account, type);
        return category;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public CategoryInfo createCategory(String categoryName, String ownerAccountGuid, String clientCreatedCategoryGuid, boolean bySync) {
        return this.createCategoryBySecretary(categoryName, ownerAccountGuid, clientCreatedCategoryGuid, null, bySync);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public CategoryInfo createCategoryBySecretary(String categoryName, String ownerAccountGuid, String clientCreatedCategoryGuid, String secretaryAccountGuid, boolean bySync) {
        String categoryGuid = clientCreatedCategoryGuid;
        if (!StringUtils.isBlank((CharSequence)categoryGuid)) {
            if (this.categoryDao.findOne((Serializable)((Object)categoryGuid)) != null) {
                throw new SpecifiedGuidConflictException("Specified category guid has been used.");
            }
        } else {
            categoryGuid = UUIDGenerator.getRandomUUID();
        }
        Account owner = this.accountDao.findOne(ownerAccountGuid);
        Category category = new Category();
        category.setGuid(categoryGuid);
        category.setName(categoryName);
        category.setOwneraccount(owner);
        if (secretaryAccountGuid != null) {
            category.setSecretaryaccountguid(secretaryAccountGuid);
        }
        category.setCategoryType(CategoryType.NORMAL);
        DateTime curTime = new DateTime();
        category.setUpdateTime(curTime);
        Category topCategory = this.categoryDao.findTopByOwneraccountOrderByDisplayorderDesc(owner);
        int maxDisplayOrder = topCategory == null ? 0 : topCategory.getDisplayOrder() + 1;
        category.setDisplayOrder(maxDisplayOrder);
        this.categoryDao.save((Object)category);
        if (!bySync) {
            owner.setCategoryOrderUpdateTime(curTime);
            LOG.debug("[CategoryOrderIssue](createCategoryBySecretary) setCategoryOrderUpdateTime(): {}", (Object)curTime);
        }
        this.accountDao.save((Object)owner);
        return new CategoryInfo(category);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DateTime setCategoryOrder(String ownerAccountGuid, CategoryOrderInfoEx categoryOrderInfoEx) {
        Account account = this.accountDao.findOne(ownerAccountGuid);
        if (account == null) {
            throw new ItemNotFoundException("Account is not found");
        }
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) categoryOrderInfoEx.getIsForceUpdate(): {}", (Object)categoryOrderInfoEx.getIsForceUpdate());
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) account.getCategoryOrderUpdateTime(): {}", (Object)account.getCategoryOrderUpdateTime());
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) categoryOrderInfoEx.getCategoryOrderModifyTime(): {}", (Object)categoryOrderInfoEx.getCategoryOrderModifyTime());
        if (!categoryOrderInfoEx.getIsForceUpdate()) {
            if (account.getCategoryOrderUpdateTime().isAfter((ReadableInstant)categoryOrderInfoEx.getCategoryOrderModifyTime())) {
                LOG.debug("[CategoryOrderIssue](setCategoryOrder) throw new RecordUpdateException()");
                throw new RecordUpdateException("categoryOrder in server  is newer than client ");
            }
            if (account.getCategoryOrderUpdateTime().isEqual((ReadableInstant)categoryOrderInfoEx.getCategoryOrderModifyTime())) {
                LOG.debug("[CategoryOrderIssue](setCategoryOrder) throw new RecordEqualException()");
                throw new RecordEqualException("categoryOrder in server  is equsl  to client ");
            }
        }
        List categories = account.getCategories().stream().filter(c -> !CategoryType.FAVORITE.equals((Object)c.getCategoryType())).collect(Collectors.toList());
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) account categories: {}", categories.stream().map(c -> c.getGuid()).collect(Collectors.toList()));
        List filteredOrderCategoryGuids = categoryOrderInfoEx.getOrderedCategoryGuids().stream().distinct().filter(g -> categories.stream().anyMatch(c -> c.getGuid().equals(g))).collect(Collectors.toList());
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) filteredOrderCategoryGuids: {}", filteredOrderCategoryGuids);
        int assignedListStartIndex = 1;
        int unassignedListStartIndex = filteredOrderCategoryGuids.size() + 1;
        for (Category category : categories) {
            int position = filteredOrderCategoryGuids.indexOf(category.getGuid());
            if (position >= 0) {
                category.setDisplayOrder(assignedListStartIndex + position);
                continue;
            }
            category.setDisplayOrder(unassignedListStartIndex);
            ++unassignedListStartIndex;
        }
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) saved categories: {}", categories);
        this.categoryDao.save(categories);
        DateTime curTime = new DateTime();
        account.setCategoryOrderUpdateTime(curTime);
        this.accountDao.save((Object)account);
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) setCategoryOrderUpdateTime(): {}", (Object)curTime);
        LOG.debug("[CategoryOrderIssue](setCategoryOrder) account.getCategoryOrderUpdateTime():{}", (Object)account.getCategoryOrderUpdateTime());
        return account.getCategoryOrderUpdateTime();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void createDefaultCategoriesOfAccount(Account account) {
        DateTime curTime = new DateTime();
        this.createDefaultCategoryOfAccountByType(account, CategoryType.FAVORITE, 0, curTime);
        this.createDefaultCategoryOfAccountByType(account, CategoryType.ALL, 1, curTime);
        this.createDefaultCategoryOfAccountByType(account, CategoryType.OTHER, 2, curTime);
        account.setCategoryOrderUpdateTime(curTime);
        LOG.debug("[CategoryOrderIssue](createDefaultCategoriesOfAccount) setCategoryOrderUpdateTime(): {}", (Object)curTime);
        this.accountDao.save((Object)account);
    }

    private void createDefaultCategoryOfAccountByType(Account account, CategoryType type, int displayOrder, DateTime curTime) {
        Category category = new Category();
        category.setOwneraccount(account);
        category.setCategoryType(type);
        category.setDisplayOrder(displayOrder);
        category.setGuid(UUIDGenerator.getRandomUUID());
        category.setUpdateTime(curTime);
        this.categoryDao.save((Object)category);
    }

    public void verifyCategoryGuids(List<String> categoryGuids) {
        this.verifyAndGetDistinctCategoriesByGuids(categoryGuids);
    }

    public void verifyCategoryGuidsOfAccountAreNormal(List<String> categoryGuids, String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("Specified account is not found.");
        }
        List categories = this.verifyAndGetDistinctCategoriesByGuids(categoryGuids);
        List filteredCategories = categories.stream().filter(cate -> !cate.getCategoryType().equals((Object)CategoryType.NORMAL) || !cate.getOwneraccount().equals((Object)account)).collect(Collectors.toList());
        if (!filteredCategories.isEmpty()) {
            throw new RequestArgumentNotValidException("Some specified categories are not NORMAL type, or not belonging to specified/login account.");
        }
    }

    public void verifyCategoryGuidsOfAccount(List<String> categoryGuids, String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("Specified account is not found.");
        }
        List categories = this.verifyAndGetDistinctCategoriesByGuids(categoryGuids);
        boolean ownerIncorrect = categories.stream().anyMatch(cate -> !cate.getOwneraccount().equals((Object)account));
        if (ownerIncorrect) {
            throw new RequestArgumentNotValidException("Some specified categories are not belonging to specified/login account.");
        }
    }

    private List<Category> verifyAndGetDistinctCategoriesByGuids(List<String> categoryGuids) {
        if (categoryGuids == null) {
            throw new ItemNotFoundException("Input category GUIDs is null.");
        }
        if (categoryGuids.isEmpty()) {
            return new ArrayList<Category>();
        }
        List distinctCategoryGuids = categoryGuids.stream().distinct().collect(Collectors.toList());
        List categories = this.categoryDao.findByGuidList(distinctCategoryGuids);
        if (categories.size() != distinctCategoryGuids.size()) {
            throw new ItemNotFoundException("Some category guids can not be found.");
        }
        return categories;
    }

    public List<Category> getModifyCategoriesByAccountIncludeDeleted(String accountGuid, DateTime lastUpdateTime, boolean IsFirstTimeSync) {
        if (IsFirstTimeSync) {
            Account account = this.accountDao.findOne(accountGuid);
            ArrayList<Category> Newcategorys = new ArrayList();
            List categories = account.getCategories();
            if (categories == null) {
                return new ArrayList<Category>();
            }
            LOG.debug("getModifyCategoriesByAccountIncludeDeleted firsttime categories {}", (Object)categories);
            Newcategorys = categories.stream().filter(cate -> !cate.isDeleted()).sorted((p1, p2) -> p1.getUpdateTime().compareTo((ReadableInstant)p2.getUpdateTime())).collect(Collectors.toList());
            LOG.debug("getModifyCategoriesByAccountIncludeDeleted firsttime categories {}", Newcategorys);
            return Newcategorys;
        }
        LOG.debug("getModifyCategoriesByAccountIncludeDeleted not firsttime guid= {},updatetime={}", (Object)accountGuid, (Object)lastUpdateTime);
        Account account = this.accountDao.findOne(accountGuid);
        LOG.debug("getModifyCategoriesByAccountIncludeDeleted not firsttime account{} ", (Object)account);
        ArrayList<Category> Newcategorys = new ArrayList();
        List categories = account.getCategories();
        LOG.debug("getModifyCategoriesByAccountIncludeDeleted not firsttime categories {}", (Object)categories);
        if (categories == null) {
            return new ArrayList<Category>();
        }
        Newcategorys = categories.stream().filter(category -> category.getUpdateTime().isAfter((ReadableInstant)lastUpdateTime)).sorted((p1, p2) -> p1.getUpdateTime().compareTo((ReadableInstant)p2.getUpdateTime())).collect(Collectors.toList());
        LOG.debug("getModifyCategoriesByAccountIncludeDeleted not firsttime categories {}", Newcategorys);
        return Newcategorys;
    }

    public void verifyModifyTime(String categoryGuid, DateTime clientCategoryModifyTime) {
        Category category = (Category)this.categoryDao.findOne((Serializable)((Object)categoryGuid));
        if (category == null) {
            throw new ItemNotFoundException("category not found.");
        }
        if (category.getUpdateTime().isAfter((ReadableInstant)clientCategoryModifyTime)) {
            throw new RecordUpdateException("Category is newer thad client" + categoryGuid);
        }
    }

    public CategoryInfo getCategoryGuidSomeoneCreateForMe(String accountGuid, String someoneAccountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            return null;
        }
        Category category = this.categoryDao.findFirstByOwneraccountAndSecretaryaccountguid(account, someoneAccountGuid);
        if (category == null) {
            return null;
        }
        return new CategoryInfo(category);
    }

    public List<String> filterOutCategoryGuidsExist(List<String> categoryGuids) {
        List distinctCategoryGuids = categoryGuids.stream().distinct().collect(Collectors.toList());
        List<String> retCategoryGuids = this.categoryDao.findByGuidList(distinctCategoryGuids).stream().map(c -> c.getGuid()).collect(Collectors.toList());
        return retCategoryGuids;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void removeAllNormalCategoriesOfAccount(String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("[removeAllNormalCategoriesOfAccount]Account is not found.");
        }
        List normalCategories = this.categoryDao.findByOwneraccount(account).stream().filter(c -> CategoryType.NORMAL.equals((Object)c.getCategoryType())).collect(Collectors.toList());
        this.categoryDao.delete(normalCategories);
    }

    public List<String> verifyAndGetNewCategoryGuidsOfAccount(List<String> categoryGuids, String accountGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("Specified account is not found.");
        }
        if (categoryGuids == null) {
            throw new ItemNotFoundException("Input category GUIDs is null.");
        }
        List<Object> categories = new ArrayList();
        if (!categoryGuids.isEmpty()) {
            List distinctCategoryGuids = categoryGuids.stream().distinct().collect(Collectors.toList());
            categories = this.categoryDao.findByGuidList(distinctCategoryGuids);
            if (categories.size() == 0) {
                categories = this.categoryDao.findByOwneraccount(account).stream().filter(cate -> cate.getCategoryType().equals((Object)CategoryType.OTHER)).collect(Collectors.toList());
            } else {
                List filteredCategories = categories.stream().filter(cate -> cate.getOwneraccount().equals((Object)account)).collect(Collectors.toList());
                if (filteredCategories.isEmpty()) {
                    throw new RequestArgumentNotValidException("Some categories not belonging to specified/login account.");
                }
            }
        }
        List<String> newCategoryGuids = categories.stream().map(cate -> cate.getGuid()).collect(Collectors.toList());
        LOG.debug("newCategoryGuids:{}", newCategoryGuids);
        return newCategoryGuids;
    }
}

