/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.AesUtil;
import com.penpower.worldcard.team.Utils.JodaDateTimeAdapter;
import com.penpower.worldcard.team.Utils.LocalDateAdapter;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.contactsystem.ContactServerBasicToken;
import com.penpower.worldcard.team.contactsystem.ContactServerLastExportInfo;
import com.penpower.worldcard.team.contactsystem.exchange.vo.ExchangeAuthInfo;
import com.penpower.worldcard.team.contactsystem.office365.vo.Office365AuthInfo;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.QContactzAuthInfoSettings;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.salesforce.SalesForceOAuthTokenType;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.AccountPrivateSettingDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountPrivateSettingDto;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.ContactServerSettingsDto;
import com.penpower.worldcard.team.dto.ContactServerSettingsDtoFull;
import com.penpower.worldcard.team.dto.ContactServerSettingsWithTokenDto;
import com.penpower.worldcard.team.entity.AccountPrivateSetting;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.CRMCompanyAssignmentOption;
import com.penpower.worldcard.team.enums.CRMExportMode;
import com.penpower.worldcard.team.enums.ContactServerExportMode;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.IdentificationResult;
import com.penpower.worldcard.team.enums.MapEngine;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.enums.NameOrder;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.ShareItem;
import com.penpower.worldcard.team.enums.ShareRule;
import com.penpower.worldcard.team.enums.SortingOrder;
import com.penpower.worldcard.team.enums.SupportCRM;
import com.penpower.worldcard.team.enums.SupportContactServer;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.AccountShareTargetService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.ContactServerAuthService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.service.impl.AccountPrivateSettingServiceImpl;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AccountPrivateSettingServiceImpl
implements AccountPrivateSettingService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountPrivateSettingServiceImpl.class);
    @Autowired
    private AccountPrivateSettingDao accountPrivateSettingDao;
    @Autowired
    private AccountShareTargetService accountShareTargetService;
    @Autowired
    private SystemSettingService systemSettingService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ContactServerAuthService contactServerAuthService;
    private Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JodaDateTimeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserMapEngineSetting(String userGuid, MapEngine mapEngine) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setMapEngine(mapEngine);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public NameOrder getUserWesternSurnameOrder(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getPrivateSetting(userGuid);
        NameOrder nameOrder = accountPrivateSetting.getWesternSurnameOrder();
        return nameOrder;
    }

    private AccountPrivateSetting getPrivateSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.accountPrivateSettingDao.findByAccountGuid(userGuid);
        return accountPrivateSetting;
    }

    public NameOrder getUserAsianSurnameOrder(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getPrivateSetting(userGuid);
        NameOrder nameOrder = accountPrivateSetting.getAsianSurnameOrder();
        return nameOrder;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserWesternSurnameOrder(String userGuid, NameOrder nameOrder) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setWesternSurnameOrder(nameOrder);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserAsianSurnameOrder(String userGuid, NameOrder nameOrder) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setAsianSurnameOrder(nameOrder);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public AccountPrivateSetting getAccountPrivateSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.accountPrivateSettingDao.findByAccountGuid(userGuid);
        return accountPrivateSetting;
    }

    public boolean getShowOwner(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getPrivateSetting(userGuid);
        return accountPrivateSetting.getShowOwnerInfo();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserShowOwner(String userGuid, boolean enable) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setShowOwnerInfo(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public MapEngine getUserMapEngineSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        MapEngine mapEngine = accountPrivateSetting.getMapEngine();
        return mapEngine;
    }

    public boolean getAutoShareSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        boolean autoShareToAll = accountPrivateSetting.isAutoShare();
        return autoShareToAll;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setAutoShareSetting(String userGuid, boolean enable) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setAutoShare(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setEditAfterRecogSetting(String userGuid, boolean enable) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setEditAfterRecog(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setAddNoteAfterRecogSetting(String userGuid, boolean enable) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setAddnoteinfoAfterRecog(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public boolean getShareContactSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        boolean autoShareToAll = accountPrivateSetting.getShareContact();
        return autoShareToAll;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setShareContactSetting(String userGuid, boolean enable) throws ItemNotFoundException, RequestArgumentNotValidException {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setShareContact(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public boolean getShareActivitySetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        boolean autoShareToAll = accountPrivateSetting.getShareActivity();
        return autoShareToAll;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setShareActivitySetting(String userGuid, boolean enable) throws ItemNotFoundException, RequestArgumentNotValidException {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setShareActivity(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public boolean getShareTaskSetting(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        boolean autoShareToAll = accountPrivateSetting.getShareTask();
        return autoShareToAll;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setShareTaskSetting(String userGuid, boolean enable) throws ItemNotFoundException, RequestArgumentNotValidException {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setShareTask(enable);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public DateTime getLastNoticeCountView(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        DateTime lastNoticeCountView = Optional.ofNullable(accountPrivateSetting.getLastNoticeCountView()).orElse(new DateTime());
        return lastNoticeCountView;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setLastNoticeCountView(String userGuid, DateTime dateTime) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setLastNoticeCountView(dateTime);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public SortingOrder getSortingOrder(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        SortingOrder sortingOrder = accountPrivateSetting.getSortingOrder();
        return sortingOrder;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setSortingOrder(String userGuid, SortingOrder sortingOrder) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setSortingOrder(sortingOrder);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setIdentificationResult(String userGuid, IdentificationResult identificationResult) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setIdentificationResult(identificationResult);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateOffice365AuthInfo(String userGuid, ContactServerSettingsWithTokenDto settingsWithTokenDto) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        String authInfo = this.gson.toJson((Object)new Office365AuthInfo(settingsWithTokenDto.getAccount(), settingsWithTokenDto.getBasicToken().getAccess_token(), settingsWithTokenDto.getBasicToken().getRefresh_token(), settingsWithTokenDto.getLastUpdateTokenTime(), settingsWithTokenDto.getSettingPlatform()));
        String authInfoEncoded = new String(new AesUtil().encodeBase64(authInfo));
        accountPrivateSetting.setOffice365authinfo(authInfoEncoded);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public IdentificationResult getIdentificationResult(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        IdentificationResult identificationResult = accountPrivateSetting.getIdentificationResult();
        return identificationResult;
    }

    public AccountPrivateSettingDto getAllUserSettings(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        AccountPrivateSettingDto dto = new AccountPrivateSettingDto();
        dto.setAsianSurnameOrder(accountPrivateSetting.getAsianSurnameOrder());
        dto.setWesternSurnameOrder(accountPrivateSetting.getWesternSurnameOrder());
        dto.setIdentificationResult(accountPrivateSetting.getIdentificationResult());
        dto.setSortingOrder(accountPrivateSetting.getSortingOrder());
        dto.setMapEngine(accountPrivateSetting.getMapEngine());
        dto.setAutoShare(accountPrivateSetting.isAutoShare());
        dto.setModifytime(accountPrivateSetting.getModifytime());
        dto.setEditAfterRecog(accountPrivateSetting.isEditAfterRecog());
        dto.setAddnoteinfoAfterRecog(accountPrivateSetting.isAddnoteinfoAfterRecog());
        AccountInfo accountInfo = this.accountService.getAccountInfo(userGuid, null);
        ShareRule shareRule = this.systemSettingService.getShareRule(accountInfo);
        dto.setGlobalShareRule(shareRule);
        List contactShareTargets = this.accountShareTargetService.getShareTargetsByShareItem(userGuid, ShareItem.CONTACT);
        dto.setContactShareTargets(contactShareTargets);
        List taskShareTargets = this.accountShareTargetService.getShareTargetsByShareItem(userGuid, ShareItem.TASK);
        dto.setTaskShareTargets(taskShareTargets);
        List activityShareTargets = this.accountShareTargetService.getShareTargetsByShareItem(userGuid, ShareItem.ACTIVITY);
        dto.setActivityShareTargets(activityShareTargets);
        dto.setUserCRMAccount(accountPrivateSetting.getUsercrmaccount());
        dto.setUserCRMExportMode(accountPrivateSetting.getCrmexportmode());
        dto.setUserCRMPassword("*");
        dto.setUserCRMSecretToken(accountPrivateSetting.getUsercrmsecrettoken());
        dto.setCrmCompanyAssignmentOption(this.getCRMCompanyAssignmentOptionForUser(accountPrivateSetting.getCrmexportmode(), accountPrivateSetting.getCrmcompanyassignmentoption()));
        try {
            ContactServerSettingsWithTokenDto contactServerSetting = this.getContactServerSettings(userGuid);
            dto.setUserContactServerAccount(contactServerSetting.getAccount());
            ContactServerExportMode contactServerExportMode = contactServerSetting.getContactServerExportMode() == null ? ContactServerExportMode.NONE : contactServerSetting.getContactServerExportMode();
            dto.setUserContactServerExportMode(contactServerExportMode);
        }
        catch (ItemNotFoundException e) {
            dto.setUserContactServerAccount(null);
            dto.setUserContactServerExportMode(ContactServerExportMode.NONE);
        }
        dto.setLastexporttime(accountPrivateSetting.getLastexporttime());
        dto.setLastexportcount(accountPrivateSetting.getLastexportcount());
        dto.setLastexportresult(accountPrivateSetting.getLastexportresult());
        return dto;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public String getContactServerLastExportInfo(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        return accountPrivateSetting.getContactserverlastexportinfo();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserCRMSettings(String userGuid, CRMSettingsDto CRMSettingsDto2) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        try {
            AccountInfo accountInfo = this.accountService.getAccountInfo(userGuid, null);
            SupportCRM currentSystemCRM = this.systemSettingService.getSystemCRM(accountInfo);
            accountPrivateSetting.setUserstoredcrmtype(currentSystemCRM);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        accountPrivateSetting.setCrmexportmode(CRMSettingsDto2.getUserCRMExportMode());
        accountPrivateSetting.setUsercrmaccount(CRMSettingsDto2.getUserCRMAccount());
        accountPrivateSetting.setUsercrmpassword(CRMSettingsDto2.getUserCRMPassword());
        accountPrivateSetting.setUsercrmsecrettoken(CRMSettingsDto2.getUserCRMSecretToken());
        accountPrivateSetting.setUsercrmtokentype(SalesForceOAuthTokenType.USERNAME_PASSWORD);
        accountPrivateSetting.setCrmcompanyassignmentoption(this.getCRMCompanyAssignmentOptionForUser(CRMSettingsDto2.getUserCRMExportMode(), CRMSettingsDto2.getCompanyAssignmentOption()));
        accountPrivateSetting.setModifytime(new DateTime());
        LOG.debug("set crm settings....");
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserContactServerSettings(String userGuid, ContactServerSettingsDto contactServerSettingsDto, String serverUrl) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        SupportContactServer currentSystemContactServer = null;
        try {
            AccountInfo accountInfo = this.accountService.getAccountInfo(userGuid, null);
            currentSystemContactServer = this.systemSettingService.getSystemContactServer(accountInfo);
            accountPrivateSetting.setContactservertype(currentSystemContactServer);
        }
        catch (ItemNotFoundException accountInfo) {
            // empty catch block
        }
        accountPrivateSetting.setContactserverexportmode(contactServerSettingsDto.getContactServerExportMode());
        accountPrivateSetting.setModifytime(new DateTime());
        String authInfo = null;
        String authInfoEncoded = null;
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$SupportContactServer[currentSystemContactServer.ordinal()]) {
            case 1: {
                String uniqueExchangeAccountId = this.contactServerAuthService.testConnectionAndGetExchangeUniqueId(new ContactServerSettingsDtoFull(contactServerSettingsDto, serverUrl));
                authInfo = this.gson.toJson((Object)new ExchangeAuthInfo(contactServerSettingsDto.getAccount(), contactServerSettingsDto.getPassword(), uniqueExchangeAccountId));
                authInfoEncoded = new String(new AesUtil().encodeBase64(authInfo));
                accountPrivateSetting.setExchangeauthinfo(authInfoEncoded);
                break;
            }
            case 2: {
                ContactServerSettingsWithTokenDto settingsWithTokenDto = (ContactServerSettingsWithTokenDto)contactServerSettingsDto;
                authInfo = this.gson.toJson((Object)new Office365AuthInfo(settingsWithTokenDto.getAccount(), settingsWithTokenDto.getBasicToken().getAccess_token(), settingsWithTokenDto.getBasicToken().getRefresh_token(), settingsWithTokenDto.getLastUpdateTokenTime(), settingsWithTokenDto.getSettingPlatform()));
                authInfoEncoded = new String(new AesUtil().encodeBase64(authInfo));
                accountPrivateSetting.setOffice365authinfo(authInfoEncoded);
                break;
            }
            case 3: {
                ContactServerSettingsWithTokenDto contactServerSettings = (ContactServerSettingsWithTokenDto)contactServerSettingsDto;
                QContactzAuthInfoSettings qContactzAuthInfoSettings = new QContactzAuthInfoSettings(contactServerSettings.getAccount(), contactServerSettings.getQcontactzAccountId(), contactServerSettings.getQcontactzAccountSid(), contactServerSettings.getQcontactzAuthToken(), contactServerSettings.getLastUpdateTokenTime(), contactServerSettings.getSettingPlatform());
                authInfo = this.gson.toJson((Object)qContactzAuthInfoSettings);
                authInfoEncoded = new AesUtil().encodeBase64(authInfo);
                accountPrivateSetting.setQcontactzauthinfo(authInfoEncoded);
                break;
            }
        }
        LOG.debug("set system contact server settings....");
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public CRMSettingsDto getUserCRMSettings(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        if (this.CRMSettingsNull(accountPrivateSetting)) {
            throw new ItemNotFoundException("No user CRM settings found.");
        }
        CRMSettingsDto CRMSettingsDto2 = new CRMSettingsDto();
        CRMSettingsDto2.setUserCRMAccount(accountPrivateSetting.getUsercrmaccount());
        CRMSettingsDto2.setUserCRMPassword(accountPrivateSetting.getUsercrmpassword());
        CRMSettingsDto2.setUserCRMSecretToken(accountPrivateSetting.getUsercrmsecrettoken());
        CRMSettingsDto2.setUserCRMExportMode(accountPrivateSetting.getCrmexportmode());
        CRMSettingsDto2.setCompanyAssignmentOption(this.getCRMCompanyAssignmentOptionForUser(accountPrivateSetting.getCrmexportmode(), accountPrivateSetting.getCrmcompanyassignmentoption()));
        return CRMSettingsDto2;
    }

    private CRMCompanyAssignmentOption getCRMCompanyAssignmentOptionForUser(CRMExportMode exportMode, CRMCompanyAssignmentOption companyAssignOption) {
        if (exportMode == null || CRMExportMode.AUTO_SYNC_CONTACT.equals((Object)exportMode)) {
            return CRMCompanyAssignmentOption.NONE;
        }
        if (companyAssignOption == null || CRMCompanyAssignmentOption.NONE.equals((Object)companyAssignOption)) {
            return CRMCompanyAssignmentOption.AUTO;
        }
        return companyAssignOption;
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public ContactServerSettingsWithTokenDto getContactServerSettings(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        ContactServerSettingsWithTokenDto contactServerSetting = new ContactServerSettingsWithTokenDto();
        SupportContactServer supportContactServer = accountPrivateSetting.getContactservertype();
        ContactServerExportMode exportMode = accountPrivateSetting.getContactserverexportmode();
        String companyGuid = this.accountDao.findOne(userGuid).getCompanyGuid();
        Globalinfocompany systemContactServerUrl = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CONTACT_SERVER_URL", companyGuid);
        Globalinfocompany systemContactServer = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CONTACT_SERVER", companyGuid);
        if (supportContactServer == null || systemContactServer != null && !systemContactServer.getConfigValue().equals(supportContactServer.toString())) {
            throw new ItemNotFoundException("No user contact server settings found.");
        }
        if (supportContactServer.equals((Object)SupportContactServer.EXCHANGE) && exportMode != null && StringUtils.isNotEmpty((CharSequence)accountPrivateSetting.getExchangeauthinfo()) && systemContactServerUrl != null) {
            contactServerSetting.setSupportContactServer(SupportContactServer.EXCHANGE);
            contactServerSetting.setContactServerExportMode(accountPrivateSetting.getContactserverexportmode());
            String authInfo = new String(new AesUtil().decodeFromBase64(accountPrivateSetting.getExchangeauthinfo()));
            ExchangeAuthInfo exchangeAuthInfo = (ExchangeAuthInfo)this.gson.fromJson(authInfo, ExchangeAuthInfo.class);
            contactServerSetting.setAccount(exchangeAuthInfo.getAccount());
            contactServerSetting.setPassword(exchangeAuthInfo.getPassword());
            contactServerSetting.setExchangeAccountUniqueId(exchangeAuthInfo.getUniqueExchangeAccountId());
            contactServerSetting.setServerUrl(systemContactServerUrl.getConfigValue());
            contactServerSetting.setSettingPlatform(Platform.WEB);
        } else if (supportContactServer.equals((Object)SupportContactServer.OFFICE365) && exportMode != null && StringUtils.isNotEmpty((CharSequence)accountPrivateSetting.getOffice365authinfo())) {
            contactServerSetting.setSupportContactServer(SupportContactServer.OFFICE365);
            contactServerSetting.setContactServerExportMode(accountPrivateSetting.getContactserverexportmode());
            String authInfo = new String(new AesUtil().decodeFromBase64(accountPrivateSetting.getOffice365authinfo()));
            Office365AuthInfo office365AuthInfo = (Office365AuthInfo)this.gson.fromJson(authInfo, Office365AuthInfo.class);
            contactServerSetting.setAccount(office365AuthInfo.getAccount());
            contactServerSetting.setBasicToken(new ContactServerBasicToken(office365AuthInfo.getAccessToken(), office365AuthInfo.getRefreshToken()));
            contactServerSetting.setLastUpdateTokenTime(office365AuthInfo.getLastUpdateTokenTime());
            contactServerSetting.setServerUrl("");
            contactServerSetting.setSettingPlatform(office365AuthInfo.getSettingPlatform());
        } else if (supportContactServer.equals((Object)SupportContactServer.QCONTACTZ) && exportMode != null && StringUtils.isNotEmpty((CharSequence)accountPrivateSetting.getQcontactzauthinfo())) {
            contactServerSetting.setSupportContactServer(SupportContactServer.QCONTACTZ);
            contactServerSetting.setContactServerExportMode(accountPrivateSetting.getContactserverexportmode());
            String authInfo = new String(new AesUtil().decodeFromBase64(accountPrivateSetting.getQcontactzauthinfo()));
            QContactzAuthInfoSettings authInfoSettings = (QContactzAuthInfoSettings)this.gson.fromJson(authInfo, QContactzAuthInfoSettings.class);
            contactServerSetting.setAccount(authInfoSettings.getUsername());
            contactServerSetting.setQcontactzAccountId(authInfoSettings.getUser_id());
            contactServerSetting.setQcontactzAccountSid(authInfoSettings.getSid());
            contactServerSetting.setQcontactzAuthToken(authInfoSettings.getToken());
            contactServerSetting.setServerUrl("");
            contactServerSetting.setLastUpdateTokenTime(authInfoSettings.getLastUpdateTokenTime());
            contactServerSetting.setSettingPlatform(authInfoSettings.getSettingPlatform());
        } else {
            throw new ItemNotFoundException("No user contact server settings found.");
        }
        return contactServerSetting;
    }

    private boolean CRMSettingsNull(AccountPrivateSetting accountPrivateSetting) {
        String crmAccount = accountPrivateSetting.getUsercrmaccount();
        String crmPassword = accountPrivateSetting.getUsercrmpassword();
        String crmSecurityToken = accountPrivateSetting.getUsercrmsecrettoken();
        CRMExportMode crmExportMode = accountPrivateSetting.getCrmexportmode();
        boolean CRMAccountSettingsAnyoneEmpty = StringUtils.isEmpty((CharSequence)crmAccount) || StringUtils.isEmpty((CharSequence)crmPassword) || StringUtils.isEmpty((CharSequence)crmSecurityToken);
        LOG.debug("CRMAccountSettingsAnyoneEmpty : {} ", (Object)CRMAccountSettingsAnyoneEmpty);
        boolean CRMSettingsNull = CRMAccountSettingsAnyoneEmpty || crmExportMode == null;
        LOG.debug("CRMSettingsNull : {} ", (Object)CRMSettingsNull);
        if (CRMSettingsNull) {
            String accessToken = accountPrivateSetting.getCrmlogintoken();
            boolean userAgentIncorrectParams = StringUtils.isEmpty((CharSequence)crmAccount) || crmExportMode == null || StringUtils.isEmpty((CharSequence)accessToken);
            LOG.debug("userAgentIncorrectParams : {} ", (Object)userAgentIncorrectParams);
            return userAgentIncorrectParams;
        }
        return CRMSettingsNull;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void cleanUserCRMSettings(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setUsercrmaccount(null);
        accountPrivateSetting.setUsercrmpassword(null);
        accountPrivateSetting.setUsercrmsecrettoken(null);
        accountPrivateSetting.setUserstoredcrmtype(null);
        accountPrivateSetting.setCrmexportmode(null);
        accountPrivateSetting.setCrmcompanyassignmentoption(null);
        accountPrivateSetting.setUsercrmtokentype(null);
        accountPrivateSetting.setCrmlogintoken(null);
        accountPrivateSetting.setConsumerkey(null);
        accountPrivateSetting.setConsumersecret(null);
        accountPrivateSetting.setCrmSyncLastCompletedTimeForCRM(null);
        accountPrivateSetting.setCrmSyncLastCompletedTimeForWCT(null);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void cleanUserContactServerSettings(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setContactserverexportmode(null);
        accountPrivateSetting.setContactservertype(null);
        accountPrivateSetting.setExchangeauthinfo(null);
        accountPrivateSetting.setOffice365authinfo(null);
        accountPrivateSetting.setQcontactzauthinfo(null);
        accountPrivateSetting.setContactServerSyncLastCompletedTimeForContactServer(null);
        accountPrivateSetting.setContactServerSyncLastCompletedTimeForWCT(null);
        accountPrivateSetting.setModifytime(new DateTime());
        accountPrivateSetting.setOffice365deltalinkforsync(null);
        accountPrivateSetting.setContactserverlastexportinfo(null);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public String getUserCRMLoginToken(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        return accountPrivateSetting.getCrmlogintoken();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void removeUserCRMloginToken(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setCrmlogintoken(null);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserCRMloginToken(String userGuid, String authString, SalesForceOAuthTokenType userCRMTokenType) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setCrmlogintoken(authString);
        accountPrivateSetting.setUsercrmtokentype(userCRMTokenType);
        accountPrivateSetting.setModifytime(new DateTime());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public SalesForceOAuthTokenType getUserCRMTokenType(String currentLoginUserGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(currentLoginUserGuid);
        return accountPrivateSetting.getUsercrmtokentype();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserCRMExportMode(String userGuid, CRMExportMode CRMExportMode2, CRMCompanyAssignmentOption crmCompanyAssignmentOption) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setCrmexportmode(CRMExportMode2);
        accountPrivateSetting.setCrmcompanyassignmentoption(this.getCRMCompanyAssignmentOptionForUser(CRMExportMode2, crmCompanyAssignmentOption));
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setContactServerExportMode(String userGuid, ContactServerExportMode contactServerExportMode) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setContactserverexportmode(contactServerExportMode);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public NameDisplayOrderSettingType getNameDisplayOrderSettingByAccount(String accountGuid) {
        return this.getNameDisplayOrderSetting(accountGuid);
    }

    public NameDisplayOrderSettingType getNameDisplayOrderSetting() {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        return this.getNameDisplayOrderSetting(loginAccount.getGuid());
    }

    private NameDisplayOrderSettingType getNameDisplayOrderSetting(String accountGuid) {
        NameOrder eastNameOrder = this.getUserAsianSurnameOrder(accountGuid);
        NameOrder westNameOrder = this.getUserWesternSurnameOrder(accountGuid);
        if (NameOrder.FIRSTNAME_LASTNAME.equals((Object)eastNameOrder)) {
            if (NameOrder.FIRSTNAME_LASTNAME.equals((Object)westNameOrder)) {
                return NameDisplayOrderSettingType.EAST_FL_WEST_FL;
            }
            return NameDisplayOrderSettingType.EAST_FL_WEST_LF;
        }
        if (NameOrder.FIRSTNAME_LASTNAME.equals((Object)westNameOrder)) {
            return NameDisplayOrderSettingType.EAST_LF_WEST_FL;
        }
        return NameDisplayOrderSettingType.EAST_LF_WEST_LF;
    }

    public String getUserCRMExportResult(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        return accountPrivateSetting.getLastexportresult();
    }

    public String getUserContactServerExportResult(String userGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        String contactServerLastExprotInfoContent = accountPrivateSetting.getContactserverlastexportinfo();
        try {
            if (StringUtils.isNotEmpty((CharSequence)contactServerLastExprotInfoContent)) {
                ContactServerLastExportInfo contactServerLastExprotInfo = (ContactServerLastExportInfo)this.gson.fromJson(contactServerLastExprotInfoContent, ContactServerLastExportInfo.class);
                return contactServerLastExprotInfo.getLastExportResult();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserCRMExportInfo(String userGuid, int exportCount, DateTime exportTime, String exportResult) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setLastexportcount(exportCount);
        accountPrivateSetting.setLastexporttime(exportTime);
        accountPrivateSetting.setLastexportresult(exportResult);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setUserContactServerExportInfo(String userGuid, int exportCount, DateTime exportTime, String exportResult) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        ContactServerLastExportInfo info = new ContactServerLastExportInfo();
        info.setLastExportCount(exportCount);
        info.setLastExportTime(exportTime);
        info.setLastExportResult(exportResult);
        accountPrivateSetting.setContactserverlastexportinfo(this.gson.toJson((Object)info));
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public boolean isManualExportToCRM(String accountGuid) {
        CRMSettingsDto crmSettingsDto = this.getUserCRMSettings(accountGuid);
        return CRMExportMode.MANUAL_EXPORT.equals((Object)crmSettingsDto.getUserCRMExportMode());
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public CRMExportMode getCrmExportMode(String accountGuid) {
        CRMSettingsDto crmSettingsDto = this.getUserCRMSettings(accountGuid);
        return crmSettingsDto.getUserCRMExportMode();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateQContactAuthInfo(String accountGuid, ContactServerSettingsWithTokenDto settingsWithTokenDto) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        QContactzAuthInfoSettings qContactzAuthInfoSettings = new QContactzAuthInfoSettings(settingsWithTokenDto.getAccount(), settingsWithTokenDto.getQcontactzAccountId(), settingsWithTokenDto.getQcontactzAccountSid(), settingsWithTokenDto.getQcontactzAuthToken(), settingsWithTokenDto.getLastUpdateTokenTime(), settingsWithTokenDto.getSettingPlatform());
        String authInfo = this.gson.toJson((Object)qContactzAuthInfoSettings);
        String authInfoEncoded = new AesUtil().encodeBase64(authInfo);
        accountPrivateSetting.setQcontactzauthinfo(authInfoEncoded);
        accountPrivateSetting.setModifytime(DateTime.now());
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public boolean isManualExportToSystemContactServer(String accountGuid) {
        ContactServerSettingsWithTokenDto contactServerSetting = this.getContactServerSettings(accountGuid);
        return ContactServerExportMode.MANUAL_EXPORT.equals((Object)contactServerSetting.getContactServerExportMode());
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public boolean isAutoSyncWithCRM(String accountGuid) {
        CRMSettingsDto crmSettingsDto = this.getUserCRMSettings(accountGuid);
        return CRMExportMode.AUTO_SYNC_CONTACT.equals((Object)crmSettingsDto.getUserCRMExportMode());
    }

    @Transactional(noRollbackFor={ItemNotFoundException.class})
    public boolean isAutoSyncWithContactServer(String accountGuid) {
        ContactServerSettingsWithTokenDto contactServerSetting = this.getContactServerSettings(accountGuid);
        return ContactServerExportMode.AUTO_SYNC_CONTACT.equals((Object)contactServerSetting.getContactServerExportMode());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class}, readOnly=false)
    public void resetUserCRMsettings(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setUsercrmaccount("");
        accountPrivateSetting.setUsercrmpassword("");
        accountPrivateSetting.setUsercrmsecrettoken("");
        accountPrivateSetting.setCrmlogintoken("");
        accountPrivateSetting.setCrmexportmode(CRMExportMode.MANUAL_EXPORT);
        accountPrivateSetting.setCrmcompanyassignmentoption(CRMCompanyAssignmentOption.AUTO);
        accountPrivateSetting.setUsercrmtokentype(null);
        accountPrivateSetting.setUserstoredcrmtype(null);
        accountPrivateSetting.setCrmSyncLastCompletedTimeForCRM(null);
        accountPrivateSetting.setCrmSyncLastCompletedTimeForWCT(null);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class}, readOnly=false)
    public void resetContactServerSettings(String accountGuid, SupportContactServer supportContactServer) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setExchangeauthinfo(null);
        accountPrivateSetting.setOffice365authinfo(null);
        accountPrivateSetting.setQcontactzauthinfo(null);
        accountPrivateSetting.setContactserverexportmode(ContactServerExportMode.MANUAL_EXPORT);
        accountPrivateSetting.setContactservertype(supportContactServer);
        accountPrivateSetting.setContactServerSyncLastCompletedTimeForContactServer(null);
        accountPrivateSetting.setContactServerSyncLastCompletedTimeForWCT(null);
        accountPrivateSetting.setOffice365deltalinkforsync(null);
        accountPrivateSetting.setContactserverlastexportinfo(null);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CrmTargetType getCrmAutoExportTargetType(String accountGuid) {
        CrmTargetType type = null;
        AccountInfo accountInfo = this.accountService.getAccountInfo(accountGuid, null);
        SupportCRM supportCRM = this.systemSettingService.getSystemCRM(accountInfo);
        if (SupportCRM.SALESFORCE.equals((Object)supportCRM)) {
            CRMSettingsDto crmSettingsDto = this.getUserCRMSettings(accountGuid);
            if (CRMExportMode.AUTO_SYNC_CONTACT.equals((Object)crmSettingsDto.getUserCRMExportMode())) return CrmTargetType.SALESFORCE_CONTACT;
            if (CRMExportMode.AUTO_EXPORT_TO_CONTACT.equals((Object)crmSettingsDto.getUserCRMExportMode())) {
                return CrmTargetType.SALESFORCE_CONTACT;
            }
            if (!CRMExportMode.AUTO_EXPORT_TO_LEAD.equals((Object)crmSettingsDto.getUserCRMExportMode())) throw new ItemNotFoundException("There is no auto export CRM settings for this account.");
            return CrmTargetType.SALESFORCE_LEAD;
        }
        if (!SupportCRM.SUGAR_CRM.equals((Object)supportCRM)) throw new ItemNotFoundException("There is no auto export CRM settings for this account.");
        return CrmTargetType.SUGAR_CRM;
    }

    public DateTime getCrmSyncLastCompletedTimeForWCT(String accountGuid, CrmTargetType crmTargetType) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        if (CrmTargetType.SALESFORCE_CONTACT.equals((Object)crmTargetType)) {
            return accountPrivateSetting.getCrmSyncLastCompletedTimeForWCT();
        }
        if (CrmTargetType.SALESFORCE_LEAD.equals((Object)crmTargetType)) {
            return accountPrivateSetting.getLeadSyncLastCompletedTimeForWCT();
        }
        return null;
    }

    public DateTime getContactServerSyncLastCompletedTimeForWCT(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        return accountPrivateSetting.getContactServerSyncLastCompletedTimeForWCT();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setCrmSyncLastCompletedTimeForWCT(String accountGuid, DateTime modifiedTime, CrmTargetType crmTargetType) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        if (CrmTargetType.SALESFORCE_CONTACT.equals((Object)crmTargetType)) {
            accountPrivateSetting.setCrmSyncLastCompletedTimeForWCT(modifiedTime);
        } else if (CrmTargetType.SALESFORCE_LEAD.equals((Object)crmTargetType)) {
            accountPrivateSetting.setLeadSyncLastCompletedTimeForWCT(modifiedTime);
        }
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setContactServerSyncLastCompletedTimeForWCT(String accountGuid, DateTime modifiedTime) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setContactServerSyncLastCompletedTimeForWCT(modifiedTime);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public DateTime getCrmSyncLastCompletedTimeForCRM(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        return accountPrivateSetting.getCrmSyncLastCompletedTimeForCRM();
    }

    public DateTime getContactServerSyncLastCompletedTimeForContactServer(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        return accountPrivateSetting.getContactServerSyncLastCompletedTimeForContactServer();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setCrmSyncLastCompletedTimeForCRM(String accountGuid, DateTime modifiedTime) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setCrmSyncLastCompletedTimeForCRM(modifiedTime);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setContactServerSyncLastCompletedTimeForContactServer(String accountGuid, DateTime modifiedTime) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setContactServerSyncLastCompletedTimeForContactServer(modifiedTime);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void setLastDeeplyDeletedContactTime(String accountGuid, DateTime time) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setLastDeeplyDeletedContactTime(time);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public DateTime getLastDeeplyDeletedContactTime(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        return accountPrivateSetting.getLastDeeplyDeletedContactTime();
    }

    public String getOffice365DeltaLinkForSync(String accountGuid) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        return accountPrivateSetting.getOffice365deltalinkforsync();
    }

    public void setOffice365DeltaLinkForSync(String userGuid, String deltaLink) {
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(userGuid);
        accountPrivateSetting.setOffice365deltalinkforsync(deltaLink);
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }

    public void cleanUserContatServerSettingsInTheSameCompany(String companyGuid) {
        List accountGuids = this.accountDao.findAllGuidsByCompany(companyGuid);
        List accountPrivateSettings = this.accountPrivateSettingDao.findbyHasLoginContactServerInAccountGuids(accountGuids);
        LOG.debug("findbyHasLoginContactServerInAccountGuids={}", (Object)accountPrivateSettings);
        accountPrivateSettings.stream().forEach(accountPrivateSetting -> {
            accountPrivateSetting.setContactserverexportmode(null);
            accountPrivateSetting.setContactservertype(null);
            accountPrivateSetting.setExchangeauthinfo(null);
            accountPrivateSetting.setOffice365authinfo(null);
            accountPrivateSetting.setContactServerSyncLastCompletedTimeForContactServer(null);
            accountPrivateSetting.setContactServerSyncLastCompletedTimeForWCT(null);
            accountPrivateSetting.setModifytime(new DateTime());
            accountPrivateSetting.setOffice365deltalinkforsync(null);
        });
        this.accountPrivateSettingDao.save((Iterable)accountPrivateSettings);
    }

    public void cleanUserCRMSettingsInTheSameCompany(String companyGuid) {
        List accountGuids = this.accountDao.findAllGuidsByCompany(companyGuid);
        List accountPrivateSettings = this.accountPrivateSettingDao.findbyHasLoginCRMInAccountGuids(accountGuids);
        LOG.debug("findbyHasLoginCRMInAccountGuids={}", (Object)accountPrivateSettings);
        accountPrivateSettings.stream().forEach(accountPrivateSetting -> {
            accountPrivateSetting.setUserstoredcrmtype(null);
            accountPrivateSetting.setCrmexportmode(null);
            accountPrivateSetting.setCrmcompanyassignmentoption(null);
            accountPrivateSetting.setUsercrmaccount(null);
            accountPrivateSetting.setUsercrmpassword(null);
            accountPrivateSetting.setUsercrmsecrettoken(null);
            accountPrivateSetting.setCrmlogintoken(null);
            accountPrivateSetting.setUsercrmtokentype(null);
            accountPrivateSetting.setCrmSyncLastCompletedTimeForCRM(null);
            accountPrivateSetting.setCrmSyncLastCompletedTimeForWCT(null);
            accountPrivateSetting.setModifytime(new DateTime());
        });
        this.accountPrivateSettingDao.save((Iterable)accountPrivateSettings);
    }

    public void updateCRMLoginToken(String accountGuid, BasicToken basicToken) {
        Gson gson = new Gson();
        AccountPrivateSetting accountPrivateSetting = this.getAccountPrivateSetting(accountGuid);
        accountPrivateSetting.setCrmlogintoken(gson.toJson((Object)basicToken));
        this.accountPrivateSettingDao.save((Object)accountPrivateSetting);
    }
}

