/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service;

import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountInfoForDS;
import com.penpower.worldcard.team.dto.ResignedAcountInfo;
import com.penpower.worldcard.team.enums.AccountLockCase;
import com.penpower.worldcard.team.enums.AccountLockedIssue;
import com.penpower.worldcard.team.enums.AccountSubscriptionStatus;
import com.penpower.worldcard.team.enums.AccountType;
import com.penpower.worldcard.team.enums.InheritanceStatus;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.web.api.vo.AccountCreationVo;
import com.penpower.worldcard.team.web.api.vo.AccountUpdateVo;
import java.util.List;

public interface AccountService {
    public boolean verifyPassword(String var1, String var2, String var3) throws RequestArgumentNotValidException;

    public void checkPasswordValidate(String var1);

    public void checkUnActiveAccountExipred();

    public void verifyAccount(String var1, String var2) throws ItemNotFoundException, RequestArgumentNotValidException;

    public String getAccountLogoRelativePath(String var1) throws ItemNotFoundException, RequestArgumentNotValidException;

    public AccountInfo getAccountInfo(String var1, String var2) throws RequestArgumentNotValidException, ItemNotFoundException;

    public ResignedAcountInfo getResignedAccountInfo(String var1, String var2) throws RequestArgumentNotValidException, ItemNotFoundException;

    public AccountInfo getBoss(String var1) throws ItemNotFoundException;

    public void UpdateAccountCompanyGuid(String var1, String var2);

    public void UpdateAccountADGuid(String var1, String var2);

    public void UpdateAccountEmail(String var1, String var2);

    public List<AccountInfo> GetAccountByCompany(String var1) throws ItemNotFoundException;

    public List<AccountInfo> GetAccountByADBaseDN(String var1, String var2) throws ItemNotFoundException;

    public List<AccountInfo> getAccountInfos(String var1) throws ItemNotFoundException;

    public List<AccountInfoForDS> getAccountList();

    public List<AccountInfo> getAccountInfosByType(String var1, AccountType var2) throws ItemNotFoundException;

    public List<AccountInfo> GetAccountsAssisantWithMe(String var1);

    public List<AccountInfo> getAccountsByStatus(String var1, UserStatus ... var2) throws ItemNotFoundException;

    public void SyncAccountWithTSMC();

    public void setSyncTSMCResult(String var1);

    public List<ResignedAcountInfo> getResignedAccounts(boolean var1, String var2) throws ItemNotFoundException;

    public List<AccountInfo> getSubordinates(String var1) throws ItemNotFoundException;

    public String createAccount(AccountCreationVo var1, String var2, boolean var3);

    public void updatePassword(String var1, String var2);

    public void changePassword(String var1, String var2, String var3) throws ItemNotFoundException;

    public void updateAccount(AccountUpdateVo var1, AccountInfo var2) throws ItemNotFoundException, RequestArgumentNotValidException;

    public void deleteAccount(String var1) throws ItemNotFoundException;

    public void deleteAccountbyCompany(String var1);

    public void UpdateAccountAssistant(String var1, String var2) throws ItemNotFoundException;

    public UserStatus getAccountStatus(String var1);

    @Deprecated
    public List<AccountInfo> deleteAccounts(List<String> var1);

    @Deprecated
    public List<String> setAccountsStatusToResigned(List<String> var1);

    public void resetPassword(String var1);

    public void verifyAccountGuids(List<String> var1);

    public void changeDisplayName(String var1, String var2);

    public void setAccountUserStatus(String var1, UserStatus var2);

    public List<String> getAllSubordinateGuids(String var1);

    public List<String> getAllBossGuids(String var1);

    public long getAccountCount(String var1);

    public long getAccountCountforAllCompany();

    public long getAccountCountIncludeNotValid(String var1);

    public String getAccountPasswordMd5(String var1);

    public void setAccountLockissue(String var1, AccountLockedIssue var2, AccountLockCase var3);

    public void setAccountStatusToResigned(String var1, String var2);

    public AccountInfo getAccountInfoByDisplayName(String var1, String var2);

    public List<AccountInfo> getAccountsByRole(String var1, UserRole var2);

    public void updateInheritanceStatus(String var1, InheritanceStatus var2);

    public void updateInheritorAccountField(String var1, String var2);

    public void cleanInheritorAccountField(String var1);

    public boolean verifyInheritorStatus(String var1);

    public List<AccountInfo> getAccountByInheritanceStatus(InheritanceStatus var1);

    public void resetInheriteStatus(String var1);

    public void resetUnderInheritingAccountsInheritanceStatus();

    public boolean verifyAccountIsInheritor(String var1);

    public void changeActiveDirectoryAccountMail(String var1, String var2);

    public void publishAccountSecurityChangedEvent(AccountUpdateVo var1);

    public boolean isSubordinateOf(String var1, String var2);

    public void SetAllUserTokenInvalidate();

    public boolean updateSubscriptionStatus(List<String> var1, AccountSubscriptionStatus var2, String var3, AccountLockCase var4, boolean var5);

    public void unLockAccount(List<String> var1, String var2);

    public void UpdateAllAccountToTemplateInvalidate(boolean var1, String var2, AccountInfo var3, AccountLockCase var4, boolean var5);

    public List<String> getAllAccountGuidsInTheSameCompany(String var1);
}

