/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.config.property.ContactSyncGlobalProperties;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.CRMAuthenticationManager;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.enums.CRMExportMode;
import com.penpower.worldcard.team.enums.CrmExportFailedReason;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.StorageSpaceNotEnoughException;
import com.penpower.worldcard.team.notice.content.CrmExportResultContent;
import com.penpower.worldcard.team.notice.content.CrmSyncResultContent;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.scheduler.job.SyncContactsOfAccountsWithSalesforceJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.SalesForceTokenService;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForCRM;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactFailToExport;
import com.penpower.worldcard.team.web.api.vo.ContactInfoVoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class SyncContactsOfAccountsWithSalesforceJob
extends AbstractInterruptJob {
    public static final String DEFAULT_QUARTZ_GROP_NAME = "SYNC_CONTACTS_OF_ACCOUNTS_WITH_CRM_JOB";
    private static final Logger LOG = LoggerFactory.getLogger(SyncContactsOfAccountsWithSalesforceJob.class);
    private static final String INTERRUPT = "INTERRUPT";
    private JobExecutionContext thisContext;
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private SalesForceTokenService salesForceTokenService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private CRMAuthenticationManager salesforceAuthenticationManager;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("==============SyncContactsOfAccountsWithSalesforceJob start===============");
        this.thisContext = context;
        if (ReadOnlyStatusManager.READ_ONLY_STATUS.get()) {
            throw new StorageSpaceNotEnoughException("Disk space is not enough, CRM sync process is stopped.");
        }
        Set copyQueue = ContactSyncGlobalProperties.ACCOUNT_QUEUE_FOR_CRM_SYNC.stream().collect(Collectors.toSet());
        if (!copyQueue.isEmpty()) {
            LOG.debug("preSyncAccountListForSalesforce={}", copyQueue);
        }
        for (String preSyncAccountGuid : copyQueue) {
            ContactSyncGlobalProperties.ACCOUNT_QUEUE_FOR_CRM_SYNC.remove(preSyncAccountGuid);
            AccountInfo account = this.accountService.getAccountInfo(preSyncAccountGuid, null);
            try {
                CRMExportMode crmExportMode = this.accountPrivateSettingService.getCrmExportMode(account.getGuid());
                this.executeSyncContactProcess(account, crmExportMode);
            }
            catch (ItemNotFoundException ex) {
                LOG.debug("no user crm setting found = {}", (Object)account);
            }
        }
        if (((DateTime)ContactSyncGlobalProperties.LAST_CRM_SYNC_COMPLETED_TIME.get()).plusMinutes(3).isAfterNow()) {
            return;
        }
        List companys = this.companyService.FindAllCompany();
        boolean successTestAccessToken = false;
        for (Company company : companys) {
            List accountInfos = new ArrayList();
            try {
                accountInfos = this.accountService.getAccountsByStatus(company.getGuid(), new UserStatus[]{UserStatus.ACTIVE});
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            for (AccountInfo account : accountInfos) {
                String accountGuid = account.getGuid();
                LOG.debug("accountGuid:{}, account.getName():{}", (Object)accountGuid, (Object)account.getName());
                try {
                    CRMExportMode crmExportMode = this.accountPrivateSettingService.getCrmExportMode(account.getGuid());
                    if (CRMExportMode.MANUAL_EXPORT.equals((Object)crmExportMode) && ((DateTime)ContactSyncGlobalProperties.LAST_CRM_TEST_TOKEN_TIME_FOR_MAUNAL_EXPORT.get()).plusMinutes(15).isBeforeNow()) {
                        this.testAccessToken(account);
                        successTestAccessToken = true;
                        continue;
                    }
                    if (CRMExportMode.MANUAL_EXPORT.equals((Object)crmExportMode)) continue;
                    this.executeSyncContactProcess(account, crmExportMode);
                }
                catch (ItemNotFoundException ex) {
                    LOG.debug("no user crm setting found = {}", (Object)account);
                }
            }
        }
        if (successTestAccessToken) {
            ContactSyncGlobalProperties.LAST_CRM_TEST_TOKEN_TIME_FOR_MAUNAL_EXPORT.set(DateTime.now());
        }
        ContactSyncGlobalProperties.LAST_CRM_SYNC_COMPLETED_TIME.set(DateTime.now());
        LOG.debug("==============SyncContactsOfAccountsWithSalesforceJob end===============");
    }

    private BasicToken testAccessToken(AccountInfo account) {
        BasicToken basicToken = null;
        try {
            OkHttpClient client = this.companyGlobalInfoService.getOKHttpClientWithProxy(account.getCompanyGuid());
            basicToken = this.salesForceTokenService.retrieveToken(account.getGuid(), client);
            if (basicToken instanceof NullCRMToken) {
                throw new CRMOperationException("Get basicToken is NullCRMToken.");
            }
            this.accountPrivateSettingService.updateCRMLoginToken(account.getGuid(), basicToken);
        }
        catch (IOException client) {
        }
        catch (CRMOperationException e) {
            LOG.error("Get CRM access token for this account failed.({}, {})", (Object)account.getGuid(), (Object)account.getName());
            String failedResult = "Get CRM access token for this account failed.";
            String latestNotifyContent = this.noticeService.getLatestNotifyContent(account.getGuid());
            boolean isSameResult = latestNotifyContent.equals(failedResult);
            this.checkIfSendNoticeAndSetExportResult(account.getGuid(), failedResult, isSameResult, NotifyType.GET_CRM_TOKEN_FAILED, 0);
        }
        return basicToken;
    }

    private void executeSyncContactProcess(AccountInfo account, CRMExportMode crmExportMode) {
        String accountGuid = account.getGuid();
        try {
            CrmTargetType crmTargetType = CrmTargetType.SALESFORCE_CONTACT;
            boolean isAutoSyncWithCRM = false;
            if (CRMExportMode.MANUAL_EXPORT.equals((Object)crmExportMode)) {
                LOG.debug("CRM export settings is not auto({}, {})", (Object)accountGuid, (Object)account.getName());
                return;
            }
            crmTargetType = this.accountPrivateSettingService.getCrmAutoExportTargetType(accountGuid);
            CRMOperationService crmOperationService = GlobalUtils.getCrmOperationService((CrmTargetType)crmTargetType);
            BasicToken basicToken = this.testAccessToken(account);
            OkHttpClient client = this.companyGlobalInfoService.getOKHttpClientWithProxy(account.getCompanyGuid());
            if (basicToken == null) {
                return;
            }
            CrmSyncResultContent result = new CrmSyncResultContent();
            if (CRMExportMode.AUTO_SYNC_CONTACT.equals((Object)crmExportMode) || CRMExportMode.AUTO_EXPORT_TO_LEAD.equals((Object)crmExportMode) || CRMExportMode.AUTO_EXPORT_TO_CONTACT.equals((Object)crmExportMode)) {
                boolean isAutoExport = CRMExportMode.AUTO_EXPORT_TO_LEAD.equals((Object)crmExportMode) || CRMExportMode.AUTO_EXPORT_TO_CONTACT.equals((Object)crmExportMode);
                CrmSyncResultContent resultExport = this.exportContactsInPrivate(accountGuid, crmTargetType, isAutoExport, crmOperationService, basicToken, client);
                result.appendResultContent(resultExport);
            }
            if (CRMExportMode.AUTO_SYNC_CONTACT.equals((Object)crmExportMode)) {
                CrmSyncResultContent resultImport = this.importRecordsIntoPrivate(accountGuid, crmOperationService, basicToken, client);
                result.appendResultContent(resultImport);
            }
            if (!CollectionUtils.isEmpty((Collection)result.getFailedList())) {
                NotifyType notifyType = isAutoSyncWithCRM ? NotifyType.CONTACT_SYNC_WITH_CRM : NotifyType.CONTACT_EXPORTED;
                String latestNotifyContent = this.noticeService.getLatestNotifyContent(accountGuid);
                CrmExportResultContent latestResultContent = (CrmExportResultContent)GlobalUtils.getObjectFromJson((String)latestNotifyContent, CrmExportResultContent.class);
                boolean isSameResult = false;
                if (latestResultContent != null && CollectionUtils.isNotEmpty((Collection)latestResultContent.getFailedList())) {
                    isSameResult = GlobalUtils.getJsonString((Object)latestResultContent.getFailedList()).equals(GlobalUtils.getJsonString((Object)result.getFailedList()));
                }
                this.checkIfSendNoticeAndSetExportResult(accountGuid, GlobalUtils.getJsonString((Object)result), isSameResult, notifyType, result.getNumSucceeded());
            }
        }
        catch (Exception e) {
            LOG.debug("Account({},{}) encounter exception in sync process: {}", new Object[]{accountGuid, account.getName(), e});
            return;
        }
    }

    private CrmSyncResultContent exportContactsInPrivate(String accountGuid, CrmTargetType crmTargetType, boolean isAutoExport, CRMOperationService crmOperationService, BasicToken basicToken, OkHttpClient client) {
        DateTime lastSyncCompletedTime = this.accountPrivateSettingService.getCrmSyncLastCompletedTimeForWCT(accountGuid, crmTargetType);
        LOG.debug("{}, lastSyncCompletedTime={}", (Object)crmTargetType, (Object)lastSyncCompletedTime);
        List contactsNeedSync = crmOperationService.getWctSyncInfosByAccount(accountGuid, lastSyncCompletedTime, isAutoExport);
        LOG.debug("contactsNeedSync={}", (Object)contactsNeedSync);
        CrmSyncResultContent result = new CrmSyncResultContent();
        boolean isCheckMode = false;
        for (ContactCrmSyncInfoForWCT syncInfo : contactsNeedSync) {
            String contactGuid = syncInfo.getContactGuid();
            try {
                CrmSyncActionType crmActionType = this.syncContactFromWCT(syncInfo, isAutoExport, accountGuid, crmOperationService, basicToken, isCheckMode, client);
                this.contactPrivateService.updateContactCRMExportFailedReason(accountGuid, syncInfo.getContactGuid(), null);
                this.dealWithCrmSyncResult(result, crmActionType);
                this.accountPrivateSettingService.setCrmSyncLastCompletedTimeForWCT(accountGuid, syncInfo.getModifiedTime(), crmTargetType);
            }
            catch (Exception e) {
                ContactSimpleInfoDto infoDto = this.contactPrivateService.getSimpleContactDtoByGuid(contactGuid, accountGuid);
                result.getFailedList().add(new ContactFailToExport(contactGuid, e.getMessage(), infoDto.getFullname(), infoDto.getCompany()));
                CrmExportFailedReason failedReason = GlobalUtils.getCRMExportFailedReason((String)e.getMessage());
                this.contactPrivateService.updateContactCRMExportFailedReason(accountGuid, syncInfo.getContactGuid(), failedReason);
                LOG.debug("syncContactFromWCT fail(account guid:{}, contact guid:{})", (Object)accountGuid, (Object)contactGuid);
                LOG.debug("syncContactFromWCT fail:{}", (Throwable)e);
                this.accountPrivateSettingService.setCrmSyncLastCompletedTimeForWCT(accountGuid, syncInfo.getModifiedTime(), crmTargetType);
            }
        }
        return result;
    }

    private void dealWithCrmSyncResult(CrmSyncResultContent result, CrmSyncActionType crmActionType) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$scheduler$job$SyncContactsOfAccountsWithSalesforceJob$CrmSyncActionType[crmActionType.ordinal()]) {
            case 1: {
                result.increaseNumCrmAdd();
                result.increaseNumSucceeded();
                break;
            }
            case 2: {
                result.increaseNumCrmUpdate();
                result.increaseNumSucceeded();
                break;
            }
            case 3: {
                result.increaseNumCrmDelete();
                result.increaseNumSucceeded();
                break;
            }
            case 4: {
                result.increaseNumWctAdd();
                result.increaseNumSucceeded();
                break;
            }
            case 5: {
                result.increaseNumWctUpdate();
                result.increaseNumSucceeded();
                break;
            }
            case 6: {
                result.increaseNumWctDelete();
                result.increaseNumSucceeded();
                break;
            }
        }
    }

    private CrmSyncResultContent importRecordsIntoPrivate(String accountGuid, CRMOperationService crmOperationService, BasicToken basicToken, OkHttpClient client) {
        DateTime lastSyncCompletedTime = this.accountPrivateSettingService.getCrmSyncLastCompletedTimeForCRM(accountGuid);
        List crmRecordsNeedSync = crmOperationService.getCrmSyncInfosByAccount(accountGuid, lastSyncCompletedTime, basicToken, client);
        CrmSyncResultContent result = new CrmSyncResultContent();
        for (ContactCrmSyncInfoForCRM syncInfo : crmRecordsNeedSync) {
            try {
                CrmSyncActionType crmSyncActionType = this.syncContactFromCRM(syncInfo, accountGuid, crmOperationService, basicToken, client);
                this.accountPrivateSettingService.setCrmSyncLastCompletedTimeForCRM(accountGuid, syncInfo.getModifiedTime());
                this.dealWithCrmSyncResult(result, crmSyncActionType);
                if (crmSyncActionType != CrmSyncActionType.WCT_ADD && crmSyncActionType != CrmSyncActionType.WCT_DELETE && crmSyncActionType != CrmSyncActionType.WCT_UPDATE) continue;
                crmOperationService.updateWCTModifyTimeForSync(accountGuid, syncInfo, crmSyncActionType);
            }
            catch (Exception e) {
                result.getFailedList().add(new ContactFailToExport("", e.getMessage(), "", ""));
                LOG.debug("syncContactFromCRM fail(account guid:{}, CRM ID:{})", (Object)accountGuid, (Object)syncInfo.getCrmID());
                LOG.debug("syncContactFromCRM fail:{}", (Throwable)e);
                break;
            }
        }
        return result;
    }

    private CrmSyncActionType syncContactFromCRM(ContactCrmSyncInfoForCRM syncInfoCRM, String accountGuid, CRMOperationService crmService, BasicToken basicToken, OkHttpClient client) {
        String crmID = syncInfoCRM.getCrmID();
        if (syncInfoCRM.isDeleted().booleanValue()) {
            ContactCrmSyncInfoForWCT syncInfoWCT = crmService.getWctSyncInfoByCorrespondingCrmSyncInfo(accountGuid, syncInfoCRM);
            if (syncInfoWCT != null && syncInfoWCT.isUpdatedByLastCRMSync()) {
                LOG.debug("syncInfoWCT.getModifiedTime().isEqual(syncInfoWCT.getPreviousContactServerModifiedTime()) [SyncContactFromWCT] NONE: syncInfoWCT={}", (Object)syncInfoWCT);
                return CrmSyncActionType.NONE;
            }
            if (syncInfoWCT != null && !syncInfoWCT.isDeleted().booleanValue()) {
                LOG.debug("[syncContactFromCRM]WCT_DELETE");
                this.contactPrivateService.updateCategoriesOfContact(syncInfoWCT.getContactGuid(), null, accountGuid, ListSetBehavior.REMOVE_ALL, null);
                crmService.setExportCrmInfo(accountGuid, syncInfoWCT.getContactGuid(), syncInfoCRM.getCrmID(), syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getModifiedTime());
                return CrmSyncActionType.WCT_DELETE;
            }
            LOG.debug("[syncContactFromCRM]NONE - if (syncInfoCRM.isDeleted())");
            return CrmSyncActionType.NONE;
        }
        ContactCrmSyncInfoForWCT syncInfoWCT = crmService.getWctSyncInfoByCorrespondingCrmSyncInfo(accountGuid, syncInfoCRM);
        if (syncInfoWCT == null) {
            LOG.debug("[syncContactFromCRM]WCT_ADD");
            ContactCreationVo contactCreationVo = crmService.getContactCreationVoByCrmID(accountGuid, crmID, basicToken, client);
            AccountInfo accountinfo = this.accountService.getAccountInfo(accountGuid, null);
            if (accountinfo != null) {
                String contactGuid = this.contactPrivateService.createContact(contactCreationVo, null, null, null, accountinfo.getCompanyGuid());
                crmService.setExportCrmInfo(accountGuid, contactGuid, syncInfoCRM.getCrmID(), syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getModifiedTime());
            }
            return CrmSyncActionType.WCT_ADD;
        }
        if (!syncInfoWCT.isDeleted().booleanValue() && syncInfoCRM.getModifiedTime().isAfter((ReadableInstant)syncInfoWCT.getPreviousCrmModifiedTime()) && syncInfoCRM.getModifiedTime().isAfter((ReadableInstant)syncInfoWCT.getModifiedTime())) {
            LOG.debug("[syncContactFromCRM]WCT_UPDATE");
            ContactInfoVoForWCT originContact = this.contactPrivateService.getContactInfoVoForWCTByGuid(syncInfoWCT.getContactGuid(), accountGuid);
            ContactUpdateVo vo = crmService.getContactUpdateVoByCrmID(syncInfoWCT, basicToken, (ContactInfoForRequest)originContact, client);
            this.contactPrivateService.updateContact(vo, accountGuid);
            crmService.setExportCrmInfo(accountGuid, syncInfoWCT.getContactGuid(), syncInfoCRM.getCrmID(), syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getModifiedTime());
            return CrmSyncActionType.WCT_UPDATE;
        }
        if (syncInfoWCT.isDeleted().booleanValue()) {
            ContactInfoVoForWCT originContact = this.contactPrivateService.getContactInfoVoForWCTByGuid(syncInfoWCT.getContactGuid(), accountGuid);
            ContactUpdateVo vo = crmService.getContactUpdateVoByCrmID(syncInfoWCT, basicToken, (ContactInfoForRequest)originContact, client);
            this.contactPrivateService.downloadToPrivateAndUpdateContact(accountGuid, syncInfoWCT.getContactGuid(), vo);
            crmService.setExportCrmInfo(accountGuid, syncInfoWCT.getContactGuid(), syncInfoCRM.getCrmID(), syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getModifiedTime());
            LOG.debug("[syncContactFromCRM] WCT_ADD, contactGuid={}", (Object)syncInfoWCT.getContactGuid());
            return CrmSyncActionType.WCT_ADD;
        }
        LOG.debug("[syncContactFromCRM]NONE");
        return CrmSyncActionType.NONE;
    }

    private CrmSyncActionType syncContactFromWCT(ContactCrmSyncInfoForWCT syncInfoWCT, boolean isAutoExport, String accountGuid, CRMOperationService crmService, BasicToken basicToken, boolean isCheckMode, OkHttpClient client) {
        ContactCrmSyncInfoForCRM syncInfoCRM = null;
        if (syncInfoWCT.isDeleted().booleanValue() && !isAutoExport) {
            if (isCheckMode) {
                LOG.debug("[syncContactFromWCT]NONE - if (syncInfoWCT.isDeleted()) && if (isCheckMode)");
                return CrmSyncActionType.NONE;
            }
            syncInfoCRM = this.getCorrespondingInCRM(syncInfoWCT, accountGuid, crmService, basicToken, client);
            if (syncInfoCRM != null && !syncInfoCRM.isDeleted().booleanValue()) {
                LOG.debug("[syncContactFromWCT]CRM_DELETE");
                crmService.deleteRecord(accountGuid, syncInfoWCT.getCrmID(), syncInfoWCT.getContactGuid(), true, basicToken, client);
                return CrmSyncActionType.CRM_DELETE;
            }
            LOG.debug("[syncContactFromWCT]NONE - if (syncInfoWCT.isDeleted())");
            return CrmSyncActionType.NONE;
        }
        syncInfoCRM = this.getCorrespondingInCRM(syncInfoWCT, accountGuid, crmService, basicToken, client);
        if (syncInfoCRM == null || syncInfoCRM.isDeleted().booleanValue() && isAutoExport || syncInfoCRM.isDeleted().booleanValue() && syncInfoCRM.getModifiedTime().equals((Object)syncInfoWCT.getPreviousCrmModifiedTime())) {
            ContactInfoForResponse contact = this.contactPrivateService.getContactResponseInfoByGuid(syncInfoWCT.getContactGuid());
            if (isCheckMode) {
                LOG.debug("[syncContactFromWCT]NONE - exportContactCheck(), exportContactToCRM()");
                crmService.exportContactCheck(contact);
                return CrmSyncActionType.NONE;
            }
            LOG.debug("[syncContactFromWCT]CRM_ADD");
            crmService.exportContactToCRM(accountGuid, contact, true, basicToken, "", client);
            return CrmSyncActionType.CRM_ADD;
        }
        if (!syncInfoCRM.isDeleted().booleanValue() && !syncInfoWCT.isUpdatedByLastCRMSync() && syncInfoWCT.getModifiedTime().isAfter((ReadableInstant)syncInfoCRM.getModifiedTime())) {
            ContactInfoForResponse contact = this.contactPrivateService.getContactResponseInfoByGuid(syncInfoWCT.getContactGuid());
            if (isCheckMode) {
                LOG.debug("[syncContactFromWCT]NONE - exportContactCheck(), updateContactToCRM()");
                crmService.exportContactCheck(contact);
                return CrmSyncActionType.NONE;
            }
            try {
                LOG.debug("[syncContactFromWCT]CRM_UPDATE");
                crmService.updateContactToCRM(accountGuid, contact, syncInfoWCT.getCrmID(), true, basicToken, "", client);
                return CrmSyncActionType.CRM_UPDATE;
            }
            catch (Exception ex) {
                crmService.exportContactToCRM(accountGuid, contact, true, basicToken, "", client);
                return CrmSyncActionType.CRM_ADD;
            }
        }
        LOG.debug("[syncContactFromWCT]NONE");
        return CrmSyncActionType.NONE;
    }

    private ContactCrmSyncInfoForCRM getCorrespondingInCRM(ContactCrmSyncInfoForWCT syncInfo, String accountGuid, CRMOperationService crmService, BasicToken basicToken, OkHttpClient client) {
        if (StringUtil.IsStringNullorEmpty((String)syncInfo.getCrmID())) {
            return null;
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        if (!crmSettingsDto.getUserCRMAccount().equals(syncInfo.getSyncCrmAccount())) {
            return null;
        }
        ContactCrmSyncInfoForCRM syncInfoCRM = crmService.getRecordSyncInfo(accountGuid, syncInfo.getCrmID(), basicToken, client);
        if (syncInfoCRM == null) {
            return null;
        }
        return syncInfoCRM;
    }

    private void checkIfSendNoticeAndSetExportResult(String accountGuid, String exportResultContentString, boolean isSameResult, NotifyType notifyType, int exportCount) {
        LOG.info("isSameResult={}", (Object)isSameResult);
        if (!isSameResult) {
            this.noticeService.addNewNotice(NotifyCategory.SYSTEM, notifyType, exportResultContentString, accountGuid, null);
        }
        this.accountPrivateSettingService.setUserCRMExportInfo(accountGuid, exportCount, new DateTime(), exportResultContentString);
    }

    private boolean isInterrupted() {
        return this.thisContext.getJobDetail().getJobDataMap().containsKey((Object)INTERRUPT) && (Boolean)this.thisContext.getJobDetail().getJobDataMap().get((Object)INTERRUPT) != false;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

