/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.config.property.ContactSyncGlobalProperties;
import com.penpower.worldcard.team.contactsystem.ContactServerBasicToken;
import com.penpower.worldcard.team.contactsystem.CustomExchangeService;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactServerSettingsDtoFull;
import com.penpower.worldcard.team.dto.ContactServerSettingsWithTokenDto;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.dto.Office365SyncInfoWithDeltaLink;
import com.penpower.worldcard.team.entity.AccountPrivateSetting;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.enums.ContactServerExportMode;
import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.SupportContactServer;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.StorageSpaceNotEnoughException;
import com.penpower.worldcard.team.notice.content.ContactServerSyncResultContent;
import com.penpower.worldcard.team.notice.content.CrmExportResultContent;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.scheduler.job.SyncContactsOfAccountsWithContactServerJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactServerAuthService;
import com.penpower.worldcard.team.service.ContactServerOperationService;
import com.penpower.worldcard.team.service.ExchangeOperationService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.Office365OperationService;
import com.penpower.worldcard.team.web.api.vo.ContactFailToExport;
import com.penpower.worldcard.team.web.api.vo.ContactInfoVoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactServerSyncInfoForContactServer;
import com.penpower.worldcard.team.web.api.vo.ContactServerSyncInfoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactVoWithImageId;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class SyncContactsOfAccountsWithContactServerJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(SyncContactsOfAccountsWithContactServerJob.class);
    public static final String DEFAULT_QUARTZ_GROP_NAME = "SYNC_CONTACTS_OF_ACCOUNTS_WITH_CONTACT_SERVER_JOB";
    private static final String INTERRUPT = "INTERRUPT";
    private JobExecutionContext thisContext;
    @Autowired
    private AccountService accountService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ContactServerAuthService contactServerAuthService;
    @Autowired
    private ContactServerOperationService contactServerOperationService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private Office365OperationService office365OperationService;
    @Autowired
    private ExchangeOperationService exchangeOperationService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("==============SyncContactsOfAccountsWithContactServerJob start===============");
        if (ReadOnlyStatusManager.READ_ONLY_STATUS.get()) {
            throw new StorageSpaceNotEnoughException("Disk space is not enough, CRM sync process is stopped.");
        }
        Set copyQueue = ContactSyncGlobalProperties.ACCOUNT_QUEUE_FOR_CONTACT_SERVER_SYNC.stream().collect(Collectors.toSet());
        if (!copyQueue.isEmpty()) {
            LOG.debug("preSyncAccountList={}", copyQueue);
        }
        for (String preSyncAccountGuid : copyQueue) {
            ContactSyncGlobalProperties.ACCOUNT_QUEUE_FOR_CONTACT_SERVER_SYNC.remove(preSyncAccountGuid);
            AccountInfo account = this.accountService.getAccountInfo(preSyncAccountGuid, null);
            OkHttpClient client = this.companyGlobalInfoService.getOKHttpClientWithProxy(account.getCompanyGuid());
            this.executeSyncContactProcess(account, client);
        }
        if (((DateTime)ContactSyncGlobalProperties.LAST_CONTACT_SERVER_SYNC_COMPLETED_TIME.get()).plusMinutes(3).isAfterNow()) {
            return;
        }
        List companies = this.companyService.FindAllCompany();
        for (Company company : companies) {
            List accountInfos = new ArrayList();
            try {
                accountInfos = this.accountService.getAccountsByStatus(company.getGuid(), new UserStatus[]{UserStatus.ACTIVE});
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            for (AccountInfo account : accountInfos) {
                if (copyQueue.contains(account.getGuid())) continue;
                OkHttpClient client = this.companyGlobalInfoService.getOKHttpClientWithProxy(account.getCompanyGuid());
                this.executeSyncContactProcess(account, client);
            }
        }
        ContactSyncGlobalProperties.LAST_CONTACT_SERVER_SYNC_COMPLETED_TIME.set(DateTime.now());
        LOG.debug("==============SyncContactsOfAccountsWithContactServerJob end===============");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSyncContactProcess(AccountInfo account, OkHttpClient client) {
        String accountGuid = account.getGuid();
        try (CustomExchangeService exchangeService = null;){
            ContactServerSettingsWithTokenDto contactServerSetting = this.accountPrivateSettingService.getContactServerSettings(accountGuid);
            boolean isAutoSyncWithContactServer = contactServerSetting.getContactServerExportMode().equals((Object)ContactServerExportMode.AUTO_SYNC_CONTACT);
            boolean isAutoExport2ContactServer = contactServerSetting.getContactServerExportMode().equals((Object)ContactServerExportMode.AUTO_EXPORT);
            int refreshTokenPeriodInMinutes = isAutoSyncWithContactServer ? 20 : 10080;
            try {
                contactServerSetting = this.refreshTokenProcees(accountGuid, contactServerSetting, refreshTokenPeriodInMinutes, client);
            }
            catch (Exception ex) {
                LOG.error("Refresh token failed account={}", (Object)account.getName(), (Object)ex);
                String failedResult = "Refresh token failed";
                String latestNotifyContent = this.noticeService.getLatestNotifyContent(accountGuid);
                this.checkIfSendNoticeAndSetExportResult(accountGuid, failedResult, latestNotifyContent.equals(failedResult), NotifyType.GET_CRM_TOKEN_FAILED, 0);
                this.accountPrivateSettingService.resetContactServerSettings(accountGuid, contactServerSetting.getSupportContactServer());
                if (exchangeService != null) {
                    exchangeService.close();
                }
                return;
            }
            try {
                this.contactServerAuthService.testConnectionAndGetExchangeUniqueId((ContactServerSettingsDtoFull)contactServerSetting);
            }
            catch (Exception ex) {
                LOG.error("Contact server connection fail for this account.({}, {})", (Object)accountGuid, (Object)account.getName());
                String failedResult = "Contact server connection fail for this account";
                String latestNotifyContent = this.noticeService.getLatestNotifyContent(accountGuid);
                this.checkIfSendNoticeAndSetExportResult(accountGuid, failedResult, latestNotifyContent.equals(failedResult), NotifyType.GET_CRM_TOKEN_FAILED, 0);
                this.accountPrivateSettingService.resetContactServerSettings(accountGuid, contactServerSetting.getSupportContactServer());
                if (exchangeService != null) {
                    exchangeService.close();
                }
                return;
            }
            if (!isAutoSyncWithContactServer && !isAutoExport2ContactServer) {
                return;
            }
            ContactServerSyncResultContent result = new ContactServerSyncResultContent();
            exchangeService = this.exchangeOperationService.getExchangeCredentialOfService((ContactServerSettingsDtoFull)contactServerSetting);
            String office365ContactFolderId = this.office365OperationService.findContactFolderId(contactServerSetting, client);
            AccountPrivateSetting setting = this.accountPrivateSettingService.getAccountPrivateSetting(accountGuid);
            Instant syncStart = Instant.now();
            if (isAutoSyncWithContactServer || isAutoExport2ContactServer) {
                ContactServerSyncResultContent resultExport = this.exportContactInPrivate(accountGuid, contactServerSetting, office365ContactFolderId, exchangeService, setting.getContactServerSyncLastCompletedTimeForWCT(), setting.getContactServerSyncLastCompletedTimeForContactServer(), client);
                result.appendResultContent(resultExport);
            }
            if (isAutoSyncWithContactServer) {
                boolean isCheckMode = CollectionUtils.isNotEmpty((Collection)result.getFailedList());
                contactServerSetting = this.refreshTokenProcees(accountGuid, contactServerSetting, 45, client);
                ContactServerSyncResultContent resultImport = this.importRecordsIntoPrivate(accountGuid, contactServerSetting, office365ContactFolderId, exchangeService, isCheckMode, account.getCompanyGuid(), setting.getContactServerSyncLastCompletedTimeForContactServer(), client);
                result.appendResultContent(resultImport);
            }
            Instant syncEnd = Instant.now();
            Duration syncDuration = Duration.between(syncStart, syncEnd);
            String spendTimeString = syncDuration.getSeconds() + "." + syncDuration.getNano() / 1000000 + "s";
            LOG.debug("Sync account={}, result=[{}], time={}", new Object[]{account.getEmail(), result, spendTimeString});
            if (CollectionUtils.isNotEmpty((Collection)result.getFailedList())) {
                NotifyType notifyType = isAutoSyncWithContactServer ? NotifyType.CONTACT_SYNC_WITH_CONTACT_SERVER : NotifyType.CONTACT_EXPORTED_TO_CONTACT_SERVER;
                String latestNotifyContent = this.noticeService.getLatestNotifyContent(accountGuid);
                CrmExportResultContent latestResultContent = (CrmExportResultContent)GlobalUtils.getObjectFromJson((String)latestNotifyContent, CrmExportResultContent.class);
                boolean isSameResult = false;
                if (latestResultContent != null && CollectionUtils.isNotEmpty((Collection)latestResultContent.getFailedList())) {
                    isSameResult = GlobalUtils.getJsonString((Object)latestResultContent.getFailedList()).equals(GlobalUtils.getJsonString((Object)result.getFailedList()));
                }
                this.checkIfSendNoticeAndSetExportResult(accountGuid, GlobalUtils.getJsonString((Object)result), isSameResult, notifyType, result.getNumSucceeded());
            }
            return;
        }
    }

    private void checkIfSendNoticeAndSetExportResult(String accountGuid, String exportResultContentString, boolean isSameResult, NotifyType notifyType, int exportCount) {
        if (!isSameResult) {
            this.noticeService.addNewNotice(NotifyCategory.SYSTEM, notifyType, exportResultContentString, accountGuid, null);
        }
        this.accountPrivateSettingService.setUserContactServerExportInfo(accountGuid, exportCount, new DateTime(), exportResultContentString);
    }

    private ContactServerSyncResultContent importRecordsIntoPrivate(String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, String office365ContactFolderId, CustomExchangeService exchangeService, boolean isCheckMode, String companyGuid, DateTime lastSyncCompletedTime, OkHttpClient client) throws Exception {
        List contactServerRecordsNeedSync = new ArrayList();
        String previousDeltaLink = this.accountPrivateSettingService.getOffice365DeltaLinkForSync(accountGuid);
        Office365SyncInfoWithDeltaLink office365SyncInfoWithDeltaLink = null;
        try {
            office365SyncInfoWithDeltaLink = this.contactServerOperationService.getOffice365SyncInfosByDeltaQuery(accountGuid, contactServerSetting, previousDeltaLink, client);
        }
        catch (Exception ex) {
            previousDeltaLink = "";
            office365SyncInfoWithDeltaLink = this.contactServerOperationService.getOffice365SyncInfosByDeltaQuery(accountGuid, contactServerSetting, previousDeltaLink, client);
            this.accountPrivateSettingService.setOffice365DeltaLinkForSync(accountGuid, null);
        }
        if (office365SyncInfoWithDeltaLink == null) {
            contactServerRecordsNeedSync = this.contactServerOperationService.getContactServerSyncInfosByAccount(accountGuid, lastSyncCompletedTime, contactServerSetting, exchangeService, client);
            LOG.debug("contactServerRecordsNeedSyncSize={}", (Object)contactServerRecordsNeedSync.size());
        } else {
            contactServerRecordsNeedSync = office365SyncInfoWithDeltaLink.getSyncInfos();
            LOG.debug("contactServerRecordsNeedSyncSize by delta link={}", (Object)contactServerRecordsNeedSync.size());
        }
        LOG.debug("contactServerRecordsNeedSync={}", contactServerRecordsNeedSync);
        ContactServerSyncResultContent result = new ContactServerSyncResultContent();
        DateTime lastContactServerModifyTimeForContactServer = null;
        int currentCompleteCount = 0;
        for (ContactServerSyncInfoForContactServer syncInfo : contactServerRecordsNeedSync) {
            try {
                ContactServerSyncActionType contactServerSyncActionType = this.syncContactFromContactServer(syncInfo, accountGuid, contactServerSetting, office365ContactFolderId, exchangeService, companyGuid, client);
                if (contactServerSyncActionType == ContactServerSyncActionType.WCT_ADD || contactServerSyncActionType == ContactServerSyncActionType.WCT_DELETE || contactServerSyncActionType == ContactServerSyncActionType.WCT_UPDATE) {
                    this.contactServerOperationService.updateWCTModifyTimeForSync(accountGuid, contactServerSetting.getSupportContactServer(), syncInfo, contactServerSyncActionType);
                }
                lastContactServerModifyTimeForContactServer = syncInfo.getModifiedTime();
                this.dealWithContactServerResult(result, contactServerSyncActionType);
                if (currentCompleteCount % 50 == 0 && currentCompleteCount != 0) {
                    try {
                        contactServerSetting = this.accountPrivateSettingService.getContactServerSettings(accountGuid);
                        contactServerSetting = this.refreshTokenProcees(accountGuid, contactServerSetting, 45, client);
                    }
                    catch (ItemNotFoundException ex) {
                        break;
                    }
                }
                ++currentCompleteCount;
            }
            catch (Exception ex) {
                LOG.error("{}", (Throwable)ex);
                result.getFailedList().add(new ContactFailToExport("", ex.getMessage(), "", ""));
                if (ex != null && ex.getMessage() != null && ex.getMessage().contains("401")) break;
                LOG.debug("[SyncContactsOfAccountsWithContactServerJob]SyncContactFromContactServer fail(account guid:{}, CRM ID:{})", (Object)accountGuid, (Object)syncInfo.getContactServerId());
                LOG.debug("[SyncContactsOfAccountsWithContactServerJob]SyncContactFromContactServer fail:{}", (Throwable)ex);
            }
        }
        if (contactServerSetting.getSupportContactServer().equals((Object)SupportContactServer.OFFICE365) && office365SyncInfoWithDeltaLink != null && CollectionUtils.isNotEmpty(contactServerRecordsNeedSync) && CollectionUtils.isEmpty((Collection)result.getFailedList())) {
            this.accountPrivateSettingService.setOffice365DeltaLinkForSync(accountGuid, office365SyncInfoWithDeltaLink.getNewDeltaLink());
        }
        if (lastContactServerModifyTimeForContactServer != null) {
            this.accountPrivateSettingService.setContactServerSyncLastCompletedTimeForContactServer(accountGuid, lastContactServerModifyTimeForContactServer);
        }
        return result;
    }

    private void dealWithContactServerResult(ContactServerSyncResultContent result, ContactServerSyncActionType contactServerSyncActionType) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$scheduler$job$SyncContactsOfAccountsWithContactServerJob$ContactServerSyncActionType[contactServerSyncActionType.ordinal()]) {
            case 1: {
                result.increaseNumContactServerAdd();
                result.increaseNumSucceeded();
                break;
            }
            case 2: {
                result.increaseNumContactServerUpdate();
                result.increaseNumSucceeded();
                break;
            }
            case 3: {
                result.increaseNumContactServerDelete();
                result.increaseNumSucceeded();
                break;
            }
            case 4: {
                result.increaseNumWctAdd();
                result.increaseNumSucceeded();
                break;
            }
            case 5: {
                result.increaseNumWctUpdate();
                result.increaseNumSucceeded();
                break;
            }
            case 6: {
                result.increaseNumWctDelete();
                result.increaseNumSucceeded();
                break;
            }
        }
    }

    private ContactServerSyncActionType syncContactFromContactServer(ContactServerSyncInfoForContactServer syncInfoContactServer, String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, String office365ContactFolderId, CustomExchangeService exchangeService, String companyGuid, OkHttpClient client) throws Exception {
        String contactServerId = syncInfoContactServer.getContactServerId();
        if (syncInfoContactServer.isDeleted() && office365ContactFolderId != null) {
            syncInfoContactServer = this.contactServerOperationService.getRecordSyncInfo(accountGuid, contactServerId, contactServerSetting, office365ContactFolderId, exchangeService, false, client);
        }
        if (syncInfoContactServer.isDeleted()) {
            ContactServerSyncInfoForWCT syncInfoWCT = this.contactServerOperationService.getWctSyncInfoByCorrespondingContactServerSyncInfo(accountGuid, syncInfoContactServer, contactServerSetting);
            if (syncInfoWCT != null && !syncInfoWCT.isDeleted()) {
                this.contactPrivateService.updateCategoriesOfContact(syncInfoWCT.getContactGuid(), null, accountGuid, ListSetBehavior.REMOVE_ALL, null);
                this.contactServerOperationService.setExportContactServerInfo(accountGuid, syncInfoWCT.getContactGuid(), contactServerId, syncInfoContactServer.getSyncContacServerAccount(), syncInfoContactServer.getModifiedTime(), contactServerSetting);
                LOG.debug("[syncContactFromContactServer] WCT_DELETE, contactGuid={}", (Object)syncInfoWCT.getContactGuid());
                return ContactServerSyncActionType.WCT_DELETE;
            }
            LOG.debug("[syncContactFromContactServer] NONE, syncInfoWCT={}", (Object)syncInfoWCT);
            return ContactServerSyncActionType.NONE;
        }
        ContactServerSyncInfoForWCT syncInfoWCT = this.contactServerOperationService.getWctSyncInfoByCorrespondingContactServerSyncInfo(accountGuid, syncInfoContactServer, contactServerSetting);
        LOG.debug("corresponding contact contact server={}, syncInfoWCT={}", (Object)syncInfoContactServer, (Object)syncInfoWCT);
        if (syncInfoWCT == null) {
            ContactVoWithImageId contactCreationVoWithImageId = this.contactServerOperationService.getContactCreationVoByContactServerId(accountGuid, contactServerId, contactServerSetting, exchangeService, client);
            String contactGuid = this.contactPrivateService.createContact(contactCreationVoWithImageId.getContactCreationVo(), null, null, contactCreationVoWithImageId.getLogoImageFileGuid(), companyGuid);
            this.contactServerOperationService.setExportContactServerInfo(accountGuid, contactGuid, contactServerId, syncInfoContactServer.getSyncContacServerAccount(), syncInfoContactServer.getModifiedTime(), contactServerSetting);
            LOG.debug("[syncContactFromContactServer] WCT_ADD, contactGuid={}", (Object)contactGuid);
            return ContactServerSyncActionType.WCT_ADD;
        }
        if (!syncInfoWCT.isDeleted() && syncInfoContactServer.getModifiedTime().isAfter((ReadableInstant)syncInfoWCT.getPreviousContactServerModifiedTime()) && syncInfoContactServer.getModifiedTime().isAfter((ReadableInstant)syncInfoWCT.getModifiedTime())) {
            LOG.debug("wct update, syncInfoContactServer={}, syncInfoWCT={}", (Object)syncInfoContactServer, (Object)syncInfoWCT);
            ContactInfoVoForWCT originContact = this.contactPrivateService.getContactInfoVoForWCTByGuid(syncInfoWCT.getContactGuid(), accountGuid);
            ContactVoWithImageId contactUpdateVoWithImage = this.contactServerOperationService.getContactUpdateVoByContactServerId(syncInfoWCT, (ContactInfoForRequest)originContact, contactServerSetting, exchangeService, client);
            this.contactPrivateService.updateContact(contactUpdateVoWithImage.getContactUpdateVo(), accountGuid);
            this.contactServerOperationService.setExportContactServerInfo(accountGuid, syncInfoWCT.getContactGuid(), contactServerId, syncInfoContactServer.getSyncContacServerAccount(), syncInfoContactServer.getModifiedTime(), contactServerSetting);
            LOG.debug("[syncContactFromContactServer] WCT_UPDATE, contactGuid={}", (Object)syncInfoWCT.getContactGuid());
            return ContactServerSyncActionType.WCT_UPDATE;
        }
        if (syncInfoWCT.isDeleted()) {
            ContactInfoVoForWCT originContact = this.contactPrivateService.getContactInfoVoForWCTByGuid(syncInfoWCT.getContactGuid(), accountGuid);
            ContactVoWithImageId contactUpdateVoWithImage = this.contactServerOperationService.getContactUpdateVoByContactServerId(syncInfoWCT, (ContactInfoForRequest)originContact, contactServerSetting, exchangeService, client);
            this.contactPrivateService.downloadToPrivateAndUpdateContact(accountGuid, syncInfoWCT.getContactGuid(), contactUpdateVoWithImage.getContactUpdateVo());
            this.contactServerOperationService.setExportContactServerInfo(accountGuid, syncInfoWCT.getContactGuid(), contactServerId, syncInfoContactServer.getSyncContacServerAccount(), syncInfoContactServer.getModifiedTime(), contactServerSetting);
            LOG.debug("[syncContactFromContactServer] WCT_UPDATE, contactGuid={}", (Object)syncInfoWCT.getContactGuid());
            return ContactServerSyncActionType.WCT_ADD;
        }
        return ContactServerSyncActionType.NONE;
    }

    private ContactServerSyncResultContent exportContactInPrivate(String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, String office365ContactFolderId, CustomExchangeService exchangeService, DateTime lastSyncCompletedTimeForWCT, DateTime lastSyncCompletedTimeForContactServer, OkHttpClient client) {
        boolean isFirstTimeSync = lastSyncCompletedTimeForWCT == null || lastSyncCompletedTimeForWCT == GlobalUtils.getEarliestTime();
        List contactsNeedSync = this.contactServerOperationService.getWctSyncInfosByAccount(accountGuid, contactServerSetting, lastSyncCompletedTimeForWCT, isFirstTimeSync);
        LOG.debug("contactsNeedSyncForWCTSize={}", (Object)contactsNeedSync.size());
        LOG.debug("lastSyncCompletedTime={}, contactsNeedSync={}", (Object)lastSyncCompletedTimeForWCT, (Object)contactsNeedSync);
        ContactServerSyncResultContent result = new ContactServerSyncResultContent();
        DateTime modifyTime = null;
        int currentCompleteCount = 0;
        for (ContactServerSyncInfoForWCT syncInfo : contactsNeedSync) {
            String contactGuid = syncInfo.getContactGuid();
            try {
                ContactServerSyncActionType contactServerActionType = this.syncContactFromWCT(syncInfo, accountGuid, contactServerSetting, office365ContactFolderId, exchangeService, isFirstTimeSync, lastSyncCompletedTimeForWCT, lastSyncCompletedTimeForContactServer, client);
                modifyTime = syncInfo.getModifiedTime();
                this.dealWithContactServerResult(result, contactServerActionType);
                if (currentCompleteCount % 50 == 0 && currentCompleteCount != 0) {
                    try {
                        contactServerSetting = this.accountPrivateSettingService.getContactServerSettings(accountGuid);
                        contactServerSetting = this.refreshTokenProcees(accountGuid, contactServerSetting, 45, client);
                    }
                    catch (ItemNotFoundException ex) {
                        break;
                    }
                }
                ++currentCompleteCount;
            }
            catch (Exception ex) {
                ContactSimpleInfoDto infoDto = this.contactPrivateService.getSimpleContactDtoByGuid(contactGuid, accountGuid);
                result.getFailedList().add(new ContactFailToExport(contactGuid, ex.getMessage(), infoDto.getFullname(), infoDto.getCompany()));
                if (ex.getMessage().contains("401")) break;
                LOG.debug("[SyncContactsOfAccountsWithContactServerJob]SyncContactFromWCT fail(account guid:{}, contact guid:{})", (Object)accountGuid, (Object)contactGuid);
                LOG.debug("[SyncContactsOfAccountsWithContactServerJob]SyncContactFromWCT fail:{}", (Throwable)ex);
            }
        }
        if (modifyTime != null) {
            this.accountPrivateSettingService.setContactServerSyncLastCompletedTimeForWCT(accountGuid, modifyTime);
        }
        return result;
    }

    private ContactServerSyncActionType syncContactFromWCT(ContactServerSyncInfoForWCT syncInfoWCT, String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, String office365ContactFolderId, CustomExchangeService exchangeService, boolean isFirstTimeSync, DateTime lastSyncCompletedTimeForWCT, DateTime lastSyncCompletedTimeForContactServer, OkHttpClient client) throws Exception {
        ContactServerSyncInfoForContactServer syncInfoContactServer = null;
        if (syncInfoWCT.isDeleted()) {
            if (syncInfoWCT.isUpdatedByLastContactServerSync()) {
                LOG.debug("syncInfoWCT.getModifiedTime().isEqual(syncInfoWCT.getPreviousContactServerModifiedTime()) [SyncContactFromWCT] NONE: syncInfoWCT={}", (Object)syncInfoWCT);
                return ContactServerSyncActionType.NONE;
            }
            boolean executeDeleteOperation = this.contactServerOperationService.deleteRecord(contactServerSetting, syncInfoWCT.getContactServerId(), exchangeService, client);
            if (executeDeleteOperation) {
                LOG.debug("[SyncContactFromWCT] CONTACT_SERVER_DELETE: syncInfoWCT={}", (Object)syncInfoWCT);
                return ContactServerSyncActionType.CONTACT_SERVER_DELETE;
            }
            LOG.debug("[SyncContactFromWCT] NONE: syncInfoWCT={}", (Object)syncInfoWCT);
            return ContactServerSyncActionType.NONE;
        }
        syncInfoContactServer = this.getCorrespondingInContactServer(syncInfoWCT, accountGuid, contactServerSetting, office365ContactFolderId, exchangeService, isFirstTimeSync, client);
        LOG.debug("syncInfoContactServer={}", (Object)syncInfoContactServer);
        LOG.debug("syncInfoWCT={}", (Object)syncInfoWCT);
        boolean isContactUpdatedAfterLastSyncBothSides = false;
        if (syncInfoContactServer != null) {
            lastSyncCompletedTimeForWCT = lastSyncCompletedTimeForWCT == null ? GlobalUtils.getEarliestTime() : lastSyncCompletedTimeForWCT;
            DateTime dateTime = lastSyncCompletedTimeForContactServer = lastSyncCompletedTimeForContactServer == null ? GlobalUtils.getEarliestTime() : lastSyncCompletedTimeForContactServer;
            boolean bl = syncInfoWCT.getModifiedTime().isAfter((ReadableInstant)lastSyncCompletedTimeForWCT) && syncInfoContactServer.getModifiedTime().isAfter((ReadableInstant)lastSyncCompletedTimeForContactServer) && !syncInfoContactServer.getModifiedTime().equals((Object)(syncInfoWCT.getPreviousContactServerModifiedTime() == null ? GlobalUtils.getEarliestTime() : syncInfoWCT.getPreviousContactServerModifiedTime())) ? true : (isContactUpdatedAfterLastSyncBothSides = false);
        }
        if (syncInfoContactServer == null || syncInfoContactServer.isDeleted() && isFirstTimeSync || syncInfoContactServer.isDeleted() && !isContactUpdatedAfterLastSyncBothSides && syncInfoContactServer.getModifiedTime().isBefore((ReadableInstant)syncInfoWCT.getModifiedTime())) {
            ContactInfoForResponse contactInfo = this.contactPrivateService.getContactResponseInfoByGuid(syncInfoWCT.getContactGuid());
            this.contactServerOperationService.exportToContactServer(contactServerSetting, contactInfo, accountGuid, true, exchangeService, client);
            LOG.debug("[SyncContactFromWCT] CONTACT_SERVER_ADD, syncInfoWCT={}", (Object)syncInfoWCT);
            return ContactServerSyncActionType.CONTACT_SERVER_ADD;
        }
        if (!syncInfoContactServer.isDeleted() && !syncInfoWCT.isUpdatedByLastContactServerSync() && syncInfoWCT.getModifiedTime().isAfter((ReadableInstant)syncInfoContactServer.getModifiedTime())) {
            ContactInfoForResponse contactInfo = this.contactPrivateService.getContactResponseInfoByGuid(syncInfoWCT.getContactGuid());
            this.contactServerOperationService.updateContactToContactServer(contactServerSetting, syncInfoWCT.getContactServerId(), contactInfo, accountGuid, true, office365ContactFolderId, exchangeService, client);
            LOG.debug("[SyncContactFromWCT] CONTACT_SERVER_UPDATE, syncInfoWCT={}", (Object)syncInfoWCT);
            return ContactServerSyncActionType.CONTACT_SERVER_UPDATE;
        }
        LOG.debug("[SyncContactFromWCT] NONE, syncInfoWCT={}", (Object)syncInfoWCT);
        return ContactServerSyncActionType.NONE;
    }

    private ContactServerSyncInfoForContactServer getCorrespondingInContactServer(ContactServerSyncInfoForWCT syncInfoWCT, String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, String office365ContactFolderId, CustomExchangeService exchangeService, boolean isFirstTimeSync, OkHttpClient client) {
        if (StringUtils.isEmpty((CharSequence)syncInfoWCT.getContactServerId())) {
            return null;
        }
        try {
            ContactServerSyncInfoForContactServer syncInfoContactServer = this.contactServerOperationService.getRecordSyncInfo(accountGuid, syncInfoWCT.getContactServerId(), contactServerSetting, office365ContactFolderId, exchangeService, isFirstTimeSync, client);
            return syncInfoContactServer;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private ContactServerSettingsWithTokenDto refreshTokenProcees(String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, int minutes, OkHttpClient client) {
        SupportContactServer supportContactServer = contactServerSetting.getSupportContactServer();
        if (SupportContactServer.OFFICE365.equals((Object)supportContactServer)) {
            DateTime lastUpdateTokenTime = contactServerSetting.getLastUpdateTokenTime() == null ? GlobalUtils.getEarliestTime() : contactServerSetting.getLastUpdateTokenTime();
            DateTime now = DateTime.now();
            LOG.debug("lastUpdateTokenTime={}, now={}", (Object)lastUpdateTokenTime, (Object)now);
            if (now.isAfter((ReadableInstant)lastUpdateTokenTime.plusMinutes(minutes))) {
                ContactServerBasicToken basicToken = this.contactServerAuthService.refreshToken(supportContactServer, contactServerSetting.getBasicToken().getRefresh_token(), contactServerSetting.getSettingPlatform(), client);
                LOG.debug("refreshToken success basicToken={}", (Object)basicToken);
                this.accountPrivateSettingService.updateOffice365AuthInfo(accountGuid, new ContactServerSettingsWithTokenDto(contactServerSetting.getAccount(), basicToken, now, contactServerSetting.getSettingPlatform()));
                contactServerSetting.setBasicToken(basicToken);
                contactServerSetting.setLastUpdateTokenTime(now);
            }
        } else if (SupportContactServer.QCONTACTZ.equals((Object)supportContactServer)) {
            DateTime lastUpdateTokenTime = contactServerSetting.getLastUpdateTokenTime().plusMinutes(30);
            DateTime now = DateTime.now();
            if (now.isAfter((ReadableInstant)lastUpdateTokenTime)) {
                String refreshToken = this.contactServerAuthService.refreshQContactzAuthToken(contactServerSetting, client);
                ContactServerSettingsWithTokenDto settingsWithTokenDto = new ContactServerSettingsWithTokenDto();
                settingsWithTokenDto.setAccount(contactServerSetting.getAccount());
                settingsWithTokenDto.setQcontactzAccountId(contactServerSetting.getQcontactzAccountId());
                settingsWithTokenDto.setQcontactzAccountSid(contactServerSetting.getQcontactzAccountSid());
                settingsWithTokenDto.setQcontactzAuthToken(refreshToken);
                settingsWithTokenDto.setLastUpdateTokenTime(DateTime.now());
                settingsWithTokenDto.setSettingPlatform(contactServerSetting.getSettingPlatform());
                this.accountPrivateSettingService.updateQContactAuthInfo(accountGuid, settingsWithTokenDto);
                contactServerSetting.setQcontactzAuthToken(refreshToken);
                contactServerSetting.setLastUpdateTokenTime(now);
                LOG.debug("contactServerSetting lastUpdateTokenTime: {}", (Object)contactServerSetting.getLastUpdateTokenTime());
            }
        }
        return contactServerSetting;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

