/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.EmailType;
import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.mail.MailInfo;
import com.penpower.worldcard.team.mail.SystemInitialMainInfoBuilder;
import com.penpower.worldcard.team.mail.TSMCApplyAccountVertifyMailInfoBuilder;
import com.penpower.worldcard.team.scheduler.job.SendMailJob;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class SendMailJob
extends QuartzJobBean
implements InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(SendMailJob.class);
    private static final String INTERRUPT = "INTERRUPT";
    public static final String EMAIL_TYPE = "EMAIL_TYPE";
    public static final String SEND_EMAIL = "SEND_EMAIL";
    public static final String SEND_USERNAME = "SEND_USERNAME";
    public static final String SEND_LANGUAGECODE = "SEND_LANGUAGECODE";
    public static final String SEND_COMPANYGUID = "SEND_COMPANYGUID";
    public static final String ACTIVE_URL = "ACTIVE_URL";
    private JobExecutionContext thisContext;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private JavaMailSender javaMailSender;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.info("==============SendMailJob start===============");
        this.thisContext = context;
        try {
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            String emailTypeString = dataMap.getString(EMAIL_TYPE);
            EmailType emailType = EmailType.valueOf((String)emailTypeString);
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$EmailType[emailType.ordinal()]) {
                case 1: {
                    String email = dataMap.getString(SEND_EMAIL);
                    String username = dataMap.getString(SEND_USERNAME);
                    String languagecode = dataMap.getString(SEND_LANGUAGECODE);
                    String companyGuid = dataMap.getString(SEND_COMPANYGUID);
                    LOG.info("SendMailJob lang={}", (Object)languagecode);
                    LanguageCode languageCode = LanguageCode.valueOf((String)languagecode);
                    LOG.info("SendMailJob lang={}", (Object)languageCode);
                    this.SendSystemInitialMailtoRegister(email, username, companyGuid, languageCode);
                    break;
                }
                case 2: {
                    String email = dataMap.getString(SEND_EMAIL);
                    String username = dataMap.getString(SEND_USERNAME);
                    String activeUrl = dataMap.getString(ACTIVE_URL);
                    String companyGuid = dataMap.getString(SEND_COMPANYGUID);
                    this.SendTSMCVertiryApplyAccountMail(email, username, activeUrl, companyGuid);
                }
            }
        }
        catch (Exception e) {
            LOG.error("SendMailJob error" + e.getMessage());
        }
        LOG.info("==============SendMailJob end===============");
    }

    void SendTSMCVertiryApplyAccountMail(String email, String userName, String ActiveUrl, String companyGuid) {
        try {
            TSMCApplyAccountVertifyMailInfoBuilder mailInfoBuilder = new TSMCApplyAccountVertifyMailInfoBuilder(userName, ActiveUrl, LanguageCode.TW);
            MailInfo TSMCApplyAccountVertifyMail = mailInfoBuilder.createMailInfo();
            LOG.debug("Check mail info : \n {}", (Object)TSMCApplyAccountVertifyMail);
            Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SMTP_MAIL_SETTING", companyGuid);
            String MailSetJson = "";
            if (globalinfocompany != null) {
                MailSetJson = globalinfocompany.getConfigValue();
            }
            LOG.error("sendMail MailSetJson = {}", (Object)MailSetJson);
            GlobalUtils.sendMail((String)email, (String)TSMCApplyAccountVertifyMail.getMailSubject(), (String)TSMCApplyAccountVertifyMail.getStringMailBody(), (String)"text/html;charset=utf-8", (String)MailSetJson);
        }
        catch (Exception ex) {
            LOG.error("Fail to send mail ={} ", (Throwable)ex);
        }
    }

    void SendSystemInitialMailtoRegister(String email, String userName, String companyGuid, LanguageCode languageCode) {
        try {
            SystemInitialMainInfoBuilder mailInfoBuilder = new SystemInitialMainInfoBuilder(userName, email, languageCode);
            MailInfo systemInitialMailInfo = mailInfoBuilder.createMailInfo();
            LOG.debug("Check mail info : \n {}", (Object)systemInitialMailInfo);
            Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SMTP_MAIL_SETTING", companyGuid);
            String MailSetJson = "";
            if (globalinfocompany != null) {
                MailSetJson = globalinfocompany.getConfigValue();
            }
            LOG.error("sendMail MailSetJson = {}", (Object)MailSetJson);
            GlobalUtils.sendMail((String)email, (String)systemInitialMailInfo.getMailSubject(), (String)systemInitialMailInfo.getStringMailBody(), (String)"text/html;charset=utf-8", (String)MailSetJson);
        }
        catch (Exception ex) {
            LOG.error("Fail to send mail ={} ", (Throwable)ex);
        }
    }

    private boolean isInterrupted() {
        return this.thisContext.getJobDetail().getJobDataMap().containsKey((Object)INTERRUPT) && (Boolean)this.thisContext.getJobDetail().getJobDataMap().get((Object)INTERRUPT) != false;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

