/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.TempStoredDataType;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.service.AccountShareTargetService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SendBeSharedNoticeToAccountJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(SendBeSharedNoticeToAccountJob.class);
    public static final String SHARE_ACCOUNT_GUID = "SHARE_ACCOUNT_GUID";
    public static final String BESHARED_ACCOUNT_GUID = "BESHARED_ACCOUNT_GUID";
    @Autowired
    private AccountShareTargetService accountShareTargetService;
    @Autowired
    private NoticeService noticeService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String shareAccountGuid = dataMap.getString(SHARE_ACCOUNT_GUID);
        String beSharedAccountGuid = dataMap.getString(BESHARED_ACCOUNT_GUID);
        TempStoredDataType itemType = TempStoredDataType.CONTACT;
        List itemGuids = this.accountShareTargetService.getSharedItemGuids(shareAccountGuid, beSharedAccountGuid, itemType);
        ArrayList copyedItemGuids = new ArrayList(itemGuids);
        while (!CollectionUtils.isEmpty(copyedItemGuids)) {
            List headList = copyedItemGuids.subList(0, Math.min(copyedItemGuids.size(), 300));
            ListRequestVo noticeContentModel = new ListRequestVo();
            noticeContentModel.setList(headList);
            this.noticeService.addNewNotice(NotifyCategory.CONTACT, NotifyType.CONTACT_BESHARED, GlobalUtils.getJsonString((Object)noticeContentModel), beSharedAccountGuid, shareAccountGuid);
            copyedItemGuids.removeAll(headList);
        }
        LOG.debug("[SendBeSharedNoticeToAccountJob]shareAccountGuid: {},beSharedAccountGuid: {}", (Object)shareAccountGuid, (Object)beSharedAccountGuid);
        this.accountShareTargetService.removeSharedItems(shareAccountGuid, beSharedAccountGuid, itemType, itemGuids);
    }
}

