/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.CollectionUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.config.ApplicationConfig;
import com.penpower.worldcard.team.config.elasticsearch.ElasticSearchProperties;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.CustomFieldDao;
import com.penpower.worldcard.team.dto.WctInfo;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.entity.Searchengineindexingevent;
import com.penpower.worldcard.team.enums.CustomFieldCategory;
import com.penpower.worldcard.team.enums.CustomFieldContactAttribute;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.SearchEngineIndexMissingException;
import com.penpower.worldcard.team.exception.SearchEngineNotRunningException;
import com.penpower.worldcard.team.exception.SearchEngineSpaceInsufficientException;
import com.penpower.worldcard.team.mail.MailInfo;
import com.penpower.worldcard.team.mail.SearchEngineFailedMailInfoBuilder;
import com.penpower.worldcard.team.notice.content.SearchEngineDiskSpaceInfoChangedContent;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.scheduler.job.RebuildElasticsearchIndexJob;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ElasticSearchService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SearchEngineIndexingEventService;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.ConnectException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.elasticsearch.client.RestHighLevelClient;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class RebuildElasticsearchIndexJob
extends AbstractInterruptJob {
    public static final String DEFAULT_QUARTZ_GROP_NAME = "REBUILD_ELASTICSEARCH_INDEX";
    private static final Logger LOG = LoggerFactory.getLogger(RebuildElasticsearchIndexJob.class);
    private static final String SPACE_INSUFFICIENT_INDEX_READ_ONLY_FAILURE_REASON = "FORBIDDEN/12/index read-only";
    private static final String INDEX = "contact";
    private static final int SEARCH_ENGINE_RETRY_CONNECTION_WAITING_TIME_SECONDS = 30;
    private static final int SEARCH_ENGINE_CHECK_DISK_SPACE_WAITING_TIME_SECONDES = 30;
    private static final int ELASTIC_SEARCH_UPDATE_INDEX_FREQUENCY_SECONDS = 2;
    public static final AtomicBoolean CURRENT_DISK_SPACE_INSUFFICIENT = new AtomicBoolean(false);
    public static final AtomicBoolean DISK_SPACE_INFO_CHANGED = new AtomicBoolean(false);
    public static final AtomicInteger SEARCH_ENGINE_FAILED_COUNTER = new AtomicInteger(0);
    private static final int NEED_TO_SEND_MAIL_COUNT_PERIOD = 100;
    private static final String DEFAULT_SEARCH_ENGINE_FAILED_MAIL_TARGET = "cloud_team@penpower.com.tw";
    private static ReentrantLock lock = new ReentrantLock();
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ElasticSearchService elasticSearchService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    @Qualifier(value="searchEngineIndex")
    private String searchEngineIndex;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private ServletContext context;
    @Autowired
    private SearchEngineIndexingEventService searchEngineIndexingEventService;
    private String elasticSearchLastEventCompleteInfoKey;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        boolean isPublicCloud;
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("ELASTIC_SEARCH_INDEXING_COMPLETE");
        ServerType serverType = this.registryService.GetServerType();
        boolean bl = isPublicCloud = serverType.equals((Object)ServerType.ASUSTOR_NAS_AUTOMATION) || serverType.equals((Object)ServerType.ASUSTOR_NAS_Cloud) || serverType.equals((Object)ServerType.Linux_Server_Cloud) || serverType.equals((Object)ServerType.Google_Linux_Server_Cloud);
        while (!this.elasticSearchServerExist() && !this.interrupted()) {
            try {
                if (isPublicCloud) {
                    if (SEARCH_ENGINE_FAILED_COUNTER.get() % 100 == 0) {
                        this.sendMailProcess("Cannot connect to search engine");
                    }
                    this.incrementFailedCount();
                }
                LOG.error(String.format("SearchEngine not running, system will retry connection after %d seconds", 30));
                Thread.sleep(30000L);
            }
            catch (Exception exception) {}
        }
        boolean indexCompleteForWCT = Boolean.parseBoolean(globalInfo.getConfigValue());
        boolean indexExistInElasticSearch = this.elasticSearchIndexExist("v_1.0.0");
        WctIndexingBehavior behavior = this.getElasticSearchIndexingBehavior(indexCompleteForWCT, indexExistInElasticSearch);
        WctIndexingMode currentMode = WctIndexingMode.INDEXING_MODE;
        do {
            try {
                boolean indexingComplete;
                if (WctIndexingMode.INDEXING_MODE.equals((Object)currentMode) && (indexingComplete = this.enterIndexingMode(behavior, globalInfo.getGuid()))) {
                    currentMode = WctIndexingMode.MONITORING_MODE;
                }
                if (!WctIndexingMode.MONITORING_MODE.equals((Object)currentMode)) continue;
                this.enterMonitoringMode();
            }
            catch (SearchEngineNotRunningException ex) {
                LOG.info(ex.getMessage());
                LOG.info(String.format("System will retry connection after %d seconds", 30));
                if (isPublicCloud) {
                    if (SEARCH_ENGINE_FAILED_COUNTER.get() % 100 == 0) {
                        this.sendMailProcess(ex.getMessage());
                    }
                    this.incrementFailedCount();
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (SearchEngineSpaceInsufficientException ex) {
                LOG.debug(ex.getMessage());
                behavior = WctIndexingBehavior.INDEX_UNFINISHED_CONTACT;
                if (DISK_SPACE_INFO_CHANGED.get()) {
                    String diskSpaceInfoChangedContent = GlobalUtils.getJsonString((Object)new SearchEngineDiskSpaceInfoChangedContent(CURRENT_DISK_SPACE_INSUFFICIENT.get()));
                    this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.SEARCH_ENGINE_DISK_SPACE_INFO_CHANGED, diskSpaceInfoChangedContent, null, "");
                    DISK_SPACE_INFO_CHANGED.set(false);
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (SearchEngineIndexMissingException ex) {
                LOG.info(ex.getMessage());
                behavior = WctIndexingBehavior.INDEX_ALL_CONTACT;
                currentMode = WctIndexingMode.INDEXING_MODE;
            }
            catch (Exception e) {
                LOG.info("Elasticsearch job unspecified exception occurs:{}", (Throwable)e);
                LOG.debug("=============== Stop rebuildElasticSearch job ===============");
                if (isPublicCloud) {
                    if (SEARCH_ENGINE_FAILED_COUNTER.get() % 100 == 0) {
                        this.sendMailProcess(e.getMessage());
                    }
                    this.incrementFailedCount();
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!this.interrupted());
    }

    private Globalinfo getElasticSearchLastEventCompleteInfo() {
        try {
            Globalinfo elasticSearchSyncCompleteTimeInfo = this.globalInfoService.getPropertiesByKey(this.elasticSearchLastEventCompleteInfoKey);
            return elasticSearchSyncCompleteTimeInfo;
        }
        catch (Exception ex) {
            throw new SearchEngineNotRunningException(ex.getMessage());
        }
    }

    private void incrementFailedCount() {
        if (SEARCH_ENGINE_FAILED_COUNTER.get() == Integer.MAX_VALUE) {
            SEARCH_ENGINE_FAILED_COUNTER.set(0);
        } else {
            SEARCH_ENGINE_FAILED_COUNTER.incrementAndGet();
        }
    }

    private void sendMailProcess(String failedMessage) {
        if (!HardwareIdUtil.linuxSystem()) {
            LOG.error("It's not linux system, mail won't send, failedMessage:{}", (Object)failedMessage);
            return;
        }
        try {
            Path wctServerInfoPath = Paths.get(this.context.getRealPath(""), new String[0]).getParent();
            Gson gson = new Gson();
            WctInfo wctInfo = null;
            LOG.debug("getCloudDbName wctServerInfoPath {}", (Object)wctServerInfoPath);
            if (Files.exists(wctServerInfoPath, new LinkOption[0])) {
                Path wctInfoFile = wctServerInfoPath.resolve("wct_info.json");
                LOG.debug("getCloudDbName wctInfoFile {}", (Object)wctInfoFile);
                try (FileReader fr2 = new FileReader(wctInfoFile.toFile());){
                    wctInfo = (WctInfo)gson.fromJson((Reader)fr2, WctInfo.class);
                    LOG.debug("getCloudDbName wctInfo {}", (Object)wctInfo);
                }
                catch (IOException fr2) {
                    // empty catch block
                }
            }
            SearchEngineFailedMailInfoBuilder mailInfoBuilder = new SearchEngineFailedMailInfoBuilder(failedMessage, wctInfo);
            MailInfo searchEngineFailedMailInfo = mailInfoBuilder.createMailInfo();
            LOG.debug("Check mail info : \n {}", (Object)searchEngineFailedMailInfo);
            GlobalUtils.sendMail((String)DEFAULT_SEARCH_ENGINE_FAILED_MAIL_TARGET, (String)searchEngineFailedMailInfo.getMailSubject(), (String)searchEngineFailedMailInfo.getStringMailBody(), (String)"text/html;charset=utf-8", (String)"");
        }
        catch (Exception ex) {
            LOG.error("Fail to send mail ", (Throwable)ex);
        }
    }

    private void enterMonitoringMode() throws SearchEngineSpaceInsufficientException, SearchEngineNotRunningException, SearchEngineIndexMissingException, IOException {
        LOG.info("===================== Enter monitoringMode =====================");
        do {
            int contactIndexingNumber;
            if ((contactIndexingNumber = this.indexContact().getContactIndexingNumber()) != 0) {
                LOG.debug("contactIndexingNumber:{}", (Object)contactIndexingNumber);
            } else {
                if (!this.elasticSearchServerExist()) {
                    throw new SearchEngineNotRunningException("Search engine not running.");
                }
                if (!this.elasticSearchIndexExist("v_1.0.0")) {
                    throw new SearchEngineIndexMissingException("Search engine index is missing.");
                }
                if (this.getElasticSearchLastEventCompleteInfo() == null) {
                    throw new SearchEngineIndexMissingException("Search engine global info index is missing.");
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.interrupted());
    }

    private boolean enterIndexingMode(WctIndexingBehavior behavior, String globalInfoGuid) throws SearchEngineSpaceInsufficientException, SearchEngineNotRunningException, SearchEngineIndexMissingException, IOException {
        LOG.info("===================== Enter indexingMode =====================");
        LOG.info("Indexing started at:{}, WctIndexingBehavior:{}", (Object)DateTime.now(), (Object)behavior);
        int indexingContactNumber = 0;
        while (behavior != WctIndexingBehavior.COMPLETED) {
            if (WctIndexingBehavior.INDEX_ALL_CONTACT.equals((Object)behavior)) {
                this.elasticSearchSettingInitize();
                int count = this.globalInfoService.countElasticSearchLastCompleteInfoProperties();
                if (count < 2) {
                    this.globalInfoService.updatePropertyValue(globalInfoGuid, "false");
                }
                behavior = this.indexAllContact().getBehavior();
            }
            if (WctIndexingBehavior.INDEX_UNFINISHED_CONTACT.equals((Object)behavior)) {
                LOG.info("Index_unfinished_contact");
                IndexingStatus indexingStatus = this.indexContact();
                behavior = indexingStatus.getBehavior();
                if ((indexingContactNumber += indexingStatus.getContactIndexingNumber()) % 1000 == 0 || WctIndexingBehavior.COMPLETED.equals((Object)behavior)) {
                    LOG.debug("indexContactNumber:{}, time:{}", (Object)indexingContactNumber, (Object)DateTime.now());
                }
            }
            if (!this.interrupted()) continue;
        }
        LOG.info("Indexing finished at:{}, totalIndexingContact:{}", (Object)DateTime.now(), (Object)indexingContactNumber);
        if (WctIndexingBehavior.COMPLETED.equals((Object)behavior)) {
            this.globalInfoService.updatePropertyValue(globalInfoGuid, "true");
            return true;
        }
        return false;
    }

    private boolean elasticSearchServerExist() {
        try {
            this.elasticSearchLastEventCompleteInfoKey = "ELASTIC_SEARCH_LAST_COMPLETE_EVENT_TIME_" + this.client.info(new Header[0]).getClusterUuid();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private WctIndexingBehavior getElasticSearchIndexingBehavior(boolean indexCompleteForWCT, boolean indexExistInElasticSearch) {
        if (!indexExistInElasticSearch || this.getElasticSearchLastEventCompleteInfo() == null) {
            return WctIndexingBehavior.INDEX_ALL_CONTACT;
        }
        if (!indexCompleteForWCT) {
            return WctIndexingBehavior.INDEX_UNFINISHED_CONTACT;
        }
        return WctIndexingBehavior.COMPLETED;
    }

    private IndexingStatus indexAllContact() throws SearchEngineSpaceInsufficientException, SearchEngineIndexMissingException, SearchEngineNotRunningException, IOException {
        DateTime indexAllContactsStartTime = DateTime.now();
        int page = 0;
        Page needToReindexPagedContactGuids = this.contactDao.getLastContactGuids((Pageable)new PageRequest(page, 100));
        List needToReindexContactGuids = needToReindexPagedContactGuids.getContent();
        if (CollectionUtil.collectionEmpty((Collection)needToReindexContactGuids)) {
            return new IndexingStatus(this, WctIndexingBehavior.INDEX_UNFINISHED_CONTACT, 0);
        }
        int totalCount = needToReindexContactGuids.size();
        this.updateElasticSearchIndex(needToReindexContactGuids);
        while (needToReindexPagedContactGuids.hasNext()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            needToReindexPagedContactGuids = this.contactDao.getLastContactGuids((Pageable)new PageRequest(++page, 100));
            needToReindexContactGuids = needToReindexPagedContactGuids.getContent();
            this.updateElasticSearchIndex(needToReindexContactGuids);
            totalCount += needToReindexContactGuids.size();
        }
        Globalinfo elasticSearchLastEventCompleteInfo = this.getElasticSearchLastEventCompleteInfo();
        if (elasticSearchLastEventCompleteInfo == null) {
            this.globalInfoService.createNewProperties(this.elasticSearchLastEventCompleteInfoKey, indexAllContactsStartTime.toString("yyyy-MM-dd HH:mm:ss.SSS"));
        } else {
            this.globalInfoService.updatePropertyValue(elasticSearchLastEventCompleteInfo.getGuid(), indexAllContactsStartTime.toString("yyyy-MM-dd HH:mm:ss.SSS"));
        }
        return new IndexingStatus(this, WctIndexingBehavior.INDEX_UNFINISHED_CONTACT, totalCount);
    }

    private void updateElasticSearchIndex(List<String> needToReindexContactGuids) throws SearchEngineSpaceInsufficientException, SearchEngineIndexMissingException, SearchEngineNotRunningException, IOException {
        LOG.debug("needToReindexContactGuids={}", needToReindexContactGuids);
        List contacts = this.contactPrivateService.getContactForEsByContactGuids(needToReindexContactGuids);
        this.elasticSearchService.updateEsContact(contacts);
    }

    private IndexingStatus indexContact() throws SearchEngineSpaceInsufficientException, SearchEngineIndexMissingException, SearchEngineNotRunningException, IOException {
        Globalinfo elasticSearchLastEventCompleteInfo = this.getElasticSearchLastEventCompleteInfo();
        if (elasticSearchLastEventCompleteInfo == null) {
            LOG.error("globalinfo key not exist={}", (Object)this.elasticSearchLastEventCompleteInfoKey);
            this.globalInfoService.createNewProperties(this.elasticSearchLastEventCompleteInfoKey, GlobalUtils.getEarliestTime().toString("yyyy-MM-dd HH:mm:ss.SSS"));
            throw new SearchEngineIndexMissingException("elasticSearchLastEventCompleteInfo is null");
        }
        DateTime elasticSearchLastEventCompleteTime = DateTime.parse((String)elasticSearchLastEventCompleteInfo.getConfigValue(), (DateTimeFormatter)ApplicationConfig.DATE_TIME_FORMATTER);
        Page indexingPagedEvent = this.searchEngineIndexingEventService.getSearchEngineIndexingEventAfterSpecificTime(elasticSearchLastEventCompleteTime, new PageRequest(0, 500));
        int contextIndexingNumber = 0;
        for (Searchengineindexingevent searchengineindexingevent : indexingPagedEvent.getContent()) {
            List<Object> needToReindexContactGuids = Arrays.asList((Object[])new Gson().fromJson(searchengineindexingevent.getContactList(), String[].class));
            this.updateElasticSearchIndex(needToReindexContactGuids);
            contextIndexingNumber += needToReindexContactGuids.size();
            this.globalInfoService.updatePropertyValue(elasticSearchLastEventCompleteInfo.getGuid(), searchengineindexingevent.getCreatedtime().toString("yyyy-MM-dd HH:mm:ss.SSS"));
        }
        if (contextIndexingNumber == 0) {
            return new IndexingStatus(this, WctIndexingBehavior.COMPLETED, 0);
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.debug("contextIndexingNumber={}", (Object)contextIndexingNumber);
        return new IndexingStatus(this, WctIndexingBehavior.INDEX_UNFINISHED_CONTACT, contextIndexingNumber);
    }

    private void elasticSearchSettingInitize() throws SearchEngineSpaceInsufficientException, SearchEngineNotRunningException, IOException {
        block6: {
            try {
                try {
                    this.elasticSearchService.removeAllIndex();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HttpEntity indexInitialSetting = ElasticSearchProperties.getIndexInitialSetting();
                HttpEntity indexMappingSetting = ElasticSearchProperties.getIndexMappingSetting();
                HttpEntity customFieldMappingSetting = this.getCustomFieldMappingSetting();
                this.client.getLowLevelClient().performRequest("PUT", this.searchEngineIndex, Collections.emptyMap(), indexInitialSetting, new Header[0]);
                this.client.getLowLevelClient().performRequest("PUT", this.searchEngineIndex + "/" + "v_1.0.0" + "/_mapping/", Collections.emptyMap(), indexMappingSetting, new Header[0]);
                if (customFieldMappingSetting != null) {
                    this.client.getLowLevelClient().performRequest("PUT", this.searchEngineIndex + "/" + "v_1.0.0" + "/_mapping/", Collections.emptyMap(), customFieldMappingSetting, new Header[0]);
                }
            }
            catch (ConnectException ex) {
                throw new SearchEngineNotRunningException("Search engine not running.");
            }
            catch (IOException ex) {
                if (!ex.getMessage().contains(SPACE_INSUFFICIENT_INDEX_READ_ONLY_FAILURE_REASON)) break block6;
                this.elasticSearchService.handleSearchEngineReadOnlyException();
            }
        }
    }

    private HttpEntity getCustomFieldMappingSetting() throws IOException {
        List customFieldTextTypeGuids = this.customFieldDao.findGuidsByCustomfieldcategoryAndType(CustomFieldCategory.CONTACT, Arrays.asList(CustomFieldContactAttribute.TEXT, CustomFieldContactAttribute.EMAIL, CustomFieldContactAttribute.URL, CustomFieldContactAttribute.PICKLIST));
        List customFieldNumberTypeGuids = this.customFieldDao.findGuidsByCustomfieldcategoryAndType(CustomFieldCategory.CONTACT, Arrays.asList(CustomFieldContactAttribute.FLOAT, CustomFieldContactAttribute.NUMBER));
        if (CollectionUtil.collectionEmpty((Collection)customFieldTextTypeGuids) && CollectionUtil.collectionEmpty((Collection)customFieldNumberTypeGuids)) {
            return null;
        }
        return ElasticSearchProperties.getCustomFieldMappingSetting((List)customFieldTextTypeGuids, (List)customFieldNumberTypeGuids);
    }

    private boolean elasticSearchIndexExist(String version) {
        try {
            this.client.getLowLevelClient().performRequest("GET", this.searchEngineIndex + "/_mapping/" + version, Collections.emptyMap(), new Header[0]);
            return true;
        }
        catch (IOException ex) {
            LOG.debug(ex.getMessage());
            return false;
        }
    }

    public static final void changeCurrentDiskSpaceInsufficientValue(boolean currentDiskSpaceInsufficient) {
        lock.lock();
        try {
            if (CURRENT_DISK_SPACE_INSUFFICIENT.get() != currentDiskSpaceInsufficient) {
                LOG.debug("Change currentDiskSpaceInsufficient from [{}] to [{}]", (Object)CURRENT_DISK_SPACE_INSUFFICIENT.get(), (Object)currentDiskSpaceInsufficient);
                CURRENT_DISK_SPACE_INSUFFICIENT.set(currentDiskSpaceInsufficient);
                DISK_SPACE_INFO_CHANGED.set(true);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

