/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.contactsystem.ContactServerBasicToken;
import com.penpower.worldcard.team.contactsystem.CustomExchangeService;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactServerSettingsDtoFull;
import com.penpower.worldcard.team.dto.ContactServerSettingsWithTokenDto;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.SupportContactServer;
import com.penpower.worldcard.team.notice.content.CrmExportResultContent;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactServerAuthService;
import com.penpower.worldcard.team.service.ContactServerOperationService;
import com.penpower.worldcard.team.service.ExchangeOperationService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.Office365OperationService;
import com.penpower.worldcard.team.web.api.vo.ContactFailToExport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import okhttp3.OkHttpClient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ExportContactToContactServerJob
extends QuartzJobBean
implements InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(ExportContactToContactServerJob.class);
    public static final String EXPORT_CONTACT_GUIDS = "EXPORT_CONTACT_GUIDS";
    public static final String EXPORT_ACCOUNT_GUID = "EXPORT_ACCOUNT_GUID";
    public static final String EXPORT_IS_SEND_NOTICE = "EXPORT_IS_SEND_NOTICE";
    public static final String EXPORT_COMPANY_GUID = "EXPORT_COMPANY_GUID";
    private static final String INTERRUPT = "INTERRUPT";
    private JobExecutionContext thisContext;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ContactServerOperationService contactServerOperationService;
    @Autowired
    private ContactServerAuthService contactServerAuthService;
    @Autowired
    private ExchangeOperationService exchangeOperationService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private Office365OperationService office365OperationService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        this.thisContext = context;
        LOG.info("================================================ExportContactToContactServerJob start({})==============================", (Object)Thread.currentThread().getName());
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        List contactGuids = (List)dataMap.get((Object)EXPORT_CONTACT_GUIDS);
        String accountGuid = dataMap.getString(EXPORT_ACCOUNT_GUID);
        String companyGuid = dataMap.getString(EXPORT_COMPANY_GUID);
        boolean isSendNotice = dataMap.getBooleanValue(EXPORT_IS_SEND_NOTICE);
        ContactServerSettingsWithTokenDto contactServerSetting = this.accountPrivateSettingService.getContactServerSettings(accountGuid);
        LOG.debug("Check accessToken...");
        OkHttpClient client = this.companyGlobalInfoService.getOKHttpClientWithProxy(companyGuid);
        try {
            contactServerSetting = this.refreshTokenProcees(accountGuid, contactServerSetting, client);
        }
        catch (Exception ex) {
            LOG.error("Refresh toekn failed", (Throwable)ex);
        }
        ArrayList failedExportReasonList = new ArrayList();
        try (CustomExchangeService exchangeService = null;){
            exchangeService = this.exchangeOperationService.getExchangeCredentialOfService((ContactServerSettingsDtoFull)contactServerSetting);
            boolean isInterrupted = this.manualExportContactsToContactServer(accountGuid, contactGuids, failedExportReasonList, contactServerSetting, exchangeService, client);
            if (isSendNotice) {
                if (isInterrupted) {
                    this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.CONTACT_EXPORTED_CANCELED, "Export process is interrupted.", accountGuid, null);
                } else {
                    int numSucceed = contactGuids.size() - failedExportReasonList.size();
                    CrmExportResultContent noticeModel = new CrmExportResultContent(numSucceed, failedExportReasonList);
                    this.noticeService.addNewNotice(NotifyCategory.SYSTEM, NotifyType.CONTACT_EXPORTED_TO_CONTACT_SERVER, GlobalUtils.getJsonString((Object)noticeModel), accountGuid, null);
                }
            }
        }
        LOG.debug("================================================ExportContactsToCrmJob end({})==============================", (Object)Thread.currentThread().getName());
    }

    private boolean manualExportContactsToContactServer(String accountGuid, List<String> contactGuids, List<ContactFailToExport> failedExportReasonList, ContactServerSettingsWithTokenDto contactServerSetting, CustomExchangeService exchangeService, OkHttpClient client) {
        for (String contactGuid : contactGuids) {
            LOG.debug("[manualExportContactsToContactServer] (Contact: {}) Before check isInterrupted()", (Object)contactGuid);
            if (this.isInterrupted()) {
                return true;
            }
            ContactInfoForResponse contactInfo = null;
            try {
                contactInfo = this.contactPrivateService.getContactResponseInfoByGuid(contactGuid);
                LOG.debug("[manualExportContactsToContactServer] (Contact: {}) After getContactResponseInfoByGuid()", (Object)contactGuid);
                String contactServerId = this.contactServerOperationService.getExportContactServerId(accountGuid, contactGuid, contactServerSetting.getSupportContactServer());
                if (StringUtils.isEmpty((CharSequence)contactServerId)) {
                    LOG.debug("[manualExportContactsToContactServer] (Contact: {}) exportToContactServer()", (Object)contactGuid);
                    this.contactServerOperationService.exportToContactServer(contactServerSetting, contactInfo, accountGuid, false, exchangeService, client);
                } else {
                    LOG.debug("[manualExportContactsToContactServer] (Contact: {}) updateContactToContactServer()", (Object)contactGuid);
                    String office365ContactFolderId = this.office365OperationService.findContactFolderId(contactServerSetting, client);
                    this.contactServerOperationService.updateContactToContactServer(contactServerSetting, contactServerId, contactInfo, accountGuid, false, office365ContactFolderId, exchangeService, client);
                }
                LOG.debug("[manualExportContactsToContactServer] (Contact: {}) Complete export/update ContactServer", (Object)contactGuid);
            }
            catch (Exception ex) {
                List names;
                ContactSimpleInfoDto infoDto = this.contactPrivateService.getSimpleContactDtoByGuid(contactGuid, accountGuid);
                ContactFailToExport failReason = new ContactFailToExport(contactGuid, ex.getMessage(), infoDto.getFullname(), infoDto.getCompany());
                failedExportReasonList.add(failReason);
                String contactname = "";
                List list = names = contactInfo == null ? null : contactInfo.getNames();
                if (!CollectionUtils.isEmpty((Collection)names)) {
                    ContactnameInfo name = (ContactnameInfo)names.get(0);
                    contactname = name.getFirstName() + " " + name.getLastName();
                }
                LOG.error("[manualExportContactsToContactServer failed] (Contact: {}) {}", (Object)contactname, (Object)ex.getMessage());
            }
        }
        return false;
    }

    private ContactServerSettingsWithTokenDto refreshTokenProcees(String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, OkHttpClient client) {
        SupportContactServer supportContactServer = contactServerSetting.getSupportContactServer();
        if (SupportContactServer.OFFICE365.equals((Object)supportContactServer)) {
            DateTime lastUpdateTokenTime = contactServerSetting.getLastUpdateTokenTime() == null ? GlobalUtils.getEarliestTime() : contactServerSetting.getLastUpdateTokenTime();
            DateTime now = DateTime.now();
            LOG.debug("lastUpdateTokenTime={}, now={}", (Object)lastUpdateTokenTime, (Object)now);
            if (now.isAfter((ReadableInstant)lastUpdateTokenTime.plusMinutes(20))) {
                LOG.info("settingPlatform={}", (Object)contactServerSetting.getSettingPlatform());
                ContactServerBasicToken basicToken = this.contactServerAuthService.refreshToken(supportContactServer, contactServerSetting.getBasicToken().getRefresh_token(), contactServerSetting.getSettingPlatform(), client);
                LOG.debug("refreshToken success basicToken={}", (Object)basicToken);
                this.accountPrivateSettingService.updateOffice365AuthInfo(accountGuid, new ContactServerSettingsWithTokenDto(contactServerSetting.getAccount(), basicToken, now, contactServerSetting.getSettingPlatform()));
                contactServerSetting.setBasicToken(basicToken);
                contactServerSetting.setLastUpdateTokenTime(now);
            }
        }
        return contactServerSetting;
    }

    private boolean isInterrupted() {
        return this.thisContext.getJobDetail().getJobDataMap().containsKey((Object)INTERRUPT) && (Boolean)this.thisContext.getJobDetail().getJobDataMap().get((Object)INTERRUPT) != false;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

