/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.auth.TokenManager;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.scheduler.job.DailyCheckRegisterJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.SubscriptionService;
import java.util.List;
import org.joda.time.DateTime;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DeleteImageforPeriodJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(DailyCheckRegisterJob.class);
    @Autowired
    AccountService accountService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private CompanyService companyService;
    @Value(value="${KeepContactImage}")
    private String keepContactImage;

    public boolean KeepContactImage() {
        LOG.debug("keepContactImage={}", (Object)this.keepContactImage);
        return this.keepContactImage.compareToIgnoreCase("false") != 0;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.error("DeleteImageforPeriodJob start");
        if (this.KeepContactImage()) {
            LOG.error("DeleteImageforPeriodJob escape");
            return;
        }
        DateTime timeline = DateTime.now().minusHours(2);
        this.contactPrivateService.ClearContactImageBefore(timeline);
        DateTime DateTimeNow = DateTime.now();
        List companys = this.companyService.FindAllCompany();
        if (companys.size() > 1 || companys.size() == 0) {
            return;
        }
        Company tsmc = (Company)companys.get(0);
        String lastSyncTimeString = GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"TSMC_LAST_SYNC_TIME", (String)tsmc.getGuid());
        LOG.debug("DeleteImageforPeriodJob lastSyncTimeString ={}", (Object)lastSyncTimeString);
        if (!StringUtil.IsStringNullorEmpty((String)lastSyncTimeString)) {
            DateTime lastcheckpasstime = DateTime.parse((String)lastSyncTimeString);
            DateTime lastDay = lastcheckpasstime.plusHours(2);
            LOG.debug("DeleteImageforPeriodJob lastDay ={} lastcheckpasstime ={}", (Object)lastDay, (Object)lastcheckpasstime);
            if (lastDay.isBeforeNow()) {
                LOG.debug("DeleteImageforPeriodJob active");
                GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"TSMC_LAST_SYNC_TIME", (String)DateTime.now().toString(), (String)tsmc.getGuid());
                this.accountService.SyncAccountWithTSMC();
            }
        } else {
            GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"TSMC_LAST_SYNC_TIME", (String)DateTime.now().toString(), (String)tsmc.getGuid());
            this.accountService.SyncAccountWithTSMC();
        }
        if (DateTimeNow.getHourOfDay() % 2 != 0 || DateTimeNow.getMinuteOfHour() % 60 < 5) {
            // empty if block
        }
        LOG.error("DeleteImageforPeriodJob end");
    }
}

