/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.entity.Session;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.SearchEngineIndexingEventService;
import com.penpower.worldcard.team.service.SessionService;
import com.penpower.worldcard.team.service.TokenService;
import com.penpower.worldcard.team.web.api.vo.ContactFailToExport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class DeleteContactsDeeplyJob
extends QuartzJobBean
implements InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteContactsDeeplyJob.class);
    private static final String INTERRUPT = "INTERRUPT";
    private JobExecutionContext thisContext;
    @Autowired
    private ContactService contactService;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private PathManager cardPathManager;
    @Autowired
    private SearchEngineIndexingEventService searchEngineIndexingEventService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.info("==============DeleteContactsDeeplyJob start===============");
        this.thisContext = context;
        int numSucceed = 0;
        ArrayList<ContactFailToExport> failedReasonList = new ArrayList<ContactFailToExport>();
        List contactGuids = this.contactService.getContactGuidsDeletedOrderByModifyTime();
        LOG.debug("getContactGuidsDeleted, list size:{}", (Object)contactGuids.size());
        this.contactService.setDeeplyDeleteContactJobStatus(true);
        for (String contactGuid : contactGuids) {
            LOG.debug("contactService.deleteContactDeeply({})", (Object)contactGuid);
            try {
                boolean succeed = this.contactService.deleteContactDeeply(contactGuid);
                if (!succeed) continue;
                ++numSucceed;
            }
            catch (Exception e) {
                LOG.error("Deeply delete contact fail.", (Throwable)e);
                ContactFailToExport failReason = new ContactFailToExport(contactGuid, e.getMessage(), "", "");
                failedReasonList.add(failReason);
            }
        }
        this.contactService.setDeeplyDeleteContactJobStatus(false);
        numSucceed = 0;
        failedReasonList = new ArrayList();
        LOG.debug("Before getSessionByLoginToken");
        List sessions = this.sessionService.getSessionByLoginToken("SESSION_TOKEN_NEED_DELETED_IMAGES");
        LOG.debug("getSessionByLoginToken,size:{}", (Object)sessions.size());
        for (Session session : sessions) {
            String imageFilePathString = session.getItemValue();
            LOG.debug("imageFilePathString:{}", (Object)imageFilePathString);
            try {
                Path imageFilePath = this.cardPathManager.getFullyPath(imageFilePathString);
                Files.deleteIfExists(imageFilePath);
                Path imageFolder = imageFilePath.getParent();
                Optional<String[]> fileListOptional = Optional.ofNullable(imageFolder.toFile().list());
                if (fileListOptional.isPresent() && fileListOptional.get().length == 0) {
                    Files.deleteIfExists(imageFolder);
                }
                this.sessionService.removeSessionByKey(session.getItemKey());
                ++numSucceed;
            }
            catch (IOException e) {
                LOG.error("Delete image file in storage failed.({})", (Object)imageFilePathString);
                ContactFailToExport failReason = new ContactFailToExport(imageFilePathString, e.getMessage(), "", "");
                failedReasonList.add(failReason);
            }
        }
        this.tokenService.deleteInvalidateToken();
        this.accountService.checkUnActiveAccountExipred();
        this.searchEngineIndexingEventService.deleteExpiredSearchEngineIndexingEvent();
        LOG.info("==============DeleteContactsDeeplyJob end===============");
    }

    private boolean isInterrupted() {
        return this.thisContext.getJobDetail().getJobDataMap().containsKey((Object)INTERRUPT) && (Boolean)this.thisContext.getJobDetail().getJobDataMap().get((Object)INTERRUPT) != false;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.thisContext.getJobDetail().getJobDataMap().put(INTERRUPT, true);
    }
}

