/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.notice.event.WebSocketNoticePublisher;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.websokcet.WebSocketNotifyEvent;
import java.util.Arrays;
import java.util.List;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class DeleteCategoryJob
extends QuartzJobBean
implements InterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteCategoryJob.class);
    public static final String CATEGORY_OWNER_GUID = "CATEGORY_OWNER_GUID";
    public static final String CATEGORY_GUID = "CATEGORY_GUID";
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    @Qualifier(value="webSocketNoticePublisher")
    private WebSocketNoticePublisher webSocketNoticePublisher;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String categoryOwnerGuid = dataMap.getString(CATEGORY_OWNER_GUID);
        String categoryGuid = dataMap.getString(CATEGORY_GUID);
        try {
            List contactGuids = this.contactPrivateService.getContactGuidsByCategory(categoryGuid);
            this.categoryService.deleteCategory_Begin(categoryGuid);
            contactGuids.forEach(contactGuid -> this.contactPrivateService.updateCategoriesOfContact(contactGuid, Arrays.asList(categoryGuid), categoryOwnerGuid, ListSetBehavior.REMOVE, null));
            this.categoryService.deleteCategory_End(categoryGuid, categoryOwnerGuid, false);
            List remainedContactGuids = this.contactPrivateService.getContactGuidsByCategory(categoryGuid);
            remainedContactGuids.forEach(contactGuid -> this.contactPrivateService.updateCategoriesOfContact(contactGuid, Arrays.asList(categoryGuid), categoryOwnerGuid, ListSetBehavior.REMOVE, null));
        }
        catch (Exception e) {
            LOG.error("Delete category fail. {}", (Throwable)e);
            this.categoryService.deleteCategory_Fail(categoryGuid);
        }
        this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.CATEGORY_DELETE_FINISHED, Arrays.asList(categoryOwnerGuid));
    }

    public void interrupt() throws UnableToInterruptJobException {
    }
}

