/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.DiskInfos;
import com.penpower.worldcard.team.Utils.FileSystemUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.InvalidBackupPathException;
import com.penpower.worldcard.team.notice.content.LocalStorageSpaceNotEnoughContent;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.scheduler.job.DailyStorageSpaceMonitor;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class DailyStorageSpaceMonitor
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(DailyStorageSpaceMonitor.class);
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    AccountService accountService;
    @Autowired
    private CompanyService companyService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (this.interrupted()) {
            return;
        }
        ServerType serverType = this.registryService.GetServerType();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[serverType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                LOG.debug(String.format("serverType:%s, skip the storage check", serverType));
                return;
            }
        }
        String fileSystemRootPath = this.applicationProperties.getProperty("FILE_SYSTEM_ROOT_PATH");
        LOG.debug("fileSystemRootPath: {} ", (Object)fileSystemRootPath);
        Path fileSystemRoot = Paths.get(fileSystemRootPath, new String[0]);
        if (!Files.exists(fileSystemRoot, new LinkOption[0])) {
            try {
                Files.createDirectories(fileSystemRoot, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.warn("Fail to create filesystem root path : {}", (Object)fileSystemRoot);
            }
        }
        DiskInfos diskInfos = FileSystemUtil.getDiskInfos((Path)fileSystemRoot);
        double percetageValue = FileSystemUtil.getPercentageValue((long)diskInfos.getUsableSpaceBytes(), (long)diskInfos.getTotalSpaceBytes());
        BigDecimal big = new BigDecimal(String.valueOf(percetageValue)).setScale(0, 4);
        boolean storageFirstPercentageLimitExceeded = FileSystemUtil.storageLessThan100GSendNotice((DiskInfos)diskInfos);
        boolean storageSecondPercentageLimitExceeded = FileSystemUtil.storageLessThan50GReadOnlyMode((DiskInfos)diskInfos);
        LOG.debug("daily storage check .....");
        LOG.debug("diskInfos : {} ", (Object)diskInfos);
        LOG.debug("storageFirstPercentageLimitExceeded (Less than 100G) : {}", (Object)storageFirstPercentageLimitExceeded);
        LOG.debug("storageSecondPercentageLimitExceeded (Less than 50G) : {}", (Object)storageSecondPercentageLimitExceeded);
        Company company = null;
        List companys = this.companyService.FindAllCompany();
        if (companys.size() == 0) {
            throw new InvalidBackupPathException("no company for  backup");
        }
        if (companys.size() > 1) {
            throw new InvalidBackupPathException("multi company no support backup");
        }
        company = (Company)companys.get(0);
        String usableSpaceLessThanValue = null;
        if (storageSecondPercentageLimitExceeded) {
            usableSpaceLessThanValue = String.valueOf(50L) + "GB";
        } else if (storageFirstPercentageLimitExceeded) {
            usableSpaceLessThanValue = String.valueOf(100L) + "GB";
        }
        if (storageFirstPercentageLimitExceeded || storageSecondPercentageLimitExceeded) {
            String storageNotEnoughtContent = GlobalUtils.getJsonString((Object)new LocalStorageSpaceNotEnoughContent(FileSystemUtil.convertToStringRepresentation((long)diskInfos.getTotalSpaceBytes()), FileSystemUtil.convertToStringRepresentation((long)diskInfos.getUsableSpaceBytes()), String.valueOf(big.toString()), usableSpaceLessThanValue));
            LOG.debug("storageNotEnoughtContent : {}", (Object)storageNotEnoughtContent);
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.LOW_STORAGE_SPACE, storageNotEnoughtContent, null, company.getGuid());
        }
    }
}

