/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.auth.TokenManager;
import com.penpower.worldcard.team.dao.LogPerformanceDao;
import com.penpower.worldcard.team.dao.SystemMonitorDao;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.enums.IssueStatus;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.notice.content.SubscriptionAlertContent;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.scheduler.job.DailyCheckSubscriptionnJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.web.api.vo.SubscriptionInfoVo;
import java.time.LocalDateTime;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class DailyCheckSubscriptionnJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(DailyCheckSubscriptionnJob.class);
    @Autowired
    AccountService accountService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private SystemMonitorDao systemMonitorDao;
    @Autowired
    private LogPerformanceDao logPerformanceDao;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.error("DailyCheckSubscriptionnJob start");
        if (this.registryService.GetServerType() == ServerType.ASUSTOR_NAS_AUTOMATION || this.registryService.GetServerType() == ServerType.Google_Linux_Server_Cloud) {
            LocalDateTime now = LocalDateTime.now();
            int currHour = now.getHour();
            DateTime dtStart = new DateTime();
            double sleepSec = Math.random() * 120.0;
            if (currHour == 23) {
                sleepSec += 2700.0;
            }
            DateTime dtEnd2 = dtStart.plusSeconds((int)sleepSec);
            while (!this.interrupted()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!dtEnd2.isBeforeNow()) continue;
            }
            List companys = this.companyService.FindAllCompany();
            for (Company company : companys) {
                if (this.subscriptionService.getLicenseMode(company.getGuid()) != LicenseMode.SUBSCRIPTION) {
                    LOG.debug("DailyCheckSubscriptionnJob not SUBSCRIPTION MODE ");
                    continue;
                }
                if (this.interrupted()) {
                    return;
                }
                switch (currHour) {
                    case 0: 
                    case 2: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 16: 
                    case 19: {
                        this.doCheckSignStatus(company, false);
                        this.doDownloadSubscriptionInfo(company);
                        break;
                    }
                    case 23: {
                        try {
                            LOG.debug("START UPLOAD DBSIGN");
                            this.doMakeDataBaseSign(company);
                            this.doSigntoPRS(company);
                            this.doCheckFromPRS(company);
                            this.doDownloadSubscriptionInfo(company);
                            this.CleanLog(company);
                        }
                        catch (ItemNotFoundException e) {
                            LOG.debug("DOWNLOAD OR CHECK EXCEPTION ={}", (Throwable)e);
                        }
                        this.doCheckSignStatus(company, true);
                    }
                }
            }
        } else {
            LOG.error("DailyCheckSubscriptionnJob wait");
            LocalDateTime now = LocalDateTime.now();
            DateTime dtStart = new DateTime();
            double sleepSec = Math.random() * 120.0;
            DateTime dtEnd = dtStart.plusSeconds((int)sleepSec);
            while (!this.interrupted()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException dtEnd2) {
                    // empty catch block
                }
                if (!dtEnd.isBeforeNow()) continue;
            }
            LOG.error("DailyCheckSubscriptionnJob go");
            List companys = this.companyService.FindAllCompany();
            for (Company company : companys) {
                if (this.subscriptionService.getLicenseMode(company.getGuid()) != LicenseMode.SUBSCRIPTION) {
                    LOG.debug("DailyCheckSubscriptionnJob not SUBSCRIPTION MODE ");
                    continue;
                }
                if (this.interrupted()) {
                    return;
                }
                switch (now.getHour()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.doCheckSignStatus(company, false);
                        this.doMakeDataBaseSign(company);
                        break;
                    }
                    case 7: {
                        this.doCheckSignStatus(company, false);
                        this.doDownloadSubscriptionInfo(company);
                        break;
                    }
                    case 8: 
                    case 9: {
                        this.doCheckSignStatus(company, false);
                        this.doSigntoPRS(company);
                        break;
                    }
                    case 11: {
                        this.doCheckSignStatus(company, false);
                        this.doDownloadSubscriptionInfo(company);
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: {
                        try {
                            this.doCheckFromPRS(company);
                            this.doDownloadSubscriptionInfo(company);
                        }
                        catch (ItemNotFoundException e) {
                            LOG.debug("DOWNLOAD OR CHECK EXCEPTION ={}", (Throwable)e);
                        }
                        LOG.debug("DailyCheckSubscriptionnJob 16");
                        this.doCheckSignStatus(company, false);
                        break;
                    }
                    case 19: {
                        LOG.debug("DailyCheckSubscriptionnJob 19");
                        try {
                            this.doDownloadSubscriptionInfo(company);
                        }
                        catch (ItemNotFoundException e) {
                            LOG.debug("DOWNLOAD OR CHECK EXCEPTION ={}", (Throwable)e);
                        }
                        this.doCheckSignStatus(company, true);
                        break;
                    }
                }
            }
        }
    }

    private void CleanLog(Company company) {
        DateTime currDatetime = new DateTime();
        currDatetime = currDatetime.minusDays(10);
        DateTime tenDayago = new DateTime(currDatetime.getYear(), currDatetime.getMonthOfYear(), currDatetime.getDayOfMonth(), 0, 0, 0);
        LOG.debug("CleanLog before {} ", (Object)tenDayago);
        this.systemMonitorDao.CleanRecordBecordBeforeDate(tenDayago);
        this.logPerformanceDao.CleanRecordBecordBeforeDate(tenDayago);
    }

    private void doCheckSignStatus(Company company, boolean IsNotice) {
        LOG.debug("doCheckSignStatus ");
        SubscriptionInfoVo subscriptionInfoVo = this.subscriptionService.getSubscriptionInfo(company.getGuid());
        if (subscriptionInfoVo != null) {
            LOG.debug("doCheckSignStatus 2");
            DateTime refreshTime = subscriptionInfoVo.getCurrentDateTime();
            if (refreshTime.plusDays(30).isBeforeNow()) {
                LOG.debug("doCheckSignStatus 3");
                GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_CHECK_CONNECT_STATUS", (String)IssueStatus.LOCKED.toString(), (String)company.getGuid());
                LOG.debug("doCheckSignStatus SET ALL TOKEN INVALIDATE START");
                this.accountService.SetAllUserTokenInvalidate();
                LOG.error("doCheckSignStatus SET ALL TOKEN INVALIDATE END");
            } else {
                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[this.registryService.GetServerType().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        if (!refreshTime.plusDays(7).isBeforeNow() || !IsNotice) break;
                        LOG.debug("doCheckSignStatus 4");
                        int days = Days.daysBetween((ReadableInstant)refreshTime, (ReadableInstant)new DateTime()).getDays();
                        SubscriptionAlertContent subscriptionAlertContent = new SubscriptionAlertContent();
                        subscriptionAlertContent.setLostConnectDays(days);
                        String subscriptionAlertContentString = GlobalUtils.getJsonString((Object)subscriptionAlertContent);
                        this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.SUBSCRIPTION_LOST_CHECK, subscriptionAlertContentString, null, company.getGuid());
                    }
                }
            }
        }
    }

    private void doMakeDataBaseSign(Company company) {
        this.subscriptionService.MakeDataBaseSign(company.getGuid());
    }

    private void doSigntoPRS(Company company) {
        this.subscriptionService.SignDBSign(company.getGuid());
    }

    private void doCheckFromPRS(Company company) {
        this.subscriptionService.CheckDBSign(company.getGuid());
    }

    private void doDownloadSubscriptionInfo(Company company) {
        this.subscriptionService.DownloadSubscriptionInfo(company.getGuid());
        this.subscriptionService.CheckLicenseValidate(company.getGuid(), false, null, true);
        if (this.interrupted()) {
            return;
        }
    }
}

