/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.SearchEngineIndexingEventDao;
import com.penpower.worldcard.team.entity.Searchengineindexingevent;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.service.ContactService;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class CheckContactToBeIndexedJob
extends AbstractInterruptJob {
    public static final String DEFAULT_QUARTZ_GROP_NAME = "CHECK_SEARCH_ENGINE_INDEX_CONTACT_JOG";
    private static final Logger LOG = LoggerFactory.getLogger(CheckContactToBeIndexedJob.class);
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private ContactService contactService;
    @Autowired
    private SearchEngineIndexingEventDao searchEngineIndexingEventDao;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        DateTime startTime = DateTime.now();
        DateTime oneMinuteAfterStart = startTime.plusMinutes(1);
        LOG.debug("CheckContactToBeIndexedJob start");
        block4: while (true) {
            try {
                while (true) {
                    List needToReindexContact;
                    if (!(needToReindexContact = this.contactDao.findByModifyTimeForSearchNewerThanModifyTimeInSearch((Pageable)new PageRequest(0, 300)).getContent()).isEmpty()) {
                        List needToReindexContactGuids = needToReindexContact.stream().map(c -> c.getGuid()).collect(Collectors.toList());
                        this.searchEngineIndexingEventDao.save((Object)new Searchengineindexingevent(UUIDGenerator.getRandomUUID(), new Gson().toJson(needToReindexContactGuids), DateTime.now(), null));
                        this.contactService.updatContactModifyTimeInSearch(needToReindexContact);
                    }
                    if (this.interrupted()) {
                        LOG.debug("CheckContactToBeIndexedJob interrupted");
                        break block4;
                    }
                    if (DateTime.now().isAfter((ReadableInstant)oneMinuteAfterStart)) {
                        LOG.debug("CheckContactToBeIndexedJob end");
                        break block4;
                    }
                    try {
                        Thread.sleep(2000L);
                        continue block4;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOG.error(ex.toString());
                break;
            }
        }
    }
}

