/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler.job;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountSecurityInfoForRequest;
import com.penpower.worldcard.team.dto.DeviceAndIpConstraint;
import com.penpower.worldcard.team.dto.DeviceAndIpConstraintForRequest;
import com.penpower.worldcard.team.enums.InheritMode;
import com.penpower.worldcard.team.enums.InheritanceStatus;
import com.penpower.worldcard.team.enums.ListSetBehavior;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.notice.content.AccountSetInheritorContent;
import com.penpower.worldcard.team.scheduler.job.AbstractInterruptJob;
import com.penpower.worldcard.team.service.AccountSecurityService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.web.api.vo.AccountUpdateVo;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class AssignAccountInheritorJob
extends AbstractInterruptJob {
    private static final Logger LOG = LoggerFactory.getLogger(AssignAccountInheritorJob.class);
    public static final String DEFAULT_QUARTZ_GROP_NAME = "ASSIGN_INHERITOR_GROUP";
    public static final String JOB_DATA_ACCOUNT_GUID_PARAM_NAME = "accountGuid";
    public static final String JOB_DATA_INHERITOR_ACCOUNT_GUID_PARAM_NAME = "inheritorAccountGuid";
    public static final String JOB_DATA_ADMIN_ACCOUNT_NAME_PARAM_NAME = "adminAccountName";
    public static final String JOB_DATA_ADMIN_ACCOUNT_GUID_PARAM_NAME = "adminAccountGuid";
    public static final String JOB_DATA_INHERIT_MODE = "JOB_DATA_INHERIT_MODE";
    @Autowired
    private AccountService accountService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private AccountSecurityService accountSecurityService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String accountGuid = dataMap.getString(JOB_DATA_ACCOUNT_GUID_PARAM_NAME);
        String inheritorAccountGuid = dataMap.getString(JOB_DATA_INHERITOR_ACCOUNT_GUID_PARAM_NAME);
        String adminAccountName = dataMap.getString(JOB_DATA_ADMIN_ACCOUNT_NAME_PARAM_NAME);
        String adminAccountGuid = dataMap.getString(JOB_DATA_ADMIN_ACCOUNT_GUID_PARAM_NAME);
        InheritMode inheritMode = (InheritMode)dataMap.get((Object)JOB_DATA_INHERIT_MODE);
        AccountInfo currentLoginAccount = this.accountService.getAccountInfo(adminAccountGuid, null);
        LOG.debug("accountGuid : {} ", (Object)accountGuid);
        LOG.debug("inheritorAccountGuid : {} ", (Object)inheritorAccountGuid);
        LOG.debug("adminAccountName : {} ", (Object)adminAccountName);
        LOG.debug("adminAccountGuid : {} ", (Object)adminAccountGuid);
        try {
            this.accountService.updateInheritanceStatus(accountGuid, InheritanceStatus.INHERITING);
            this.accountService.updateInheritorAccountField(accountGuid, inheritorAccountGuid);
            if (InheritMode.TRANSFER_ALL_DATA.equals((Object)inheritMode)) {
                this.doInherit(accountGuid, inheritorAccountGuid);
            } else if (InheritMode.MOVE_AS_SUBORDINATE.equals((Object)inheritMode)) {
                this.moveAccount(accountGuid, inheritorAccountGuid, currentLoginAccount);
            }
            this.accountService.updateInheritanceStatus(accountGuid, InheritanceStatus.INHERITED);
        }
        catch (Exception ex) {
            this.accountService.cleanInheritorAccountField(accountGuid);
            this.accountService.updateInheritanceStatus(accountGuid, InheritanceStatus.FAILED);
            LOG.error("Fail to assign inheritor[{}] ,  account[{}] ", new Object[]{inheritorAccountGuid, accountGuid, ex});
            return;
        }
        AccountInfo originalAccountInfo = this.accountService.getAccountInfo(accountGuid, null);
        AccountInfo inheritorAccountInfo = this.accountService.getAccountInfo(inheritorAccountGuid, null);
        String newAccountNoticeContent = GlobalUtils.getJsonString((Object)new AccountSetInheritorContent(adminAccountName, adminAccountGuid, originalAccountInfo.getName(), originalAccountInfo.getGuid(), inheritorAccountInfo.getName(), inheritorAccountInfo.getGuid()));
        this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.ACCOUNT_SET_INHERITOR, newAccountNoticeContent, null, originalAccountInfo.getCompanyGuid());
    }

    private void doInherit(String accountGuid, String inheritorAccountGuid) {
        long start = System.currentTimeMillis();
        LOG.debug("[doInherit]start");
        List ownedContactGuids = this.contactPrivateService.getContactGuidsOwnedByAccount(accountGuid);
        for (Object contactGuid : ownedContactGuids) {
            this.contactPrivateService.setContactToNewOwner((String)contactGuid, inheritorAccountGuid);
        }
        LOG.debug("[doInherit]end set new owner(TIME: {})(LOOP: {})", (Object)(System.currentTimeMillis() - start), (Object)ownedContactGuids.size());
        start = System.currentTimeMillis();
        List beSharedContactGuids = this.contactPublicService.getContactGuidsBeSharedByAccount(accountGuid);
        for (String contactGuid : beSharedContactGuids) {
            this.contactPublicService.shareContactToAccounts(contactGuid, Arrays.asList(inheritorAccountGuid), ListSetBehavior.ADD, null);
            this.contactPublicService.shareContactToAccounts(contactGuid, Arrays.asList(accountGuid), ListSetBehavior.REMOVE, null);
        }
        LOG.debug("[doInherit]end set new share(TIME: {})(LOOP: {})", (Object)(System.currentTimeMillis() - start), (Object)beSharedContactGuids.size());
        start = System.currentTimeMillis();
        List contactGuidsInPrivate = this.contactPrivateService.getContactGuidsAllInPrivateByAccount(accountGuid, true);
        for (String contactGuid : contactGuidsInPrivate) {
            this.contactPrivateService.moveContactWithCategoriesOfAccountToAccount(contactGuid, accountGuid, inheritorAccountGuid);
        }
        LOG.debug("[doInherit]end moveContactWithCategoriesOfAccountToAccount(TIME: {})(LOOP: {})", (Object)(System.currentTimeMillis() - start), (Object)contactGuidsInPrivate.size());
        start = System.currentTimeMillis();
        this.categoryService.removeAllNormalCategoriesOfAccount(accountGuid);
        LOG.debug("[doInherit]end removeAllNormalCategoriesOfAccount(TIME: {})", (Object)(System.currentTimeMillis() - start));
    }

    private void moveAccount(String movedAccountGuid, String accountGuid, AccountInfo currentLoginAccount) {
        List subordinates = null;
        try {
            subordinates = this.accountService.getSubordinates(movedAccountGuid);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        if (!CollectionUtils.isEmpty(subordinates)) {
            String bossGuid = "";
            AccountInfo boss = null;
            try {
                boss = this.accountService.getBoss(movedAccountGuid);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            if (boss != null) {
                bossGuid = boss.getGuid();
            }
            for (AccountInfo accountInfo : subordinates) {
                this.updateAccountBoss(accountInfo, bossGuid, currentLoginAccount);
            }
        }
        AccountInfo movedAccount = this.accountService.getAccountInfo(movedAccountGuid, null);
        this.updateAccountBoss(movedAccount, accountGuid, currentLoginAccount);
    }

    private void updateAccountBoss(AccountInfo accountInfo, String bossGuid, AccountInfo currentLoginAccount) {
        String logoPath = null;
        try {
            logoPath = this.accountService.getAccountLogoRelativePath(accountInfo.getGuid());
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        AccountUpdateVo vo = new AccountUpdateVo(accountInfo.getGuid(), accountInfo.getName(), accountInfo.getRole(), bossGuid, accountInfo.isSecretary(), accountInfo.isExportAbility(), accountInfo.isPrintAbility(), logoPath);
        List accountSecurityInfos = this.accountSecurityService.getAccountSecurityInfos(accountInfo.getGuid());
        List accountSecurityInfoForRequest = accountSecurityInfos.stream().map(info -> new AccountSecurityInfoForRequest(info.getPlatform(), Boolean.valueOf(info.getAccountAvailable()), Boolean.valueOf(info.getBindingDeviceEnable()), this.deviceAndIpConstraintToRequest(info.getBindingdevicesAndIpConstraint()))).collect(Collectors.toList());
        vo.setAccountSecurityInfos(accountSecurityInfoForRequest);
        this.accountService.updateAccount(vo, currentLoginAccount);
    }

    private List<DeviceAndIpConstraintForRequest> deviceAndIpConstraintToRequest(List<DeviceAndIpConstraint> deviceAndIpConstraints) {
        return deviceAndIpConstraints.stream().map(deviceAndIpConstraint -> new DeviceAndIpConstraintForRequest(deviceAndIpConstraint)).collect(Collectors.toList());
    }
}

