/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler;

import org.quartz.Job;

public class JobIdentify {
    private static final String TRIGGER_IDENTIFY_SUFFIX = "_Trigger";
    private String triggerIdentify;
    private String jobDetailIdentify;
    private String group;
    private Class<? extends Job> jobClass;

    public JobIdentify(String group, Class<? extends Job> jobClass) {
        this.group = group;
        this.jobClass = jobClass;
        this.jobDetailIdentify = jobClass.getName();
        this.triggerIdentify = String.format("%s%s", this.jobDetailIdentify, TRIGGER_IDENTIFY_SUFFIX);
    }

    public Class<? extends Job> getJobClass() {
        return this.jobClass;
    }

    public String getGroup() {
        return this.group;
    }

    public String getJobDetailName() {
        return this.jobDetailIdentify;
    }

    public String getTriggerIdentify() {
        return this.triggerIdentify;
    }

    public String toString() {
        return "JobIdentify [triggerIdentify=" + this.triggerIdentify + ", jobDetailIdentify=" + this.jobDetailIdentify + ", group=" + this.group + ", jobClass=" + this.jobClass + "]";
    }

    public void setJobDetailIdentify(String jobDetailIdentify) {
        this.jobDetailIdentify = jobDetailIdentify;
    }
}

