/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.scheduler;

import com.penpower.worldcard.team.config.scheduler.InterruptedSchedulerFactoryBean;
import com.penpower.worldcard.team.exception.ScheduleStartException;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="databaseScheduleManager")
public class DatabaseScheduleManagerImpl
implements ScheduleManager {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseScheduleManagerImpl.class);
    @Autowired
    @Qualifier(value="scheculerFactoryBeanManuallyInDatabase")
    private InterruptedSchedulerFactoryBean schedulerFactory;

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void startScheduleOnce(JobIdentify jobIdentify, Date startDate, JobDataMap jobDataMap) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            JobDetail job = JobBuilder.newJob((Class)jobIdentify.getJobClass()).withIdentity(jobIdentify.getJobDetailName(), jobIdentify.getGroup()).usingJobData(jobDataMap).build();
            Trigger trigger = null;
            trigger = startDate != null ? TriggerBuilder.newTrigger().withIdentity(jobIdentify.getTriggerIdentify(), jobIdentify.getGroup()).startAt(startDate).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(0)).forJob(job).build() : TriggerBuilder.newTrigger().withIdentity(jobIdentify.getTriggerIdentify(), jobIdentify.getGroup()).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(0)).forJob(job).build();
            scheduler.scheduleJob(job, trigger);
        }
        catch (Exception e) {
            throw new ScheduleStartException(String.format("Fail to start scheduler with jobIdentify : %s", jobIdentify), (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void startSchedule(JobIdentify jobIdentify, String cronExpression, Date startDate, JobDataMap jobDataMap) {
        try {
            CronExpression.validateExpression((String)cronExpression);
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            JobDetail job = JobBuilder.newJob((Class)jobIdentify.getJobClass()).withIdentity(jobIdentify.getJobDetailName(), jobIdentify.getGroup()).usingJobData(jobDataMap).storeDurably().build();
            JobKey key = job.getKey();
            LOG.info("key : {}", (Object)key.getName());
            LOG.info("getGroup : {}", (Object)key.getGroup());
            Trigger trigger = null;
            trigger = startDate != null ? TriggerBuilder.newTrigger().withIdentity(jobIdentify.getTriggerIdentify(), jobIdentify.getGroup()).startAt(startDate).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).forJob(job).build() : TriggerBuilder.newTrigger().withIdentity(jobIdentify.getTriggerIdentify(), jobIdentify.getGroup()).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).forJob(job).build();
            scheduler.scheduleJob(job, trigger);
        }
        catch (Exception e) {
            throw new ScheduleStartException(String.format("Fail to start scheduler with jobIdentify : %s", jobIdentify), (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void startScheduleOnce(JobIdentify jobIdentify, Date startDate, Serializable parameter) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            JobDetail job = JobBuilder.newJob((Class)jobIdentify.getJobClass()).withIdentity(jobIdentify.getJobDetailName(), jobIdentify.getGroup()).build();
            if (parameter != null) {
                job.getJobDataMap().put("ExportJobInfo", (Object)parameter);
            }
            Trigger trigger = null;
            trigger = startDate != null ? TriggerBuilder.newTrigger().withIdentity(jobIdentify.getTriggerIdentify(), jobIdentify.getGroup()).startAt(startDate).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(1).withRepeatCount(0)).build() : TriggerBuilder.newTrigger().withIdentity(jobIdentify.getTriggerIdentify(), jobIdentify.getGroup()).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(1).withRepeatCount(0)).build();
            scheduler.scheduleJob(job, trigger);
        }
        catch (Exception e) {
            throw new ScheduleStartException(String.format("Fail to start scheduler with jobIdentify : %s", jobIdentify), (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public boolean deleteSchedule(JobIdentify jobIdentify) {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        JobKey jobKey = new JobKey(jobIdentify.getJobDetailName(), jobIdentify.getGroup());
        try {
            scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            return false;
        }
        return true;
    }

    public Scheduler getScheduler() {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        return scheduler;
    }

    public boolean jobRunning(Class<?> jobClass) {
        LOG.debug("check job running....");
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        boolean assignAccountInheritorJobRunning = false;
        try {
            List ececutionJobs = scheduler.getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : ececutionJobs) {
                Class runningJobClass;
                JobDetail jobDetail = jobExecutionContext.getJobDetail();
                if (jobDetail == null || (runningJobClass = jobDetail.getJobClass()) != jobClass) continue;
                assignAccountInheritorJobRunning = true;
                break;
            }
        }
        catch (SchedulerException e) {
            LOG.error("fail to check schedule job running...", (Throwable)e);
        }
        return assignAccountInheritorJobRunning;
    }

    public JobDetail getJobDetail(JobKey jobKey) {
        JobDetail jobDetail;
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        try {
            jobDetail = scheduler.getJobDetail(jobKey);
        }
        catch (SchedulerException e) {
            return null;
        }
        return jobDetail;
    }

    public void interruptJobByJobGroup(Class<?> jobClass) {
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        try {
            for (String groupName : scheduler.getJobGroupNames()) {
                for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName))) {
                    if (jobKey.getName() != jobClass.getName()) continue;
                    scheduler.interrupt(jobKey);
                }
            }
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }
}

