/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.restore;

import com.penpower.worldcard.team.exception.DatabaseUtilsRuntimeException;
import com.penpower.worldcard.team.restore.DatabaseConnectionInfo;
import com.penpower.worldcard.team.restore.DatabaseJdbcUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.postgresql.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlJdbcUtils
implements DatabaseJdbcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSqlJdbcUtils.class);
    private DatabaseConnectionInfo databaseConnectionInfo;

    public PostgreSqlJdbcUtils(DatabaseConnectionInfo databaseConnectionInfo) {
        this.databaseConnectionInfo = databaseConnectionInfo;
    }

    public void deleteDatabase(String databaseName) {
        LOG.debug("Delete database , databaseName : {} ", (Object)databaseName);
        boolean databaeNameExists = this.checkDatabaseExists(databaseName);
        if (!databaeNameExists) {
            return;
        }
        try {
            String rootUrl = String.format(this.databaseConnectionInfo.getRootUrlFormat(), "jdbc:postgresql://", this.databaseConnectionInfo.getServerIpAddress(), this.databaseConnectionInfo.getServerPort());
            String driver = Driver.class.getName().toString();
            Class.forName(driver);
            try (Connection connection = DriverManager.getConnection(rootUrl, this.databaseConnectionInfo.getDbUserName(), this.databaseConnectionInfo.getDbPassword());
                 Statement statement = connection.createStatement();){
                String dropDatabase = "DROP DATABASE " + databaseName + ";";
                statement.executeUpdate(dropDatabase);
            }
        }
        catch (Exception e1) {
            throw new DatabaseUtilsRuntimeException("Fail to delete database , databaseName : " + databaseName, (Throwable)e1);
        }
    }

    public void cleanDatabaseSessions(String databaseName) {
        LOG.debug("Clean all database sessions , databaseName : {} ", (Object)databaseName);
        try {
            String rootUrl = String.format(this.databaseConnectionInfo.getRootUrlFormat(), "jdbc:postgresql://", this.databaseConnectionInfo.getServerIpAddress(), this.databaseConnectionInfo.getServerPort());
            String driver = Driver.class.getName().toString();
            Class.forName(driver);
            try (Connection connection = DriverManager.getConnection(rootUrl, this.databaseConnectionInfo.getDbUserName(), this.databaseConnectionInfo.getDbPassword());
                 Statement statement = connection.createStatement();){
                String cleanAllSessionSql = "SELECT pg_terminate_backend( pid ) FROM pg_stat_activity WHERE pid <> pg_backend_pid( ) AND datname = '" + databaseName + "';";
                LOG.debug("cleanAllSessionSql : {}", (Object)cleanAllSessionSql);
                statement.execute(cleanAllSessionSql);
            }
        }
        catch (Exception e1) {
            throw new DatabaseUtilsRuntimeException("Fail to clean all database sessions... databaseName: " + databaseName, (Throwable)e1);
        }
    }

    public void createDatabase(String databaseName) {
        try {
            LOG.debug("create a new database , databaeName : {}", (Object)databaseName);
            this.cleanDatabaseSessions(databaseName);
            this.cleanDatabaseSessions("template1");
            String rootUrl = String.format(this.databaseConnectionInfo.getRootUrlFormat(), "jdbc:postgresql://", this.databaseConnectionInfo.getServerIpAddress(), this.databaseConnectionInfo.getServerPort());
            String driver = Driver.class.getName().toString();
            Class.forName(driver);
            try (Connection connection = DriverManager.getConnection(rootUrl, this.databaseConnectionInfo.getDbUserName(), this.databaseConnectionInfo.getDbPassword());){
                try (Statement statement = connection.createStatement();){
                    try {
                        String pg01 = "UPDATE pg_database SET datistemplate = FALSE WHERE datname = 'template1';";
                        statement.executeUpdate(pg01);
                        String pg02 = "DROP DATABASE template1;";
                        statement.executeUpdate(pg02);
                    }
                    catch (Exception pg01) {
                        // empty catch block
                    }
                    try {
                        String pg03 = "CREATE DATABASE template1 WITH owner=postgres template=template0 encoding='UTF8' LC_COLLATE = 'C' LC_CTYPE = 'C';";
                        statement.executeUpdate(pg03);
                    }
                    catch (Exception pg03) {
                        // empty catch block
                    }
                    String pg04 = "UPDATE pg_database SET datistemplate=TRUE WHERE datname='template1';";
                    statement.executeUpdate(pg04);
                    LOG.debug("Create a new database with template1 and UTF-8 encoding");
                    String postgreSql = String.format("CREATE DATABASE %s WITH TEMPLATE template1 OWNER = postgres ENCODING = 'UTF8' LC_COLLATE = 'C' LC_CTYPE = 'C';", databaseName);
                    statement.executeUpdate(postgreSql);
                }
                LOG.debug("database[{}] created successfully.", (Object)databaseName);
            }
        }
        catch (Exception e1) {
            throw new DatabaseUtilsRuntimeException("Fail to create a new database , databaseName  : " + databaseName, (Throwable)e1);
        }
    }

    public void renameDatabase(String databaseNameFrom, String databaseNameTo) {
        LOG.debug("Rename the database from [{}] to [{}] ", (Object)databaseNameFrom, (Object)databaseNameTo);
        boolean databaseNameFromExists = this.checkDatabaseExists(databaseNameFrom);
        LOG.debug("databaseNameFromExists : {} ", (Object)databaseNameFromExists);
        if (!databaseNameFromExists) {
            return;
        }
        try {
            String rootUrl = String.format(this.databaseConnectionInfo.getRootUrlFormat(), "jdbc:postgresql://", this.databaseConnectionInfo.getServerIpAddress(), this.databaseConnectionInfo.getServerPort());
            String driver = Driver.class.getName().toString();
            Class.forName(driver);
            try (Connection connection = DriverManager.getConnection(rootUrl, this.databaseConnectionInfo.getDbUserName(), this.databaseConnectionInfo.getDbPassword());
                 Statement statement = connection.createStatement();){
                String renameDatabaseSql = String.format("ALTER DATABASE \"%s\" RENAME TO \"%s\";", databaseNameFrom, databaseNameTo);
                statement.execute(renameDatabaseSql);
            }
        }
        catch (Exception e1) {
            throw new DatabaseUtilsRuntimeException("Fail to rename database from " + databaseNameFrom + " to " + databaseNameTo, (Throwable)e1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDatabaseExists(String databaseName) {
        LOG.debug("Check database exists or not , databaseName  : {}", (Object)databaseName);
        try {
            String rootUrl = String.format(this.databaseConnectionInfo.getRootUrlFormat(), "jdbc:postgresql://", this.databaseConnectionInfo.getServerIpAddress(), this.databaseConnectionInfo.getServerPort());
            String driver = Driver.class.getName().toString();
            Class.forName(driver);
            try (Connection connection = DriverManager.getConnection(rootUrl, this.databaseConnectionInfo.getDbUserName(), this.databaseConnectionInfo.getDbPassword());
                 Statement statement = connection.createStatement();){
                String checkDatabaseExistsSql = "SELECT 1 from pg_database WHERE datname='" + databaseName + "';";
                try (ResultSet rs = statement.executeQuery(checkDatabaseExistsSql);){
                    rs.next();
                    int count = rs.getInt(1);
                    if (count > 0) return true;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (Exception e1) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public long queryDatabaseSize(String databaseName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

