/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.notice.event.listener;

import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.notice.event.NoticeEvent;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.websokcet.NoticeMessageSender;
import com.penpower.worldcard.team.websokcet.SocketMessageObject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class NoticeEventListener
implements ApplicationListener<NoticeEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeEventListener.class);
    private static final long NOTICE_SEND_DELAY_TIME = 2500L;
    @Autowired
    private NoticeMessageSender noticeMessageSender;
    @Autowired
    private AccountService accountService;

    public void onApplicationEvent(NoticeEvent event) {
        this.internalDelay(2500L);
        LOG.debug("trigger noticeEvent............");
        LOG.debug("NoticeEvent : {} ", (Object)event);
        SocketMessageObject socketMessageObject = event.getSocketMessageObject();
        List receiverGuids = event.getReceiverGuids();
        LOG.debug("receiverGuids : {} ", (Object)receiverGuids);
        receiverGuids.stream().forEach(receiverGuid -> {
            LOG.debug("find by guid : {}", receiverGuid);
            AccountInfo receiver = this.accountService.getAccountInfo(receiverGuid, null);
            this.noticeMessageSender.sendMessageToUser(receiver.getEmail(), socketMessageObject);
        });
    }

    private void internalDelay(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

