/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.notice.event;

import com.penpower.worldcard.team.notice.event.NoticeEvent;
import com.penpower.worldcard.team.websokcet.SocketMessageObject;
import com.penpower.worldcard.team.websokcet.WebSocketNotifyEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;

@Component(value="webSocketNoticePublisher")
public class WebSocketNoticePublisher
implements ApplicationEventPublisherAware {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketNoticePublisher.class);
    private ApplicationEventPublisher applicationEventPublisher;

    public final void publishNoticeEvent(WebSocketNotifyEvent webSocketNotifyEvent, List<String> receiverGuids) {
        LOG.debug("push notice event..... webSocketNotifyEvent: {} ", (Object)webSocketNotifyEvent);
        try {
            SocketMessageObject socketObject = new SocketMessageObject(webSocketNotifyEvent);
            NoticeEvent noticeEvent = new NoticeEvent((Object)this, socketObject, receiverGuids);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)noticeEvent);
        }
        catch (Exception ex) {
            LOG.warn("Fail to push websocket notice message event......", (Throwable)ex);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        System.out.println("publisher: " + applicationEventPublisher);
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

