/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.mail;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.mail.MailInfo;
import com.penpower.worldcard.team.mail.MailInfoType;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MailInfoBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MailInfoBuilder.class);
    protected LanguageCode languageCode;
    protected Map<String, Object> subjectContext;
    protected Map<String, Object> bodyContext;

    protected final LanguageCode getLanguageCode() {
        return this.languageCode;
    }

    protected final void setLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode;
    }

    protected final Map<String, Object> getSubjectContext() {
        return this.subjectContext;
    }

    protected final void setSubjectContext(Map<String, Object> subjectContext) {
        this.subjectContext = subjectContext;
    }

    protected final Map<String, Object> getBodyContext() {
        return this.bodyContext;
    }

    protected final void setBodyContext(Map<String, Object> bodyContext) {
        this.bodyContext = bodyContext;
    }

    public final MailInfo createMailInfo() {
        String subject = this.getContentFromPebbleEngine(this.getSubjectContext(), MailInfoType.SUBJECT);
        String body = this.getContentFromPebbleEngine(this.getBodyContext(), MailInfoType.BODY);
        MailInfo mailInfo = new MailInfo(subject, body);
        return mailInfo;
    }

    protected String getContentFromPebbleEngine(Map<String, Object> context, MailInfoType mailInfoType) {
        String forgetPasswordHtmlMsg = "";
        try {
            String templateEnginePath = this.getPebbleEngineTemplateFile(mailInfoType);
            LOG.debug("getContentFromPebbleEngine templateEnginePath={} ", (Object)templateEnginePath);
            PebbleEngine engine = new PebbleEngine.Builder().build();
            PebbleTemplate compiledTemplate = engine.getTemplate(templateEnginePath);
            try (StringWriter writer = new StringWriter();){
                compiledTemplate.evaluate((Writer)writer, context);
                forgetPasswordHtmlMsg = ((Object)writer).toString();
            }
        }
        catch (Exception ex) {
            LOG.warn("Fail to get content from PebbleEngine .....try to use default content...");
            return this.getDefaultContent(mailInfoType);
        }
        return forgetPasswordHtmlMsg;
    }

    protected abstract String getPebbleEngineTemplateFile(MailInfoType var1);

    protected abstract String getDefaultContent(MailInfoType var1);
}

