/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.ldap;

import com.penpower.worldcard.team.enums.ActiveDirectoryNodeType;
import com.penpower.worldcard.team.enums.ActiveDirectoryTreeSearchOption;
import com.penpower.worldcard.team.exception.ActiveDirectoryAccountExpiredException;
import com.penpower.worldcard.team.exception.ActiveDirectoryConnectionException;
import com.penpower.worldcard.team.exception.ActiveDirectoryInvalidCredentialsException;
import com.penpower.worldcard.team.exception.ActiveDirectoryPasswordExpiredException;
import com.penpower.worldcard.team.exception.ActiveDirectoryUserMustRestPasswordException;
import com.penpower.worldcard.team.exception.ActiveDirectoryUserNotFoundException;
import com.penpower.worldcard.team.exception.LdapBusyException;
import com.penpower.worldcard.team.exception.LdapInvalidCredentialsException;
import com.penpower.worldcard.team.exception.LdapRuntimeException;
import com.penpower.worldcard.team.exception.LdapUnavaiableException;
import com.penpower.worldcard.team.ldap.ActiveDirectoryAccountInfo;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectoryInfo;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectoryTreeNodeInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.core.support.LdapOperationsCallback;
import org.springframework.ldap.core.support.SingleContextSource;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class ActiveDirectoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveDirectoryUtils.class);
    private static final String LDAP_ERROR_CODE_AND_DATA_PATTERN = ".*error code (\\w*).* data (\\w*).*";
    private static final String LDAP_INVALID_CREDENTIALS_ERROR_CODE = "49";
    private static final String LDAP_BUSY_ERROR_CODE = "51";
    private static final String LDAP_UNAVAILABLE_ERROR_CODE = "52";
    private static final String AD_INVALID_CREDENTIALS_DATA_CODE = "52e";
    private static final String AD_USER_NOT_FOUND = "525";
    private static final String AD_PASSWORD_EXPIRED = "532";
    private static final String AD_ACCOUNT_EXPIRED = "701";
    private static final String AD_USER_MUST_RESET_PASSWORD = "773";
    private LdapContextSource ctxSrc;
    private LdapTemplate ldapTemplate;
    public static final String DEFAULT_ACTIVE_DIRECTORY_PORT = "389";
    public static final String DEFAULT_ACTIVE_DIRECTORY_BASEDN_SPLIT_SYMBOL = ",";
    public static final String DEFAULT_ACTIVE_DIRECTORY_ACCOUNT_SPLIT_SYMBOL = "@";
    public static final String DEFAULT_ACTIVE_DIRECTORY_DOMAIN_JOIN_SYMBOL = ".";
    public static final String ACTIVE_DIRECTORY_SAMACCOUNT_ATTRIBUTE = "sAMAccountName";
    public static final String ACTIVE_DIRECTORY_SEARCH_PERSON_QUERY_FILTER = "(&(objectClass=person)(objectClass=user)(!(objectClass=computer))(!(userAccountControl:1.2.840.113556.1.4.803:=2)))";
    public static final String ACTIVE_DIRECTORY_SEARCH_GROUP_QUERY_FILTER = "(|(objectClass=container)(objectClass=organizationalUnit)(objectClass=builtinDomain)(objectClass=group))";
    public static final String ACTIVE_DIRECTORY_SEARCH_USER_QUERY_FILTER = "(&(objectClass=person)(objectClass=user)(!(objectClass=computer))(!(userAccountControl:1.2.840.113556.1.4.803:=2)))";
    public static final String ACTIVE_DIRECTORY_SEARCH_USER_AND_GROUP_QUERY_FILTER = "(|(|(objectClass=container)(objectClass=organizationalUnit)(objectClass=builtinDomain)(objectClass=group))(&(objectClass=person)(objectClass=user)(!(objectClass=computer))(!(userAccountControl:1.2.840.113556.1.4.803:=2))))";
    public static final String ACTIVE_DIRECTORY_SEARCH_OBJECT_CLASS_FILTER = "(&(objectClass=*))";
    public static final String ACTIVE_DIRECTORY_DOMAIN_PART_PREFIX = "dc=";
    public static final String ACTIVE_DIRECTORY_URL_TEMPLATE = "ldap://%s:%s";
    public static final String ACTIVE_DIRECTORY_USERPRINCIPALNAME_TEMPLATE = "%s@%s";
    public static final String ACTIVE_DIRECTORY_ACCOUNT_ATTRIBUTE_VALUE = "sAMAccountName";
    public static final String ACTIVE_DIRECTORY_ACCOUNT_GUID = "objectGUID";
    public static final String ACTIVE_DIRECTORY_MAIL_ATTRIBUTE_VALUE = "mail";
    public static final String ACTIVE_DIRECTORY_DISTINGUISHED_NAME_ATTRIBUTE = "distinguishedName";
    public static final String ACTIVE_DIRECTORY_OBJECT_CLASS_ATTRIBUTE = "objectClass";
    public static final String ACTIVE_DIRECTORY_NAME_ATTRIBUTE = "name";
    public static final String ACTIVE_DIRECTORY_SHOW_IN_ADVANCED_VIEW_ONLY_ATTRIBUTE = "showInAdvancedViewOnly";
    public static final int ACTIVE_DIRECTORY_DOMAIN_PART_PREFIX_LENGTH = 3;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static final LdapRuntimeException convertToLdapRuntimeException(Exception ex) {
        String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
        Pattern pattern = Pattern.compile(".*error code (\\w*).* data (\\w*).*", 2);
        Matcher matcher = pattern.matcher(rootCauseMessage);
        if (matcher.matches()) {
            String errorCode = matcher.group(1) == null ? "" : matcher.group(1).toLowerCase();
            String errorData = matcher.group(2) == null ? "" : matcher.group(2).toLowerCase();
            switch (errorCode) {
                case "49": {
                    if ("52e".equals(errorData)) {
                        return new ActiveDirectoryInvalidCredentialsException("The client passed either an incorrect DN or password.", (Throwable)ex);
                    }
                    if ("525".equals(errorData)) {
                        return new ActiveDirectoryUserNotFoundException("User name is invalid.", (Throwable)ex);
                    }
                    if ("532".equals(errorData)) {
                        return new ActiveDirectoryPasswordExpiredException("The specified account password has expired.", (Throwable)ex);
                    }
                    if ("701".equals(errorData)) {
                        return new ActiveDirectoryAccountExpiredException("The user's account has expired.", (Throwable)ex);
                    }
                    if ("773".equals(errorData)) {
                        return new ActiveDirectoryUserMustRestPasswordException("The user's password must be changed before logging on the first time.", (Throwable)ex);
                    }
                    return new LdapInvalidCredentialsException("The client passed either an incorrect DN or password.", (Throwable)ex);
                }
                case "51": {
                    return new LdapBusyException("server is too busy.", (Throwable)ex);
                }
                case "52": {
                    return new LdapUnavaiableException("server cannot process the client's bind request.", (Throwable)ex);
                }
            }
        }
        return new LdapRuntimeException("Other LDAP exception occurs.", (Throwable)ex);
    }

    public final String getBaseFromBaseDn(String adServerBaseDn) {
        String[] baseDnValues;
        String[] stringArray = baseDnValues = StringUtils.isEmpty((CharSequence)adServerBaseDn) ? null : adServerBaseDn.split(",");
        if (baseDnValues == null || baseDnValues.length <= 0) {
            return "";
        }
        List<String> baseDnParts = Arrays.asList(baseDnValues);
        String domain = baseDnParts.stream().filter(baseDnPart -> baseDnPart != null && baseDnPart.toLowerCase().indexOf("dc=") >= 0).collect(Collectors.joining(","));
        if (domain.length() <= 0) {
            return "";
        }
        return domain;
    }

    public ActiveDirectoryUtils(ActiveDirectoryInfo activeDirectoryInfo) {
        String url = String.format("ldap://%s:%s", activeDirectoryInfo.getAdServer(), "389");
        LOG.debug("LDAP debug ---- URL :{} ", (Object)url);
        this.ctxSrc = new LdapContextSource();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.ldap.attributes.binary", "objectGUID");
        this.ctxSrc.setBaseEnvironmentProperties(env);
        this.ctxSrc.setUrl(url);
        this.ctxSrc.setBase(this.getBaseFromBaseDn(activeDirectoryInfo.getAdServerBaseDn()));
        String adSamAccountName = activeDirectoryInfo.getLoginAccount();
        String adServerBaseDn = activeDirectoryInfo.getAdServerBaseDn();
        String domainName = this.getDomainFromBaseDn(adServerBaseDn);
        LOG.debug("LDAP debug ---- adSamAccountName : {} ", (Object)adSamAccountName);
        LOG.debug("LDAP debug ---- adServerBaseDn : {} ", (Object)adServerBaseDn);
        LOG.debug("LDAP debug ---- domainName : {} ", (Object)domainName);
        boolean isEmailFormat = this.isEmailFormat(adSamAccountName);
        LOG.debug("LDAP debug ---- isEmailFormat : {} ", (Object)isEmailFormat);
        if (!isEmailFormat) {
            if (StringUtils.isEmpty((CharSequence)domainName)) {
                this.ctxSrc.setUserDn(adSamAccountName);
            } else {
                String userPrincipalName = String.format("%s@%s", adSamAccountName, domainName);
                this.ctxSrc.setUserDn(userPrincipalName);
                LOG.debug("LDAP debug ---- userPrincipalName : {} ", (Object)userPrincipalName);
            }
        } else {
            LOG.debug("LDAP debug ---- no email format accountName found, use the original account  : {} ", (Object)adSamAccountName);
            this.ctxSrc.setUserDn(adSamAccountName);
        }
        this.ctxSrc.setPassword(activeDirectoryInfo.getLoginPassword());
        this.ctxSrc.afterPropertiesSet();
        this.ldapTemplate = new LdapTemplate((ContextSource)this.ctxSrc);
    }

    private boolean isEmailFormat(String adSamAccountName) {
        String[] adSamAccountNameParts = adSamAccountName.split("@");
        boolean isEmailFormat = adSamAccountNameParts.length > 1;
        return isEmailFormat;
    }

    public final String getDomainFromBaseDn(String baseDn) {
        String[] baseDnValues;
        String[] stringArray = baseDnValues = StringUtils.isEmpty((CharSequence)baseDn) ? null : baseDn.split(",");
        if (baseDnValues == null || baseDnValues.length <= 0) {
            return "";
        }
        List<String> baseDnParts = Arrays.asList(baseDnValues);
        String domain = baseDnParts.stream().filter(baseDnPart -> baseDnPart != null && baseDnPart.toLowerCase().indexOf("dc=") >= 0).map(baseDnPart -> {
            String baseDnPartLowerCase = baseDnPart.toLowerCase();
            String dcValue = baseDnPartLowerCase.substring(3, baseDnPartLowerCase.length());
            return dcValue;
        }).collect(Collectors.joining("."));
        if (domain.length() <= 0) {
            return "";
        }
        return domain;
    }

    public final String searchAccountMailAttritube(String accountName) {
        List email = this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().where("sAMAccountName").is(accountName), attrs -> attrs.get("mail") == null ? null : attrs.get("mail").get().toString());
        return (String)email.get(0);
    }

    public final void authenticate(String account, String password) throws RuntimeException {
        boolean isEmailFormat = this.isEmailFormat(account);
        LOG.debug("Try to authenticate with account:{} ", (Object)account);
        LOG.debug("isEmailFormat :{} ", (Object)isEmailFormat);
        try {
            String authAccount = account;
            if (isEmailFormat) {
                String[] authAccountParts = authAccount.split("@");
                authAccount = authAccountParts[0];
                LOG.debug("found the email format account .....");
                LOG.debug("source account:[{}] , new authAccount:[{}]", (Object)account, (Object)authAccount);
            }
            this.ldapTemplate.setIgnorePartialResultException(true);
            this.ldapTemplate.authenticate((LdapQuery)LdapQueryBuilder.query().where("sAMAccountName").is(authAccount), password);
        }
        catch (CommunicationException ex) {
            throw new ActiveDirectoryConnectionException("Fail to connect to AD server.", (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("ActiveDirectory authenticate failed.", (Throwable)ex);
            LdapRuntimeException newException = ActiveDirectoryUtils.convertToLdapRuntimeException((Exception)ex);
            throw newException;
        }
    }

    public final List<ActiveDirectoryAccountInfo> getAllUserAccountNames() {
        LOG.debug("try to get all user account names from ad server....");
        try {
            return this.getAllPersonNames(this.ctxSrc);
        }
        catch (Exception ex) {
            LOG.error("Fail to get all account name list from ad server....={}", (Object)ex.getMessage());
            throw new LdapRuntimeException("Fail to get all account name list from ad server....", (Throwable)ex);
        }
    }

    public List<ActiveDirectoryTreeNodeInfo> getTreeNodes(String baseDn, List<ActiveDirectoryTreeSearchOption> options, int searchScope) {
        try {
            this.setCtxBaseDn(baseDn);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(searchScope);
            PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(100);
            return (List)SingleContextSource.doWithSingleContext((ContextSource)this.ctxSrc, (LdapOperationsCallback)new /* Unavailable Anonymous Inner Class!! */, (boolean)false, (boolean)true, (boolean)false);
        }
        catch (Exception ex) {
            LOG.error("Fail to get tree nodes from ad server....{}", (Object)ex.getMessage());
            throw new LdapRuntimeException("Fail to get all account name list from ad server....", (Throwable)ex);
        }
    }

    private final List<String> getListByAttributeName(Attributes attributes, String attributeName) throws NamingException {
        Attribute attribute = attributes.get(attributeName);
        if (attribute == null) {
            return null;
        }
        List<String> result = Collections.list(attribute.getAll()).stream().map(i -> ((String)i).trim()).collect(Collectors.toList());
        return result;
    }

    private final ActiveDirectoryTreeNodeInfo getNodeInfoByAttributes(Attributes a) throws NamingException {
        Attribute showInAdvancedViewOnly = a.get("showInAdvancedViewOnly");
        if (showInAdvancedViewOnly != null && StringUtils.equalsIgnoreCase((CharSequence)((String)showInAdvancedViewOnly.get()), (CharSequence)Boolean.TRUE.toString())) {
            return null;
        }
        List objectClasses = this.getListByAttributeName(a, "objectClass");
        ActiveDirectoryTreeNodeInfo nodeInfo = new ActiveDirectoryTreeNodeInfo();
        String guid = ActiveDirectoryUtils.bytesToHex((byte[])((byte[])a.get("objectGUID").get()));
        if (objectClasses.contains("user")) {
            String accountName = (String)a.get("sAMAccountName").get();
            nodeInfo = new ActiveDirectoryAccountInfo(accountName, "", guid);
            nodeInfo.setNodeType(ActiveDirectoryNodeType.USER);
            nodeInfo.setIsRoot(Boolean.valueOf(false));
        } else if (objectClasses.contains("container") || objectClasses.contains("organizationalUnit") || objectClasses.contains("builtinDomain")) {
            nodeInfo.setNodeType(ActiveDirectoryNodeType.GROUP);
            nodeInfo.setIsRoot(Boolean.valueOf(false));
        } else if (objectClasses.contains("group")) {
            nodeInfo.setNodeType(ActiveDirectoryNodeType.GROUP);
            List members = this.getListByAttributeName(a, "member");
            nodeInfo.setGroupMembersBaseDn(members);
            nodeInfo.setIsRoot(Boolean.valueOf(false));
        } else if (objectClasses.contains("domainDNS")) {
            nodeInfo.setNodeType(ActiveDirectoryNodeType.GROUP);
            nodeInfo.setIsRoot(Boolean.valueOf(true));
        } else {
            return null;
        }
        String baseDn = a.get("distinguishedName") == null ? null : (String)a.get("distinguishedName").get();
        String name = a.get("name") == null ? null : (String)a.get("name").get();
        nodeInfo.setBaseDn(baseDn);
        nodeInfo.setName(name);
        nodeInfo.setGuid(guid);
        return nodeInfo;
    }

    public final ActiveDirectoryTreeNodeInfo getNodeInfo(String baseDn) {
        try {
            this.setCtxBaseDn(baseDn);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(5);
            List nodeInfo = (List)SingleContextSource.doWithSingleContext((ContextSource)this.ctxSrc, (LdapOperationsCallback)new /* Unavailable Anonymous Inner Class!! */, (boolean)false, (boolean)true, (boolean)false);
            return (ActiveDirectoryTreeNodeInfo)nodeInfo.get(0);
        }
        catch (Exception ex) {
            LOG.error("Fail to get node info from ad server....={}", (Object)ex.getMessage());
            throw new LdapRuntimeException("Fail to get node info from ad server....", (Throwable)ex);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private final List<ActiveDirectoryAccountInfo> getAllPersonNames(LdapContextSource contextSource) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(5);
        return (List)SingleContextSource.doWithSingleContext((ContextSource)contextSource, (LdapOperationsCallback)new /* Unavailable Anonymous Inner Class!! */, (boolean)false, (boolean)true, (boolean)false);
    }

    public void setCtxBaseDn(String adServerBaseDn) {
        this.ctxSrc.setBase(adServerBaseDn);
        this.ctxSrc.afterPropertiesSet();
    }

    static /* synthetic */ ActiveDirectoryTreeNodeInfo access$000(ActiveDirectoryUtils x0, Attributes x1) throws NamingException {
        return x0.getNodeInfoByAttributes(x1);
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }
}

