/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.entity;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.PlatformCategory;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import org.hibernate.annotations.DynamicUpdate;
import org.joda.time.DateTime;

@Entity
@DynamicUpdate
@NamedQuery(name="Token.findAll", query="SELECT t FROM Token t")
public class Token
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private String token;
    private String userguid;
    private DateTime createdtime;
    private DateTime expiredtime;
    private DateTime invalidtime;
    private String ip;
    private String deviceid;
    @Enumerated(value=EnumType.STRING)
    private Platform platform;
    @Enumerated(value=EnumType.STRING)
    private PlatformCategory platformcategory;
    private String hostname;

    public Token() {
    }

    public Token(TokenInfo tokenInfo) {
        this.token = tokenInfo.getToken();
        this.userguid = tokenInfo.getUserGuid() == null ? "" : tokenInfo.getUserGuid();
        this.createdtime = tokenInfo.getCreatedTime();
        this.expiredtime = tokenInfo.getExpiredTime();
        this.invalidtime = tokenInfo.getInvalidTime();
        this.ip = tokenInfo.getIp() == null ? "" : tokenInfo.getIp();
        this.deviceid = tokenInfo.getDeviceId() == null ? "" : tokenInfo.getDeviceId();
        this.platform = tokenInfo.getPlatform();
        this.platformcategory = tokenInfo.getPlatformCategory();
    }

    public Token(String token, String userGuid, Platform platform, String ip, String deviceId, String hostname) {
        this.token = token;
        this.createdtime = new DateTime(System.currentTimeMillis());
        this.expiredtime = this.createdtime.plusMinutes(30);
        this.invalidtime = this.createdtime.plusMinutes(43200);
        this.userguid = userGuid == null ? "" : userGuid;
        this.platform = platform;
        this.platformcategory = GlobalUtils.getPlatformCategory((Platform)this.platform);
        this.ip = ip == null ? "" : ip;
        this.deviceid = deviceId == null ? "" : deviceId;
        this.hostname = hostname;
    }

    public Token(String token, String userGuid, String ip) {
        this.token = token;
        this.createdtime = new DateTime(System.currentTimeMillis());
        this.expiredtime = this.createdtime.plusMinutes(30);
        this.invalidtime = this.createdtime.plusMinutes(43200);
        this.userguid = userGuid == null ? "" : userGuid;
        this.platform = Platform.WEB;
        this.ip = ip == null ? "" : ip;
        this.deviceid = "";
        this.platformcategory = GlobalUtils.getPlatformCategory((Platform)this.platform);
        this.ip = "";
        this.deviceid = "";
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getUserguid() {
        return this.userguid;
    }

    public void setUserguid(String userguid) {
        this.userguid = userguid;
    }

    public DateTime getCreatedtime() {
        return this.createdtime;
    }

    public void setCreatedtime(DateTime createdtime) {
        this.createdtime = createdtime;
    }

    public DateTime getExpiredtime() {
        return this.expiredtime;
    }

    public void setExpiredtime(DateTime expiredtime) {
        this.expiredtime = expiredtime;
    }

    public DateTime getInvalidtime() {
        return this.invalidtime;
    }

    public void setInvalidtime(DateTime invalidtime) {
        this.invalidtime = invalidtime;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getDeviceid() {
        return this.deviceid;
    }

    public void setDeviceid(String deviceid) {
        this.deviceid = deviceid;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public PlatformCategory getPlatformcategory() {
        return this.platformcategory;
    }

    public void setPlatformcategory(PlatformCategory platformcategory) {
        this.platformcategory = platformcategory;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String toString() {
        return "Token [token=" + this.token + ", userguid=" + this.userguid + ", createdtime=" + this.createdtime + ", expiredtime=" + this.expiredtime + ", invalidtime=" + this.invalidtime + ", ip=" + this.ip + ", deviceid=" + this.deviceid + ", platform=" + this.platform + ", platformcategory=" + this.platformcategory + "]";
    }
}

