/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.entity;

import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.dao.CategoryDao;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.enums.CategoryType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@DynamicUpdate
@NamedQuery(name="Category.findAll", query="SELECT c FROM Category c")
public class Category
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private String guid;
    @Enumerated(value=EnumType.STRING)
    private CategoryType categorytype;
    private int contactcount;
    private int displayorder;
    private String name;
    private DateTime updatetime = new DateTime();
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean isdeleted;
    @Column(name="secretary_account_guid")
    private String secretaryaccountguid;
    @Column(name="inheritecategoryguid")
    private String inheritecategoryguid;
    @Column(name="parentcategoryguid")
    private String parentCategoryGuid;
    @Column(name="isusual")
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean isUsual;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ownerguid")
    private Account owneraccount;
    @ManyToMany(mappedBy="categoriesownme")
    private List<Contact> contacts = new ArrayList();

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public CategoryType getCategoryType() {
        return this.categorytype;
    }

    public void setCategoryType(CategoryType categoryType) {
        this.categorytype = categoryType;
    }

    public int getDisplayOrder() {
        return this.displayorder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayorder = displayOrder;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    public Account getOwneraccount() {
        return this.owneraccount;
    }

    public void setOwneraccount(Account ownerAccount) {
        this.owneraccount = ownerAccount;
    }

    public int getContactCount() {
        return this.contactcount;
    }

    public void setContactCount(int contactCount) {
        this.contactcount = contactCount;
    }

    public DateTime getUpdateTime() {
        return this.updatetime;
    }

    public void setUpdateTime(DateTime updateTime) {
        this.updatetime = updateTime;
    }

    public boolean isDeleted() {
        return this.isdeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isdeleted = isDeleted;
    }

    public String getSecretaryaccountguid() {
        return this.secretaryaccountguid;
    }

    public void setSecretaryaccountguid(String secretaryaccountguid) {
        this.secretaryaccountguid = secretaryaccountguid;
    }

    public String getInheritecategoryguid() {
        return this.inheritecategoryguid;
    }

    public void setInheritecategoryguid(String inheritecategoryguid) {
        this.inheritecategoryguid = inheritecategoryguid;
    }

    public String getParentCategoryGuid() {
        return this.parentCategoryGuid;
    }

    public boolean isUsual() {
        return this.isUsual;
    }

    public void setParentCategoryGuid(String parentCategoryGuid) {
        this.parentCategoryGuid = parentCategoryGuid;
    }

    public void setUsual(boolean isUsual) {
        this.isUsual = isUsual;
    }

    public boolean isAncestorOf(Category category, CategoryDao categoryDao) {
        String parentCategoryGuid = category.getParentCategoryGuid();
        while (!StringUtil.IsStringNullorEmpty((String)parentCategoryGuid)) {
            if (parentCategoryGuid.equals(this.getGuid())) {
                return true;
            }
            Category parent = (Category)categoryDao.findOne((Serializable)((Object)parentCategoryGuid));
            if (parent == null) break;
            parentCategoryGuid = parent.getParentCategoryGuid();
        }
        return false;
    }

    public String toString() {
        return "Category [guid=" + this.guid + ", categorytype=" + this.categorytype + ", displayorder=" + this.displayorder + ", name=" + this.name + ", isdeleted=" + this.isdeleted + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof Category) {
            Category otherCategory = (Category)object;
            if (this.guid != null) {
                return this.guid.equals(otherCategory.getGuid());
            }
        }
        return super.equals(object);
    }
}

