/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.entity;

import com.penpower.worldcard.team.entity.AccountPrivateSetting;
import com.penpower.worldcard.team.entity.Accountbindingdeviceinfo;
import com.penpower.worldcard.team.entity.Accountloginrecord;
import com.penpower.worldcard.team.entity.Accountmycardsetting;
import com.penpower.worldcard.team.entity.Accountsecuritysetting;
import com.penpower.worldcard.team.entity.Accountsharetargetsetting;
import com.penpower.worldcard.team.entity.Activity;
import com.penpower.worldcard.team.entity.Category;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Notice;
import com.penpower.worldcard.team.entity.Task;
import com.penpower.worldcard.team.enums.AccountLockCase;
import com.penpower.worldcard.team.enums.AccountLockedIssue;
import com.penpower.worldcard.team.enums.AccountSubscriptionStatus;
import com.penpower.worldcard.team.enums.AccountType;
import com.penpower.worldcard.team.enums.InheritanceStatus;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@DynamicUpdate
@NamedQuery(name="Account.findAll", query="SELECT a FROM Account a")
public class Account
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private String guid;
    private DateTime createtime;
    private DateTime categoryorderupdatetime;
    private DateTime resigndate;
    private DateTime inheritdate;
    private DateTime lastpasswordchangetime;
    private String displayname;
    private String email;
    private String logofilepath;
    private String password;
    private String inheritedaccount;
    @Enumerated(value=EnumType.STRING)
    private AccountType accounttype;
    @Enumerated(value=EnumType.STRING)
    private AccountSubscriptionStatus accountsubscriptionstatus;
    private String activedirectoryserver;
    private String activedirectorybasedn;
    private String activedirectoryaccountmail;
    private String activedirectoryguid;
    private String assistantguid;
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean exportability;
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean secretary;
    @Type(type="org.hibernate.type.NumericBooleanType")
    private boolean printability;
    @Enumerated(value=EnumType.STRING)
    private UserRole role;
    @Enumerated(value=EnumType.STRING)
    private AccountLockedIssue lockedissue;
    @Enumerated(value=EnumType.STRING)
    private AccountLockCase lockcase;
    @Enumerated(value=EnumType.STRING)
    private UserStatus status;
    @Enumerated(value=EnumType.STRING)
    private InheritanceStatus inheritancestatus;
    private Integer contactcountinprivate;
    private Integer mycardcount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="boss")
    private Account boss;
    @OneToMany(mappedBy="boss")
    private List<Account> subordinates;
    private String company_guid;
    @ManyToMany
    @JoinTable(name="account_can_view_task", joinColumns={@JoinColumn(name="account_guid")}, inverseJoinColumns={@JoinColumn(name="task_guid")})
    private List<Task> tasks1;
    @OneToOne(mappedBy="account", cascade={CascadeType.ALL})
    private AccountPrivateSetting accountprivatesetting;
    @OneToMany(mappedBy="account", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Accountsharetargetsetting> accountsharetargetsettings;
    @ManyToMany(mappedBy="accounts")
    private List<Activity> activities1;
    @OneToMany(mappedBy="account")
    private List<Activity> activities2;
    @OneToMany(mappedBy="owneraccount", cascade={CascadeType.ALL})
    private List<Category> categories;
    @ManyToMany(mappedBy="accountscanview")
    private List<Contact> canviewcontacts;
    @OneToMany(mappedBy="owneraccount")
    private List<Contact> owncontacts;
    @OneToMany(mappedBy="owner")
    private List<Task> owntasks;
    @OneToMany(mappedBy="creator")
    private List<Task> createdtasks;
    @OneToMany(mappedBy="account", cascade={CascadeType.ALL})
    private List<Notice> notices;
    @OneToMany(mappedBy="account", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Accountbindingdeviceinfo> accountbindingdeviceinfos;
    @OneToMany(mappedBy="account")
    private List<Accountloginrecord> loginrecords;
    @OneToOne(mappedBy="account", cascade={CascadeType.ALL})
    private Accountsecuritysetting accountsecuritysetting;
    @OneToMany(mappedBy="account", cascade={CascadeType.ALL})
    private List<Accountmycardsetting> accountmycardsettings;

    public Account() {
        this.setContactcountinprivate(Integer.valueOf(0));
    }

    public String getInheritedAccount() {
        return this.inheritedaccount;
    }

    public void setInheritedAccount(String inheritedAccount) {
        this.inheritedaccount = inheritedAccount;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getDisplayName() {
        return this.displayname;
    }

    public void setDisplayName(String displayName) {
        this.displayname = displayName;
    }

    public void setLockCase(AccountLockCase lockcase) {
        this.lockcase = lockcase;
    }

    public AccountLockCase getLockCase() {
        return this.lockcase;
    }

    public void setLockIssue(AccountLockedIssue accountLockedIssue) {
        this.lockedissue = accountLockedIssue;
    }

    public AccountLockedIssue getLockIssue() {
        return this.lockedissue;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Account getBoss() {
        return this.boss;
    }

    public void setBoss(Account boss) {
        this.boss = boss;
    }

    public List<Account> getSubordinates() {
        return this.subordinates;
    }

    public void setSubordinates(List<Account> subordinates) {
        this.subordinates = subordinates;
    }

    public String getCompanyGuid() {
        return this.company_guid;
    }

    public void setCompanyGuid(String company) {
        this.company_guid = company;
    }

    public List<Task> getTasks1() {
        return this.tasks1;
    }

    public void setTasks1(List<Task> tasks1) {
        this.tasks1 = tasks1;
    }

    public AccountPrivateSetting getAccountPrivateSetting() {
        return this.accountprivatesetting;
    }

    public void setAccountPrivateSetting(AccountPrivateSetting accountPrivateSetting) {
        this.accountprivatesetting = accountPrivateSetting;
    }

    public List<Activity> getActivities1() {
        return this.activities1;
    }

    public void setActivities1(List<Activity> activities1) {
        this.activities1 = activities1;
    }

    public List<Activity> getActivities2() {
        return this.activities2;
    }

    public void setActivities2(List<Activity> activities2) {
        this.activities2 = activities2;
    }

    public Activity addActivities2(Activity activities2) {
        this.getActivities2().add(activities2);
        activities2.setAccount(this);
        return activities2;
    }

    public Activity removeActivities2(Activity activities2) {
        this.getActivities2().remove(activities2);
        activities2.setAccount(null);
        return activities2;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public Category addCategory(Category category) {
        this.getCategories().add(category);
        category.setOwneraccount(this);
        return category;
    }

    public Category removeCategory(Category category) {
        this.getCategories().remove(category);
        category.setOwneraccount(null);
        return category;
    }

    public List<Task> getOwnTasks() {
        return this.owntasks;
    }

    public void setOwnTasks(List<Task> ownTasks) {
        this.owntasks = ownTasks;
    }

    public Task addOwnedTasks(Task task) {
        this.getOwnTasks().add(task);
        task.setOwner(this);
        return task;
    }

    public Task removeOwnedTasks(Task task) {
        this.getOwnTasks().remove(task);
        task.setOwner(null);
        return task;
    }

    public List<Task> getCreatedTasks() {
        return this.createdtasks;
    }

    public void setCreatedTasks(List<Task> tasks) {
        this.createdtasks = tasks;
    }

    public Task addCreatedTask(Task task) {
        this.getCreatedTasks().add(task);
        task.setCreator(this);
        return task;
    }

    public Task removeCreatedTask(Task task) {
        this.getCreatedTasks().remove(task);
        task.setCreator(null);
        return task;
    }

    public DateTime getLastPasswordChangeTime() {
        return this.lastpasswordchangetime;
    }

    public void setLastPasswordChangeTime(DateTime lastpasswordchangetime) {
        this.lastpasswordchangetime = lastpasswordchangetime;
    }

    public DateTime getCreateTime() {
        return this.createtime;
    }

    public void setCreateTime(DateTime createTime) {
        this.createtime = createTime;
    }

    public UserRole getRole() {
        return this.role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    public UserStatus getStatus() {
        return this.status;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    public boolean isExportAbility() {
        return this.exportability;
    }

    public void setExportAbility(boolean exportAbility) {
        this.exportability = exportAbility;
    }

    public String getLogoFilepath() {
        return this.logofilepath;
    }

    public void setLogoFilepath(String logoFilepath) {
        this.logofilepath = logoFilepath;
    }

    public List<Contact> getCanViewContacts() {
        return this.canviewcontacts;
    }

    public void setCanViewContacts(List<Contact> canViewContacts) {
        this.canviewcontacts = canViewContacts;
    }

    public List<Contact> getOwnContacts() {
        return this.owncontacts;
    }

    public void setOwnContacts(List<Contact> ownContacts) {
        this.owncontacts = ownContacts;
    }

    public DateTime getCategoryOrderUpdateTime() {
        return this.categoryorderupdatetime;
    }

    public void setCategoryOrderUpdateTime(DateTime categoryOrderUpdateTime) {
        this.categoryorderupdatetime = categoryOrderUpdateTime;
    }

    public DateTime getResignDate() {
        return this.resigndate;
    }

    public void setResignDate(DateTime resignDate) {
        this.resigndate = resignDate;
    }

    public DateTime getInheritDate() {
        return this.inheritdate;
    }

    public void setInheritDate(DateTime inheritDate) {
        this.inheritdate = inheritDate;
    }

    public List<Accountsharetargetsetting> getAccountsharetargetsettings() {
        return this.accountsharetargetsettings;
    }

    public void setAccountsharetargetsettings(List<Accountsharetargetsetting> accountsharetargetsettings) {
        this.accountsharetargetsettings = accountsharetargetsettings;
    }

    public boolean isSecretary() {
        return this.secretary;
    }

    public void setSecretary(boolean secretary) {
        this.secretary = secretary;
    }

    public List<Notice> getNotices() {
        return this.notices;
    }

    public void setNotices(List<Notice> notices) {
        this.notices = notices;
    }

    public InheritanceStatus getInheritancestatus() {
        return this.inheritancestatus;
    }

    public void setInheritancestatus(InheritanceStatus inheritancestatus) {
        this.inheritancestatus = inheritancestatus;
    }

    public Integer getContactcountinprivate() {
        return this.contactcountinprivate;
    }

    public void setContactcountinprivate(Integer contactcountinprivate) {
        this.contactcountinprivate = contactcountinprivate;
    }

    public boolean isPrintability() {
        return this.printability;
    }

    public void setPrintability(boolean printability) {
        this.printability = printability;
    }

    public AccountType getAccounttype() {
        return this.accounttype;
    }

    public void setAccounttype(AccountType accounttype) {
        this.accounttype = accounttype;
    }

    public AccountSubscriptionStatus getAccountSubscriptionStatus() {
        return this.accountsubscriptionstatus;
    }

    public void setAccountSubscriptionStatus(AccountSubscriptionStatus accountsubscriptionstatus) {
        if (accountsubscriptionstatus == AccountSubscriptionStatus.TEMPLATE_INVALIDATE) {
            this.accountsubscriptionstatus = accountsubscriptionstatus;
            this.setLockIssue(AccountLockedIssue.SUBSCRIPTION_TEMPLATE_INVALIDATE);
        } else {
            if (this.getLockIssue() == AccountLockedIssue.SUBSCRIPTION_TEMPLATE_INVALIDATE) {
                this.setLockIssue(AccountLockedIssue.NO_ISSUE);
            }
            this.accountsubscriptionstatus = accountsubscriptionstatus;
        }
    }

    public String getActivedirectoryserver() {
        return this.activedirectoryserver;
    }

    public void setActivedirectoryserver(String activedirectoryserver) {
        this.activedirectoryserver = activedirectoryserver;
    }

    public String getActivedirectorybasedn() {
        return this.activedirectorybasedn;
    }

    public void setActivedirectorybasedn(String activedirectorybasedn) {
        this.activedirectorybasedn = activedirectorybasedn;
    }

    public void setActivedirectoryguid(String activedirectoryguid) {
        this.activedirectoryguid = activedirectoryguid;
    }

    public String getActivedirectoryguid() {
        return this.activedirectoryguid;
    }

    public void setAssistantguid(String assistantguid) {
        this.assistantguid = assistantguid;
    }

    public String getAssistantguid() {
        return this.assistantguid;
    }

    public String getActivedirectoryaccountmail() {
        return this.activedirectoryaccountmail;
    }

    public void setActivedirectoryaccountmail(String activedirectoryaccountmail) {
        this.activedirectoryaccountmail = activedirectoryaccountmail;
    }

    public List<Accountbindingdeviceinfo> getAccountbindingdeviceinfos() {
        return this.accountbindingdeviceinfos;
    }

    public void setAccountbindingdeviceinfos(List<Accountbindingdeviceinfo> accountbindingdeviceinfos) {
        this.accountbindingdeviceinfos = accountbindingdeviceinfos;
    }

    public List<Accountloginrecord> getLoginrecords() {
        return this.loginrecords;
    }

    public void setLoginrecords(List<Accountloginrecord> loginrecords) {
        this.loginrecords = loginrecords;
    }

    public Accountsecuritysetting getAccountsecuritysetting() {
        return this.accountsecuritysetting;
    }

    public void setAccountsecuritysetting(Accountsecuritysetting accountsecuritysetting) {
        this.accountsecuritysetting = accountsecuritysetting;
    }

    public List<Accountmycardsetting> getAccountmycardsettings() {
        return this.accountmycardsettings;
    }

    public void setAccountmycardsettings(List<Accountmycardsetting> accountmycardsettings) {
        this.accountmycardsettings = accountmycardsettings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Account other = (Account)obj;
        return !(this.guid == null ? other.getGuid() != null : !this.guid.equals(other.getGuid()));
    }

    public String toString() {
        return "Account [guid=" + this.guid + ", createtime=" + this.createtime + ", categoryorderupdatetime=" + this.categoryorderupdatetime + ", resigndate=" + this.resigndate + ", inheritdate=" + this.inheritdate + ", displayname=" + this.displayname + ", email=" + this.email + ", logofilepath=" + this.logofilepath + ", password=" + this.password + ", inheritedaccount=" + this.inheritedaccount + ", accounttype=" + this.accounttype + ", activedirectoryserver=" + this.activedirectoryserver + ", activedirectorybasedn=" + this.activedirectorybasedn + ", activedirectoryaccountmail=" + this.activedirectoryaccountmail + ", exportability=" + this.exportability + ", secretary=" + this.secretary + ", printability=" + this.printability + ", role=" + this.role + ", status=" + this.status + ", inheritancestatus=" + this.inheritancestatus + ", contactcountinprivate=" + this.contactcountinprivate + ",company_guid=" + this.company_guid + "]";
    }

    public Integer getMycardcount() {
        return this.mycardcount;
    }

    public void setMycardcount(Integer mycardcount) {
        this.mycardcount = mycardcount;
    }
}

