/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto.mapper;

import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.mapper.DtoMapper;
import com.penpower.worldcard.team.entity.Account;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="accountInfoDtoMapper")
public class AccountInfoDtoMapper
implements DtoMapper<Account, AccountInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(AccountInfoDtoMapper.class);
    @Autowired
    private AccountDao accountDao;

    public AccountInfo transformToDto(Account entity) {
        AccountInfo accountInfo = new AccountInfo();
        accountInfo.setGuid(entity.getGuid() == null ? null : entity.getGuid());
        accountInfo.setEmail(entity.getEmail());
        accountInfo.setName(entity.getDisplayName());
        accountInfo.setRole(entity.getRole());
        accountInfo.setStatus(entity.getStatus());
        accountInfo.setInheritanceStatus(entity.getInheritancestatus());
        accountInfo.setCreateDate(entity.getCreateTime());
        accountInfo.setExportAbility(entity.isExportAbility());
        accountInfo.setSecretary(entity.isSecretary());
        accountInfo.setPrintAbility(entity.isPrintability());
        accountInfo.setAccountType(entity.getAccounttype());
        accountInfo.setLastPasswordChangeTime(entity.getLastPasswordChangeTime());
        accountInfo.setAccountSubscriptionStatus(entity.getAccountSubscriptionStatus());
        accountInfo.setLockedIssue(entity.getLockIssue());
        accountInfo.setLockCase(entity.getLockCase());
        accountInfo.setActivedirectoryguid(entity.getActivedirectoryguid());
        accountInfo.setAssistantGuid(entity.getAssistantguid());
        accountInfo.setMycardCount(entity.getMycardcount());
        if (entity.getCompanyGuid() != null) {
            accountInfo.setCompanyGuid(entity.getCompanyGuid());
        }
        accountInfo.setActiveDirectoryServer(entity.getActivedirectoryserver());
        accountInfo.setActiveDirectoryBaseDn(entity.getActivedirectorybasedn());
        accountInfo.setActiveDirectoryAccountMail(entity.getActivedirectoryaccountmail());
        Account account = this.accountDao.findOne(entity.getGuid());
        if (account.getBoss() != null) {
            Account boss = account.getBoss();
            accountInfo.setBoss(boss.getGuid());
        }
        return accountInfo;
    }

    public Account transformToEntity(AccountInfo dto) {
        return null;
    }
}

