/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.google.gson.annotations.SerializedName;
import com.penpower.worldcard.team.Utils.SidUtil;
import com.penpower.worldcard.team.enums.LanguageCode;
import com.penpower.worldcard.team.enums.QContactzSecurityType;
import com.penpower.worldcard.team.web.api.vo.QContactzAuthTokenVo;

public class QContactzAuthTokenDto {
    private String username;
    private String password;
    @SerializedName(value="security_code")
    private String securityCode;
    @SerializedName(value="security_answer")
    private String securityAnswer;
    @SerializedName(value="get_question")
    private Boolean securityQuestion;
    @SerializedName(value="send_mail")
    private Boolean securityEmail;
    private QContactzSecurityType securityType;
    private String qlang;

    public QContactzAuthTokenDto(String username, String password, QContactzSecurityType securityType, LanguageCode languageCode) {
        this.username = username;
        this.password = SidUtil.ezEncode((String)password);
        this.securityType = securityType;
        this.setQlang(languageCode);
    }

    public QContactzAuthTokenDto(QContactzAuthTokenVo vo, LanguageCode languageCode) {
        this(vo.getAccount(), vo.getPassword(), vo.getSecurityType(), languageCode);
        if (QContactzSecurityType.PHONE.equals((Object)vo.getSecurityType())) {
            this.securityCode = vo.getSecurityValue();
        } else if (QContactzSecurityType.EMAIL.equals((Object)vo.getSecurityType())) {
            this.securityCode = vo.getSecurityValue();
        } else if (QContactzSecurityType.QUESTION.equals((Object)vo.getSecurityType())) {
            this.securityAnswer = vo.getSecurityValue();
        }
    }

    public QContactzAuthTokenDto(String username, String encode, QContactzSecurityType type, String qlang) {
        this.username = username;
        this.password = encode;
        if (QContactzSecurityType.EMAIL.equals((Object)type)) {
            this.securityEmail = true;
        } else if (QContactzSecurityType.QUESTION.equals((Object)type)) {
            this.securityQuestion = true;
        }
        this.setQlang(qlang);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public Boolean getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(Boolean securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public String getSecurityAnswer() {
        return this.securityAnswer;
    }

    public void setSecurityAnswer(String securityAnswer) {
        this.securityAnswer = securityAnswer;
    }

    public Boolean getSecurityEmail() {
        return this.securityEmail;
    }

    public void setSecurityEmail(Boolean securityEmail) {
        this.securityEmail = securityEmail;
    }

    public QContactzSecurityType getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(QContactzSecurityType securityType) {
        this.securityType = securityType;
    }

    public String getQlang() {
        return this.qlang;
    }

    public void setQlang(String qlang) {
        this.qlang = qlang;
    }

    public void setQlang(LanguageCode langCode) {
        if (LanguageCode.CN.equals((Object)langCode)) {
            this.setQlang("SCH");
        } else if (LanguageCode.TW.equals((Object)langCode)) {
            this.setQlang("TCH");
        } else if (LanguageCode.JA.equals((Object)langCode)) {
            this.setQlang("JPN");
        } else if (LanguageCode.KO.equals((Object)langCode)) {
            this.setQlang("KOR");
        } else {
            this.setQlang("ENG");
        }
    }
}

