/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.dto.ContactIMInfo;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactdateInfo;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.dto.ContactsocialInfo;
import com.penpower.worldcard.team.dto.ContacturlInfo;
import com.penpower.worldcard.team.enums.NameOrder;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;

public class MycardInfo {
    private String id;
    @Valid
    private List<ContactnameInfo> names = new ArrayList();
    @Valid
    private List<ContactjobinfoInfo> jobinfos = new ArrayList();
    @Valid
    private List<ContactaddressInfo> addresses = new ArrayList();
    @Valid
    private List<ContactphoneInfo> phones = new ArrayList();
    @Valid
    private List<ContacturlInfo> urls = new ArrayList();
    @Valid
    private List<ContactemailInfo> emails = new ArrayList();
    @Valid
    private List<ContactIMInfo> IMs = new ArrayList();
    @Valid
    private List<ContactsocialInfo> socials = new ArrayList();
    @Valid
    private List<ContactdateInfo> dates = new ArrayList();
    @Size(max=4096)
    private String note;
    @Size(max=32)
    private String uniformNumber;
    @Size(max=64)
    private String nickname;
    private Integer recogLanguageFront = -1;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime birthday;
    private NameOrder asianSurnameOrderSetting;
    private NameOrder westernSurnameOrderSetting;

    public MycardInfo generateMycardInfo() {
        MycardInfo mycardInfo = new MycardInfo();
        mycardInfo.setNames(this.getNames());
        mycardInfo.setJobinfos(this.getJobinfos());
        mycardInfo.setAddresses(this.getAddresses());
        mycardInfo.setPhones(this.getPhones());
        mycardInfo.setUrls(this.getUrls());
        mycardInfo.setEmails(this.getEmails());
        mycardInfo.setIMs(this.getIMs());
        mycardInfo.setSocials(this.getSocials());
        mycardInfo.setDates(this.getDates());
        mycardInfo.setNote(this.getNote());
        mycardInfo.setUniformNumber(this.getUniformNumber());
        mycardInfo.setNickname(this.getNickname());
        mycardInfo.setRecogLanguageFront(this.getRecogLanguageFront());
        mycardInfo.setBirthday(this.getBirthday());
        return mycardInfo;
    }

    public MycardInfo generateMycardInfoWithNameAndEmail(String displayName, String email) {
        ContactnameInfo contactnameInfo = new ContactnameInfo();
        contactnameInfo.setFirstName(displayName);
        contactnameInfo.setRecognizeSource(RecognizeSourceType.MANUAL);
        this.setNames(Arrays.asList(contactnameInfo));
        ContactemailInfo contactemailInfo = new ContactemailInfo();
        contactemailInfo.setValue(email);
        contactemailInfo.setRecognizeSource(RecognizeSourceType.MANUAL);
        this.setEmails(Arrays.asList(contactemailInfo));
        return this.generateMycardInfo();
    }

    public List<ContactnameInfo> getNames() {
        return this.names;
    }

    public void setNames(List<ContactnameInfo> names) {
        this.names = names;
    }

    public List<ContactjobinfoInfo> getJobinfos() {
        return this.jobinfos;
    }

    public void setJobinfos(List<ContactjobinfoInfo> jobinfos) {
        this.jobinfos = jobinfos;
    }

    public List<ContactaddressInfo> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<ContactaddressInfo> addresses) {
        this.addresses = addresses;
    }

    public List<ContactphoneInfo> getPhones() {
        return this.phones;
    }

    public void setPhones(List<ContactphoneInfo> phones) {
        this.phones = phones;
    }

    public List<ContacturlInfo> getUrls() {
        return this.urls;
    }

    public void setUrls(List<ContacturlInfo> urls) {
        this.urls = urls;
    }

    public List<ContactemailInfo> getEmails() {
        return this.emails;
    }

    public void setEmails(List<ContactemailInfo> emails) {
        this.emails = emails;
    }

    public List<ContactIMInfo> getIMs() {
        return this.IMs;
    }

    public void setIMs(List<ContactIMInfo> IMs) {
        this.IMs = IMs;
    }

    public List<ContactsocialInfo> getSocials() {
        return this.socials;
    }

    public void setSocials(List<ContactsocialInfo> socials) {
        this.socials = socials;
    }

    public List<ContactdateInfo> getDates() {
        return this.dates;
    }

    public void setDates(List<ContactdateInfo> dates) {
        this.dates = dates;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getUniformNumber() {
        return this.uniformNumber;
    }

    public void setUniformNumber(String uniformNumber) {
        this.uniformNumber = uniformNumber;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Integer getRecogLanguageFront() {
        return this.recogLanguageFront;
    }

    public void setRecogLanguageFront(Integer recogLanguageFront) {
        this.recogLanguageFront = recogLanguageFront;
    }

    public DateTime getBirthday() {
        return this.birthday;
    }

    public void setBirthday(DateTime birthday) {
        this.birthday = birthday;
    }

    public NameOrder getAsianSurnameOrderSetting() {
        return this.asianSurnameOrderSetting;
    }

    public void setAsianSurnameOrderSetting(NameOrder asianSurnameOrderSetting) {
        this.asianSurnameOrderSetting = asianSurnameOrderSetting;
    }

    public NameOrder getWesternSurnameOrderSetting() {
        return this.westernSurnameOrderSetting;
    }

    public void setWesternSurnameOrderSetting(NameOrder westernSurnameOrderSetting) {
        this.westernSurnameOrderSetting = westernSurnameOrderSetting;
    }

    public String toString() {
        return "MycardInfo{id='" + this.id + '\'' + ", names=" + this.names + ", jobinfos=" + this.jobinfos + ", addresses=" + this.addresses + ", phones=" + this.phones + ", urls=" + this.urls + ", emails=" + this.emails + ", IMs=" + this.IMs + ", socials=" + this.socials + ", dates=" + this.dates + ", note='" + this.note + '\'' + ", uniformNumber='" + this.uniformNumber + '\'' + ", nickname='" + this.nickname + '\'' + ", recogLanguageFront=" + this.recogLanguageFront + ", birthday=" + this.birthday + '}';
    }
}

