/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.entity.Contactemail;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotBlank;

public class ContactemailInfo {
    private String guid;
    @NotBlank
    @Size(max=128)
    private String value;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private ContactFieldType type;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private RecognizeSourceType recognizeSource;

    public ContactemailInfo() {
    }

    public ContactemailInfo(Contactemail email) {
        this.guid = email.getGuid();
        this.value = email.getEmailValue();
        this.type = email.getEmailType();
        this.recognizeSource = email.getRecognizeSource();
    }

    public ContactemailInfo(String value, ContactFieldType type, RecognizeSourceType recognizeSource) {
        this.value = value;
        this.type = type;
        this.recognizeSource = recognizeSource;
    }

    public Contactemail newContactemail() {
        Contactemail email = new Contactemail();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            email.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            email.setGuid(this.guid);
        }
        email.setEmailType(this.type);
        email.setEmailValue(GlobalUtils.getFieldString((String)this.value, (int)128));
        email.setRecognizeSource(this.recognizeSource);
        return email;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ContactFieldType getType() {
        return this.type;
    }

    public void setType(ContactFieldType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RecognizeSourceType getRecognizeSource() {
        return this.recognizeSource;
    }

    public void setRecognizeSource(RecognizeSourceType recognizeSource) {
        this.recognizeSource = recognizeSource;
    }
}

