/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.entity.Contactdate;
import com.penpower.worldcard.team.enums.ContactDateType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;

public class ContactdateInfo {
    private String guid;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private ContactDateType type;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime value;

    public ContactdateInfo() {
    }

    public ContactdateInfo(String guid, ContactDateType type, DateTime value) {
        this.guid = guid;
        this.type = type;
        this.value = value;
    }

    public ContactdateInfo(Contactdate date) {
        this.guid = date.getGuid();
        this.type = date.getDateType();
        this.value = date.getDateValue();
    }

    public Contactdate newConctactdate() {
        Contactdate date = new Contactdate();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            date.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            date.setGuid(this.guid);
        }
        date.setDateType(this.type);
        date.setDateValue(this.value);
        return date;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ContactDateType getType() {
        return this.type;
    }

    public void setType(ContactDateType type) {
        this.type = type;
    }

    public DateTime getValue() {
        return this.value;
    }

    public void setValue(DateTime value) {
        this.value = value;
    }
}

