/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.config.ApplicationConfig;
import com.penpower.worldcard.team.entity.Contactcustomdata;
import com.penpower.worldcard.team.enums.CustomFieldContactAttribute;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import java.text.DecimalFormat;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotBlank;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactcustomdataInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ContactcustomdataInfo.class);
    private String guid;
    @NotBlank
    private String customfieldSettingGuid;
    private CustomFieldContactAttribute fieldType;
    @NotBlank
    @Size(max=256)
    private String textValue;
    private String fieldCaption;

    public ContactcustomdataInfo() {
    }

    public ContactcustomdataInfo(Contactcustomdata custom) {
        this.guid = custom.getGuid();
        this.customfieldSettingGuid = custom.getFieldsettingguid();
        this.fieldType = custom.getFieldtype();
        if (this.fieldType.equals((Object)CustomFieldContactAttribute.DATE) || this.fieldType.equals((Object)CustomFieldContactAttribute.DATE_TIME)) {
            DateTime dTime = custom.getDatetimevalue();
            this.textValue = dTime.toString(ApplicationConfig.DATE_TIME_FORMATTER);
        }
        if (this.fieldType.equals((Object)CustomFieldContactAttribute.EMAIL) || this.fieldType.equals((Object)CustomFieldContactAttribute.PICKLIST) || this.fieldType.equals((Object)CustomFieldContactAttribute.TEXT) || this.fieldType.equals((Object)CustomFieldContactAttribute.URL)) {
            this.textValue = custom.getTextvalue();
        }
        if (this.fieldType.equals((Object)CustomFieldContactAttribute.NUMBER)) {
            this.textValue = Long.toString(custom.getIntvalue());
        }
        if (this.fieldType.equals((Object)CustomFieldContactAttribute.FLOAT)) {
            DecimalFormat df = new DecimalFormat("#");
            df.setMaximumFractionDigits(3);
            df.setMaximumIntegerDigits(15);
            this.textValue = df.format(custom.getFloatvalue());
        }
    }

    public Contactcustomdata newContactcustomdata() {
        Contactcustomdata custom = new Contactcustomdata();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            custom.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            custom.setGuid(this.guid);
        }
        custom.setFieldtype(this.fieldType);
        if (this.fieldType.equals((Object)CustomFieldContactAttribute.DATE) || this.fieldType.equals((Object)CustomFieldContactAttribute.DATE_TIME)) {
            try {
                DateTime dTime = ApplicationConfig.DATE_TIME_FORMATTER.parseDateTime(this.textValue);
                custom.setDatetimevalue(dTime);
            }
            catch (Exception e) {
                throw new RequestArgumentNotValidException("Input custom field is not a valid datetime");
            }
        }
        if (this.fieldType.equals((Object)CustomFieldContactAttribute.EMAIL) || this.fieldType.equals((Object)CustomFieldContactAttribute.PICKLIST) || this.fieldType.equals((Object)CustomFieldContactAttribute.URL)) {
            custom.setTextvalue(this.textValue);
        }
        if (this.fieldType.equals((Object)CustomFieldContactAttribute.TEXT)) {
            custom.setTextvalue(GlobalUtils.getFieldString((String)this.textValue, (int)256));
        }
        if (this.fieldType.equals((Object)CustomFieldContactAttribute.NUMBER)) {
            try {
                long num = Long.parseLong(this.textValue);
                custom.setIntvalue(Long.valueOf(num));
            }
            catch (NumberFormatException e) {
                throw new RequestArgumentNotValidException("Input custom field is not a valid number(Long).");
            }
        }
        if (this.fieldType.equals((Object)CustomFieldContactAttribute.FLOAT)) {
            try {
                double f = Double.parseDouble(this.textValue);
                custom.setFloatvalue(Double.valueOf(f));
            }
            catch (NumberFormatException e) {
                throw new RequestArgumentNotValidException("Input custom field is not a valid number(Float).");
            }
        }
        return custom;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getCustomfieldSettingGuid() {
        return this.customfieldSettingGuid;
    }

    public void setCustomfieldSettingGuid(String customfieldSettingGuid) {
        this.customfieldSettingGuid = customfieldSettingGuid;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public CustomFieldContactAttribute getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(CustomFieldContactAttribute fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldCaption() {
        return this.fieldCaption;
    }

    public void setFieldCaption(String fieldCaption) {
        this.fieldCaption = fieldCaption;
    }
}

