/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.dto.ContactIMInfo;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactcustomdataInfo;
import com.penpower.worldcard.team.dto.ContactdateInfo;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.dto.ContactsocialInfo;
import com.penpower.worldcard.team.dto.ContacturlInfo;
import com.penpower.worldcard.team.entity.Contact;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;

public class ContactInfoForRequest {
    private static final Logger LOG = LoggerFactory.getLogger(ContactInfoForRequest.class);
    @Valid
    private List<ContactnameInfo> names = new ArrayList();
    @Valid
    private List<ContactjobinfoInfo> jobinfos = new ArrayList();
    @Valid
    private List<ContactaddressInfo> addresses = new ArrayList();
    @Valid
    private List<ContactphoneInfo> phones = new ArrayList();
    @Valid
    private List<ContacturlInfo> urls = new ArrayList();
    @Valid
    private List<ContactemailInfo> emails = new ArrayList();
    @Valid
    private List<ContactIMInfo> IMs = new ArrayList();
    @Valid
    private List<ContactsocialInfo> socials = new ArrayList();
    @Valid
    private List<ContactdateInfo> dates = new ArrayList();
    @Valid
    private List<ContactcustomdataInfo> customDataList = new ArrayList();
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime birthday;
    @Size(max=4096)
    private String note;
    @Size(max=32)
    private String uniformNumber;
    @Size(max=64)
    private String nickname;
    private Integer recogLanguageFront;
    private Integer recogLanguageBack;
    private Boolean beCorrected;
    private String ContentSha1;

    public ContactInfoForRequest() {
        this.setRecogLanguageFront(Integer.valueOf(-1));
        this.setRecogLanguageBack(Integer.valueOf(-1));
    }

    public ContactInfoForRequest(Contact contact) {
        this();
        Comparator orderComparator;
        if (!CollectionUtils.isEmpty((Collection)contact.getContactnames())) {
            orderComparator = (o1, o2) -> o1.getFieldOrder().compareTo(o2.getFieldOrder());
            this.names = contact.getContactnames().stream().sorted(orderComparator).map(name -> new ContactnameInfo(name)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactjobinfos())) {
            orderComparator = (o1, o2) -> o1.getFieldOrder().compareTo(o2.getFieldOrder());
            this.jobinfos = contact.getContactjobinfos().stream().sorted(orderComparator).map(job -> new ContactjobinfoInfo(job)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactaddresses())) {
            orderComparator = (o1, o2) -> o1.getFieldorder().compareTo(o2.getFieldorder());
            this.addresses = contact.getContactaddresses().stream().sorted(orderComparator).map(ad -> new ContactaddressInfo(ad)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactdates())) {
            orderComparator = (o1, o2) -> o1.getFieldorder().compareTo(o2.getFieldorder());
            this.dates = contact.getContactdates().stream().sorted(orderComparator).map(date -> new ContactdateInfo(date)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactphones())) {
            orderComparator = (o1, o2) -> o1.getFieldorder().compareTo(o2.getFieldorder());
            this.phones = contact.getContactphones().stream().sorted(orderComparator).map(phone -> new ContactphoneInfo(phone)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactemails())) {
            orderComparator = (o1, o2) -> o1.getFieldorder().compareTo(o2.getFieldorder());
            this.emails = contact.getContactemails().stream().sorted(orderComparator).map(email -> new ContactemailInfo(email)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactims())) {
            orderComparator = (o1, o2) -> o1.getFieldorder().compareTo(o2.getFieldorder());
            this.IMs = contact.getContactims().stream().sorted(orderComparator).map(im -> new ContactIMInfo(im)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContacturls())) {
            orderComparator = (o1, o2) -> o1.getFieldorder().compareTo(o2.getFieldorder());
            this.urls = contact.getContacturls().stream().sorted(orderComparator).map(url -> new ContacturlInfo(url)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactsocials())) {
            orderComparator = (o1, o2) -> o1.getFieldorder().compareTo(o2.getFieldorder());
            this.socials = contact.getContactsocials().stream().sorted(orderComparator).map(social -> new ContactsocialInfo(social)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)contact.getContactcustomdata())) {
            this.customDataList = contact.getContactcustomdata().stream().map(custom -> new ContactcustomdataInfo(custom)).collect(Collectors.toList());
        }
        if (contact.getBirthday() != null) {
            this.setBirthday(contact.getBirthday());
        }
        if (contact.getNote() != null) {
            this.setNote(contact.getNote());
        }
        if (contact.getUniformNumber() != null) {
            this.setUniformNumber(contact.getUniformNumber());
        }
        if (contact.getNickname() != null) {
            this.setNickname(contact.getNickname());
        }
        if (contact.getRecogLanguageFront() != null) {
            this.setRecogLanguageFront(contact.getRecogLanguageFront());
        }
        if (contact.getRecogLanguageBack() != null) {
            this.setRecogLanguageBack(contact.getRecogLanguageBack());
        }
        boolean beCorrected = false;
        if (contact.getIsCorrected() != null && contact.getIsCorrected().booleanValue()) {
            beCorrected = true;
        }
        this.setBeCorrected(Boolean.valueOf(beCorrected));
        this.setContentSha1(contact.getTextSha1());
    }

    public List<ContacturlInfo> getUrls() {
        return this.urls;
    }

    public void setUrls(List<ContacturlInfo> urls) {
        this.urls = urls;
    }

    public List<ContactemailInfo> getEmails() {
        return this.emails;
    }

    public void setEmails(List<ContactemailInfo> emails) {
        this.emails = emails;
    }

    public List<ContactIMInfo> getIMs() {
        return this.IMs;
    }

    public void setIMs(List<ContactIMInfo> iMs) {
        this.IMs = iMs;
    }

    public List<ContactsocialInfo> getSocials() {
        return this.socials;
    }

    public void setSocials(List<ContactsocialInfo> socials) {
        this.socials = socials;
    }

    public DateTime getBirthday() {
        return this.birthday;
    }

    public void setBirthday(DateTime birthday) {
        this.birthday = birthday;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getUniformNumber() {
        return this.uniformNumber;
    }

    public void setUniformNumber(String uniformNumber) {
        this.uniformNumber = uniformNumber;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Integer getRecogLanguageFront() {
        return this.recogLanguageFront;
    }

    public void setRecogLanguageFront(Integer recogLanguageFront) {
        this.recogLanguageFront = recogLanguageFront;
    }

    public Integer getRecogLanguageBack() {
        return this.recogLanguageBack;
    }

    public void setRecogLanguageBack(Integer recogLanguageBack) {
        this.recogLanguageBack = recogLanguageBack;
    }

    public List<ContactaddressInfo> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<ContactaddressInfo> addresses) {
        this.addresses = addresses;
    }

    public List<ContactdateInfo> getDates() {
        return this.dates;
    }

    public void setDates(List<ContactdateInfo> dates) {
        this.dates = dates;
    }

    public List<ContactjobinfoInfo> getJobinfos() {
        return this.jobinfos;
    }

    public void setJobinfos(List<ContactjobinfoInfo> jobinfos) {
        this.jobinfos = jobinfos;
    }

    public List<ContactnameInfo> getNames() {
        return this.names;
    }

    public void setNames(List<ContactnameInfo> names) {
        this.names = names;
    }

    public List<ContactphoneInfo> getPhones() {
        return this.phones;
    }

    public void setPhones(List<ContactphoneInfo> phones) {
        this.phones = phones;
    }

    public List<ContactcustomdataInfo> getCustomDataList() {
        return this.customDataList;
    }

    public void setCustomDataList(List<ContactcustomdataInfo> customDataList) {
        this.customDataList = customDataList;
    }

    public Boolean getBeCorrected() {
        return this.beCorrected;
    }

    public void setBeCorrected(Boolean beCorrected) {
        this.beCorrected = beCorrected;
    }

    public String getContentSha1() {
        return this.ContentSha1;
    }

    public void setContentSha1(String ContentSha1) {
        this.ContentSha1 = ContentSha1;
    }

    public String toString() {
        return "ContactInfoForRequest [names=" + this.names + ", jobinfos=" + this.jobinfos + ", addresses=" + this.addresses + ", phones=" + this.phones + ", urls=" + this.urls + ", emails=" + this.emails + ", IMs=" + this.IMs + ", socials=" + this.socials + ", dates=" + this.dates + ", birthday=" + this.birthday + ", note=" + this.note + ", uniformNumber=" + this.uniformNumber + ", nickname=" + this.nickname + ", recogLanguageFront=" + this.recogLanguageFront + ", recogLanguageBack=" + this.recogLanguageBack + ", beCorrected=" + this.beCorrected + "]";
    }
}

