/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dto;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.entity.Contactim;
import com.penpower.worldcard.team.enums.ContactIMType;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotBlank;

public class ContactIMInfo {
    private String guid;
    @NotBlank
    @Size(max=128)
    private String value;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private ContactIMType type;
    @NotNull
    @ApiModelProperty(dataType="java.lang.String", required=true)
    private RecognizeSourceType recognizeSource;

    public ContactIMInfo(String value, ContactIMType type, RecognizeSourceType recognizeSource) {
        this.value = value;
        this.type = type;
        this.recognizeSource = recognizeSource;
    }

    public ContactIMInfo() {
    }

    public ContactIMInfo(Contactim im) {
        this.guid = im.getGuid();
        this.value = im.getImValue();
        this.type = im.getImType();
        this.recognizeSource = im.getRecognizeSource();
    }

    public Contactim newContactim() {
        Contactim im = new Contactim();
        if (StringUtil.IsStringNullorEmpty((String)this.guid)) {
            im.setGuid(UUIDGenerator.getRandomUUID());
        } else {
            im.setGuid(this.guid);
        }
        im.setImType(this.type);
        im.setImValue(GlobalUtils.getFieldString((String)this.value, (int)128));
        im.setRecognizeSource(this.recognizeSource);
        return im;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ContactIMType getType() {
        return this.type;
    }

    public void setType(ContactIMType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RecognizeSourceType getRecognizeSource() {
        return this.recognizeSource;
    }

    public void setRecognizeSource(RecognizeSourceType recognizeSource) {
        this.recognizeSource = recognizeSource;
    }
}

