/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.dao;

import com.penpower.worldcard.team.dto.ContactStatusSyncInfo;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.enums.CrmExportFailedReason;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ContactStatusForAccountDao
extends JpaRepository<Contactstatusforaccount, String> {
    public Contactstatusforaccount findFirstByAccountAndContact(Account var1, Contact var2);

    @Query(value="select count(cs) > 0 from Contactstatusforaccount cs where cs.account.guid = :accountGuid and cs.contact.guid = :contactGuid and cs.isdeletedfromaccount = false")
    public Boolean existByAccountAndContact(@Param(value="accountGuid") String var1, @Param(value="contactGuid") String var2);

    @Query(value="select count(cs) from Contactstatusforaccount cs where cs.account.guid = :accountGuid and cs.contact.guid = :contactGuid and cs.isdeletedfromaccount = false")
    public Long countByAccountAndContact(@Param(value="accountGuid") String var1, @Param(value="contactGuid") String var2);

    @Query(value="select count(cs) from Contactstatusforaccount cs where cs.account.guid = :accountGuid and cs.isdeletedfromaccount = false")
    public Long countByAccount(@Param(value="accountGuid") String var1);

    @Query(value="select cs from Contactstatusforaccount cs where cs.account.guid = :accountGuid and cs.contact.guid = :contactGuid")
    public List<Contactstatusforaccount> findByAccountGuidAndContactGuid(@Param(value="accountGuid") String var1, @Param(value="contactGuid") String var2);

    public List<Contactstatusforaccount> findByAccountAndContact(Account var1, Contact var2);

    @Query(value="select cs.contact.guid from Contactstatusforaccount cs join Contactimage ci where cs.account.guid =:accountGuid and ci.contact.guid != cs.contact.guid and cs.isdeletedfromaccount = false ")
    public Page<String> getRandomContactWithoutImageList(@Param(value="accountGuid") String var1, Pageable var2);

    @Query(value="select cs from Contactstatusforaccount cs where cs.account.guid = :accountGuid and (cs.modifyTimeForCrmSync >= :modifyTime or cs.contact.modifyTimeForCrmSync >= :modifyTime)")
    public List<Contactstatusforaccount> findContactByAccountAndModifyTimeForSync(@Param(value="accountGuid") String var1, @Param(value="modifyTime") DateTime var2);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactStatusSyncInfo(cs, c.guid, c.modifyTimeForCrmSync) from Contactstatusforaccount cs join cs.contact c where cs.account.guid = :accountGuid and c.isdeleted = false and cs.isdeletedfromaccount = false and (cs.modifyTimeForCrmSync > :modifyTime or c.modifyTimeForCrmSync > :modifyTime)")
    public List<ContactStatusSyncInfo> findContactUndeletedByAccountAndModifyTimeForCRMSync(@Param(value="accountGuid") String var1, @Param(value="modifyTime") DateTime var2);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactStatusSyncInfo(cs, c.guid, c.modifyTimeForCrmSync) from Contactstatusforaccount cs join cs.contact c where cs.account.guid = :accountGuid and (cs.modifyTimeForCrmSync > :modifyTime or c.modifyTimeForCrmSync > :modifyTime)")
    public List<ContactStatusSyncInfo> findContactByAccountAndModifyTimeForCRMSync(@Param(value="accountGuid") String var1, @Param(value="modifyTime") DateTime var2);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactStatusSyncInfo(cs, c.guid, c.modifyTimeForContactServerSync) from Contactstatusforaccount cs join cs.contact c where cs.account.guid = :accountGuid and c.isdeleted = false and cs.isdeletedfromaccount = false and (cs.modifyTimeForContactServerSync > :modifyTime or c.modifyTimeForContactServerSync > :modifyTime)")
    public List<ContactStatusSyncInfo> findContactUndeletedByAccountAndModifyTimeForContactServerSync(@Param(value="accountGuid") String var1, @Param(value="modifyTime") DateTime var2);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactStatusSyncInfo(cs, c.guid, c.modifyTimeForContactServerSync) from Contactstatusforaccount cs join cs.contact c where cs.account.guid = :accountGuid and (cs.modifyTimeForContactServerSync > :modifyTime or c.modifyTimeForContactServerSync > :modifyTime)")
    public List<ContactStatusSyncInfo> findContactByAccountAndModifyTimeForContactServerSync(@Param(value="accountGuid") String var1, @Param(value="modifyTime") DateTime var2);

    @Query(value="select cs.contact.guid from Contactstatusforaccount cs where cs.account = :account and cs.isdeletedfromaccount = :isDeleted")
    public List<String> findContactGuidByAccountAndIsdeletedfromaccount(@Param(value="account") Account var1, @Param(value="isDeleted") Boolean var2);

    @Query(value="select p from Contactstatusforaccount p join p.contact c where c.guid = :contactGuid")
    public List<Contactstatusforaccount> findByContactGuid(@Param(value="contactGuid") String var1);

    @Query(value="select p from Contactstatusforaccount p join p.contact c where c.modifytime >:modifyTime and p.statusupdatetime >:updateTime and c.isdeleted = false and p.isdeletedfromaccount = false and p.account =:account")
    public List<Contactstatusforaccount> findContactModifyTime(@Param(value="modifyTime") DateTime var1, @Param(value="account") Account var2);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime  >:updateTime and  p.statusupdatetime <= :stopTime and p.account =:account ")
    public Page<Contactstatusforaccount> findBetweenTime(@Param(value="updateTime") DateTime var1, @Param(value="stopTime") DateTime var2, @Param(value="account") Account var3, Pageable var4);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime  >:updateTime and  p.statusupdatetime <= :stopTime and p.account =:account  ")
    public List<Contactstatusforaccount> findBetweenTimeList(@Param(value="updateTime") DateTime var1, @Param(value="stopTime") DateTime var2, @Param(value="account") Account var3);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime >=:seekTime and  p.statusupdatetime <=:stopTime and p.account =:account  ")
    public Page<Contactstatusforaccount> findBetweenSeekTime(@Param(value="seekTime") DateTime var1, @Param(value="stopTime") DateTime var2, @Param(value="account") Account var3, Pageable var4);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime >=:seekTime and  p.statusupdatetime <=:stopTime and p.account =:account  ")
    public List<Contactstatusforaccount> findBetweenSeekTimeList(@Param(value="seekTime") DateTime var1, @Param(value="stopTime") DateTime var2, @Param(value="account") Account var3);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime >=:seekTime and  p.statusupdatetime <=:stopTime and p.account =:account and p.isdeletedfromaccount = false ")
    public Page<Contactstatusforaccount> findBetweenSeekTimeWithoutDeleted(@Param(value="seekTime") DateTime var1, @Param(value="stopTime") DateTime var2, @Param(value="account") Account var3, Pageable var4);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime >=:seekTime and  p.statusupdatetime <=:stopTime and p.account =:account and p.isdeletedfromaccount = false ")
    public List<Contactstatusforaccount> findBetweenSeekTimeWithoutDeletedList(@Param(value="seekTime") DateTime var1, @Param(value="stopTime") DateTime var2, @Param(value="account") Account var3);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime  >=:seekTime  and p.account =:account and p.isdeletedfromaccount = false  ")
    public Page<Contactstatusforaccount> findAfterSeekTimeWithoutDeleted(@Param(value="seekTime") DateTime var1, @Param(value="account") Account var2, Pageable var3);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime  >=:seekTime  and p.account =:account and p.isdeletedfromaccount = false  ")
    public List<Contactstatusforaccount> findAfterSeekTimeWithoutDeletedList(@Param(value="seekTime") DateTime var1, @Param(value="account") Account var2);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime  >:updateTime  and p.account =:account  ")
    public Page<Contactstatusforaccount> findAfterTime(@Param(value="updateTime") DateTime var1, @Param(value="account") Account var2, Pageable var3);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime  >=:seekTime  and p.account =:account ")
    public Page<Contactstatusforaccount> findAfterSeekTime(@Param(value="seekTime") DateTime var1, @Param(value="account") Account var2, Pageable var3);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime >=:seekTime   and p.account=:account ")
    public List<Contactstatusforaccount> findAfterTimeList(@Param(value="seekTime") DateTime var1, @Param(value="account") Account var2);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime >:updateTime and  p.isdeletedfromaccount = true  and p.account=:account ")
    public List<Contactstatusforaccount> findAfterTimeAndDeleted(@Param(value="updateTime") DateTime var1, @Param(value="account") Account var2);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime >:updateTime and p.statusupdatetime <= :seekTime and  p.isdeletedfromaccount = true  and p.account=:account ")
    public List<Contactstatusforaccount> findBetweenTimeAndDeleted(@Param(value="updateTime") DateTime var1, @Param(value="seekTime") DateTime var2, @Param(value="account") Account var3);

    @Query(value="select p from Contactstatusforaccount p  where p.statusupdatetime >=:dateSeekTime and p.statusupdatetime <= :seekTime and  p.isdeletedfromaccount = true  and p.account=:account ")
    public List<Contactstatusforaccount> findBetweenSeekTimeAndDeleted(@Param(value="dateSeekTime") DateTime var1, @Param(value="seekTime") DateTime var2, @Param(value="account") Account var3);

    @Query(value="select cs from Contactstatusforaccount cs where cs.account.guid = :accountGuid and cs.salesforceaccount = :salesforceAccount and cs.exporttosalesforceid = :salesforceContactID")
    public List<Contactstatusforaccount> findByAccountAndSalesforceAccountAndContactID(@Param(value="accountGuid") String var1, @Param(value="salesforceAccount") String var2, @Param(value="salesforceContactID") String var3);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactStatusSyncInfo(cs, c.guid, c.modifyTimeForContactServerSync) from Contactstatusforaccount cs join cs.contact c where cs.account.guid = :accountGuid and cs.exchangeaccount = :exchangeAccount and cs.exporttoexchangeid = :exchangeContactId")
    public List<ContactStatusSyncInfo> findByAccountAndExchangeAccountAndContactID(@Param(value="accountGuid") String var1, @Param(value="exchangeAccount") String var2, @Param(value="exchangeContactId") String var3);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactStatusSyncInfo(cs, c.guid, c.modifyTimeForCrmSync) from Contactstatusforaccount cs join cs.contact c where cs.account.guid = :accountGuid and cs.salesforceaccount = :salesforceAccount and cs.exporttosalesforceid = :salesforceContactID")
    public List<ContactStatusSyncInfo> findSyncInfoByAccountAndSalesforceAccountAndContactId(@Param(value="accountGuid") String var1, @Param(value="salesforceAccount") String var2, @Param(value="salesforceContactID") String var3);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactStatusSyncInfo(cs, c.guid, c.modifyTimeForContactServerSync) from Contactstatusforaccount cs join cs.contact c where cs.account.guid = :accountGuid and cs.office365account = :office365Account and cs.exporttooffice365id = :office365ContactId")
    public List<ContactStatusSyncInfo> findByAccountAndOffice365AccountAndContactID(@Param(value="accountGuid") String var1, @Param(value="office365Account") String var2, @Param(value="office365ContactId") String var3);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactStatusSyncInfo(cs, c.guid, c.modifyTimeForContactServerSync) from Contactstatusforaccount cs join cs.contact c where cs.account.guid = :accountGuid and cs.qcontactzaccount = :qcontactzAccount and cs.exporttoqcontactzid = :qcontactzContactId")
    public List<ContactStatusSyncInfo> findByAccountAndQContactzAccountAndContactID(@Param(value="accountGuid") String var1, @Param(value="qcontactzAccount") String var2, @Param(value="qcontactzContactId") String var3);

    @Query(value="select new com.penpower.worldcard.team.dto.ContactStatusSyncInfo(cs, c.guid, c.modifyTimeForCrmSync) from Contactstatusforaccount cs join cs.contact c where cs.account.guid = :accountGuid and c.isdeleted = false and (cs.crmexportfailedreason != :failedReason or cs.crmexportfailedreason is null) and cs.isdeletedfromaccount = false and (cs.modifyTimeForCrmSync > :modifyTime or c.modifyTimeForCrmSync > :modifyTime)")
    public List<ContactStatusSyncInfo> findContactUndeletedByAccountAndModifyTimeExcludeFailedReasonForCRMSync(@Param(value="accountGuid") String var1, @Param(value="modifyTime") DateTime var2, @Param(value="failedReason") CrmExportFailedReason var3);
}

