/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.crm.salesforce;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.OkHttpUtils;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.CRMAuthenticationManager;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.crm.salesforce.SalesForceAuthenticationManager;
import com.penpower.worldcard.team.crm.salesforce.SalesForceOAuthTokenType;
import com.penpower.worldcard.team.crm.salesforce.SalesforceOAuthToken;
import com.penpower.worldcard.team.crm.salesforce.SalesforceUserAgentOAuthToken;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.exception.CRMLoginException;
import com.penpower.worldcard.team.exception.CRMLogoutException;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.exception.HttpConnectionException;
import java.io.IOException;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SalesForceAuthenticationManager
implements CRMAuthenticationManager {
    private static final Logger LOG = LoggerFactory.getLogger(SalesForceAuthenticationManager.class);
    public static final String OAUTH_LOGIN_URL_FORMAT = "https://%s/services/oauth2/token";
    public static final String STANDARD_DOMAIN = "login.salesforce.com";
    private static final String LOGOUT_URL_FORMAT = "https://%s/services/oauth2/revoke";

    public BasicToken loginCRM(CRMSettingsDto CRMSettingsDto2, String domain, OkHttpClient client) throws CRMLoginException, HttpConnectionException {
        Gson gson = new Gson();
        String url = String.format(OAUTH_LOGIN_URL_FORMAT, domain);
        FormBody formBody = new FormBody.Builder().add("grant_type", "password").add("client_id", "3MVG9A2kN3Bn17ht.gwAqdFxa15P7PR2Qq.UehIdGvredPOsMv6W3ukTgnHPuG4tILwlUHhlD9iMbViwTmvm9").add("client_secret", "5035759151164667231").add("username", CRMSettingsDto2.getUserCRMAccount()).add("password", CRMSettingsDto2.getUserCRMPassword() + CRMSettingsDto2.getUserCRMSecretToken()).build();
        Request request = new Request.Builder().url(url).post((RequestBody)formBody).build();
        SalesforceOAuthToken authResult = null;
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new CRMLoginException("Unexpected code " + OkHttpUtils.getResponseBodyString((Response)response));
            }
            String authString = OkHttpUtils.getResponseBodyString((Response)response);
            authResult = (SalesforceOAuthToken)gson.fromJson(authString, SalesforceOAuthToken.class);
            LOG.debug("authString : {} ", (Object)authString);
        }
        catch (IOException ex) {
            LOG.error("Failed to login CRM system.", (Throwable)ex);
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
        return authResult;
    }

    public void logoutCRM(String accessToken, String domain, OkHttpClient client) throws CRMLogoutException {
        String url = String.format(LOGOUT_URL_FORMAT, domain);
        FormBody revokeTokenFormBody = new FormBody.Builder().add("token", accessToken).build();
        Request revokeTokenRequest = new Request.Builder().url(url).post((RequestBody)revokeTokenFormBody).build();
        try (Response revokeResponse = client.newCall(revokeTokenRequest).execute();){
            if (!revokeResponse.isSuccessful()) {
                throw new CRMOperationException("CRM logout failed , Unexpected code " + OkHttpUtils.getResponseBodyString((Response)revokeResponse));
            }
        }
        catch (IOException e) {
            LOG.error("Failed to logout CRM... ", (Throwable)e);
            throw new HttpConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean testAccessToken(BasicToken authToken, SalesForceOAuthTokenType tokenType, OkHttpClient client) throws IOException {
        if (authToken instanceof NullCRMToken) {
            return false;
        }
        return this.testAccessTokenInternal(authToken, tokenType, client);
    }

    public boolean testAccessTokenByJsonString(String accessTokenJson, SalesForceOAuthTokenType tokenType, OkHttpClient client) throws IOException {
        BasicToken authToken = this.getTokenByType(accessTokenJson, tokenType);
        if (authToken instanceof NullCRMToken) {
            return false;
        }
        return this.testAccessTokenInternal(authToken, tokenType, client);
    }

    private boolean testAccessTokenInternal(BasicToken authToken, SalesForceOAuthTokenType tokenType, OkHttpClient client) throws IOException {
        String instanceUrl = null;
        switch (1.$SwitchMap$com$penpower$worldcard$team$crm$salesforce$SalesForceOAuthTokenType[tokenType.ordinal()]) {
            case 1: {
                instanceUrl = ((SalesforceUserAgentOAuthToken)authToken).getInstance_url();
                break;
            }
            default: {
                instanceUrl = ((SalesforceOAuthToken)authToken).getInstance_url();
            }
        }
        String testGetSobjectUrl = instanceUrl + "/services/data/v39.0/sobjects";
        String accessToken = authToken.getAccess_token();
        try {
            Request testAccessTokenRequest = new Request.Builder().addHeader("Authorization", "Bearer " + accessToken).url(testGetSobjectUrl).build();
            try (Response testAccessTokenResponse = client.newCall(testAccessTokenRequest).execute();){
                if (!testAccessTokenResponse.isSuccessful()) {
                    String failureMessage = OkHttpUtils.getResponseBodyString((Response)testAccessTokenResponse);
                    LOG.warn("Test access_token failed : {} ", (Object)failureMessage);
                    LOG.error("accessToken={}", (Object)accessToken);
                    throw new CRMOperationException(failureMessage);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Test access_token failed IOException,", (Throwable)e);
            LOG.error("accessToken={}", (Object)accessToken);
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Test access_token failed,", (Throwable)e);
            LOG.error("accessToken={}", (Object)accessToken);
            throw new CRMOperationException(e.getMessage());
        }
        return true;
    }

    private BasicToken getTokenByType(String userCRMloginTokenString, SalesForceOAuthTokenType tokenType) {
        BasicToken authResult = null;
        Gson gson = new Gson();
        switch (1.$SwitchMap$com$penpower$worldcard$team$crm$salesforce$SalesForceOAuthTokenType[tokenType.ordinal()]) {
            case 1: {
                try {
                    authResult = (BasicToken)gson.fromJson(userCRMloginTokenString, SalesforceUserAgentOAuthToken.class);
                }
                catch (Exception ex) {
                    authResult = new NullCRMToken();
                }
                break;
            }
            default: {
                try {
                    authResult = (BasicToken)gson.fromJson(userCRMloginTokenString, SalesforceOAuthToken.class);
                    break;
                }
                catch (Exception ex) {
                    authResult = new NullCRMToken();
                }
            }
        }
        return authResult;
    }

    public BasicToken getAccessToken(String CRMLoginJsonToken, SalesForceOAuthTokenType tokenType) {
        return this.getTokenByType(CRMLoginJsonToken, tokenType);
    }

    public void testDomain(String domain, OkHttpClient client) {
        block17: {
            try {
                String url = "";
                url = domain.indexOf("https://") == 0 ? String.format("%s/services/oauth2/token", domain) : String.format(OAUTH_LOGIN_URL_FORMAT, domain);
                Request testDomainRequest = new Request.Builder().url(url).get().build();
                try (Response testDomainResponse = client.newCall(testDomainRequest).execute();){
                    String message = OkHttpUtils.getResponseBodyString((Response)testDomainResponse);
                    if (message.contains("unsupported_grant_type") && message.contains("grant type not supported")) {
                        LOG.debug("correctUrl");
                        break block17;
                    }
                    if (testDomainResponse.code() == 404) {
                        message = "UnknownHostException";
                    }
                    throw new HttpConnectionException(message);
                }
            }
            catch (Exception ex) {
                String errorMessage = ex.getMessage();
                String exceptionStr = ex.toString();
                if (exceptionStr.contains("UnknownHostException") || exceptionStr.contains("SunCertPathBuilderException")) {
                    errorMessage = "Unknown Salesforce Host:" + domain;
                }
                throw new HttpConnectionException(errorMessage);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SalesforceUserAgentOAuthToken getOauthTokenByCode(String authCode, String domain, OkHttpClient client) {
        String url = String.format(OAUTH_LOGIN_URL_FORMAT, domain);
        FormBody body = new FormBody.Builder().add("code", authCode).add("redirect_uri", "https://salesforce-oauth.worldcardteam.com").add("client_id", "3MVG9A2kN3Bn17ht.gwAqdFxa15P7PR2Qq.UehIdGvredPOsMv6W3ukTgnHPuG4tILwlUHhlD9iMbViwTmvm9").add("client_secret", "5035759151164667231").add("grant_type", "authorization_code").build();
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        Gson gson = new Gson();
        LOG.info("get token url={}", (Object)url);
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            if (!response.isSuccessful()) {
                LOG.error("url={}, responseString={}", (Object)url, (Object)responseString);
                throw new Exception(responseString);
            }
            LOG.info("url={}, responseString={}", (Object)url, (Object)responseString);
            SalesforceUserAgentOAuthToken salesforceUserToken = (SalesforceUserAgentOAuthToken)gson.fromJson(responseString, SalesforceUserAgentOAuthToken.class);
            Request getUserInfoRequest = new Request.Builder().url(salesforceUserToken.getId()).header("Authorization", salesforceUserToken.getToken_type() + " " + salesforceUserToken.getAccess_token()).get().build();
            LOG.info("get user info url={}", (Object)salesforceUserToken.getId());
            try (Response getUserInfoResponse = client.newCall(getUserInfoRequest).execute();){
                String userInfoString = OkHttpUtils.getResponseBodyString((Response)getUserInfoResponse);
                if (!getUserInfoResponse.isSuccessful()) {
                    LOG.error("url={}, responseString={}", (Object)salesforceUserToken.getId(), (Object)userInfoString);
                    throw new Exception(userInfoString);
                }
                String email = new JSONObject(userInfoString).getString("username");
                salesforceUserToken.setEmail(email);
            }
            SalesforceUserAgentOAuthToken salesforceUserAgentOAuthToken = salesforceUserToken;
            return salesforceUserAgentOAuthToken;
        }
        catch (Exception ex) {
            LOG.error("Get salesforce oauth token error", (Throwable)ex);
            throw new HttpConnectionException(ex.getMessage());
        }
    }
}

