/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.websocket;

import com.penpower.worldcard.team.config.websocket.WebSocketSessionManager;
import com.penpower.worldcard.team.websokcet.SimpleTextMessageSender;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketSessionManager {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTextMessageSender.class);
    private final Map<WebsocketKeyObject, WebSocketSession> internalSessionMap = new ConcurrentHashMap();

    public final void addSession(String email, String token, WebSocketSession session) {
        WebsocketKeyObject key = new WebsocketKeyObject(this, email, token);
        this.internalSessionMap.put(key, session);
        LOG.debug("self class : {} ", (Object)this);
        LOG.debug("add websocket session by key : {}", (Object)key);
        this.printMapSize();
    }

    private void printMapSize() {
        LOG.debug("session map size  : {} ", (Object)this.internalSessionMap.size());
    }

    public final List<WebSocketSession> getSessionsWithOutFilters(List<String> filterEmails, List<String> filterTokens) {
        LOG.debug("internalSessionMap : {} ", (Object)this.internalSessionMap);
        List<WebSocketSession> sessions = this.internalSessionMap.entrySet().stream().filter(entry -> !Optional.ofNullable(filterEmails).orElse(Collections.emptyList()).contains(((WebsocketKeyObject)entry.getKey()).getEmail())).filter(entry -> !Optional.ofNullable(filterTokens).orElse(Collections.emptyList()).contains(((WebsocketKeyObject)entry.getKey()).getToken())).map(entry -> (WebSocketSession)entry.getValue()).collect(Collectors.toList());
        return sessions;
    }

    public final List<WebSocketSession> getSessionsWithFilters(List<String> filterEmails, List<String> filterTokens) {
        List<WebSocketSession> sessions = this.internalSessionMap.entrySet().stream().filter(entry -> {
            if (filterEmails == null) {
                return true;
            }
            return Optional.ofNullable(filterEmails).orElse(Collections.emptyList()).contains(((WebsocketKeyObject)entry.getKey()).getEmail());
        }).filter(entry -> {
            if (filterTokens == null) {
                return true;
            }
            return Optional.ofNullable(filterTokens).orElse(Collections.emptyList()).contains(((WebsocketKeyObject)entry.getKey()).getToken());
        }).map(entry -> (WebSocketSession)entry.getValue()).collect(Collectors.toList());
        return sessions;
    }

    public final void removeSession(String email, String token, WebSocketSession session) {
        WebsocketKeyObject key = new WebsocketKeyObject(this, email, token);
        this.internalSessionMap.remove(key);
        LOG.debug("remove websocket session by key : {}", (Object)key);
        this.printMapSize();
    }

    public final WebSocketSession getUserSession(String token) {
        WebSocketSession seession = (WebSocketSession)this.internalSessionMap.entrySet().stream().filter(entry -> ((WebsocketKeyObject)entry.getKey()).getToken().equals(token)).findFirst().get().getValue();
        return seession;
    }

    public final void clear() {
        this.internalSessionMap.clear();
    }
}

