/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.security;

import com.penpower.worldcard.team.auth.AccountSecurityFilter;
import com.penpower.worldcard.team.auth.LocalStorageSpaceAuthenticationProvider;
import com.penpower.worldcard.team.auth.SubscriptionAuthenticationProvider;
import com.penpower.worldcard.team.auth.TokenAuthenticationFilter;
import com.penpower.worldcard.team.auth.TokenAuthenticationProvider;
import com.penpower.worldcard.team.auth.TokenManager;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.service.AccountSecurityService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.TokenService;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.web.filter.CharacterEncodingFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, proxyTargetClass=true)
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String TOKEN_PARAM_NAME = "token";
    private static final String API_ROOT_PATH = "/api/**";
    private static final String LOGIN_URL_PATH = "/auth/login**";
    private static final String LOGOUT_URL_PATH = "/auth/logout**";
    private static final String PURCHASE_LICENSE_PATH = "/auth/purchase_license**";
    private static final String FORGET_PASSWORD_URL_PATH = "/auth/forgetPassword**";
    private static final String VERIFY_FORGET_PASSWORD_URL_PATH = "/auth/verify_forget_password_token**";
    private static final String VERIFY_APPLYACCOUNT_URL_PATH = "/auth/verify_apply_account_token**";
    private static final String RESET_PASSWORD_URL_PATH = "/auth/resetPassword**";
    private static final String REFRESH_TOKEN_URL_PATH = "/auth/refreshToken**";
    private static final String REGISTER_NEW_PATH = "/system/Initial**";
    private static final String SYSTEM_IS_ACTIVED_PATH = "/system/IsServerActived**";
    private static final String RE_REGISTER_NEW_PATH = "/system/ReInitial**";
    private static final String ISSUPPORT_SUBSCRIPTION_PATH = "/system/IsSupportSubscription**";
    private static final String SYSTEM_IS_MULTICOMPANY_FRAME = "/system/getIsMultiCompanyFrame**";
    private static final String SYSTEM_IS_SIMPLIFYUI = "/system/getIsSimplifyUI**";
    private static final String SYSTEM_INITIAL_BY_DEMO = "/system/InitialbyDemo**";
    private static final String SYSTEM_INITIAL_BY_CLOUD = "/system/InitialbyCloud**";
    private static final String SYSTEM_INITIAL_BY_CLOUD_WEB = "/system/InitialCloudbyWeb**";
    private static final String SYSTEM_INITIAL_BY_CLOUD_SINGLE_ACCOUNT = "/system/InitialbyCloudSingleAccount**";
    private static final String SYSTEM_GETUPDISPLAYOPTION = "/system/getUIDisplayOption**";
    private static final String SYSTEM_IS_REACTIVED_PATH = "/system/IsServerNeedReActived**";
    private static final String SYSTEM_IS_ALIVE = "/system/IsAlive**";
    private static final String SYSTEM_IS_FINE = "/system/IsFine**";
    private static final String SYSTEM_GET_VERSION_INFO = "/system/GetVersionInfo**";
    private static final String SYSTEM_GET_PRODUCT_VERSION_INFO = "/system/GetProductVersionInfo**";
    private static final String SYSTEM_GET_PRODUCT_INFO = "/system/GetProductInfo**";
    private static final String SYSTEM_CHECK_SERVICE_STATUS = "/system/CheckServiceStatus**";
    private static final String SYSTEM_CHANGE_SYSTEM_LOG_LEVEL = "/system/change_system_log_level**";
    private static final String SYSTEM_CHECK_GET_ASUSDNSNAME = "/system/GetASUSDDNSName**";
    private static final String SYSTEM_GET_REGISTER_STATUS = "/system/GetRegisterStatus**";
    private static final String SYSTEM_GET_DB_BUILD_TIME = "/system/GetDBBuildTime**";
    private static final String SYSTEM_GET_lICENSE = "/system/GetLicense**";
    private static final String SYSTEM_GET_SUBSCRIPTIONSTATUS = "/system/GetSubscriptionStatus**";
    private static final String SYSTEM_REMOVE_SERVER = "/system/RemoveServer**";
    private static final String SYSTEM_REFRESH_SUBSCRIPTION_INFO_BY_SERVICE_ID = "/system/RefreshSubscriptionInfoByServiceId**";
    private static final String SYSTEM_PAUSE_ALL_SCHEDULER = "/system/pause_all_scheduler**";
    private static final String SYSTEM_RESUME_ALL_SCHEDULER = "/system/resume_all_scheduler**";
    private static final String SYSTEM_GET_ALL_ACCOUNT = "/system/GetAccounts**";
    private static final String SYSTEM_GET_ALL_TOKEN = "/system/GetTokens**";
    private static final String SYSTEM_DELETECOMPANY = "/system/DeleteCompany**";
    private static final String SYSTEM_GET_AVAILABLE_COMPANY_COUNT = "/system/getAvailableCompanyCount**";
    private static final String SYSTEM_IS_CLOUD = "/system/IsCloud**";
    private static final String SYSTEM_APPLYACCOUNT = "/system/ApplyAccount**";
    private static final String RESTORE_STORAGE_INFOS_PATH = "/api/restore/get_restore_storage_infos";
    private static final String RESTORE_JOB_STATUS_PATH = "/api/restore/get_restore_job_status";
    private static final String RESTORE_JOB_PROGRESS_PATH = "/api/restore/get_restore_job_progress";
    private static final String RESTORE_START_JOB_NO_AUTH_PATH = "/api/restore/start_restore_no_auth";
    private static final String MYCARD_NO_AUTH_PATH = "/api/mycard_unauth/**";
    private static final String TEST_URL_PATH = "/api/test**";
    private static final String SWAGGER_WEBJARS_PATH = "/webjars/**";
    private static final String SWAGGER_UI_PATH = "/swagger-ui.html**";
    private static final String SWAGGER_API_DOC_PATH = "/api-docs**";
    private static final String SWAGGER_V2_API_DOC_PATH = "/v2/**";
    private static final String SWAGGER_RESOURCE_PATH = "/swagger-resources**";
    private static final String SWAGGER_SECURITY_PATH = "/configuration/security**";
    private static final String SWAGGER_CONFIGURATION_UI_PATH = "/configuration/ui**";
    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private Environment env;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountSecurityService accountSecurityService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private TokenService tokenService;

    protected void configure(HttpSecurity http) throws Exception {
        CharacterEncodingFilter filter = new CharacterEncodingFilter();
        filter.setEncoding("UTF-8");
        filter.setForceEncoding(true);
        http.addFilterBefore((Filter)filter, CsrfFilter.class);
        http.headers().httpStrictTransportSecurity().disable();
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{API_ROOT_PATH})).authenticated().anyRequest()).authenticated().and()).anonymous().disable()).exceptionHandling().authenticationEntryPoint(this.unauthorizedEntryPoint());
        http.addFilterBefore((Filter)new TokenAuthenticationFilter(this.authenticationManager(), this.applicationProperties, this.tokenService), BasicAuthenticationFilter.class);
        http.addFilterAfter((Filter)new AccountSecurityFilter(this.accountSecurityService, this.accountService), BasicAuthenticationFilter.class);
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{TEST_URL_PATH})).antMatchers(new String[]{LOGIN_URL_PATH})).antMatchers(new String[]{LOGOUT_URL_PATH})).antMatchers(new String[]{FORGET_PASSWORD_URL_PATH})).antMatchers(new String[]{PURCHASE_LICENSE_PATH})).antMatchers(new String[]{VERIFY_FORGET_PASSWORD_URL_PATH})).antMatchers(new String[]{RESET_PASSWORD_URL_PATH})).antMatchers(new String[]{REFRESH_TOKEN_URL_PATH})).antMatchers(new String[]{SWAGGER_UI_PATH})).antMatchers(new String[]{SWAGGER_V2_API_DOC_PATH})).antMatchers(new String[]{SWAGGER_WEBJARS_PATH})).antMatchers(new String[]{SWAGGER_API_DOC_PATH})).antMatchers(new String[]{SWAGGER_RESOURCE_PATH})).antMatchers(new String[]{SWAGGER_SECURITY_PATH})).antMatchers(new String[]{SWAGGER_CONFIGURATION_UI_PATH})).antMatchers(new String[]{REGISTER_NEW_PATH})).antMatchers(new String[]{RESTORE_JOB_PROGRESS_PATH})).antMatchers(new String[]{RESTORE_JOB_STATUS_PATH})).antMatchers(new String[]{RESTORE_START_JOB_NO_AUTH_PATH})).antMatchers(new String[]{RESTORE_STORAGE_INFOS_PATH})).antMatchers(new String[]{MYCARD_NO_AUTH_PATH})).antMatchers(new String[]{RE_REGISTER_NEW_PATH})).antMatchers(new String[]{ISSUPPORT_SUBSCRIPTION_PATH})).antMatchers(new String[]{SYSTEM_IS_ACTIVED_PATH})).antMatchers(new String[]{SYSTEM_IS_REACTIVED_PATH})).antMatchers(new String[]{SYSTEM_IS_ALIVE})).antMatchers(new String[]{SYSTEM_GET_VERSION_INFO})).antMatchers(new String[]{SYSTEM_CHECK_SERVICE_STATUS})).antMatchers(new String[]{SYSTEM_IS_FINE})).antMatchers(new String[]{SYSTEM_CHANGE_SYSTEM_LOG_LEVEL})).antMatchers(new String[]{SYSTEM_CHECK_GET_ASUSDNSNAME})).antMatchers(new String[]{SYSTEM_GET_REGISTER_STATUS})).antMatchers(new String[]{SYSTEM_GET_PRODUCT_INFO})).antMatchers(new String[]{SYSTEM_GET_DB_BUILD_TIME})).antMatchers(new String[]{SYSTEM_GET_PRODUCT_VERSION_INFO})).antMatchers(new String[]{SYSTEM_GET_lICENSE})).antMatchers(new String[]{SYSTEM_GET_SUBSCRIPTIONSTATUS})).antMatchers(new String[]{SYSTEM_REMOVE_SERVER})).antMatchers(new String[]{SYSTEM_REFRESH_SUBSCRIPTION_INFO_BY_SERVICE_ID})).antMatchers(new String[]{SYSTEM_PAUSE_ALL_SCHEDULER})).antMatchers(new String[]{SYSTEM_RESUME_ALL_SCHEDULER})).antMatchers(new String[]{SYSTEM_GET_ALL_TOKEN})).antMatchers(new String[]{SYSTEM_GET_ALL_ACCOUNT})).antMatchers(new String[]{SYSTEM_DELETECOMPANY})).antMatchers(new String[]{SYSTEM_IS_SIMPLIFYUI})).antMatchers(new String[]{SYSTEM_IS_MULTICOMPANY_FRAME})).antMatchers(new String[]{SYSTEM_GET_AVAILABLE_COMPANY_COUNT})).antMatchers(new String[]{SYSTEM_INITIAL_BY_DEMO})).antMatchers(new String[]{SYSTEM_INITIAL_BY_CLOUD_WEB})).antMatchers(new String[]{SYSTEM_INITIAL_BY_CLOUD})).antMatchers(new String[]{SYSTEM_INITIAL_BY_CLOUD_SINGLE_ACCOUNT})).antMatchers(new String[]{SYSTEM_APPLYACCOUNT})).antMatchers(new String[]{VERIFY_APPLYACCOUNT_URL_PATH})).antMatchers(new String[]{SYSTEM_GETUPDISPLAYOPTION})).antMatchers(new String[]{SYSTEM_IS_CLOUD});
        super.configure(web);
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider(this.localStorageSpaceAuthenticationProvider());
        auth.authenticationProvider(this.tokenAuthenticationProvider());
        auth.authenticationProvider(this.SubscriptionAuthenticationProvider());
    }

    @Bean
    public AuthenticationEntryPoint unauthorizedEntryPoint() {
        return (request, response, authException) -> response.sendError(401);
    }

    @Bean
    public AuthenticationProvider tokenAuthenticationProvider() {
        return new TokenAuthenticationProvider(this.tokenManager, this.accountService, this.tokenService);
    }

    @Bean
    public AuthenticationProvider SubscriptionAuthenticationProvider() {
        return new SubscriptionAuthenticationProvider(this.applicationProperties);
    }

    @Bean
    public AuthenticationProvider localStorageSpaceAuthenticationProvider() {
        return new LocalStorageSpaceAuthenticationProvider(this.applicationProperties, this.registryService);
    }
}

