/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.scheduler;

import com.penpower.worldcard.team.config.scheduler.AutoWiringSpringBeanJobFactory;
import com.penpower.worldcard.team.config.scheduler.InterruptedSchedulerFactoryBean;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.DatabaseType;
import com.penpower.worldcard.team.service.GlobalInfoService;
import javax.sql.DataSource;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SpringQuartzConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SpringQuartzConfig.class);
    @Autowired
    @Qualifier(value="localStorageSpaceMonitorJobTrigger")
    private CronTriggerFactoryBean localStorageSpaceMonitorJobTrigger;
    @Autowired
    @Qualifier(value="dailyStorageSpaceMonitorJobTrigger")
    private CronTriggerFactoryBean dailyStorageSpaceMonitorJobTrigger;
    @Autowired
    @Qualifier(value="simpleJobTrigger")
    private CronTriggerFactoryBean simpleJobTrigger;
    @Autowired
    @Qualifier(value="exportAllContactsJobTrigger")
    private CronTriggerFactoryBean exportAllContactsJobTrigger;
    @Autowired
    @Qualifier(value="syncAllContactsWithCrmJobTrigger")
    private CronTriggerFactoryBean syncAllContactsWithCrmJobTrigger;
    @Autowired
    @Qualifier(value="syncAllContactsWithContactServerJobTrigger")
    private CronTriggerFactoryBean syncAllContactsWithContactServerJobTrigger;
    @Autowired
    @Qualifier(value="deleteContactsDeeplyJobTrigger")
    private CronTriggerFactoryBean deleteContactsDeeplyJobTrigger;
    @Autowired
    @Qualifier(value="deadLockAccountInheritorJobCheckerTrigger")
    private CronTriggerFactoryBean deadLockAccountInheritorJobCheckerTrigger;
    @Autowired
    @Qualifier(value="cleanOutOBoundNoticesPerUserJobTrigger")
    private CronTriggerFactoryBean cleanOutOBoundNoticesPerUserJobTrigger;
    @Autowired
    @Qualifier(value="dailyDeleteImageforPeriodJobTrigger")
    private CronTriggerFactoryBean dailyDeleteImageforPeriodJobTrigger;
    @Autowired
    @Qualifier(value="dailyCheckRegisterJobTrigger")
    private CronTriggerFactoryBean dailyCheckRegisterJobTrigger;
    @Autowired
    private Environment env;
    @Value(value="${developmentEnv:false}")
    private boolean developmentEnv;
    @Autowired
    @Qualifier(value="dailyCheckSubscriptionnJobTrigger")
    private CronTriggerFactoryBean dailyCheckSubscriptionnJobTrigger;
    @Autowired
    @Qualifier(value="systemPerformanceMonitorJobTrigger")
    private CronTriggerFactoryBean systemPerformanceMonitorJobTrigger;
    @Autowired
    @Qualifier(value="adAccountSyncJobTrigger")
    private CronTriggerFactoryBean adAccountSyncJobTrigger;
    @Autowired
    @Qualifier(value="checkContactToBeIndexedJobTrigger")
    private CronTriggerFactoryBean checkContactToBeIndexedJobTrigger;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Value(value="${softwareVersion:false}")
    private boolean softwareVersion;

    @Bean
    public AutoWiringSpringBeanJobFactory autoWiringSpringBeanJobFactory() {
        return new AutoWiringSpringBeanJobFactory();
    }

    @Bean(name={"scheculerFactoryBeanManually"})
    public InterruptedSchedulerFactoryBean manuallyScheculerFactoryBean() {
        InterruptedSchedulerFactoryBean scheduler = new InterruptedSchedulerFactoryBean();
        scheduler.setJobFactory((JobFactory)this.autoWiringSpringBeanJobFactory());
        scheduler.setAutoStartup(true);
        return scheduler;
    }

    private DatabaseType getDatabaseType() {
        String databaseType = null;
        databaseType = this.softwareVersion ? this.env.getProperty("dataSource.software.type") : (this.developmentEnv ? this.env.getProperty("dataSource.dev.type") : this.env.getProperty("dataSource.nas.type"));
        DatabaseType type = DatabaseType.valueOf((String)databaseType);
        return type;
    }

    @Bean(name={"scheculerFactoryBeanManuallyInDatabase"})
    public InterruptedSchedulerFactoryBean scheculerFactoryBeanManuallyInDatabase() {
        InterruptedSchedulerFactoryBean scheduler = new InterruptedSchedulerFactoryBean();
        scheduler.setJobFactory((JobFactory)this.autoWiringSpringBeanJobFactory());
        scheduler.setDataSource(this.dataSource);
        scheduler.setTransactionManager(this.platformTransactionManager);
        Globalinfo databaseTypeInfo = this.globalInfoService.getPropertiesByKey("DATABASE_TYPE");
        DatabaseType databaseType = DatabaseType.POSTGRESQL;
        if (databaseTypeInfo != null) {
            LOG.info("databaseTypeInfo not null , change the value!!");
            databaseType = DatabaseType.valueOf((String)databaseTypeInfo.getConfigValue());
        } else {
            databaseType = this.getDatabaseType();
        }
        LOG.info("loading the quartz prpoerties , check softwareVersion : {} ", (Object)this.softwareVersion);
        LOG.info("loading the quartz prpoerties , check dataBaseType : {} ", (Object)databaseTypeInfo);
        LOG.info("loading the quartz prpoerties , check typeInfo : {} ", (Object)databaseType);
        if (this.softwareVersion) {
            if (DatabaseType.MSSQL.equals((Object)databaseType)) {
                scheduler.setConfigLocation((Resource)new ClassPathResource("quartz.software.mssql.properties"));
            } else if (DatabaseType.POSTGRESQL.equals((Object)databaseType)) {
                scheduler.setConfigLocation((Resource)new ClassPathResource("quartz.software.postgresql.properties"));
            }
        } else {
            scheduler.setConfigLocation((Resource)new ClassPathResource("quartz.properties"));
        }
        scheduler.setAutoStartup(true);
        scheduler.setOverwriteExistingJobs(true);
        scheduler.setTriggers(new Trigger[]{this.localStorageSpaceMonitorJobTrigger.getObject(), this.dailyStorageSpaceMonitorJobTrigger.getObject(), this.cleanOutOBoundNoticesPerUserJobTrigger.getObject(), this.syncAllContactsWithCrmJobTrigger.getObject(), this.syncAllContactsWithContactServerJobTrigger.getObject(), this.deleteContactsDeeplyJobTrigger.getObject(), this.deadLockAccountInheritorJobCheckerTrigger.getObject(), this.dailyCheckRegisterJobTrigger.getObject(), this.dailyDeleteImageforPeriodJobTrigger.getObject(), this.dailyCheckSubscriptionnJobTrigger.getObject(), this.systemPerformanceMonitorJobTrigger.getObject(), this.adAccountSyncJobTrigger.getObject(), this.checkContactToBeIndexedJobTrigger.getObject()});
        return scheduler;
    }

    @Bean(name={"scheculerFactoryBeanAutomatically"})
    public InterruptedSchedulerFactoryBean scheculerFactoryBeanAutomatically() {
        InterruptedSchedulerFactoryBean scheduler = new InterruptedSchedulerFactoryBean();
        scheduler.setJobFactory((JobFactory)this.autoWiringSpringBeanJobFactory());
        scheduler.setConfigLocation((Resource)new ClassPathResource("quartz.auto.properties"));
        return scheduler;
    }
}

