/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.scheduler;

import com.penpower.worldcard.team.exception.DatabaseUtilsRuntimeException;
import java.util.List;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class InterruptedSchedulerFactoryBean
extends SchedulerFactoryBean {
    private static final Logger LOG = LoggerFactory.getLogger(InterruptedSchedulerFactoryBean.class);

    public void destroy() throws SchedulerException {
        LOG.info("Stop all running schedule and shutdown schedule......");
        Scheduler scheduler = this.getScheduler();
        try {
            List executingJobs = scheduler.getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : executingJobs) {
                JobDetail executingJobDetai = jobExecutionContext.getJobDetail();
                JobKey key = executingJobDetai.getKey();
                scheduler.interrupt(key);
            }
            scheduler.pauseAll();
        }
        catch (SchedulerException e) {
            throw new DatabaseUtilsRuntimeException("Fail to interrupt current running jobs.....", (Throwable)e);
        }
        super.destroy();
    }
}

