/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.property;

import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.config.property.PropertiesLoader;
import com.penpower.worldcard.team.enums.ServerType;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class HardCodePropertiesLoader
implements PropertiesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(HardCodePropertiesLoader.class);
    private Environment env;

    public HardCodePropertiesLoader() {
    }

    public HardCodePropertiesLoader(Environment env) {
        this.env = env;
    }

    public Map<String, String> loadPorperties() {
        String svrType = this.env.getProperty("Servertype");
        ServerType serverType = ServerType.ASUSTOR_NAS;
        if (svrType != null) {
            serverType = ServerType.valueOf((String)svrType);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("LOG_ENABLE", "false");
        String fileSystemRootPathFromProperties = this.env.getProperty("filesystem.root.path");
        LOG.info("check the filesystem.root.path properties value : {} ", (Object)fileSystemRootPathFromProperties);
        if (this.noDefineFromSoftwareTools(fileSystemRootPathFromProperties)) {
            LOG.info("No define from software , use the tomcat catalin.base path for the root path....");
            String fileSystemRootPath = (String)properties.get("FILE_SYSTEM_ROOT_PATH");
            if (StringUtil.IsStringNullorEmpty((String)fileSystemRootPath)) {
                if (serverType == ServerType.Window_Server) {
                    String dataFolder = System.getenv("ALLUSERSPROFILE") + "\\WorldCardTeamServer\\temp\\";
                    properties.put("FILE_SYSTEM_ROOT_PATH", dataFolder);
                    LOG.info("filesRoot : {}", (Object)dataFolder);
                } else {
                    String tomcatRoot = System.getProperty("catalina.base");
                    if (tomcatRoot != null) {
                        Path tomcatRootPath = Paths.get(tomcatRoot, new String[0]);
                        Path filesRoot = Paths.get(tomcatRootPath.getParent().toString(), "wctdb", "files");
                        properties.put("FILE_SYSTEM_ROOT_PATH", filesRoot.toString());
                        LOG.info("tomcatRootPath : {}", (Object)tomcatRootPath);
                        LOG.info("filesRoot : {}", (Object)filesRoot);
                    }
                }
            }
        } else {
            LOG.info("Found the new software defined root path , fileSystemRootPathFromProperties : {}", (Object)fileSystemRootPathFromProperties);
            Path root = Paths.get(fileSystemRootPathFromProperties, new String[0]);
            Path filesRoot = Paths.get(root.toString(), "wctdb", "files");
            properties.put("FILE_SYSTEM_ROOT_PATH", filesRoot.toString());
            LOG.info("root : {}", (Object)root);
            LOG.info("filesRoot : {}", (Object)filesRoot);
        }
        if (serverType == ServerType.ASUSTOR_NAS_AUTOMATION || serverType == ServerType.ASUSTOR_NAS_Cloud || serverType == ServerType.Linux_Server_Cloud || serverType == ServerType.Google_Linux_Server_Cloud) {
            LOG.info("public cloud version:{}, turn on log_performance setting", (Object)serverType);
            properties.put("LOG_ENABLE", String.valueOf(true));
        }
        return properties;
    }

    private boolean noDefineFromSoftwareTools(String fileSystemRootPathFromProperties) {
        try {
            Path path = Paths.get(fileSystemRootPathFromProperties, new String[0]);
            LOG.info("Test fileSystemRootPathFromProperties toString : {}", (Object)path.toString());
            LOG.info("Test fileSystemRootPathFromProperties toAbsolutePath : {}", (Object)path.toAbsolutePath());
        }
        catch (InvalidPathException ex) {
            return false;
        }
        String fileSystemRootPathFromPropertiesToNull = StringUtils.stripToNull((String)fileSystemRootPathFromProperties);
        LOG.info("fileSystemRootPathFromPropertiesToNull : {} ", (Object)fileSystemRootPathFromPropertiesToNull);
        return fileSystemRootPathFromPropertiesToNull == null || "$PATH".equals(fileSystemRootPathFromProperties);
    }
}

